/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.attacktopn;

import com.hs.atic.analysis.report.attack.attacktopn.AttackPacketTopnDataSet;
import com.hs.atic.analysis.report.attack.attacktopn.AttackTopn;
import com.hs.atic.analysis.report.integration.MulColumnView;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.security.ireport.engine.dataset.IFlexTableData;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class AttackPacketTopn4Integration
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<MulColumnView> dataList = new ArrayList<MulColumnView>();
    private boolean isContainV1R1 = false;
    private int orderUnit = 0;

    public List<IFlexTableData> getFlexTableHeader() {
        return null;
    }

    public List<MulColumnView> sortListByField(List<MulColumnView> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<MulColumnView> orderedList = null;
        if (null != sortList) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<MulColumnView> list = new ArrayList<MulColumnView>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        boolean needQuery4InteReport = ReportAnalysisUtil.checkNeedQuery4InteReport(queryCond, "AttackEventTopN");
        if (!needQuery4InteReport) {
            return 0;
        }
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        List<JsonValueItem> jsonValueItemList = null;
        List<JsonValueItem> zoneJsonValueItemList = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItemList.get(0).getValue());
        zoneJsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        String zoneId = String.valueOf(zoneJsonValueItemList.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
            return 0;
        }
        if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
            return 0;
        }
        AttackPacketTopnDataSet attackPacketTopnDataSet = new AttackPacketTopnDataSet();
        List<JsonValueItem> typeJsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type_combobox");
        if (0 == datastatConditionForm.getDevSerType()) {
            this.isContainV1R1 = ReportAnalysisUtil.isContainV1(deviceId, zoneId);
            if (this.isContainV1R1) {
                typeJsonValueItemList.get(0).setValue(String.valueOf(4));
            } else {
                typeJsonValueItemList.get(0).setValue(String.valueOf(0));
            }
            String isInteReport = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
            if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true")) {
                typeJsonValueItemList.get(0).setValue(String.valueOf(this.orderUnit));
            }
        } else {
            typeJsonValueItemList.get(0).setValue(String.valueOf(1));
        }
        try {
            attackPacketTopnDataSet.prepareData(reportId, dataSourceId, queryCond, sessionId);
            List<AttackTopn> tempAttackTopnData = attackPacketTopnDataSet.getDataList();
            this.processFinalData(tempAttackTopnData, queryCond, datastatConditionForm.getDevSerType());
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"AttackCountDataSet prepareData happened exception !", (Throwable)e);
        }
        return 0;
    }

    private void processFinalData(List<AttackTopn> tempAttackTopnData, Map<?, ?> queryCond, int deviceType) {
        if (null == tempAttackTopnData || tempAttackTopnData.isEmpty()) {
            this.dataList = new ArrayList<MulColumnView>();
            return;
        }
        Locale locale = ReportAnalysisUtil.getCurrentUserLocale4Report(queryCond);
        int topNum = 1;
        String newLineStr = "\n";
        String topNStr = "Top ";
        String attackTypeStr = AticUtil.getText((String)"atic.report.integration.attackType", (Locale)locale);
        String attackStartTimeStr = AticUtil.getText((String)"atic.report.integration.attackStartTime", (Locale)locale);
        String statusStr = AticUtil.getText((String)"atic.report.integration.attackStatus", (Locale)locale);
        String attackIpStr = AticUtil.getText((String)"atic.report.integration.attackIp", (Locale)locale);
        String maxDropKbpsStr = AticUtil.getText((String)"atic.report.integration.dropMaxKbps", (Locale)locale);
        String maxDropPpsStr = AticUtil.getText((String)"atic.report.integration.dropMaxPps", (Locale)locale);
        String abnormalStartTimeStr = AticUtil.getText((String)"atic.report.integration.abnormalStartTime", (Locale)locale);
        String attackEndTimeStr = AticUtil.getText((String)"atic.report.integration.attackEndTime", (Locale)locale);
        String zoneNameStr = AticUtil.getText((String)"atic.report.integration.zoneName", (Locale)locale);
        String attackDuration = AticUtil.getText((String)"atic.report.integration.attackDuration", (Locale)locale);
        String limitValueStr = AticUtil.getText((String)"atic.report.integration.limitValue", (Locale)locale);
        for (AttackTopn attackTopn : tempAttackTopnData) {
            MulColumnView mulColumnView = new MulColumnView();
            mulColumnView.setTopNum(topNStr + topNum);
            String attackStatus = ReportAnalysisUtil.getExactLogAttackStatus(locale).get(String.valueOf(attackTopn.getAttackStatus()));
            String endTime = "";
            endTime = 0 != attackTopn.getAttackStatus() ? "-" : attackTopn.getEndTimeStr();
            String startTimeAttack = "";
            startTimeAttack = AticUtil.isNull((String)attackTopn.getStartTimeAttackStr()) ? "-" : attackTopn.getStartTimeAttackStr();
            String firstColumn = attackTypeStr + attackTopn.getAttackTypeName() + newLineStr + abnormalStartTimeStr + attackTopn.getStartTimeAlertStr() + newLineStr + attackStartTimeStr + startTimeAttack + newLineStr + statusStr + attackStatus + newLineStr + attackIpStr + IPUtil4Atic.compressIP((String)attackTopn.getZoneIpStr());
            String secondColumn = newLineStr + limitValueStr + attackTopn.getLimitDis() + newLineStr + attackEndTimeStr + endTime + newLineStr + attackDuration + attackTopn.getDurationStr() + newLineStr + zoneNameStr + attackTopn.getZoneName();
            if (0 == deviceType) {
                if (this.isContainV1R1) {
                    firstColumn = firstColumn + newLineStr + maxDropPpsStr + attackTopn.getMaxDropPps();
                } else {
                    firstColumn = firstColumn + newLineStr + maxDropKbpsStr + attackTopn.getMaxDropKbps();
                    secondColumn = secondColumn + newLineStr + maxDropPpsStr + attackTopn.getMaxDropPps();
                }
            }
            mulColumnView.setFirstColumn(firstColumn);
            mulColumnView.setSecondColumn(secondColumn);
            this.dataList.add(mulColumnView);
            ++topNum;
        }
    }

    public int getOrderUnit() {
        return this.orderUnit;
    }

    public void setOrderUnit(int orderUnit) {
        this.orderUnit = orderUnit;
    }

    public List<MulColumnView> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<MulColumnView> dataList) {
        this.dataList = dataList;
    }
}

