/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.attacktopn;

import com.hs.atic.analysis.report.attack.attacktopn.AttackTopn;
import com.hs.atic.analysis.report.attack.attacktopn.AttackTopnComparator;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.AttackTopnForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.CommonUtil;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class AttackPacketTopnDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<AttackTopn> dataList = new ArrayList<AttackTopn>();
    private IDataStatService dataStatService;
    private String nextLineStr = "<br>";
    private Integer typeValue;

    public List<AttackTopn> sortListByField(List<AttackTopn> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        if (pageSize > 100L) {
            this.nextLineStr = "\n";
        }
        Map<String, String> ipAndDeviceName = ReportAnalysisUtil.getAllIpAndDeviceName();
        for (AttackTopn log : this.dataList) {
            log.setAttackLogInfo(AticUtil.getText((String)"atic.report.integration.deviceName") + ipAndDeviceName.get(log.getDeviceIpStr()) + this.nextLineStr + AticUtil.getText((String)"atic.analysis.common.zone") + log.getZoneName() + this.nextLineStr + AticUtil.getText((String)"atic.bis.datastat.flowcompare.label.user.ip") + AticUtil.getText((String)"atic.public.punctuation.colon") + log.getZoneIpStr());
            String endTime = log.getEndTimeStr().length() > 5 ? log.getEndTimeStr().substring(5) : log.getEndTimeStr();
            log.setAttackLogTimes(AticUtil.getText((String)"atic.analysis.report.time.start") + log.getStartTimeAlertStr().substring(5) + this.nextLineStr + AticUtil.getText((String)"atic.analysis.report.time.end") + endTime);
        }
        List<AttackTopn> orderedList = null;
        if (null != sortList) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<AttackTopn> list = new ArrayList<AttackTopn>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getLogoAndNameMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        try {
            Integer topn = this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
            List<AttackTopnForm> attackTopnFormList = null;
            Long deviceId = datastatConditionForm.getDeviceId();
            attackTopnFormList = deviceId > 0L ? this.getSingleCleanDeviceData(datastatConditionForm) : this.getMultiCleanDeviceData(currentLogUserId, datastatConditionForm);
            this.dataList = this.getAttackTopnList(attackTopnFormList, topn, queryCond);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"AttackCountDataSet prepareData happened exception !", (Throwable)e);
        }
        return 0;
    }

    private List<AttackTopn> getAttackTopnList(List<AttackTopnForm> attackTopnFormList, Integer topn, Map<?, ?> queryCond) {
        ArrayList<AttackTopn> topnList = new ArrayList<AttackTopn>();
        if (null == attackTopnFormList || null == topn) {
            this.logger.info((Object)"getAttackTopnFormList is empty !");
            return topnList;
        }
        IZoneService zoneService = ReportBisUtil.getZoneService();
        if (0 == this.typeValue) {
            Collections.sort(attackTopnFormList, new AttackTopnComparator("maxDropKbps"));
        } else if (4 == this.typeValue) {
            Collections.sort(attackTopnFormList, new AttackTopnComparator("maxDropPps"));
        } else if (1 == this.typeValue) {
            Collections.sort(attackTopnFormList, new AttackTopnComparator("duration"));
        } else if (2 == this.typeValue) {
            Collections.sort(attackTopnFormList, new AttackTopnComparator("dropKbits"));
        }
        if (topn > attackTopnFormList.size()) {
            topn = attackTopnFormList.size();
        }
        Locale locale = ReportAnalysisUtil.getCurrentUserLocale4Report(queryCond);
        for (int i = 0; i < topn; ++i) {
            AttackTopnForm form = attackTopnFormList.get(i);
            AttackTopn attackTopn = new AttackTopn();
            attackTopn.setDeviceIpStr(form.getDeviceIp());
            ZoneInfoForm zoneForm = zoneService.getById(form.getZoneId());
            if (null == zoneForm) {
                attackTopn.setZoneName(AticUtil.getText((String)"atic.analysis.common.unknownZone", (Locale)locale) + form.getZoneId());
            } else {
                attackTopn.setZoneName(zoneForm.getZoneDesc());
            }
            if (form.getZoneIp().equals("0") && form.getBizId() == 0L) {
                attackTopn.setZoneIpStr("-");
            } else {
                attackTopn.setZoneIpStr(IPUtil4Atic.compressIP((String)form.getZoneIp()));
            }
            attackTopn.setStartTimeAlertStr(ReportAnalysisUtil.formateTime(form.getStartTimeAlert()));
            attackTopn.setStartTimeAttackStr(ReportAnalysisUtil.formateTime(form.getStartTimeAttack()));
            attackTopn.setEndTimeStr(ReportAnalysisUtil.formateTime(form.getEndTime()));
            attackTopn.setDurationStr(ReportAnalysisUtil.longTimeToHMS(form.getDuration()));
            if (form.getAttackType() >= 10) {
                attackTopn.setAttackTypeName(ReportAnalysisUtil.getDisplayAttackType(String.valueOf(form.getAttackType())));
            } else {
                attackTopn.setAttackTypeName(ReportAnalysisUtil.getCustomAttackTypeStr(form.getZoneId(), form.getDeviceIp(), form.getProtocol(), form.getPort()));
            }
            if (0 != form.getAttackStatus()) {
                attackTopn.setEndTimeStr("-");
            }
            attackTopn.setAttackStatus(form.getAttackStatus());
            attackTopn.setAttackStatusName(ReportAnalysisUtil.getExactLogAttackStatus().get(String.valueOf(form.getAttackStatus())));
            attackTopn.setMaxDropKbps(form.getMaxDropKbps());
            attackTopn.setMaxDropPps(form.getMaxDropPps());
            attackTopn.setMaxDropKbpsStr(CommonUtil.transformNumber((String)String.valueOf(form.getMaxDropKbps()), null));
            attackTopn.setMaxDropPpsStr(CommonUtil.transformNumber((String)String.valueOf(form.getMaxDropPps()), null));
            attackTopn.setDropKbits(form.getDropKbits() / 8L);
            attackTopn.setDropKbitsStr(CommonUtil.transformNumber((String)String.valueOf(form.getDropKbits() / 8L), null));
            String limitDis = ReportAnalysisUtil.getLimitDis(form);
            attackTopn.setLimitDis(limitDis);
            topnList.add(attackTopn);
        }
        return topnList;
    }

    private Integer getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        List<JsonValueItem> jsonValueItemList = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItemList.get(0).getValue());
        if (direction.matches("^[\\d]*$")) {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        } else {
            datastatConditionForm.setDirection(1);
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "switchOption");
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItemList.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        String zoneId = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        if (null != jsonValueItemList && !jsonValueItemList.isEmpty() && !"0".equals(zoneId = String.valueOf(jsonValueItemList.get(0).getValue()))) {
            datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        }
        if (!(null != datastatConditionForm.getZoneId() || AnalysisConstants.getInstance().getReportType().equalsIgnoreCase("ips") && AnalysisConstants.getInstance().getReportTypeIpsReport().booleanValue())) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
        String bisId = String.valueOf(jsonValueItemList.get(0).getValue());
        ReportAnalysisUtil.processServiceCond(datastatConditionForm, bisId);
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type_combobox");
        String countTypeId = String.valueOf(jsonValueItemList.get(0).getValue());
        this.typeValue = Integer.parseInt(countTypeId);
        datastatConditionForm.setAppType(this.typeValue);
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
        String topn = String.valueOf(jsonValueItemList.get(0).getValue());
        Integer topnValue = Integer.parseInt(topn);
        datastatConditionForm.setTopn(topnValue);
        String isInteReport = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
        if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true")) {
            jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "AttackEventTopNTOPN");
            String topn4Inte = String.valueOf(jsonValueItemList.get(0).getValue());
            Integer topn4InteValue = Integer.parseInt(topn4Inte);
            datastatConditionForm.setTopn(topn4InteValue);
            return topn4InteValue;
        }
        return topnValue;
    }

    private List<AttackTopnForm> getSingleCleanDeviceData(DataStatConditionForm datastatConditionForm) {
        List<AttackTopnForm> formList = new ArrayList<AttackTopnForm>();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            return formList;
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            formList = this.dataStatService.getAttackTopn(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorIp = " + this.getcleanedMessage(collectorInfo.getIpAddress())), (Throwable)e);
        }
        return formList;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<AttackTopnForm> getMultiCleanDeviceData(Long currentLogUserId, DataStatConditionForm datastatConditionForm) {
        ArrayList<AttackTopnForm> allFormList = new ArrayList<AttackTopnForm>();
        List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
        Map<Long, List<AticDevice>> collectDevMap = ReportAnalysisUtil.getCollectDevMap(firewallList);
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
            CollectorInfo collector = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue());
            if (null == collector) continue;
            String collectorIp = collector.getIpAddress();
            ArrayList<String> deviceIpList = new ArrayList<String>();
            for (AticDevice securityNE : entry.getValue()) {
                deviceIpList.add(securityNE.getIpAddress());
            }
            datastatConditionForm.setDeviceIpList(deviceIpList);
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            List<AttackTopnForm> formList = null;
            try {
                formList = this.dataStatService.getAttackTopn(datastatConditionForm, collectorIp);
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey()), (Throwable)e);
            }
            if (null == formList || formList.isEmpty()) continue;
            allFormList.addAll(formList);
        }
        return allFormList;
    }

    public List<AttackTopn> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<AttackTopn> dataList) {
        this.dataList = dataList;
    }
}

