/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.attacktrend;

import com.hs.atic.analysis.report.attack.attacktrend.AttackTrend;
import com.hs.atic.analysis.report.attack.attacktrend.TransmitAttackTrendData;
import com.hs.atic.analysis.report.integration.datasource.AllReportHaveDataCache;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.report.util.ReportConditionUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.AttackTrendForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INpFilterService;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AttackTrendChartDataSet
extends IJavaDataSource {
    private static final Long NUM_THREE_HUNDRED = 300L;
    private static final Long NUM_THREE_THOUSAND_SIX_HUNDRED = 3600L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<AttackTrend> dataList = new ArrayList<AttackTrend>();
    private IDataStatService dataStatService;

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        return this.dataList;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getPrepareParasMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start AttackTrendChartDataSet prepareData()");
        List<AttackTrendForm> attackTrendFormList = null;
        Map<String, List<AttackTrendForm>> allCollectorAttackTypeForm = null;
        try {
            boolean needQuery4InteReport = ReportAnalysisUtil.checkNeedQuery4InteReport(queryCond, "AttackTrend");
            if (!needQuery4InteReport) {
                return 0;
            }
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            allCollectorAttackTypeForm = datastatConditionForm.getDeviceId() > 0L ? this.getSingleDeviceData(datastatConditionForm) : this.getMultDeviceData(queryCond, datastatConditionForm);
            attackTrendFormList = this.processData4Collect(datastatConditionForm, allCollectorAttackTypeForm);
            IFilterService filterService = ReportBisUtil.getFilterService();
            INpFilterService npfilterService = ReportBisUtil.getNpFilterService();
            for (AttackTrendForm form : attackTrendFormList) {
                if (2000L == form.getAttackType()) {
                    form.setAttackTypeName(AticUtil.getText((String)"atic.attack.type.62"));
                }
                if (form.getAttackType() > 2000L && form.getAttackType() < 80000L) {
                    if (null != filterService) {
                        FilterForm filterForm = filterService.queryFilterName(Long.valueOf(form.getAttackType() - 2000L));
                        if (null != filterForm && null != filterForm.getFilterName()) {
                            form.setAttackTypeName(filterForm.getFilterName());
                        } else {
                            form.setAttackTypeName("unknownFilter" + (form.getAttackType() - 2000L));
                        }
                    } else {
                        this.logger.error((Object)("get filter service failed. filter attack type : " + form.getAttackType()));
                        continue;
                    }
                }
                if (form.getAttackType() < 80000L) continue;
                if (80000L == form.getAttackType()) {
                    form.setAttackTypeName(AticUtil.getText((String)"atic.attack.type.80000"));
                    continue;
                }
                if (null != npfilterService) {
                    NPFilterForm npfilterTemp = npfilterService.queryNPFilterFormByfilterId(form.getAttackType() - 80000L);
                    if (null != npfilterTemp && null != npfilterTemp.getFilterName()) {
                        form.setAttackTypeName(npfilterTemp.getFilterName());
                    } else {
                        form.setAttackTypeName(AticUtil.getText((String)"atic.attack.type.80000"));
                    }
                    this.logger.error((Object)("get np filter service. filter attack type : " + form.getAttackType() + "; filter attack type name : " + form.getAttackTypeName()));
                    continue;
                }
                this.logger.error((Object)("get filter service failed. filter attack type : " + form.getAttackType()));
            }
            attackTrendFormList = this.getAllTimeData(attackTrendFormList, datastatConditionForm.getStartTime(), datastatConditionForm.getEndTime());
            this.getAttackTrendFormData(attackTrendFormList);
            String isNeedTransmitChartData = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isNeedTransmitChartData").get(0).getValue());
            if (!AticUtil.isNull((String)isNeedTransmitChartData) && isNeedTransmitChartData.equalsIgnoreCase("true")) {
                TransmitAttackTrendData.getInstance().addDataList(new ArrayList<AttackTrend>(this.dataList), sessionId);
                if (null != this.dataList && !this.dataList.isEmpty()) {
                    AllReportHaveDataCache.getInstance().addDataList("AttackTrend", sessionId);
                }
            }
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            this.logger.error((Object)("AttackTrendChartDataSet prepareData() exception" + legoException.getErrorCode()), (Throwable)legoException);
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"AttackTrendChartDataSet prepareData() unknow exception", (Throwable)e);
        }
        this.logger.info((Object)"end AttackTrendChartDataSet prepareData()");
        return 0;
    }

    private List<AttackTrendForm> processData4Collect(DataStatConditionForm datastatConditionForm, Map<String, List<AttackTrendForm>> allCollectorAttackTypeForm) {
        List<AttackTrendForm> attackTrendFormList = null;
        if (-2L == datastatConditionForm.getDeviceId()) {
            attackTrendFormList = this.getAllDetectTopNForm(allCollectorAttackTypeForm);
        } else {
            ArrayList<AttackTrendForm> allForm = new ArrayList<AttackTrendForm>();
            for (Map.Entry<String, List<AttackTrendForm>> entry : allCollectorAttackTypeForm.entrySet()) {
                allForm.addAll((Collection<AttackTrendForm>)entry.getValue());
            }
            attackTrendFormList = this.getTopNForm(allForm, 1);
        }
        return attackTrendFormList;
    }

    private Map<String, List<AttackTrendForm>> getMultDeviceData(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm) {
        Map<String, List<AttackTrendForm>> allCollectorAttackTypeForm = null;
        Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
        List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
        Map<Long, List<AticDevice>> collectDevMap = null;
        collectDevMap = ReportAnalysisUtil.getCollectDevMap(firewallList);
        allCollectorAttackTypeForm = this.getAllCollectorIpTopNForm(collectDevMap, datastatConditionForm);
        return allCollectorAttackTypeForm;
    }

    private void getAttackTrendFormData(List<AttackTrendForm> attackTrendFormList) {
        for (AttackTrendForm form : attackTrendFormList) {
            AttackTrend data = new AttackTrend();
            data.setDateTime(form.getDateTime() * 1000L);
            data.setAttackTypePackagePps(form.getAttackTypePackagePps());
            data.setAttackTypePackageKbps(form.getAttackTypePackageKbps());
            data.setAttackTypeName(form.getAttackTypeName());
            this.dataList.add(data);
        }
    }

    private Map<String, List<AttackTrendForm>> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        HashMap<String, List<AttackTrendForm>> allCollectorAttackTypeForm = new HashMap();
        try {
            allCollectorAttackTypeForm = this.dataStatService.getAttackTrend(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return allCollectorAttackTypeForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        Long endTime;
        String minInFlow;
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItem.get(0).getValue());
        if (direction.matches("^[\\d]*$")) {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        } else {
            datastatConditionForm.setDirection(1);
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        String zoneId = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        if (!"0".equals(zoneId)) {
            datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        } else if (!AnalysisConstants.getInstance().getReportType().equalsIgnoreCase("ips") || !AnalysisConstants.getInstance().getReportTypeIpsReport().booleanValue()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        String bisId = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
        bisId = String.valueOf(jsonValueItem.get(0).getValue());
        if (AticUtil.isNull((String)bisId)) {
            bisId = "0";
        }
        ReportAnalysisUtil.processServiceCond(datastatConditionForm, bisId);
        String zoneIp = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip");
        zoneIp = String.valueOf(jsonValueItem.get(0).getValue());
        if (!AticUtil.isNull((String)zoneIp)) {
            datastatConditionForm.setZoneIp(zoneIp);
        }
        if (!AticUtil.isNull((String)(minInFlow = String.valueOf((jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "minInFlow")).get(0).getValue())))) {
            datastatConditionForm.setMinInFlow(Long.parseLong(minInFlow));
        } else {
            datastatConditionForm.setMinInFlow(0L);
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "minAttackFlowPeak");
        String minAttackFlowPeak = String.valueOf(jsonValueItem.get(0).getValue());
        if (!AticUtil.isNull((String)minAttackFlowPeak)) {
            datastatConditionForm.setMinAttackFlowPeak(Long.parseLong(minAttackFlowPeak));
        } else {
            datastatConditionForm.setMinAttackFlowPeak(0L);
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit");
        String unit = String.valueOf(jsonValueItem.get(0).getValue());
        if (AticUtil.isNull((String)unit)) {
            datastatConditionForm.setUnit(1);
        } else {
            datastatConditionForm.setUnit(Integer.parseInt(unit));
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "startTime");
        String startTimeStr = jsonValueItem.get(0).getText();
        Long startTime = startTimeStr == null ? null : Long.valueOf(Long.parseLong(startTimeStr));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "endTime");
        String endTimeStr = jsonValueItem.get(0).getText();
        Long l = endTime = endTimeStr == null ? null : Long.valueOf(Long.parseLong(endTimeStr));
        if (null != startTime && null != endTime && queryCond.containsKey("dateRange")) {
            JsonValueObj dateObj = (JsonValueObj)queryCond.get("dateRange");
            ((JsonValueItem)dateObj.getValueList().get(0)).setValue(String.valueOf(startTime));
            ((JsonValueItem)dateObj.getValueList().get(0)).setText(AticUtil.convertTimeLong((Long)startTime));
            ((JsonValueItem)dateObj.getValueList().get(1)).setValue(String.valueOf(endTime));
            ((JsonValueItem)dateObj.getValueList().get(1)).setText(AticUtil.convertTimeLong((Long)endTime));
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "selectAttackType");
        ArrayList<String> attackTypeKey = new ArrayList<String>();
        ArrayList<String> attackTypeValue = new ArrayList<String>();
        this.getAttackType(attackTypeKey, attackTypeValue, jsonValueItem);
        datastatConditionForm.setAttackTypeKey(attackTypeKey);
        datastatConditionForm.setAttackTypeValue(attackTypeValue);
    }

    private void getAttackType(List<String> attackTypeKey, List<String> attackTypeValue, List<JsonValueItem> jsonValueItem) {
        if (jsonValueItem.get(0).getValue() == null) {
            List<JsonValueItem> allSelectType = ReportConditionUtil.getAllAttackType();
            for (JsonValueItem item : allSelectType) {
                attackTypeKey.add(item.getValue());
                attackTypeValue.add(ReportAnalysisUtil.getDisplayAttackType(item.getValue()));
            }
        } else {
            for (JsonValueItem item : jsonValueItem) {
                attackTypeKey.add(item.getValue());
                attackTypeValue.add(ReportAnalysisUtil.getDisplayAttackType(item.getValue()));
            }
        }
    }

    private List<AttackTrendForm> getAllDetectTopNForm(Map<String, List<AttackTrendForm>> inputMap) {
        List<AttackTrendForm> distinctForm = new ArrayList<AttackTrendForm>();
        List listDefendGroupForm = ReportBisUtil.getDefendGroupService().getAll();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        for (DefendGroupForm defendGroupForm : listDefendGroupForm) {
            String[] devIds;
            ArrayList<AttackTrendForm> listForm = new ArrayList<AttackTrendForm>();
            if (null == defendGroupForm.getDevices() || "".equals(defendGroupForm.getDevices())) continue;
            for (String devId : devIds = defendGroupForm.getDevices().split(",")) {
                AticDevice firewall = firewallService.getDeviceByMoid(Long.parseLong(devId));
                if (null == firewall) continue;
                String devIp = firewall.getIpAddress();
                if (!inputMap.containsKey(devIp = AticUtil.formatIpAddress((String)devIp))) continue;
                listForm.addAll((Collection<AttackTrendForm>)inputMap.get(devIp));
                inputMap.remove(devIp);
            }
            if (listForm.isEmpty()) continue;
            distinctForm.addAll(this.getTopNForm(listForm, defendGroupForm.getDetectMode()));
        }
        for (Map.Entry entry : inputMap.entrySet()) {
            distinctForm.addAll((Collection)entry.getValue());
        }
        distinctForm = this.getTopNForm(distinctForm, 1);
        return distinctForm;
    }

    private List<AttackTrendForm> getAllTimeData(List<AttackTrendForm> attackTrendFormList, long startTime, long endTime) {
        startTime = ReportAnalysisUtil.getRealStartTime(startTime, endTime);
        long timeSlot = this.getTimeSlot(startTime, endTime);
        ArrayList<String> attackTypeNameList = new ArrayList<String>();
        Long minTime = 0L;
        Long maxTime = 0L;
        for (int i = 0; i < attackTrendFormList.size(); ++i) {
            AttackTrendForm form = attackTrendFormList.get(i);
            if (i == 0) {
                minTime = form.getDateTime();
                maxTime = form.getDateTime();
            } else {
                if (form.getDateTime() < minTime) {
                    minTime = form.getDateTime();
                }
                if (form.getDateTime() > maxTime) {
                    maxTime = form.getDateTime();
                }
            }
            this.getAttackTypeNameList(form, attackTypeNameList);
        }
        HashMap<Long, List<AttackTrendForm>> map = new HashMap<Long, List<AttackTrendForm>>();
        while (minTime <= maxTime) {
            ArrayList<AttackTrendForm> tmpList = new ArrayList<AttackTrendForm>();
            for (AttackTrendForm form : attackTrendFormList) {
                if (!form.getDateTime().equals(minTime)) continue;
                tmpList.add(form);
            }
            map.put(minTime, tmpList);
            minTime = minTime + timeSlot;
        }
        this.getAttackTrendFormList(map, attackTypeNameList, attackTrendFormList);
        return attackTrendFormList;
    }

    private void getAttackTrendFormList(Map<Long, List<AttackTrendForm>> map, List<String> attackTypeNameList, List<AttackTrendForm> attackTrendFormList) {
        for (Map.Entry<Long, List<AttackTrendForm>> entry : map.entrySet()) {
            for (int i = 0; i < attackTypeNameList.size(); ++i) {
                boolean hasData = false;
                for (AttackTrendForm form : entry.getValue()) {
                    if (!form.getAttackTypeName().equals(attackTypeNameList.get(i))) continue;
                    hasData = true;
                    break;
                }
                if (hasData) continue;
                AttackTrendForm form = new AttackTrendForm();
                form.setDateTime(entry.getKey());
                form.setAttackTypePackagePps(0L);
                form.setAttackTypePackageKbps(0L);
                form.setAttackTypeName(attackTypeNameList.get(i));
                attackTrendFormList.add(form);
            }
        }
    }

    private void getAttackTypeNameList(AttackTrendForm form, List<String> attackTypeNameList) {
        if (form.getAttackType() >= 2000L) {
            return;
        }
        boolean hasData = false;
        for (int j = 0; j < attackTypeNameList.size(); ++j) {
            if (!form.getAttackTypeName().equals(attackTypeNameList.get(j))) continue;
            hasData = true;
            break;
        }
        if (!hasData) {
            attackTypeNameList.add(form.getAttackTypeName());
        }
    }

    private long getTimeSlot(long startTime, long endTime) {
        long timeSlot = 0L;
        int type = ReportAnalysisUtil.getTimeSpanType(endTime, startTime);
        timeSlot = type == AnalysisConstants.LESS_THAN_SEVEN_DAYS ? NUM_THREE_THOUSAND_SIX_HUNDRED : (type == AnalysisConstants.MORE_THAN_SEVEN_DAYS ? 24L * NUM_THREE_THOUSAND_SIX_HUNDRED : NUM_THREE_HUNDRED);
        return timeSlot;
    }

    private Map<String, List<AttackTrendForm>> getAllCollectorIpTopNForm(Map<Long, List<AticDevice>> collectDevMap, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<AttackTrendForm>> allCollectorRequestTrendForm = new HashMap<String, List<AttackTrendForm>>();
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
            String collectorIp = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue()).getIpAddress();
            datastatConditionForm.setDeviceIpList(new ArrayList<String>());
            for (AticDevice firewall : entry.getValue()) {
                if (null == datastatConditionForm.getDeviceIpList()) {
                    datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                }
                datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
            }
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            Map<Object, Object> tempMap = new HashMap();
            try {
                tempMap = this.dataStatService.getAttackTrend(datastatConditionForm, collectorIp);
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey()), (Throwable)e);
            }
            allCollectorRequestTrendForm.putAll(tempMap);
        }
        return allCollectorRequestTrendForm;
    }

    private List<AttackTrendForm> getTopNForm(List<AttackTrendForm> allForm, int netMode) {
        for (int i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (!allForm.get(i).getDateTime().equals(allForm.get(j).getDateTime()) || allForm.get(i).getAttackType() != allForm.get(j).getAttackType()) continue;
                this.dealWithSame(allForm, netMode, i, j);
            }
        }
        return allForm;
    }

    private void dealWithSame(List<AttackTrendForm> allForm, int netMode, int i, int j) {
        if (netMode == 0) {
            if (allForm.get(i).getAttackTypePackagePps() > allForm.get(j).getAttackTypePackagePps()) {
                allForm.get(i).setAttackTypePackagePps(allForm.get(i).getAttackTypePackagePps());
            } else {
                allForm.get(i).setAttackTypePackagePps(allForm.get(j).getAttackTypePackagePps());
            }
            if (allForm.get(i).getAttackTypePackageKbps() > allForm.get(j).getAttackTypePackageKbps()) {
                allForm.get(i).setAttackTypePackageKbps(allForm.get(i).getAttackTypePackageKbps());
            } else {
                allForm.get(i).setAttackTypePackageKbps(allForm.get(j).getAttackTypePackageKbps());
            }
            allForm.remove(j);
        } else if (netMode == 1) {
            allForm.get(i).setAttackTypePackagePps(allForm.get(i).getAttackTypePackagePps() + allForm.get(j).getAttackTypePackagePps());
            allForm.get(i).setAttackTypePackageKbps(allForm.get(i).getAttackTypePackageKbps() + allForm.get(j).getAttackTypePackageKbps());
            allForm.remove(j);
        }
    }
}

