/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.attacktrend;

import com.hs.atic.analysis.report.attack.attacktrend.AttackTrend;
import com.hs.atic.analysis.report.attack.attacktrend.TransmitAttackTrendData;
import com.hs.atic.analysis.report.integration.AvgAndMaxView;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class AttackTrendTable4Integration
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<AvgAndMaxView> tableData = new ArrayList<AvgAndMaxView>();

    public List<AttackTrend> sortListByField(List<AttackTrend> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        if (pageIndex == 0L && pageSize == 0L) {
            return this.tableData;
        }
        ArrayList<AvgAndMaxView> list = new ArrayList<AvgAndMaxView>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= this.tableData.size()) {
            startIndex = this.tableData.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= this.tableData.size()) {
            endIndex = this.tableData.size();
        }
        if (this.tableData.isEmpty()) {
            return list;
        }
        list.addAll(this.tableData.subList(startIndex, endIndex));
        return list;
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start AttackTrendTable4Integration prepareData");
        try {
            List<String> attackTypeNameList = null;
            List<AttackTrend> dataList = TransmitAttackTrendData.getInstance().getDataList(sessionId);
            TransmitAttackTrendData.getInstance().removeData(sessionId);
            this.logger.info((Object)"removeDate from TransmitAttackTrendData");
            if (null == dataList || dataList.isEmpty()) {
                this.logger.info((Object)"dataList is null or empty");
                return 0;
            }
            attackTypeNameList = this.processAttackTypeNameList(dataList);
            boolean showPpsData = false;
            if ("attackTrendTablePpsDataSource".equalsIgnoreCase(dataSourceId)) {
                showPpsData = true;
            }
            this.tableData = this.processAvgAndMaxData4Table(attackTypeNameList, dataList, showPpsData);
            this.logger.info((Object)"end AttackTrendTable4Integration prepareData");
            return 0;
        }
        catch (LegoCheckedException legoException) {
            this.tableData.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.tableData.clear();
            this.logger.error((Object)"AttackTrendTable4Integration prepareData() unknow exception", (Throwable)e);
            return 0;
        }
    }

    private List<AvgAndMaxView> processAvgAndMaxData4Table(List<String> attackTypeNameList, List<AttackTrend> dataList, boolean showPpsDatas) {
        ArrayList<AvgAndMaxView> returnList = new ArrayList<AvgAndMaxView>();
        for (String attackTypeName : attackTypeNameList) {
            AvgAndMaxView avgAndMaxView = new AvgAndMaxView();
            Long totalDropPacket = 0L;
            Long maxDropPacket = 0L;
            Long maxDropPacketTime = 0L;
            int attackTypeNum = 0;
            for (AttackTrend attackTrend : dataList) {
                if (!attackTypeName.equals(attackTrend.getAttackTypeName())) continue;
                ++attackTypeNum;
                if (showPpsDatas) {
                    totalDropPacket = totalDropPacket + attackTrend.getAttackTypePackagePps();
                    maxDropPacketTime = maxDropPacket <= attackTrend.getAttackTypePackagePps() ? attackTrend.getDateTime() : maxDropPacketTime;
                    maxDropPacket = maxDropPacket < attackTrend.getAttackTypePackagePps() ? attackTrend.getAttackTypePackagePps() : maxDropPacket;
                    continue;
                }
                totalDropPacket = totalDropPacket + attackTrend.getAttackTypePackageKbps();
                maxDropPacketTime = maxDropPacket <= attackTrend.getAttackTypePackageKbps() ? attackTrend.getDateTime() : maxDropPacketTime;
                maxDropPacket = maxDropPacket < attackTrend.getAttackTypePackageKbps() ? attackTrend.getAttackTypePackageKbps() : maxDropPacket;
            }
            avgAndMaxView.setName(attackTypeName);
            avgAndMaxView.setAvgValue(attackTypeNum == 0 ? 0L : totalDropPacket / (long)attackTypeNum);
            avgAndMaxView.setMaxValue(maxDropPacket);
            avgAndMaxView.setLogTime(maxDropPacketTime);
            returnList.add(avgAndMaxView);
        }
        for (int i = 0; i < returnList.size(); ++i) {
            AvgAndMaxView temp = (AvgAndMaxView)returnList.get(i);
            int index = i % AnalysisConstants.getColorPool().size();
            String attackTypeColor = AnalysisConstants.getColorPool().get(index);
            temp.setNameColor(attackTypeColor);
        }
        return returnList;
    }

    private List<String> processAttackTypeNameList(List<AttackTrend> dataList) {
        ArrayList<String> attackTypeNameList = new ArrayList<String>();
        for (AttackTrend attackTrend : dataList) {
            if (attackTypeNameList.contains(attackTrend.getAttackTypeName())) continue;
            attackTypeNameList.add(attackTrend.getAttackTypeName());
        }
        return attackTypeNameList;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.tableData.size();
    }
}

