/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.attacktype;

import com.hs.atic.analysis.report.attack.attacktype.AtackTypeDistribute;
import com.hs.atic.analysis.report.attack.attacktype.AttackTypeComparator;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.AttackTypeDistributeForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class AttackTimeDestributionDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<AtackTypeDistribute> dataList = new ArrayList<AtackTypeDistribute>();
    private IDataStatService dataStatService;
    private String between0And7 = "00:00-07:00";
    private String between7And12 = "07:00-12:00";
    private String between12And18 = "12:00-18:00";
    private String between18And24 = "18:00-24:00";

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        this.getConditionForm(queryCond, datastatConditionForm, sessionId);
        if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
            return 0;
        }
        if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
            return 0;
        }
        if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
            return 0;
        }
        List<AttackTypeDistributeForm> attackTypeDistributeForms = null;
        if (datastatConditionForm.getDeviceId() <= 0L) {
            return 0;
        }
        attackTypeDistributeForms = this.getSingleDeviceCounts(datastatConditionForm);
        this.logger.info((Object)("prepareData timeDestribution attackTypeDisFormMap.size = " + attackTypeDistributeForms.size()));
        this.dataList = this.getTimeDestributionList(attackTypeDistributeForms, datastatConditionForm);
        return 0;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        List<JsonValueItem> jsonValueItemList = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "switchOption");
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItemList.get(0).getValue());
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItemList.get(0).getValue());
        if (direction.matches("^[\\d]*$")) {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        } else {
            datastatConditionForm.setDirection(1);
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "logType");
        String logType = String.valueOf(jsonValueItemList.get(0).getValue());
        if (AticUtil.isNull((String)logType)) {
            logType = 0 == datastatConditionForm.getDevSerType() ? "2" : "1";
        }
        datastatConditionForm.setAbnormalType(Integer.parseInt(logType));
        String zoneId = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        if (null != jsonValueItemList && !jsonValueItemList.isEmpty() && !"0".equals(zoneId = String.valueOf(jsonValueItemList.get(0).getValue()))) {
            datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        }
        if (!(null != datastatConditionForm.getZoneId() || AnalysisConstants.getInstance().getReportType().equalsIgnoreCase("ips") && AnalysisConstants.getInstance().getReportTypeIpsReport().booleanValue())) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
        String bisId = String.valueOf(jsonValueItemList.get(0).getValue());
        ReportAnalysisUtil.processServiceCond(datastatConditionForm, bisId);
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip");
        String zoneIp = String.valueOf(jsonValueItemList.get(0).getValue());
        if (!AticUtil.isNull((String)zoneIp)) {
            datastatConditionForm.setZoneIp(zoneIp);
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
    }

    private List<AttackTypeDistributeForm> getSingleDeviceCounts(DataStatConditionForm datastatConditionForm) {
        List<AttackTypeDistributeForm> formList = new ArrayList<AttackTypeDistributeForm>();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)(" .. no device exist, deviceId = " + datastatConditionForm.getDeviceId()));
            return formList;
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("..no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("..no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            formList = this.dataStatService.getAttackDurationAndTrafficPeakCountsDis(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("....rmi service error, Failed to connect to the collector,collectorIp = " + this.getcleanedMessage(collectorInfo.getIpAddress())), (Throwable)e);
        }
        return formList;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<AtackTypeDistribute> getTimeDestributionList(List<AttackTypeDistributeForm> timeInervalDisFormList, DataStatConditionForm dataForm) {
        List<AtackTypeDistribute> intervalDisList = new ArrayList<AtackTypeDistribute>();
        if (null == timeInervalDisFormList) {
            return intervalDisList;
        }
        Map<String, AttackTypeDistributeForm> allStartMap = this.getTimeStatistics(timeInervalDisFormList, dataForm);
        int totalNum = timeInervalDisFormList.size();
        intervalDisList.addAll(this.getTimePeriodPercentage(allStartMap, totalNum));
        Collections.sort(intervalDisList, new AttackTypeComparator());
        intervalDisList = this.processPercentFormat(intervalDisList);
        return intervalDisList;
    }

    private Map<String, AttackTypeDistributeForm> getTimeStatistics(List<AttackTypeDistributeForm> timeInervalDisFormList, DataStatConditionForm conditionForm) {
        HashMap<String, AttackTypeDistributeForm> attackTypeDisTempMap = new HashMap<String, AttackTypeDistributeForm>();
        for (AttackTypeDistributeForm attackTimeDistribute : timeInervalDisFormList) {
            Long time = attackTimeDistribute.getStartTimeAlert();
            if (conditionForm.getAbnormalType() == 2) {
                time = attackTimeDistribute.getStartTimeAttack();
            }
            AttackTypeDistributeForm tempForm = new AttackTypeDistributeForm();
            if (time <= 0L) continue;
            int start = Integer.parseInt(this.changeTimeStamp(time));
            if (start >= 0 && start < 7) {
                if (attackTypeDisTempMap.containsKey(this.between0And7)) {
                    tempForm.setCount(((AttackTypeDistributeForm)attackTypeDisTempMap.get(this.between0And7)).getCount() + 1L);
                } else {
                    tempForm.setCount(1L);
                }
                tempForm.setStartTimeAttackName(this.between0And7);
                attackTypeDisTempMap.put(this.between0And7, tempForm);
                continue;
            }
            if (start >= 7 && start < 12) {
                if (attackTypeDisTempMap.containsKey(this.between7And12)) {
                    tempForm.setCount(((AttackTypeDistributeForm)attackTypeDisTempMap.get(this.between7And12)).getCount() + 1L);
                } else {
                    tempForm.setCount(1L);
                }
                tempForm.setStartTimeAttackName(this.between7And12);
                attackTypeDisTempMap.put(this.between7And12, tempForm);
                continue;
            }
            if (start >= 12 && start < 18) {
                if (attackTypeDisTempMap.containsKey(this.between12And18)) {
                    tempForm.setCount(((AttackTypeDistributeForm)attackTypeDisTempMap.get(this.between12And18)).getCount() + 1L);
                } else {
                    tempForm.setCount(1L);
                }
                tempForm.setStartTimeAttackName(this.between12And18);
                attackTypeDisTempMap.put(this.between12And18, tempForm);
                continue;
            }
            if (start >= 18 && start < 24) {
                if (attackTypeDisTempMap.containsKey(this.between18And24)) {
                    tempForm.setCount(((AttackTypeDistributeForm)attackTypeDisTempMap.get(this.between18And24)).getCount() + 1L);
                } else {
                    tempForm.setCount(1L);
                }
                tempForm.setStartTimeAttackName(this.between18And24);
                attackTypeDisTempMap.put(this.between18And24, tempForm);
                continue;
            }
            this.logger.error((Object)"starttime is wrong!!!");
        }
        return attackTypeDisTempMap;
    }

    private String changeTimeStamp(Long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH");
        return sdf.format(new Date(time * 1000L));
    }

    private List<AtackTypeDistribute> getTimePeriodPercentage(Map<String, AttackTypeDistributeForm> timeIntervalTempMap, float total) {
        ArrayList<AtackTypeDistribute> timeIntervalPercent = new ArrayList<AtackTypeDistribute>();
        if (timeIntervalTempMap != null) {
            for (Map.Entry<String, AttackTypeDistributeForm> sortOutPercentage : timeIntervalTempMap.entrySet()) {
                AtackTypeDistribute distribute = new AtackTypeDistribute();
                long count = sortOutPercentage.getValue().getCount();
                float percentage = (float)count / total;
                distribute.setCount(count);
                distribute.setCountStr(this.formatCount(count));
                distribute.setPercent(percentage);
                distribute.setStartTimeAttackName(sortOutPercentage.getValue().getStartTimeAttackName());
                timeIntervalPercent.add(distribute);
            }
        }
        return timeIntervalPercent;
    }

    private List<AtackTypeDistribute> processPercentFormat(List<AtackTypeDistribute> intervalList) {
        float totalPercent = 0.0f;
        if (intervalList != null && !intervalList.isEmpty()) {
            for (AtackTypeDistribute atackTypeDis : intervalList) {
                float percent = this.formatPercent(atackTypeDis.getPercent());
                totalPercent += percent;
                atackTypeDis.setPercent(percent);
                atackTypeDis.setPercentStr(percent + "%");
            }
            AtackTypeDistribute distribute = intervalList.get(intervalList.size() - 1);
            if (distribute.getPercent() > 0.0f) {
                float formatPercent = this.formatPercent((distribute.getPercent() + 100.0f - totalPercent) / 100.0f);
                distribute.setPercent(formatPercent);
                distribute.setPercentStr(formatPercent + "%");
            }
        }
        return intervalList;
    }

    private float formatPercent(float percent) {
        int tmp = Math.round(percent * 1000.0f);
        float base = 10.0f;
        return (float)tmp / base;
    }

    private String formatCount(long count) {
        int comma = 0;
        String countStr = null;
        try {
            countStr = String.valueOf(count);
        }
        catch (Exception e) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int length = countStr.length();
        comma = length % 3 == 0 ? length / 3 - 1 : length / 3;
        int len = length - comma * 3;
        for (int i = 0; i <= comma; ++i) {
            if (i == 0) {
                buffer.append(countStr.substring(0, len));
                buffer.append(',');
                continue;
            }
            buffer.append(countStr.substring(len + (i - 1) * 3, len + i * 3));
            buffer.append(',');
        }
        countStr = buffer.substring(0, buffer.length() - 1);
        return countStr;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<AtackTypeDistribute> orderedList = null;
        if (null != sortList) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<AtackTypeDistribute> list = new ArrayList<AtackTypeDistribute>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (!orderedList.isEmpty()) {
            list.addAll(orderedList.subList(startIndex, endIndex));
        }
        return list;
    }

    public List<AtackTypeDistribute> sortListByField(List<AtackTypeDistribute> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getLogoAndNameMap(queryCond);
    }
}

