/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.attacktype;

import com.hs.atic.analysis.report.attack.attacktype.AtackTypeDistribute;
import com.hs.atic.analysis.report.attack.attacktype.AttackFormType;
import com.hs.atic.analysis.report.attack.attacktype.AttackTypeComparator;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.AttackTypeDistributeForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IFlexTableData;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class AttackTrafficCountDataSet
extends IJavaDataSource {
    private static final Long NUM_ONE_THOUSAND = 1000L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<AtackTypeDistribute> dataList = new ArrayList<AtackTypeDistribute>();
    private List<AticDevice> firewallList;
    private IDataStatService dataStatService;

    public List<IFlexTableData> getFlexTableHeader() {
        return null;
    }

    public List<AtackTypeDistribute> sortListByField(List<AtackTypeDistribute> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<AtackTypeDistribute> orderedList = null;
        if (null != sortList) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<AtackTypeDistribute> list = new ArrayList<AtackTypeDistribute>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return 0;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        List<JsonValueItem> jsonValueItemList = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "switchOption");
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItemList.get(0).getValue());
        String direction = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox").get(0).getValue();
        if (AticUtil.isNull((String)direction) || !direction.matches("^(0|1|2)$")) {
            datastatConditionForm.setDirection(1);
        } else {
            if ("0".equals(direction)) {
                direction = "1";
            }
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        String zoneId = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        if (null != jsonValueItemList && !jsonValueItemList.isEmpty() && !"0".equals(zoneId = String.valueOf(jsonValueItemList.get(0).getValue()))) {
            datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        }
        if (!(null != datastatConditionForm.getZoneId() || AnalysisConstants.getInstance().getReportType().equalsIgnoreCase("ips") && AnalysisConstants.getInstance().getReportTypeIpsReport().booleanValue())) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
        String bisId = String.valueOf(jsonValueItemList.get(0).getValue());
        ReportAnalysisUtil.processServiceCond(datastatConditionForm, bisId);
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip");
        String zoneIp = String.valueOf(jsonValueItemList.get(0).getValue());
        if (!AticUtil.isNull((String)zoneIp)) {
            datastatConditionForm.setZoneIp(zoneIp);
        }
        datastatConditionForm.setUnit(0);
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
    }

    private Map<String, List<AttackTypeDistributeForm>> getSingleDevicePacketsDis(DataStatConditionForm datastatConditionForm) {
        Map<String, List<AttackTypeDistributeForm>> formMap = new HashMap<String, List<AttackTypeDistributeForm>>();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == this.firewallList) {
            this.firewallList = new ArrayList<AticDevice>();
        }
        this.firewallList.add(firewall);
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            return formMap;
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            formMap = this.dataStatService.getAttackPacketsDis(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorIp = " + this.getcleanedMessage(collectorInfo.getIpAddress())), (Throwable)e);
        }
        return formMap;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private Map<String, List<AttackTypeDistributeForm>> getMultiDevicePacketsDis(Long currentLogUserId, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<AttackTypeDistributeForm>> formMap = new HashMap<String, List<AttackTypeDistributeForm>>();
        this.firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
        List accessDevIds = ReportBisUtil.getICollectorDeviceService().getAllDeviceAccess();
        AttackTrafficCountDataSet.processAccessFireWall4Security(this.firewallList, accessDevIds);
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        Map<Long, List<AticDevice>> collectDevMap = ReportAnalysisUtil.getCollectDevMap(this.firewallList);
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
            CollectorInfo collector = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue());
            if (null == collector) continue;
            String collectorIp = collector.getIpAddress();
            ArrayList<String> deviceIpList = new ArrayList<String>();
            for (AticDevice firewall : entry.getValue()) {
                deviceIpList.add(firewall.getIpAddress());
                datastatConditionForm.setDeviceIpList(deviceIpList);
            }
            Map<String, List<AttackTypeDistributeForm>> tempMap = null;
            try {
                tempMap = this.dataStatService.getAttackPacketsDis(datastatConditionForm, collectorIp);
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorIp = " + collectorIp), (Throwable)e);
            }
            if (null == tempMap || tempMap.isEmpty()) continue;
            formMap.putAll(tempMap);
        }
        return formMap;
    }

    private List<AttackTypeDistributeForm> getAttackTypeDisFormList(Map<String, List<AttackTypeDistributeForm>> attackTypeDisFormMap) {
        ArrayList<AttackTypeDistributeForm> formList = new ArrayList<AttackTypeDistributeForm>();
        if (null != attackTypeDisFormMap) {
            for (Map.Entry<String, List<AttackTypeDistributeForm>> map : attackTypeDisFormMap.entrySet()) {
                formList.addAll((Collection<AttackTypeDistributeForm>)map.getValue());
            }
        }
        return formList;
    }

    private List<AtackTypeDistribute> getAttackTypeDisList(List<AttackTypeDistributeForm> attackTypeDisFormList) {
        List<AtackTypeDistribute> attackTypeDisList = new ArrayList<AtackTypeDistribute>();
        if (null == attackTypeDisFormList) {
            return attackTypeDisList;
        }
        ArrayList<AttackTypeDistributeForm> customAttackList = new ArrayList<AttackTypeDistributeForm>();
        HashMap<Long, AttackTypeDistributeForm> attackTypeDisMap = new HashMap<Long, AttackTypeDistributeForm>();
        float totalCount = 0.0f;
        for (AttackTypeDistributeForm attackForm : attackTypeDisFormList) {
            attackForm.setCount(attackForm.getCount() / 8L);
            Long attackType = attackForm.getAttackType();
            totalCount += (float)attackForm.getCount().longValue();
            AttackTypeDistributeForm tempForm = null;
            if (attackType < 10L) {
                customAttackList.add(attackForm);
                continue;
            }
            if (attackTypeDisMap.containsKey(attackType)) {
                tempForm = (AttackTypeDistributeForm)attackTypeDisMap.get(attackType);
                long count = tempForm.getCount() + attackForm.getCount();
                tempForm.setCount(count);
                attackTypeDisMap.put(attackType, tempForm);
                continue;
            }
            attackTypeDisMap.put(attackType, attackForm);
        }
        if (totalCount == 0.0f) {
            return attackTypeDisList;
        }
        attackTypeDisList.addAll(this.getCustomAtackTypeList(customAttackList, totalCount));
        attackTypeDisList.addAll(this.getCommonAtackTypeList(attackTypeDisMap, totalCount));
        Collections.sort(attackTypeDisList, new AttackTypeComparator());
        attackTypeDisList = this.processPercent(attackTypeDisList);
        return attackTypeDisList;
    }

    private List<AtackTypeDistribute> getCustomAtackTypeList(List<AttackTypeDistributeForm> customAttackList, float totalCount) {
        ArrayList<AtackTypeDistribute> attackTypeList = new ArrayList<AtackTypeDistribute>();
        HashMap<AttackFormType, AttackTypeDistributeForm> map = new HashMap<AttackFormType, AttackTypeDistributeForm>();
        for (AttackTypeDistributeForm attackTypeDistributeForm : customAttackList) {
            AttackFormType attackFormType = new AttackFormType(attackTypeDistributeForm);
            if (map.containsKey(attackFormType)) {
                long count = ((AttackTypeDistributeForm)map.get(attackFormType)).getCount();
                ((AttackTypeDistributeForm)map.get(attackFormType)).setCount(count + attackTypeDistributeForm.getCount());
                continue;
            }
            map.put(attackFormType, attackTypeDistributeForm);
        }
        for (Map.Entry entry : map.entrySet()) {
            AtackTypeDistribute attack = new AtackTypeDistribute();
            attack.setAttackType(((AttackTypeDistributeForm)entry.getValue()).getAttackType());
            attack.setCount(((AttackTypeDistributeForm)entry.getValue()).getCount());
            attack.setAttackTypeName(ReportAnalysisUtil.getCustomAttackTypeStr(((AttackTypeDistributeForm)entry.getValue()).getZoneId(), ((AttackTypeDistributeForm)entry.getValue()).getDeviceIp(), ((AttackTypeDistributeForm)entry.getValue()).getProtocol(), ((AttackTypeDistributeForm)entry.getValue()).getPort()));
            attack.setPercent((float)((AttackTypeDistributeForm)entry.getValue()).getCount().longValue() / totalCount);
            attack.setCountStr(this.formatCount(((AttackTypeDistributeForm)entry.getValue()).getCount()));
            attackTypeList.add(attack);
        }
        return attackTypeList;
    }

    private List<AtackTypeDistribute> getCommonAtackTypeList(Map<Long, AttackTypeDistributeForm> attackTypeDisMap, float totalCount) {
        ArrayList<AtackTypeDistribute> attackTypeDisList = new ArrayList<AtackTypeDistribute>();
        if (null != attackTypeDisMap) {
            for (Map.Entry<Long, AttackTypeDistributeForm> attackTypeSet : attackTypeDisMap.entrySet()) {
                AtackTypeDistribute distribute = new AtackTypeDistribute();
                long counts = attackTypeSet.getValue().getCount();
                float percent = (float)counts / totalCount;
                distribute.setAttackType(attackTypeSet.getKey());
                distribute.setCount(counts);
                distribute.setCountStr(this.formatCount(counts));
                distribute.setPercent(percent);
                if (distribute.getAttackType() >= 10L) {
                    distribute.setAttackTypeName(ReportAnalysisUtil.getDisplayAttackType(String.valueOf(attackTypeSet.getKey())));
                } else {
                    distribute.setAttackTypeName(ReportAnalysisUtil.getCustomAttackTypeStr(attackTypeSet.getValue().getZoneId(), attackTypeSet.getValue().getDeviceIp(), attackTypeSet.getValue().getProtocol(), attackTypeSet.getValue().getPort()));
                }
                attackTypeDisList.add(distribute);
            }
        }
        return attackTypeDisList;
    }

    private List<AtackTypeDistribute> processPercent(List<AtackTypeDistribute> attackTypeDisList) {
        float totalPercent = 0.0f;
        if (null != attackTypeDisList && !attackTypeDisList.isEmpty()) {
            for (AtackTypeDistribute attackTypeDis : attackTypeDisList) {
                float percent = this.formatPercent(attackTypeDis.getPercent());
                totalPercent += percent;
                attackTypeDis.setPercent(percent);
                attackTypeDis.setPercentStr(percent + "%");
            }
            AtackTypeDistribute tempAttackType = attackTypeDisList.get(attackTypeDisList.size() - 1);
            if (tempAttackType.getPercent() > 0.0f) {
                float lastPercent = this.formatPercent((tempAttackType.getPercent() + 100.0f - totalPercent) / 100.0f);
                tempAttackType.setPercent(lastPercent);
                tempAttackType.setPercentStr(lastPercent + "%");
            }
        }
        return attackTypeDisList;
    }

    private float formatPercent(float percent) {
        int tmp = Math.round(percent * 1000.0f);
        float base = 10.0f;
        return (float)tmp / base;
    }

    private String formatCount(long count) {
        int comma = 0;
        String countStr = null;
        try {
            countStr = String.valueOf(count);
        }
        catch (Exception e) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int length = countStr.length();
        comma = length % 3 == 0 ? length / 3 - 1 : length / 3;
        int len = length - comma * 3;
        for (int i = 0; i <= comma; ++i) {
            if (i == 0) {
                buffer.append(countStr.substring(0, len));
                buffer.append(',');
                continue;
            }
            buffer.append(countStr.substring(len + (i - 1) * 3, len + i * 3));
            buffer.append(',');
        }
        countStr = buffer.substring(0, buffer.length() - 1);
        return countStr;
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        Map<String, List<String>> map = new HashMap<String, List<String>>();
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        try {
            boolean needQuery4InteReport = ReportAnalysisUtil.checkNeedQuery4InteReport(queryCond, "AttackDisPacket");
            if (!needQuery4InteReport) {
                return map;
            }
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return map;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return map;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return map;
            }
            Map<String, List<AttackTypeDistributeForm>> attackTypeDisFormMap = null;
            if (datastatConditionForm.getDeviceId() > 0L) {
                attackTypeDisFormMap = this.getSingleDevicePacketsDis(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                attackTypeDisFormMap = this.getMultiDevicePacketsDis(currentLogUserId, datastatConditionForm);
            }
            this.dataList = this.getAttackTypeDisList(this.getAttackTypeDisFormList(attackTypeDisFormMap));
            String isInteReport = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
            if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true")) {
                map = this.processRangeAxisLabel(this.dataList, queryCond);
            }
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"AttackPacketTopnDataSet prepareData happened exception !", (Throwable)e);
        }
        ArrayList<String> companyName = new ArrayList<String>();
        companyName.add(ReportAnalysisUtil.getCompanyName());
        map.put("companyName", companyName);
        ArrayList<String> logUrl = new ArrayList<String>();
        logUrl.add(ReportAnalysisUtil.getCompaneLog());
        map.put("logImageUrl", logUrl);
        return map;
    }

    private Map<String, List<String>> processRangeAxisLabel(List<AtackTypeDistribute> dataLists, Map<?, ?> queryCond) {
        String rangeAxisLabel = "";
        Long unit = 1L;
        for (AtackTypeDistribute atackTypeDistribute : dataLists) {
            if (AticUtil.isNull((String)rangeAxisLabel) && String.valueOf(atackTypeDistribute.getCount()).length() > 17) {
                unit = 1000000L * NUM_ONE_THOUSAND;
                rangeAxisLabel = "G";
            }
            if (AticUtil.isNull((String)rangeAxisLabel) && String.valueOf(atackTypeDistribute.getCount()).length() > 14) {
                unit = 1000L * NUM_ONE_THOUSAND;
                rangeAxisLabel = "M";
            }
            if (AticUtil.isNull((String)rangeAxisLabel) && String.valueOf(atackTypeDistribute.getCount()).length() > 11) {
                unit = NUM_ONE_THOUSAND;
                rangeAxisLabel = "K";
            }
            atackTypeDistribute.setCount(atackTypeDistribute.getCount() / unit);
        }
        Locale locale = ReportAnalysisUtil.getCurrentUserLocale4Report(queryCond);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<String> chartTitle = new ArrayList<String>();
        if (AticUtil.isNull((String)rangeAxisLabel)) {
            chartTitle.add(AticUtil.getText((String)"atic.analysis.attackDis.packet.chart.title", (Locale)locale));
        } else {
            chartTitle.add(AticUtil.getText((String)"atic.analysis.attackDis.packet.chart.title", (Locale)locale) + "(" + rangeAxisLabel + ")");
        }
        map.put("attackDis.packet.chart.title", chartTitle);
        return map;
    }

    private static void processAccessFireWall4Security(List<AticDevice> lstFireWall, List<Long> accessDevIds) {
        for (int i = lstFireWall.size() - 1; i >= 0; --i) {
            AticDevice securityNE = lstFireWall.get(i);
            boolean isContain = false;
            for (Long devId : accessDevIds) {
                if (!devId.equals(securityNE.getMoId())) continue;
                isContain = true;
                break;
            }
            if (isContain) continue;
            lstFireWall.remove(i);
        }
    }
}

