/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.bisattack;

import com.hs.atic.analysis.report.attack.bisattack.BisAttackTimeTopN;
import com.hs.atic.analysis.util.RedunDeviceForm;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.BisAttackTimeTopNForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.DeviceWorkTimeForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class BisAttackTimeTopNDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<BisAttackTimeTopN> dataList = new ArrayList<BisAttackTimeTopN>();
    private Long queryStartData;
    private Long queryEndData;
    private IDataStatService dataStatService;

    public List<BisAttackTimeTopN> sortListByField(List<BisAttackTimeTopN> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<BisAttackTimeTopNForm> sortZoneAttackTimeTopNFormListByField(List<BisAttackTimeTopNForm> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getLogoAndNameMap(queryCond);
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<BisAttackTimeTopN> orderedList = null;
        if (sortList != null) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<BisAttackTimeTopN> list = new ArrayList<BisAttackTimeTopN>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start BisAttackTimeTopNDataSet prepareData");
        List<BisAttackTimeTopNForm> bisTopNFormList = null;
        Map<String, List<BisAttackTimeTopNForm>> allCollectorForm = null;
        try {
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            List<BisAttackTimeTopNForm> formDataList = null;
            if (datastatConditionForm.getDeviceId() > 0L) {
                formDataList = this.getSingleDeviceData(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
                allCollectorForm = -2L == datastatConditionForm.getDeviceId() ? this.getAllDetectDeviceDate(firewallList, datastatConditionForm) : this.getAllCollectorIpTopNForm(firewallList, datastatConditionForm);
                formDataList = this.processMultZoneNE(allCollectorForm);
            }
            bisTopNFormList = this.getTopNForm(formDataList, datastatConditionForm.getTopn());
            this.dataList = this.getAttackTimeFormDate(bisTopNFormList, queryCond);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"BisAttackTimeTopNDataSet prepareData() unknow exception", (Throwable)e);
        }
        this.logger.info((Object)"end BisAttackTimeTopNDataSet prepareData");
        return 0;
    }

    private List<BisAttackTimeTopNForm> processMultZoneNE(Map<String, List<BisAttackTimeTopNForm>> allCollectorForm) {
        ArrayList<BisAttackTimeTopNForm> returnData = new ArrayList<BisAttackTimeTopNForm>();
        Map<Long, Map<String, List<BisAttackTimeTopNForm>>> bizDeviceData = this.processMultNEBisData(allCollectorForm);
        for (Map.Entry<Long, Map<String, List<BisAttackTimeTopNForm>>> entry : bizDeviceData.entrySet()) {
            if (1 == entry.getValue().size()) {
                Long totalDate = 0L;
                Object zoneId = 0L;
                for (Map.Entry<String, List<BisAttackTimeTopNForm>> bizData : entry.getValue().entrySet()) {
                    for (BisAttackTimeTopNForm form : bizData.getValue()) {
                        totalDate = totalDate + form.getTotalDate();
                        zoneId = form.getZoneId();
                    }
                }
                BisAttackTimeTopNForm bisAttackTimeTopNForm = new BisAttackTimeTopNForm();
                bisAttackTimeTopNForm.setBisId(entry.getKey());
                bisAttackTimeTopNForm.setZoneId((Long)zoneId);
                bisAttackTimeTopNForm.setTotalDate(totalDate);
                returnData.add(bisAttackTimeTopNForm);
                continue;
            }
            ArrayList<BisAttackTimeTopNForm> bizData = new ArrayList<BisAttackTimeTopNForm>();
            for (Map.Entry entry2 : entry.getValue().entrySet()) {
                bizData.addAll((Collection)entry2.getValue());
            }
            BisAttackTimeTopNForm temp = this.processBizTotalData(bizData);
            if (null == temp) continue;
            returnData.add(temp);
        }
        return returnData;
    }

    private Map<Long, Map<String, List<BisAttackTimeTopNForm>>> processMultNEBisData(Map<String, List<BisAttackTimeTopNForm>> allCollectorForm) {
        HashMap<Long, Map<String, List<BisAttackTimeTopNForm>>> bizDeviceData = new HashMap<Long, Map<String, List<BisAttackTimeTopNForm>>>();
        for (Map.Entry<String, List<BisAttackTimeTopNForm>> entry : allCollectorForm.entrySet()) {
            for (BisAttackTimeTopNForm bizData : entry.getValue()) {
                List<BisAttackTimeTopNForm> list;
                Map deviceData;
                if (bizDeviceData.containsKey(bizData.getBisId())) {
                    deviceData = (Map)bizDeviceData.get(bizData.getBisId());
                    list = deviceData.containsKey(bizData.getDeviceIp()) ? (List)deviceData.get(bizData.getDeviceIp()) : new ArrayList();
                } else {
                    deviceData = new HashMap();
                    list = new ArrayList<BisAttackTimeTopNForm>();
                }
                list.add(bizData);
                deviceData.put(bizData.getDeviceIp(), list);
                bizDeviceData.put(bizData.getBisId(), deviceData);
            }
        }
        return bizDeviceData;
    }

    private BisAttackTimeTopNForm processBizTotalData(List<BisAttackTimeTopNForm> zoneDataList) {
        if (null == zoneDataList || zoneDataList.isEmpty()) {
            return null;
        }
        List<BisAttackTimeTopNForm> orderForm = this.sortZoneAttackTimeTopNFormListByField(zoneDataList, "startDate", "ASC");
        ArrayList<BisAttackTimeTopNForm> unionList = new ArrayList<BisAttackTimeTopNForm>();
        unionList.add(orderForm.get(0));
        for (int i = 1; i < orderForm.size(); ++i) {
            BisAttackTimeTopNForm check = (BisAttackTimeTopNForm)unionList.get(unionList.size() - 1);
            if (orderForm.get(i).getEndData() <= check.getEndData()) continue;
            if (orderForm.get(i).getStartDate() > check.getEndData()) {
                unionList.add(orderForm.get(i));
                continue;
            }
            if (orderForm.get(i).getStartDate() > check.getEndData()) continue;
            ((BisAttackTimeTopNForm)unionList.get(unionList.size() - 1)).setEndData(orderForm.get(i).getEndData());
        }
        Long startTime = ((BisAttackTimeTopNForm)unionList.get(0)).getStartDate();
        Long endTime = ((BisAttackTimeTopNForm)unionList.get(unionList.size() - 1)).getEndData();
        if (this.queryStartData > startTime) {
            ((BisAttackTimeTopNForm)unionList.get(0)).setStartDate(this.queryStartData);
        }
        if (this.queryEndData < endTime) {
            ((BisAttackTimeTopNForm)unionList.get(unionList.size() - 1)).setEndData(this.queryEndData);
        }
        Long totalDate = 0L;
        for (BisAttackTimeTopNForm form : unionList) {
            totalDate = totalDate + (form.getEndData() - form.getStartDate());
        }
        BisAttackTimeTopNForm returnData = new BisAttackTimeTopNForm();
        returnData.setTotalDate(totalDate);
        returnData.setZoneId(((BisAttackTimeTopNForm)unionList.get(0)).getZoneId());
        returnData.setBisId(((BisAttackTimeTopNForm)unionList.get(0)).getBisId());
        return returnData;
    }

    private List<BisAttackTimeTopN> getAttackTimeFormDate(List<BisAttackTimeTopNForm> bisTopNFormList, Map<?, ?> queryCond) {
        HashMap<String, Integer> sameBizNameNum = new HashMap<String, Integer>();
        IZoneService zoneService = ReportBisUtil.getZoneService();
        for (BisAttackTimeTopNForm form : bisTopNFormList) {
            ZoneInfoForm zoneForm = zoneService.getById(form.getZoneId());
            if (null == zoneForm || "".equals(zoneForm.getZoneDesc())) {
                this.logger.info((Object)("the zone not exist,zoneId = " + form.getZoneId()));
                form.setZoneName(AticUtil.getText((String)"atic.analysis.common.unknownZone") + form.getZoneId());
            } else {
                form.setZoneName(zoneForm.getZoneDesc());
            }
            ZoneServiceForm serviceForm = ReportBisUtil.getZoneMgrNorthSerice().getBizTypeById(form.getBisId());
            String bisNameTemp = "";
            if (null != serviceForm) {
                bisNameTemp = serviceForm.getServiceName();
            } else {
                this.logger.info((Object)("the biz id=" + form.getBisId() + " exist"));
                bisNameTemp = AticUtil.getText((String)"atic.analysis.common.unknownBiz") + form.getBisId();
            }
            form.setBisName(bisNameTemp);
            if (sameBizNameNum.containsKey(form.getBisName())) {
                int newNum = (Integer)sameBizNameNum.get(form.getBisName()) + 1;
                sameBizNameNum.put(form.getBisName(), newNum);
                continue;
            }
            sameBizNameNum.put(form.getBisName(), 1);
        }
        Set set = sameBizNameNum.entrySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Integer num = (Integer)entry.getValue();
            if (num > 1) continue;
            iter.remove();
        }
        return this.getReturnDataList(bisTopNFormList, sameBizNameNum, queryCond);
    }

    private List<BisAttackTimeTopN> getReturnDataList(List<BisAttackTimeTopNForm> bisTopNFormList, Map<String, Integer> sameBizNameNum, Map<?, ?> queryCond) {
        ArrayList<BisAttackTimeTopN> returnDataList = new ArrayList<BisAttackTimeTopN>();
        Locale locale = ReportAnalysisUtil.getCurrentUserLocale4Report(queryCond);
        for (int i = 0; i < bisTopNFormList.size(); ++i) {
            BisAttackTimeTopN data = new BisAttackTimeTopN();
            data.setTotalDate(bisTopNFormList.get(i).getTotalDate());
            data.setDisTotalDate(ReportAnalysisUtil.longTimeToTotalHMS(bisTopNFormList.get(i).getTotalDate(), locale));
            data.setZoneName(bisTopNFormList.get(i).getZoneName());
            String key = bisTopNFormList.get(i).getBisName();
            if (sameBizNameNum.containsKey(key) && sameBizNameNum.get(key) > 0) {
                int tempNum = sameBizNameNum.get(key);
                data.setBisName(key + "(" + tempNum + ")");
                sameBizNameNum.put(key, tempNum - 1);
            } else {
                data.setBisName(key);
            }
            returnDataList.add(data);
        }
        return returnDataList;
    }

    private Map<String, List<BisAttackTimeTopNForm>> getAllDetectDeviceDate(List<AticDevice> firewallList, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<BisAttackTimeTopNForm>> allCollectorForm = new HashMap<String, List<BisAttackTimeTopNForm>>();
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        Map<Long, List<RedunDeviceForm>> redunMap = ReportAnalysisUtil.getRedunFirewallInfoList(firewallList);
        for (Map.Entry<Long, List<RedunDeviceForm>> redun : redunMap.entrySet()) {
            List<DeviceWorkTimeForm> workTimeList = ReportAnalysisUtil.getWorkTimeList(datastatConditionForm, redun);
            for (DeviceWorkTimeForm form : workTimeList) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(form.getDeviceIp());
                datastatConditionForm.setDeviceIpList(list);
                datastatConditionForm.setStartTime(form.getStartTime());
                datastatConditionForm.setEndTime(form.getEndTime());
                Map<Object, Object> tempFormMap = new HashMap();
                try {
                    tempFormMap = this.dataStatService.getBisAttackTimeTopN(datastatConditionForm, form.getCollectorIp());
                }
                catch (Exception e) {
                    this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorIp = " + form.getCollectorIp()), (Throwable)e);
                }
                if (null == tempFormMap || tempFormMap.isEmpty()) continue;
                if (allCollectorForm.containsKey(form.getDeviceIp())) {
                    ((List)allCollectorForm.get(form.getDeviceIp())).addAll((Collection)tempFormMap.get(form.getDeviceIp()));
                    continue;
                }
                allCollectorForm.putAll(tempFormMap);
            }
        }
        List<AticDevice> redunFirewallList = ReportAnalysisUtil.getRedunFirewallList(redunMap);
        if (!redunFirewallList.isEmpty()) {
            firewallList.removeAll(redunFirewallList);
        }
        if (!firewallList.isEmpty()) {
            allCollectorForm.putAll(this.getAllCollectorIpTopNForm(firewallList, datastatConditionForm));
        }
        return allCollectorForm;
    }

    private List<BisAttackTimeTopNForm> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        ArrayList<BisAttackTimeTopNForm> returnData = new ArrayList<BisAttackTimeTopNForm>();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            Map<String, List<BisAttackTimeTopNForm>> allCollectorForm = this.dataStatService.getBisAttackTimeTopN(datastatConditionForm, collectorInfo.getIpAddress());
            for (Map.Entry<String, List<BisAttackTimeTopNForm>> entry : allCollectorForm.entrySet()) {
                returnData.addAll((Collection<BisAttackTimeTopNForm>)entry.getValue());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return returnData;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItem.get(0).getValue());
        if (direction.matches("^[\\d]*$")) {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        } else {
            datastatConditionForm.setDirection(1);
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        String zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        if (0L == datastatConditionForm.getZoneId()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        this.queryStartData = datastatConditionForm.getStartTime();
        this.queryEndData = datastatConditionForm.getEndTime();
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
        String topn = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setTopn(Integer.parseInt(topn));
    }

    private Map<String, List<BisAttackTimeTopNForm>> getAllCollectorIpTopNForm(List<AticDevice> firewallList, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<BisAttackTimeTopNForm>> allCollectorIpTopNForm = new HashMap<String, List<BisAttackTimeTopNForm>>();
        if (!firewallList.isEmpty()) {
            Map<Long, List<AticDevice>> collectDevMap = ReportAnalysisUtil.getCollectDevMap(firewallList);
            for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
                String collectorIp = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue()).getIpAddress();
                datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                for (AticDevice firewall : entry.getValue()) {
                    if (null == datastatConditionForm.getDeviceIpList()) {
                        datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                    }
                    datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
                }
                this.dataStatService = ReportAnalysisUtil.getDataStatService();
                try {
                    allCollectorIpTopNForm.putAll(this.dataStatService.getBisAttackTimeTopN(datastatConditionForm, collectorIp));
                }
                catch (Exception e) {
                    this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey()), (Throwable)e);
                }
            }
        }
        return allCollectorIpTopNForm;
    }

    private List<BisAttackTimeTopNForm> getTopNForm(List<BisAttackTimeTopNForm> allCollectorForm, int topn) {
        List<BisAttackTimeTopNForm> allForm = this.sortZoneAttackTimeTopNFormListByField(allCollectorForm, "totalDate", "DESC");
        this.processData4Order(allForm);
        if (allForm.size() > topn) {
            for (int i = allForm.size() - 1; i >= topn; --i) {
                allForm.remove(i);
            }
        }
        return allForm;
    }

    private void processData4Order(List<BisAttackTimeTopNForm> orderformList) {
        for (int i = 0; i < orderformList.size(); ++i) {
            for (int j = i + 1; j < orderformList.size(); ++j) {
                if (!orderformList.get(i).getTotalDate().equals(orderformList.get(j).getTotalDate())) continue;
                this.processItemOrder(orderformList, i, j);
            }
        }
    }

    private void processItemOrder(List<BisAttackTimeTopNForm> orderformList, int i, int j) {
        if (orderformList.get(i).getBisId() > orderformList.get(j).getBisId()) {
            BisAttackTimeTopNForm temp = orderformList.get(i);
            orderformList.set(i, orderformList.get(j));
            orderformList.set(j, temp);
        } else if (orderformList.get(i).getBisId().equals(orderformList.get(j).getBisId()) && orderformList.get(i).getZoneId() > orderformList.get(j).getZoneId()) {
            BisAttackTimeTopNForm temp = orderformList.get(i);
            orderformList.set(i, orderformList.get(j));
            orderformList.set(j, temp);
        }
    }

    public Long getQueryStartData() {
        return this.queryStartData;
    }

    public void setQueryStartData(Long queryStartData) {
        this.queryStartData = queryStartData;
    }

    public Long getQueryEndData() {
        return this.queryEndData;
    }

    public void setQueryEndData(Long queryEndData) {
        this.queryEndData = queryEndData;
    }
}

