/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.ipattack;

import com.hs.atic.analysis.report.attack.ipattack.IpAttackFlowPeakTopN;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.DataEncodeUtil;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.AttackFlowPeakTopNForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class IpAttackFlowPeakKBPSDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<IpAttackFlowPeakTopN> dataList = new ArrayList<IpAttackFlowPeakTopN>();
    private IDataStatService dataStatService;
    private String zoneIp;

    public List<IpAttackFlowPeakTopN> sortListByField(List<IpAttackFlowPeakTopN> beSortedList, String sortField, String sortType) {
        if (sortField.equalsIgnoreCase("disIp")) {
            sortField = "zoneIp";
        }
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<AttackFlowPeakTopNForm> sortZoneAttackTimeTopNFormListByField(List<AttackFlowPeakTopNForm> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        Map<String, List<String>> prepareParasMap = ReportAnalysisUtil.getLogoAndNameMap(queryCond);
        ReportAnalysisUtil.getIpAttackTitleAndColumnName(queryCond, prepareParasMap);
        this.logger.info((Object)("prepareParasMap is " + prepareParasMap.size()));
        return prepareParasMap;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<IpAttackFlowPeakTopN> orderedList = null;
        if (sortList != null) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<IpAttackFlowPeakTopN> list = new ArrayList<IpAttackFlowPeakTopN>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start IpAttackFlowFeakTopNDataSet prepareData");
        List<AttackFlowPeakTopNForm> ipTopNFormList = null;
        try {
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            List<AttackFlowPeakTopNForm> formDataList = new ArrayList<AttackFlowPeakTopNForm>();
            if (datastatConditionForm.getDeviceId() > 0L) {
                formDataList = this.getSingleDeviceData(datastatConditionForm);
            }
            ipTopNFormList = this.getTopNForm(formDataList, datastatConditionForm.getTopn());
            this.dataList = this.getAttackTimeFormDate(ipTopNFormList, queryCond);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"IpAttackFlowFeakTopNDataSet prepareData() unknow exception", (Throwable)e);
        }
        this.logger.info((Object)"end IpAttackFlowFeakTopNDataSet prepareData");
        return 0;
    }

    private List<IpAttackFlowPeakTopN> getAttackTimeFormDate(List<AttackFlowPeakTopNForm> ipTopNFormList, Map<?, ?> queryCond) {
        HashMap<String, Integer> sameIpNameNum = new HashMap<String, Integer>();
        for (AttackFlowPeakTopNForm form : ipTopNFormList) {
            if (sameIpNameNum.containsKey(form.getZoneIp())) {
                int newNum = (Integer)sameIpNameNum.get(form.getZoneIp()) + 1;
                sameIpNameNum.put(form.getZoneIp(), newNum);
                continue;
            }
            sameIpNameNum.put(form.getZoneIp(), 1);
        }
        Set set = sameIpNameNum.entrySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Integer num = (Integer)entry.getValue();
            if (num > 1) continue;
            iter.remove();
        }
        return this.processFinalData(queryCond, ipTopNFormList, sameIpNameNum);
    }

    private List<IpAttackFlowPeakTopN> processFinalData(Map<?, ?> queryCond, List<AttackFlowPeakTopNForm> ipTopNFormList, Map<String, Integer> sameIpNameNum) {
        ArrayList<IpAttackFlowPeakTopN> returnDataList = new ArrayList<IpAttackFlowPeakTopN>();
        IZoneService zoneService = ReportBisUtil.getZoneService();
        Locale locale = ReportAnalysisUtil.getCurrentUserLocale4Report(queryCond);
        for (int i = 0; i < ipTopNFormList.size(); ++i) {
            IpAttackFlowPeakTopN data = new IpAttackFlowPeakTopN();
            ZoneInfoForm zoneForm = zoneService.getById(ipTopNFormList.get(i).getZoneId());
            if (null == zoneForm || "".equals(zoneForm.getZoneDesc())) {
                this.logger.info((Object)("the zone not exist,zoneId = " + ipTopNFormList.get(i).getZoneId()));
                data.setZoneName(AticUtil.getText((String)"atic.analysis.common.unknownZone", (Locale)locale) + ipTopNFormList.get(i).getZoneId());
            } else {
                data.setZoneName(zoneForm.getZoneDesc());
            }
            String key = ipTopNFormList.get(i).getZoneIp();
            if (sameIpNameNum.containsKey(key) && sameIpNameNum.get(key) > 0) {
                int tempNum = sameIpNameNum.get(key);
                data.setDisIp(IPUtil4Atic.compressIP((String)key) + "(" + tempNum + ")");
                sameIpNameNum.put(key, tempNum - 1);
            } else {
                data.setDisIp(IPUtil4Atic.compressIP((String)ipTopNFormList.get(i).getZoneIp()));
            }
            data.setZoneIp(ipTopNFormList.get(i).getZoneIp());
            data.setAttackFlowPeakkbps(ipTopNFormList.get(i).getAttackFlowPeakkbps());
            data.setAttackFlowPeakpps(ipTopNFormList.get(i).getAttackFlowPeakpps());
            returnDataList.add(data);
        }
        return returnDataList;
    }

    private List<AttackFlowPeakTopNForm> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        ArrayList<AttackFlowPeakTopNForm> returnData = new ArrayList<AttackFlowPeakTopNForm>();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            Map<String, List<AttackFlowPeakTopNForm>> allCollectorForm = this.dataStatService.getIpAttackFlowPeakTopN(datastatConditionForm, collectorInfo.getIpAddress());
            for (Map.Entry<String, List<AttackFlowPeakTopNForm>> entry : allCollectorForm.entrySet()) {
                returnData.addAll((Collection<AttackFlowPeakTopNForm>)entry.getValue());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return returnData;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItem.get(0).getValue());
        if (direction.matches("^[\\d]*$")) {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        } else {
            datastatConditionForm.setDirection(1);
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        String zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        if (!(0L != datastatConditionForm.getZoneId() || AnalysisConstants.getInstance().getReportType().equalsIgnoreCase("ips") && AnalysisConstants.getInstance().getReportTypeIpsReport().booleanValue())) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        if (!AticUtil.isNull((String)this.zoneIp)) {
            datastatConditionForm.setZoneIp(DataEncodeUtil.encode(this.zoneIp));
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
        String topn = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setTopn(Integer.parseInt(topn));
        String isInteReport = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
        if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true")) {
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "AbnormalOrAttackTopNTOPN");
            String topn4Inte = String.valueOf(jsonValueItem.get(0).getValue());
            Integer topn4InteValue = Integer.parseInt(topn4Inte);
            datastatConditionForm.setTopn(topn4InteValue);
        }
    }

    private List<AttackFlowPeakTopNForm> getTopNForm(List<AttackFlowPeakTopNForm> allCollectorForm, int topn) {
        List<AttackFlowPeakTopNForm> allForm = this.sortZoneAttackTimeTopNFormListByField(allCollectorForm, "attackFlowPeakkbps", "DESC");
        if (allForm.size() > topn) {
            for (int i = allForm.size() - 1; i >= topn; --i) {
                allForm.remove(i);
            }
        }
        return allForm;
    }

    public String getZoneIp() {
        return this.zoneIp;
    }

    public void setZoneIp(String zoneIp) {
        this.zoneIp = zoneIp;
    }

    public List<IpAttackFlowPeakTopN> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<IpAttackFlowPeakTopN> dataList) {
        this.dataList = dataList;
    }
}

