/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.log;

import com.hs.atic.analysis.report.attack.log.AttackExactLog;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.analysis.util.ReportAticUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.sdk.analysis.form.AttackExactLogForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.sdk.util.MathUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.CommonUtil;
import com.opensymphony.xwork2.ActionContext;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class AttackExactLogDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<AttackExactLog> dataList = new ArrayList<AttackExactLog>();
    private IDataStatService dataStatService;
    private String nextLineStr = "<br>";

    public List<AttackExactLog> sortListByField(List<AttackExactLog> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        this.nextLineStr = pageSize > 100L ? "\n" : "<br>";
        for (AttackExactLog log : this.dataList) {
            String attackLogInfo = "";
            attackLogInfo = attackLogInfo + ReportAticUtil.getText("atic.analysis.common.ip.address") + log.getDisZoneIp() + this.nextLineStr + ReportAticUtil.getText("atic.analysis.common.ip.port") + log.getDestinationPort() + this.nextLineStr + ReportAticUtil.getText("atic.analysis.common.zone") + log.getZoneDesc();
            log.setAttackLogInfo(attackLogInfo);
            String endTime = log.getDisEndTime().length() > 5 ? log.getDisEndTime().substring(5) : log.getDisEndTime();
            log.setAttackLogTimes(ReportAticUtil.getText("atic.analysis.report.time.start") + log.getDisStartTimeAlert().substring(5) + this.nextLineStr + ReportAticUtil.getText("atic.analysis.report.time.end") + endTime);
            log.setAttackTypeAndPacket(ReportAticUtil.getText("atic.analysis.common.type") + log.getAttackType() + this.nextLineStr + ReportAticUtil.getText("atic.analysis.report.attack.dropPacket") + log.getDropPackets());
            double avgPackLength = 0.0;
            if (log.getDropBytes() > 0L && log.getDropPackets() > 0L) {
                avgPackLength = MathUtil.getDoubleValue((double)((double)(log.getDropBytes() * 1024L) / (double)(log.getDropPackets() * 8L)));
                avgPackLength = avgPackLength < 88.0 ? 64.0 : avgPackLength - 24.0;
            }
            String curAndLimit = "";
            if (1 == log.getDeviceType() || log.getStartTimeAttack() <= 0L) {
                curAndLimit = curAndLimit + ReportAticUtil.getText("atic.analysis.report.attack.attackFlow") + log.getCurrentDis() + this.nextLineStr + ReportAticUtil.getText("atic.report.integration.limitValue") + log.getLimitDis();
            } else {
                String unit = log.getPpsOrKbps() == 2 ? "qps" : "pps";
                curAndLimit = curAndLimit + ReportAticUtil.getText("atic.analysis.report.attack.dropKbits") + CommonUtil.transformNumber((String)String.valueOf(log.getDropBytes() / 8L), (String)"") + this.nextLineStr + ReportAticUtil.getText("atic.analysis.report.average.pack.length") + CommonUtil.transformNumber((String)String.valueOf(avgPackLength), (String)"") + this.nextLineStr + ReportAticUtil.getText("atic.analysis.report.attack.attackFlow") + log.getCurrentDis() + this.nextLineStr + ReportAticUtil.getText("atic.analysis.report.attack.flow.peak") + CommonUtil.transformNumber((String)String.valueOf(log.getMaxAttackPeakbps()), (String)"kbps/") + CommonUtil.transformNumber((String)String.valueOf(log.getMaxAttackPeakPps()), (String)unit) + this.nextLineStr + ReportAticUtil.getText("atic.report.integration.limitValue") + log.getLimitDis();
            }
            log.setAttackCurAndLimit(curAndLimit);
        }
        List<AttackExactLog> orderedList = null;
        if (sortList != null) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<AttackExactLog> list = new ArrayList<AttackExactLog>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.dataList.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "attackLogPkid");
        Long attackLogPkid = Long.parseLong(jsonValueItem.get(0).getValue());
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "collectorIp");
        String collectorIp = String.valueOf(jsonValueItem.get(0).getValue());
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit");
        String unit = String.valueOf(jsonValueItem.get(0).getValue());
        JsonValueObj objUnit = (JsonValueObj)queryCond.get("unit");
        if (null != objUnit) {
            objUnit.setShowInfo("false");
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        int direction = Integer.parseInt(jsonValueItem.get(0).getValue());
        JsonValueObj objDirection = (JsonValueObj)queryCond.get("direction_combobox");
        if (null != objDirection) {
            objDirection.setShowInfo("false");
        }
        List<AttackExactLogForm> attackExactLogFormList = null;
        try {
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            Locale locale = LocaleUtil.INSTANCE.getCurrentUserLocale();
            String language = locale.getLanguage();
            attackExactLogFormList = this.dataStatService.getAttackExactLog(attackLogPkid, collectorIp, language, direction);
            if (null == attackExactLogFormList) {
                this.logger.info((Object)"AttackExactLogFormList is null !");
                return 0;
            }
            for (AttackExactLogForm form : attackExactLogFormList) {
                this.processExactLogItem(form, collectorIp, sessionId, direction, unit);
            }
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"AttackExactLogDataSet prepareData happened exception !", (Throwable)e);
        }
        return 0;
    }

    private void processExactLogItem(AttackExactLogForm form, String collectorIp, long sessionId, int direction, String unit) {
        AttackExactLog log = new AttackExactLog();
        AticUtil.copyProperties((Object)form, (Object)log);
        this.processSrcIpAndZoneIp(form, log, sessionId, collectorIp);
        this.processZoneName(form, log);
        log.setDisplayDuration(ReportAnalysisUtil.longTimeToHMS(log.getDuration()));
        if (0 != form.getAttackStatus()) {
            log.setDisEndTime("-");
        }
        this.processAttackType(form, log);
        this.processUnit(form, log);
        ActionContext ctx = ActionContext.getContext();
        if (null != ctx) {
            HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            String checkPcapFile = this.processPcapFile(request, form, collectorIp, log);
            log.setCheckPcapFile(checkPcapFile);
            String checkFlowGraph = this.processFlowGraph(request, collectorIp, form, sessionId, direction, unit);
            log.setCheckFlowGraph(checkFlowGraph);
        }
        Map<String, JsonValueObj> reportQueryCond = this.processSingleAttackSnap(form, collectorIp, log, unit);
        log.setQueryCondtion(reportQueryCond);
        this.dataList.add(log);
    }

    private void processAttackType(AttackExactLogForm form, AttackExactLog log) {
        log.setAttackStatuStr(ReportAnalysisUtil.getExactLogAttackStatus().get(String.valueOf(form.getAttackStatus())));
        if (log.getAttackTypeValue() >= 10) {
            log.setAttackType(ReportAnalysisUtil.getDisplayAttackType(String.valueOf(log.getAttackTypeValue())));
        } else {
            log.setAttackType(ReportAnalysisUtil.getCustomAttackTypeStr(form.getZoneId(), form.getDeviceIp(), form.getProtocol(), form.getPort()));
        }
    }

    private void processZoneName(AttackExactLogForm form, AttackExactLog log) {
        ZoneInfoForm zoneForm = ReportBisUtil.getZoneService().getById(form.getZoneId());
        if (null != zoneForm) {
            log.setZoneDesc(zoneForm.getZoneDesc());
        } else {
            this.logger.info((Object)("the zone not exist,zoneId = " + form.getZoneId()));
            log.setZoneDesc(ReportAticUtil.getText("atic.analysis.common.unknownZone") + form.getZoneId());
        }
    }

    private void processSrcIpAndZoneIp(AttackExactLogForm form, AttackExactLog log, long sessionId, String collectorIp) {
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        String checkAttackSrcTopn = "<img src=\"" + request.getContextPath() + "/vsm/atic/resource/skins/images/event_down.gif\" />";
        if (!AticUtil.isNull((String)log.getSrcIp())) {
            String[] srcIpStr = log.getSrcIp().split(",");
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < srcIpStr.length; ++i) {
                buf.append(IPUtil4Atic.compressIP((String)srcIpStr[i]));
                buf.append(';');
            }
            String srcIpCompress = buf.toString();
            srcIpCompress = srcIpCompress.substring(0, srcIpCompress.length() - 1);
            log.setSrcIp(srcIpCompress);
            if (!AticUtil.isNull((String)log.getAttackSrcIpFlow())) {
                checkAttackSrcTopn = "<a style='cursor:pointer' title=\"" + ReportAticUtil.getText("atic.analysis.exact.log.attackSrc.flowTopn") + "\" href=\"javascript:window.open('" + request.getContextPath() + "/atic/ireport/dataDrill.do?reportId=attackSrcTopN" + "&attackExactLogPkid=" + log.getId() + "&reportSessionId=" + sessionId + "&collectorIp=" + collectorIp + "&dataDrillTitle=&IREPORT_WOS_CODE=','_blank');void(0);\" > <img src=\"" + request.getContextPath() + "/vsm/atic/resource/skins/images/event.gif\" /> </a>";
            }
        } else {
            log.setSrcIp("-");
        }
        log.setCheckAttackSrcTopn(checkAttackSrcTopn);
        if (form.getZoneIp().equals("0") && form.getBizId() == 0L) {
            log.setDisZoneIp("-");
        } else {
            log.setDisZoneIp(IPUtil4Atic.compressIP((String)form.getZoneIp()));
        }
    }

    private void processUnit(AttackExactLogForm form, AttackExactLog log) {
        String currentDis = ReportAnalysisUtil.getCurrentDis(form);
        String limitDis = ReportAnalysisUtil.getLimitDis(form);
        log.setCurrentDis(currentDis);
        log.setLimitDis(limitDis);
    }

    private Map<String, JsonValueObj> processSingleAttackSnap(AttackExactLogForm form, String collectorIp, AttackExactLog log, String unit) {
        HashMap<String, JsonValueObj> reportQueryCond = new HashMap<String, JsonValueObj>();
        JsonValueObj deviceIpObj = new JsonValueObj(form.getDeviceIp(), form.getDeviceIp(), form.getDeviceIp());
        reportQueryCond.put("deviceIp", deviceIpObj);
        int deviceType = 0;
        if (0L == log.getStartTimeAttack()) {
            deviceType = 1;
        }
        JsonValueObj deviceTypeObj = new JsonValueObj(String.valueOf(deviceType), String.valueOf(deviceType), String.valueOf(deviceType));
        reportQueryCond.put("deviceType", deviceTypeObj);
        JsonValueObj zoneComboboxObj = new JsonValueObj(form.getZoneId().toString(), form.getZoneId().toString(), form.getZoneId().toString());
        reportQueryCond.put("zone_combobox", zoneComboboxObj);
        JsonValueObj bisObj = new JsonValueObj(form.getBizId().toString(), form.getBizId().toString(), form.getBizId().toString());
        reportQueryCond.put("bis_combobox", bisObj);
        JsonValueObj zoneIpObj = new JsonValueObj(form.getZoneIp(), form.getZoneIp(), form.getZoneIp());
        reportQueryCond.put("zone_ip", zoneIpObj);
        JsonValueObj attackTypeObj = new JsonValueObj(form.getAttackTypeValue().toString(), form.getAttackTypeValue().toString(), form.getAttackTypeValue().toString());
        reportQueryCond.put("attackType", attackTypeObj);
        JsonValueObj protocolObj = new JsonValueObj(form.getProtocol().toString(), form.getProtocol().toString(), form.getProtocol().toString());
        reportQueryCond.put("protocol", protocolObj);
        JsonValueObj portObj = new JsonValueObj(form.getPort().toString(), form.getPort().toString(), form.getPort().toString());
        reportQueryCond.put("port", portObj);
        JsonValueObj collectorIpObj = new JsonValueObj(collectorIp, collectorIp, collectorIp);
        reportQueryCond.put("collectorIp", collectorIpObj);
        JsonValueObj startTimeObj = new JsonValueObj(log.getStartTimeAttack().toString(), log.getStartTimeAttack().toString(), AticUtil.convertTimeLong((Long)log.getStartTimeAttack()));
        JsonValueObj endTimeObj = new JsonValueObj(log.getEndTime().toString(), log.getEndTime().toString(), AticUtil.convertTimeLong((Long)log.getEndTime()));
        reportQueryCond.put("startTime", startTimeObj);
        reportQueryCond.put("endTime", endTimeObj);
        String switchOpttionVaule = "1";
        if (unit.equals("1")) {
            switchOpttionVaule = "2";
        }
        JsonValueObj switchOptionObj = new JsonValueObj(switchOpttionVaule, switchOpttionVaule, switchOpttionVaule);
        reportQueryCond.put("switchOption", switchOptionObj);
        return reportQueryCond;
    }

    private String processPcapFile(HttpServletRequest request, AttackExactLogForm form, String collectorIp, AttackExactLog log) {
        String checkPcapFile = "";
        AticDevice ne = ((IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class)).getDeviceByIp(form.getDeviceIp());
        if (ne instanceof AticDevice) {
            if (AnalysisConstants.getAllDiscardRelateAttackType().contains(log.getAttackTypeValue())) {
                checkPcapFile = "<img src=\"" + request.getContextPath() + "/vsm/atic/resource/skins/images/pcapfile_down.gif\" />";
            } else {
                AticDevice firewall = ne;
                Long devId = firewall.getMoId();
                String zoneIpTemp = log.getZoneIp();
                if (IPUtil.isIpv6((String)zoneIpTemp)) {
                    zoneIpTemp = IPUtil4Atic.convert2CompleteIpV6((String)zoneIpTemp);
                }
                checkPcapFile = "<a style='cursor:pointer' title=\"" + ReportAticUtil.getText("atic.analysis.exact.log.pcapfile") + "\" href=\"javascript:window.open('" + request.getContextPath() + "/atic/business/listPcapFileFromReport.do?startTime=" + log.getStartTimeAlert() + "&collectorIp=" + collectorIp + "&endTime=" + log.getEndTime() + "&deviceId=" + devId + "&attackType=" + log.getAttackTypeValue() + "&deviceType=" + log.getDeviceType() + "&zoneId=" + log.getZoneId() + "&protocolValue=" + log.getProtocol() + "&zoneIp4Report=" + zoneIpTemp + "&portValue=" + log.getPort() + "&IREPORT_WOS_CODE=','_blank');void(0);\" > <img src=\"" + request.getContextPath() + "/vsm/atic/resource/skins/images/pcapfile.gif\" /> </a>";
            }
        } else {
            checkPcapFile = "<img src=\"" + request.getContextPath() + "/vsm/atic/resource/skins/images/pcapfile_down.gif\" />";
        }
        return checkPcapFile;
    }

    private String processFlowGraph(HttpServletRequest request, String collectorIp, AttackExactLogForm log, long sessionId, int direction, String unit) {
        String checkFlowGraph = "";
        String reportIdURL = "singleAttackExactFlow";
        if ("ips".equalsIgnoreCase(AnalysisConstants.getInstance().getReportType()) && AnalysisConstants.getInstance().getReportTypeIpsReport().booleanValue()) {
            reportIdURL = "singleAttackExactFlowIpsReport";
        }
        if (null != log.getStartTimeAttack() && log.getStartTimeAttack() > 0L) {
            String zoneIpTemp = log.getZoneIp();
            if (IPUtil.isIpv6((String)zoneIpTemp)) {
                zoneIpTemp = IPUtil4Atic.convert2CompleteIpV6((String)zoneIpTemp);
            }
            int switchOption = 1;
            if (unit.equals("1")) {
                switchOption = 2;
            }
            checkFlowGraph = "<a style='cursor:pointer' title=\"" + ReportAticUtil.getText("atic.analysis.exact.log.attack.detail") + "\" href=\"javascript:window.open('" + request.getContextPath() + "/atic/ireport/dataDrill.do?reportId=" + reportIdURL + "&switchOption=" + switchOption + "&deviceIp=" + log.getDeviceIp() + "&deviceType=" + log.getDeviceType() + "&zone_combobox=" + log.getZoneId() + "&bis_combobox=" + log.getBizId() + "&zone_ip=" + zoneIpTemp + "&startTime=" + log.getStartTimeAttack() + "&endTime=" + log.getEndTime() + "&collectorIp=" + collectorIp + "&attackType=" + log.getAttackTypeValue() + "&protocol=" + log.getProtocol() + "&direction_combobox=" + direction + "&port=" + log.getPort() + "&reportSessionId=" + sessionId + "&dataDrillTitle=&IREPORT_WOS_CODE=','_blank');void(0);\" > <img src=\"" + request.getContextPath() + "/vsm/atic/resource/skins/images/event.gif\" /> </a>";
        } else {
            checkFlowGraph = "<img src=\"" + request.getContextPath() + "/vsm/atic/resource/skins/images/event_down.gif\" />";
        }
        return checkFlowGraph;
    }
}

