/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.log;

import com.hs.atic.analysis.report.attack.log.AttackSrcTopN;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.sdk.analysis.form.AttackExactLogForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class AttackSrcTopNDataSet
extends IJavaDataSource {
    public static final int CHART_NUM = 10;
    public static final int NUM_THREE = 3;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<AttackSrcTopN> dataList = new ArrayList<AttackSrcTopN>();
    private IDataStatService dataStatService;

    private List<AttackSrcTopN> sortListByField(List<AttackSrcTopN> beSortedList, String sortField, String sortType) {
        if ("displayAttackScrIp".equalsIgnoreCase(sortField)) {
            sortField = "attackScrIp";
        }
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<AttackSrcTopN> orderedList = null;
        if (sortList != null) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            if (orderedList.size() > 10) {
                orderedList = orderedList.subList(0, 10);
            }
            return orderedList;
        }
        ArrayList<AttackSrcTopN> list = new ArrayList<AttackSrcTopN>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start AttackSrcTopNDataSet prepareData");
        try {
            List<JsonValueItem> jsonValueItem = null;
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "attackExactLogPkid");
            Long attackExactLogPkid = Long.parseLong(jsonValueItem.get(0).getValue());
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "collectorIp");
            String collectorIp = String.valueOf(jsonValueItem.get(0).getValue());
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            AttackExactLogForm attackExactLogForm = this.dataStatService.getAttackSrcFlow(attackExactLogPkid, collectorIp);
            if (null != attackExactLogForm && !AticUtil.isNull((String)attackExactLogForm.getAttackSrcIpFlow())) {
                String attackSrcFlowData = attackExactLogForm.getAttackSrcIpFlow();
                String[] attackSrcFlow = attackSrcFlowData.split(";");
                AttackSrcTopN attackSrcTopN = null;
                for (int i = 0; i < attackSrcFlow.length; ++i) {
                    attackSrcTopN = new AttackSrcTopN();
                    String[] itemFlowData = attackSrcFlow[i].split(",");
                    if (3 != itemFlowData.length) continue;
                    attackSrcTopN.setAttackScrIp(itemFlowData[0]);
                    attackSrcTopN.setDisplayAttackScrIp(IPUtil4Atic.compressIP((String)itemFlowData[0]));
                    attackSrcTopN.setPps(Long.parseLong(itemFlowData[1]));
                    attackSrcTopN.setKbps(Long.parseLong(itemFlowData[2]));
                    this.dataList.add(attackSrcTopN);
                }
                this.dataList = this.sortListByField(this.dataList, "kbps", "DESC");
            }
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            this.logger.error((Object)"AttackSrcTopNDataSet prepareData() legoException", (Throwable)legoException);
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"AttackSrcTopNDataSet prepareData() unknow exception", (Throwable)e);
        }
        this.logger.info((Object)"end AttackSrcTopNDataSet prepareData");
        return 0;
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getLogoAndNameMap(queryCond);
    }

    public List<AttackSrcTopN> getDataList() {
        return this.dataList;
    }
}

