/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.log;

import com.hs.atic.analysis.report.attack.log.AttackExactLog;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.analysis.util.ReportAticUtil;
import com.hs.atic.analysis.util.ReportCommonUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.sdk.analysis.form.AttackExactLogForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.MathUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.CommonUtil;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class AttackTypeLogDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private Integer total = 0;
    private Long currentLogUserId;
    private String collectorIp = "";
    private String nextLineStr = "<br>";
    private List<AttackExactLog> dataList = new ArrayList<AttackExactLog>();
    private IDataStatService dataStatService;
    private DataStatConditionForm datastatConditionForm;
    private Map<?, ?> queryCond4Security;

    public List<AttackExactLog> sortListByField(List<AttackExactLog> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        this.logger.info((Object)("fetch----DeviceData :" + new SimpleDateFormat("yyyyMMdd-HH-mm-ss").format(new Date())));
        this.nextLineStr = pageSize > 100L ? "\n" : "<br>";
        List<AttackExactLogForm> attackLogFormList = null;
        if (!ReportAnalysisUtil.checkDeviceAuthority(this.queryCond4Security, this.datastatConditionForm)) {
            return new ArrayList();
        }
        if (!ReportAnalysisUtil.checkZoneAuthority(this.queryCond4Security, this.datastatConditionForm)) {
            return new ArrayList();
        }
        if (0L == pageIndex && 0L == pageSize) {
            pageSize = Integer.MAX_VALUE;
        }
        if (pageIndex < 1L) {
            pageIndex = 1L;
        }
        this.datastatConditionForm.setStartRow((int)((pageIndex - 1L) * pageSize));
        this.datastatConditionForm.setLimit((int)pageSize);
        this.dataList = new ArrayList<AttackExactLog>();
        try {
            attackLogFormList = this.getSingleDeviceData(this.datastatConditionForm, sortList);
            this.logger.info((Object)("getSingleDeviceData :" + new SimpleDateFormat("yyyyMMdd-HH-mm-ss").format(new Date())));
            this.processAttackLogList(attackLogFormList, sessionId);
            this.logger.info((Object)("pocessAttDeviceData :" + new SimpleDateFormat("yyyyMMdd-HH-mm-ss").format(new Date())));
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            this.logger.error((Object)("AttackTypeLogDataSet fetchData() LegoCheckedException:" + legoException.getErrorCode()));
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"AttackTypeLogDataSet fetchData() unknow exception", (Throwable)e);
        }
        this.logger.info((Object)("getSingleDeviceData :" + new SimpleDateFormat("yyyyMMdd-HH-mm-ss").format(new Date()) + ".data size:" + this.dataList.size()));
        return this.dataList;
    }

    private void processAttackLogList(List<AttackExactLogForm> attackLogFormList, long sessionId) {
        if (null == attackLogFormList) {
            return;
        }
        for (AttackExactLogForm form : attackLogFormList) {
            AttackExactLog log = new AttackExactLog();
            AticUtil.copyProperties((Object)form, (Object)log);
            this.processZoneName(form, log);
            String attackLogInfo = "";
            attackLogInfo = attackLogInfo + ReportAticUtil.getText("atic.analysis.common.ip.address") + log.getDisZoneIp() + this.nextLineStr + ReportAticUtil.getText("atic.analysis.common.zone") + log.getZoneDesc();
            log.setAttackLogInfo(attackLogInfo);
            String endTime = log.getDisEndTime().length() > 5 ? log.getDisEndTime().substring(5) : log.getDisEndTime();
            log.setAttackLogTimes(ReportAticUtil.getText("atic.analysis.report.time.start") + log.getDisStartTimeAlert().substring(5) + this.nextLineStr + ReportAticUtil.getText("atic.analysis.report.time.end") + endTime);
            log.setDisplayDuration(ReportAnalysisUtil.longTimeToHMS(form.getDuration()));
            double avgPackLength = 0.0;
            if (form.getDropBytes() > 0L && form.getDropPackets() > 0L) {
                avgPackLength = MathUtil.getDoubleValue((double)((double)(log.getDropBytes() * 1024L) / (double)(log.getDropPackets() * 8L)));
                avgPackLength = avgPackLength < 88.0 ? 64.0 : avgPackLength - 24.0;
            }
            log.setPackageLength(avgPackLength);
            if (log.getStartTimeAttack() <= 0L) {
                log.setAvgPackLength("-");
            } else {
                log.setAvgPackLength(CommonUtil.transformNumber((String)String.valueOf(avgPackLength), (String)""));
            }
            String unit = form.getPpsOrKbps() == 2 ? "qps" : "pps";
            log.setInFlowFeak(CommonUtil.transformNumber((String)String.valueOf(form.getIpInPeakPps()), (String)unit) + "/" + CommonUtil.transformNumber((String)String.valueOf(form.getIpInPeakKbps()), (String)"kbps"));
            log.setAttackFlowFeak(CommonUtil.transformNumber((String)String.valueOf(form.getMaxAttackPeakPps()), (String)unit) + "/" + CommonUtil.transformNumber((String)String.valueOf(form.getMaxAttackPeakbps()), (String)"kbps"));
            Map<String, JsonValueObj> reportQueryCond = this.processSingleAttackSnap(form, log);
            log.setQueryCondtion(reportQueryCond);
            this.dataList.add(log);
        }
    }

    private Map<String, JsonValueObj> processSingleAttackSnap(AttackExactLogForm form, AttackExactLog log) {
        HashMap<String, JsonValueObj> reportQueryCond = new HashMap<String, JsonValueObj>();
        JsonValueObj deviceIpObj = new JsonValueObj(form.getDeviceIp(), form.getDeviceIp(), form.getDeviceIp());
        reportQueryCond.put("deviceIp", deviceIpObj);
        int deviceType = 0;
        if (0L == log.getStartTimeAttack()) {
            deviceType = 1;
        }
        JsonValueObj deviceTypeObj = new JsonValueObj(String.valueOf(deviceType), String.valueOf(deviceType), String.valueOf(deviceType));
        reportQueryCond.put("deviceType", deviceTypeObj);
        JsonValueObj zoneComboboxObj = new JsonValueObj(form.getZoneId().toString(), form.getZoneId().toString(), form.getZoneId().toString());
        reportQueryCond.put("zone_combobox", zoneComboboxObj);
        JsonValueObj bisObj = new JsonValueObj(form.getBizId().toString(), form.getBizId().toString(), form.getBizId().toString());
        reportQueryCond.put("bis_combobox", bisObj);
        JsonValueObj zoneIpObj = new JsonValueObj(form.getZoneIp(), form.getZoneIp(), form.getZoneIp());
        reportQueryCond.put("zone_ip", zoneIpObj);
        JsonValueObj attackTypeObj = new JsonValueObj(form.getAttackTypeValue().toString(), form.getAttackTypeValue().toString(), form.getAttackTypeValue().toString());
        reportQueryCond.put("attackType", attackTypeObj);
        JsonValueObj protocolObj = new JsonValueObj(form.getProtocol().toString(), form.getProtocol().toString(), form.getProtocol().toString());
        reportQueryCond.put("protocol", protocolObj);
        JsonValueObj portObj = new JsonValueObj(form.getPort().toString(), form.getPort().toString(), form.getPort().toString());
        reportQueryCond.put("port", portObj);
        JsonValueObj collectorIpObj = new JsonValueObj(this.collectorIp, this.collectorIp, this.collectorIp);
        reportQueryCond.put("collectorIp", collectorIpObj);
        JsonValueObj startTimeObj = new JsonValueObj(log.getStartTimeAttack().toString(), log.getStartTimeAttack().toString(), AticUtil.convertTimeLong((Long)log.getStartTimeAttack()));
        JsonValueObj endTimeObj = new JsonValueObj(log.getEndTime().toString(), log.getEndTime().toString(), AticUtil.convertTimeLong((Long)log.getEndTime()));
        reportQueryCond.put("startTime", startTimeObj);
        reportQueryCond.put("endTime", endTimeObj);
        String switchOpttionVaule = "2";
        if (this.datastatConditionForm.getUnit() == 0) {
            switchOpttionVaule = "1";
        }
        JsonValueObj switchOptionObj = new JsonValueObj(switchOpttionVaule, switchOpttionVaule, switchOpttionVaule);
        reportQueryCond.put("switchOption", switchOptionObj);
        return reportQueryCond;
    }

    private void processZoneName(AttackExactLogForm form, AttackExactLog log) {
        if (form.getZoneIp().equals("0")) {
            log.setDisZoneIp("-");
        } else {
            log.setDisZoneIp(IPUtil4Atic.compressIP((String)form.getZoneIp()));
        }
        ZoneInfoForm zoneForm = ReportBisUtil.getZoneService().getById(form.getZoneId());
        if (null != zoneForm) {
            log.setZoneDesc(zoneForm.getZoneDesc());
        } else {
            this.logger.info((Object)("the zone not exist,zoneId = " + form.getZoneId()));
            log.setZoneDesc(ReportAticUtil.getText("atic.analysis.common.unknownZone") + form.getZoneId());
        }
    }

    private List<AttackExactLogForm> getSingleDeviceData(DataStatConditionForm datastatConditionForms, OrderInfo sortList) {
        List<AttackExactLogForm> attackLogFormList = new ArrayList<AttackExactLogForm>();
        IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        AticDevice firewall = aticDeviceService.getDeviceByMoid(datastatConditionForms.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForms.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForms.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = (ICollectorService)ServiceContext.getInstance().getService("collectorService", ICollectorService.class);
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(datastatConditionForms.getDeviceId());
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            this.collectorIp = collectorInfo.getIpAddress();
            attackLogFormList = null != sortList ? this.dataStatService.getAttackTypeLog(datastatConditionForms, this.collectorIp, sortList.getOrderField(), sortList.getOrderType()) : this.dataStatService.getAttackTypeLog(datastatConditionForms, this.collectorIp, null, null);
            this.total = this.dataStatService.getAttackTypeLogNum(datastatConditionForms, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return attackLogFormList;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.total.intValue();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        try {
            this.queryCond4Security = queryCond;
            List<JsonValueItem> jsonValueItem = null;
            this.datastatConditionForm = new DataStatConditionForm();
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
            String direction = String.valueOf(jsonValueItem.get(0).getValue());
            if (direction.matches("^[\\d]*$")) {
                this.datastatConditionForm.setDirection(Integer.parseInt(direction));
            } else {
                this.datastatConditionForm.setDirection(1);
            }
            ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
            String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
            ReportAnalysisUtil.processDeviceInfo(this.datastatConditionForm, deviceId);
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
            String zoneId = String.valueOf(jsonValueItem.get(0).getValue());
            this.datastatConditionForm.setZoneId(Long.parseLong(zoneId));
            if (!(AnalysisConstants.getInstance().getReportType().equalsIgnoreCase("ips") && AnalysisConstants.getInstance().getReportTypeIpsReport().booleanValue() || 0L != this.datastatConditionForm.getZoneId())) {
                ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, this.datastatConditionForm, sessionId);
            }
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
            String bisId = String.valueOf(jsonValueItem.get(0).getValue());
            ReportAnalysisUtil.processServiceCond(this.datastatConditionForm, bisId);
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip");
            String zoneIp = String.valueOf(jsonValueItem.get(0).getValue());
            this.datastatConditionForm.setZoneIp(zoneIp);
            ReportAnalysisUtil.setDateRange(queryCond, this.datastatConditionForm);
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "logType");
            String logType = String.valueOf(jsonValueItem.get(0).getValue());
            this.datastatConditionForm.setAbnormalType(Integer.parseInt(logType));
            this.currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
            String attackType = null;
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "attackType_combobox");
            attackType = String.valueOf(jsonValueItem.get(0).getValue());
            if (!AticUtil.isNull((String)attackType)) {
                this.datastatConditionForm.setAttackType(Integer.parseInt(attackType));
            }
            String attackTypeName = null;
            attackTypeName = String.valueOf(jsonValueItem.get(0).getText());
            if (!AticUtil.isNull((String)attackTypeName)) {
                this.datastatConditionForm.setAttackTypeName(attackTypeName);
            }
            this.datastatConditionForm.setShowDropPacket(this.validateDevice());
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "minInFlow");
            String minInFlow = String.valueOf(jsonValueItem.get(0).getValue());
            if (!AticUtil.isNull((String)minInFlow)) {
                this.datastatConditionForm.setMinInFlow(Long.parseLong(minInFlow));
            } else {
                this.datastatConditionForm.setMinInFlow(0L);
            }
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "minAttackFlowPeak");
            String minAttackFlowPeak = String.valueOf(jsonValueItem.get(0).getValue());
            if (!AticUtil.isNull((String)minAttackFlowPeak)) {
                this.datastatConditionForm.setMinAttackFlowPeak(Long.parseLong(minAttackFlowPeak));
            } else {
                this.datastatConditionForm.setMinAttackFlowPeak(0L);
            }
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit");
            String unit = String.valueOf(jsonValueItem.get(0).getValue());
            this.datastatConditionForm.setUnit(Integer.parseInt(unit));
            this.processQueryCondition(queryCond, logType, attackType);
            ICollectorService collectorService = (ICollectorService)ServiceContext.getInstance().getService("collectorService", ICollectorService.class);
            Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(this.datastatConditionForm.getDeviceId());
            if (null == collectorId) {
                this.logger.error((Object)("no collector exist,firewallId = " + this.datastatConditionForm.getDeviceId()));
                throw new LegoCheckedException(570512L);
            }
            CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
            if (null == collectorInfo) {
                this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
                throw new LegoCheckedException(570512L);
            }
            if (2 == collectorInfo.getStatus()) {
                this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + collectorInfo.getIpAddress()));
                throw new LegoCheckedException(570504L);
            }
        }
        catch (LegoCheckedException legoException) {
            this.logger.error((Object)("AttackTypeLogDataSet prepareData happened unknow exception :" + legoException.getErrorCode()), (Throwable)legoException);
            throw legoException;
        }
        return 0;
    }

    private boolean validateDevice() {
        IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        AticDevice firewall = aticDeviceService.getDeviceByMoid(this.datastatConditionForm.getDeviceId().longValue());
        ArrayList<AticDevice> deviceList = new ArrayList<AticDevice>();
        if (null != firewall) {
            if (5 == firewall.getDeviceType()) {
                return false;
            }
            deviceList.add(firewall);
        }
        return ReportCommonUtil.includesV1R1(deviceList);
    }

    private void processQueryCondition(Map<?, ?> queryCond, String logType, String attackType) {
        JsonValueObj objUnit = (JsonValueObj)queryCond.get("unit");
        JsonValueObj objMinAttackFlowPeak = (JsonValueObj)queryCond.get("minAttackFlowPeak");
        if (null != objMinAttackFlowPeak && "1".equals(logType)) {
            objMinAttackFlowPeak.setShowInfo("false");
        }
        if (null != objUnit && "27".equals(attackType)) {
            objUnit.setShowInfo("false");
        }
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getPrepareParasMap(queryCond);
    }

    public Long getCurrentLogUserId() {
        return this.currentLogUserId;
    }

    public void setCurrentLogUserId(Long currentLogUserId) {
        this.currentLogUserId = currentLogUserId;
    }
}

