/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.log;

import com.hs.atic.analysis.report.attack.log.AttackExactFlow;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.sdk.analysis.form.AttackExactFlowForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class SingleAttackExactFlowDataSet
extends IJavaDataSource {
    private List<AttackExactFlow> dataList = new ArrayList<AttackExactFlow>();
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private IDataStatService dataStatService;

    public List<AttackExactFlow> sortListByField(List<AttackExactFlow> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<AttackExactFlow> orderedList = null;
        if (sortList != null) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<AttackExactFlow> list = new ArrayList<AttackExactFlow>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.dataList.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.dataList.clear();
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItem.get(0).getValue());
        if (direction.matches("^[\\d]*$")) {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        } else {
            datastatConditionForm.setDirection(1);
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "deviceIp");
        String deviceIp = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setDeviceIp(deviceIp);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "deviceType");
        String deviceType = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setDevSerType(Integer.parseInt(deviceType));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        String zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
        String bizId = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setBisId(Long.parseLong(bizId));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip");
        String zoneIp = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setZoneIp(zoneIp);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "startTime");
        String startTime = jsonValueItem.get(0).getValue();
        datastatConditionForm.setStartTime(Long.parseLong(startTime));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "endTime");
        String endTime = jsonValueItem.get(0).getValue();
        datastatConditionForm.setEndTime(Long.parseLong(endTime));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "attackType");
        String attackType = jsonValueItem.get(0).getText();
        datastatConditionForm.setAttackType(Integer.parseInt(attackType));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "protocol");
        String protocol = jsonValueItem.get(0).getText();
        datastatConditionForm.setProtocol(Integer.parseInt(protocol));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "port");
        String port = jsonValueItem.get(0).getText();
        datastatConditionForm.setPort(Integer.parseInt(port));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "collectorIp");
        String collectorIp = String.valueOf(jsonValueItem.get(0).getValue());
        ArrayList<AttackExactFlowForm> attackExactFlowFormList = new ArrayList();
        try {
            if (queryCond.containsKey("dateRange")) {
                JsonValueObj dateObj = (JsonValueObj)queryCond.get("dateRange");
                ((JsonValueItem)dateObj.getValueList().get(0)).setValue(String.valueOf(AticUtil.convertTimeString((String)startTime)));
                ((JsonValueItem)dateObj.getValueList().get(0)).setText(startTime);
                ((JsonValueItem)dateObj.getValueList().get(1)).setValue(String.valueOf(AticUtil.convertTimeString((String)endTime)));
                ((JsonValueItem)dateObj.getValueList().get(1)).setText(endTime);
            }
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            try {
                attackExactFlowFormList = this.dataStatService.getSingleAttackExactFlow(datastatConditionForm, collectorIp);
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorIp = " + collectorIp), (Throwable)e);
            }
            if (null != attackExactFlowFormList) {
                this.processDataToDisplay(attackExactFlowFormList);
            }
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"SingleAttackExactFlowDataSet prepareData happened exception !", (Throwable)e);
        }
        return 0;
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        Map<String, List<String>> map = ReportAnalysisUtil.getLogoAndNameMap(queryCond);
        ArrayList<String> displayAttackTypes = new ArrayList<String>();
        displayAttackTypes.add(this.getAttackType(queryCond));
        map.put("displayAttackType", displayAttackTypes);
        return map;
    }

    private String getAttackType(Map<?, ?> queryCond) {
        String displayAttackType = "";
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "attackType");
        Integer attackType = Integer.parseInt(jsonValueItem.get(0).getText());
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "protocol");
        Integer protocol = Integer.parseInt(jsonValueItem.get(0).getText());
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "port");
        Integer port = Integer.parseInt(jsonValueItem.get(0).getText());
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "deviceIp");
        String deviceIp = String.valueOf(jsonValueItem.get(0).getValue());
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        Long zoneId = Long.parseLong(jsonValueItem.get(0).getValue());
        displayAttackType = attackType >= 10 ? ReportAnalysisUtil.getDisplayAttackType(String.valueOf(attackType)) : ReportAnalysisUtil.getCustomAttackTypeStr(zoneId, deviceIp, protocol, port);
        return displayAttackType;
    }

    private void processDataToDisplay(List<AttackExactFlowForm> attackExactFlowFormList) {
        IZoneService zoneService = ReportBisUtil.getZoneService();
        Map<String, String> ipAndDeviceName = ReportAnalysisUtil.getAllIpAndDeviceName();
        for (AttackExactFlowForm form : attackExactFlowFormList) {
            AttackExactFlow flow = new AttackExactFlow();
            AticUtil.copyProperties((Object)form, (Object)flow);
            flow.setLogTime(form.getLogTime() * 1000L);
            flow.setDisplayDeviceName(ipAndDeviceName.get(form.getDeviceIp()));
            ZoneInfoForm zoneForm = zoneService.getById(form.getZoneId());
            if (null == zoneForm) {
                flow.setZoneName(AticUtil.getText((String)"atic.analysis.common.unknownZone") + form.getZoneId());
            } else {
                flow.setZoneName(zoneForm.getZoneDesc());
            }
            if (form.getZoneIp().equals("0") && form.getBizId() == 0L) {
                flow.setDisplayZoneIp("-");
            } else {
                flow.setDisplayZoneIp(IPUtil4Atic.compressIP((String)form.getZoneIp()));
            }
            if (form.getAttackType() >= 10L) {
                flow.setDisplayAttackType(ReportAnalysisUtil.getDisplayAttackType(String.valueOf(form.getAttackType())));
            } else {
                flow.setDisplayAttackType(ReportAnalysisUtil.getCustomAttackTypeStr(form.getZoneId(), form.getDeviceIp(), form.getProtocol(), form.getPort()));
            }
            this.dataList.add(flow);
        }
    }
}

