/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.log;

import com.hs.atic.analysis.report.ReportConditionValidateUtils;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.sdk.util.IPUtil;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.validator.AbstractValidator;
import java.util.List;
import java.util.Map;

public class SingleAttackExactFlowValidator
extends AbstractValidator {
    public boolean validate(Map<String, JsonValueObj> reportCon) {
        for (Map.Entry<String, JsonValueObj> entry : reportCon.entrySet()) {
            List list;
            JsonValueObj jsonValueObj;
            String checkKey = entry.getKey();
            if ("reportId".equals(entry.getKey())) {
                jsonValueObj = reportCon.get("reportId");
                if (null == jsonValueObj) {
                    return false;
                }
                list = jsonValueObj.getValueList();
                if (!((JsonValueItem)list.get(0)).getValue().equals("singleAttackExactFlow")) {
                    return false;
                }
            } else {
                if ("switchOption".equals(checkKey) && !ReportConditionValidateUtils.isValidateSwitchOption(reportCon)) {
                    return false;
                }
                if ("deviceIp".equals(checkKey)) {
                    jsonValueObj = reportCon.get("deviceIp");
                    if (null == jsonValueObj) {
                        return false;
                    }
                    list = jsonValueObj.getValueList();
                    String deviceIp = ((JsonValueItem)list.get(0)).getValue().trim();
                    if (!AticUtil.isNull((String)deviceIp) && !IPUtil.isIpv4((String)deviceIp)) {
                        return false;
                    }
                }
            }
            if (!this.checkF(checkKey, reportCon)) {
                return false;
            }
            if (this.checkS(checkKey, reportCon)) continue;
            return false;
        }
        return true;
    }

    private boolean checkF(String checkKey, Map<String, JsonValueObj> reportCon) {
        if ("deviceType".equals(checkKey)) {
            JsonValueObj jsonValueObj = reportCon.get("deviceType");
            if (null == jsonValueObj) {
                return false;
            }
            List list = jsonValueObj.getValueList();
            String regex = "^(0|1|2)$";
            if (!((JsonValueItem)list.get(0)).getValue().matches(regex)) {
                return false;
            }
        } else {
            if ("zone_combobox".equals(checkKey) && !ReportConditionValidateUtils.isValidateZoneCombobox(reportCon)) {
                return false;
            }
            if ("bis_combobox".equals(checkKey) && !ReportConditionValidateUtils.isValidateBisCombobox(reportCon)) {
                return false;
            }
            if ("zone_ip".equals(checkKey) && !ReportConditionValidateUtils.isValidateZoneIp(reportCon)) {
                return false;
            }
            if ("startTime".equals(checkKey) && !ReportConditionValidateUtils.isValidateStartTime(reportCon)) {
                return false;
            }
            if ("endTime".equals(checkKey) && !ReportConditionValidateUtils.isValidateEndTime(reportCon)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkS(String checkKey, Map<String, JsonValueObj> reportCon) {
        if ("collectorIp".equals(checkKey) && !ReportConditionValidateUtils.checkIsCollectorIp(reportCon)) {
            return false;
        }
        if ("attackType".equals(checkKey) && !ReportConditionValidateUtils.checkIsNum("attackType", reportCon)) {
            return false;
        }
        if ("protocol".equals(checkKey) && !ReportConditionValidateUtils.checkIsNum("protocol", reportCon)) {
            return false;
        }
        if ("port".equals(checkKey) && !ReportConditionValidateUtils.checkIsNum("port", reportCon)) {
            return false;
        }
        if ("reportSessionId".equals(checkKey) && !ReportConditionValidateUtils.checkIsNum("reportSessionId", reportCon)) {
            return false;
        }
        if ("dataDrillTitle".equals(checkKey) && !ReportConditionValidateUtils.checkDataDrillTitle(reportCon)) {
            return false;
        }
        return !"IREPORT_WOS_CODE".equals(checkKey) || ReportConditionValidateUtils.checkIreportWosCode(reportCon);
    }
}

