/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.zoneattack;

import com.hs.atic.analysis.report.attack.zoneattack.ZoneAttackCountTopN;
import com.hs.atic.analysis.util.RedunDeviceForm;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.DeviceWorkTimeForm;
import com.hs.atic.sdk.analysis.form.ZoneAttackCountTopNForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class ZoneAttackCountTopNDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<ZoneAttackCountTopN> dataList = new ArrayList<ZoneAttackCountTopN>();
    private IDataStatService dataStatService;

    public List<ZoneAttackCountTopN> sortListByField(List<ZoneAttackCountTopN> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<ZoneAttackCountTopN> orderedList = null;
        if (sortList != null) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<ZoneAttackCountTopN> list = new ArrayList<ZoneAttackCountTopN>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getLogoAndNameMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start ZoneAttackCountTopNDataSet prepareData");
        List<ZoneAttackCountTopNForm> zoneTopNFormList = null;
        Map<String, List<ZoneAttackCountTopNForm>> allCollectorForm = null;
        try {
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            if (datastatConditionForm.getDeviceId() > 0L) {
                allCollectorForm = this.getSingleDeviceData(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
                allCollectorForm = -2L == datastatConditionForm.getDeviceId() ? this.getAllDetectDeviceDate(firewallList, datastatConditionForm) : this.getAllCollectorIpTopNForm(firewallList, datastatConditionForm);
            }
            zoneTopNFormList = this.getTopNForm(allCollectorForm, datastatConditionForm.getTopn());
            this.dataList = this.getZoneAttackFormDate(zoneTopNFormList, queryCond);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"ZoneAttackCountTopNDataSet prepareData() unknow exception", (Throwable)e);
        }
        this.logger.info((Object)"end ZoneAttackCountTopNDataSet prepareData");
        return 0;
    }

    private List<ZoneAttackCountTopN> getZoneAttackFormDate(List<ZoneAttackCountTopNForm> zoneTopNFormList, Map<?, ?> queryCond) {
        ArrayList<ZoneAttackCountTopN> returnDataList = new ArrayList<ZoneAttackCountTopN>();
        IZoneService zoneService = ReportBisUtil.getZoneService();
        Locale locale = ReportAnalysisUtil.getCurrentUserLocale4Report(queryCond);
        for (int i = 0; i < zoneTopNFormList.size(); ++i) {
            ZoneAttackCountTopN data = new ZoneAttackCountTopN();
            data.setAttackTimes(zoneTopNFormList.get(i).getAttackTimes());
            ZoneInfoForm zoneForm = zoneService.getById(zoneTopNFormList.get(i).getZoneId());
            if (null == zoneForm || "".equals(zoneForm.getZoneDesc())) {
                this.logger.info((Object)("the zone not exist,zoneId = " + zoneTopNFormList.get(i).getZoneId()));
                data.setZoneName(AticUtil.getText((String)"atic.analysis.common.unknownZone", (Locale)locale) + zoneTopNFormList.get(i).getZoneId());
            } else {
                data.setZoneName(zoneForm.getZoneDesc());
            }
            data.setZoneId(zoneTopNFormList.get(i).getZoneId());
            returnDataList.add(data);
        }
        return returnDataList;
    }

    private Map<String, List<ZoneAttackCountTopNForm>> getAllDetectDeviceDate(List<AticDevice> firewallList, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<ZoneAttackCountTopNForm>> allCollectorForm = new HashMap<String, List<ZoneAttackCountTopNForm>>();
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        Map<Long, List<RedunDeviceForm>> redunMap = ReportAnalysisUtil.getRedunFirewallInfoList(firewallList);
        for (Map.Entry<Long, List<RedunDeviceForm>> redun : redunMap.entrySet()) {
            List<DeviceWorkTimeForm> workTimeList = ReportAnalysisUtil.getWorkTimeList(datastatConditionForm, redun);
            for (DeviceWorkTimeForm form : workTimeList) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(form.getDeviceIp());
                datastatConditionForm.setDeviceIpList(list);
                datastatConditionForm.setStartTime(form.getStartTime());
                datastatConditionForm.setEndTime(form.getEndTime());
                Map<Object, Object> tempFormMap = new HashMap();
                try {
                    tempFormMap = this.dataStatService.getZoneAttackCountTopN(datastatConditionForm, form.getCollectorIp());
                }
                catch (Exception e) {
                    this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorIp = " + form.getCollectorIp()), (Throwable)e);
                }
                if (null == tempFormMap || tempFormMap.isEmpty()) continue;
                if (allCollectorForm.containsKey(form.getDeviceIp())) {
                    ((List)allCollectorForm.get(form.getDeviceIp())).addAll((Collection)tempFormMap.get(form.getDeviceIp()));
                    continue;
                }
                allCollectorForm.putAll(tempFormMap);
            }
        }
        List<AticDevice> redunFirewallList = ReportAnalysisUtil.getRedunFirewallList(redunMap);
        if (!redunFirewallList.isEmpty()) {
            firewallList.removeAll(redunFirewallList);
        }
        if (!firewallList.isEmpty()) {
            allCollectorForm.putAll(this.getAllCollectorIpTopNForm(firewallList, datastatConditionForm));
        }
        return allCollectorForm;
    }

    private Map<String, List<ZoneAttackCountTopNForm>> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<ZoneAttackCountTopNForm>> allCollectorForm = new HashMap();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewallId = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            allCollectorForm = this.dataStatService.getZoneAttackCountTopN(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return allCollectorForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
        String topn = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setTopn(Integer.parseInt(topn));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItem.get(0).getValue());
        if (direction.matches("^[\\d]*$")) {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        } else {
            datastatConditionForm.setDirection(1);
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        String isInteReport = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
        if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true")) {
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "AbnormalOrAttackTopNTOPN");
            String topn4Inte = String.valueOf(jsonValueItem.get(0).getValue());
            Integer topn4InteValue = Integer.parseInt(topn4Inte);
            datastatConditionForm.setTopn(topn4InteValue);
        }
        ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
    }

    private Map<String, List<ZoneAttackCountTopNForm>> getAllCollectorIpTopNForm(List<AticDevice> firewallList, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<ZoneAttackCountTopNForm>> allCollectFormData = new HashMap<String, List<ZoneAttackCountTopNForm>>();
        if (!firewallList.isEmpty()) {
            Map<Long, List<AticDevice>> collectDevMap = ReportAnalysisUtil.getCollectDevMap(firewallList);
            for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
                String collectorIp = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue()).getIpAddress();
                datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                for (AticDevice firewall : entry.getValue()) {
                    if (null == datastatConditionForm.getDeviceIpList()) {
                        datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                    }
                    datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
                }
                this.dataStatService = ReportAnalysisUtil.getDataStatService();
                try {
                    allCollectFormData.putAll(this.dataStatService.getZoneAttackCountTopN(datastatConditionForm, collectorIp));
                }
                catch (Exception e) {
                    this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey()), (Throwable)e);
                }
            }
        }
        return allCollectFormData;
    }

    private List<ZoneAttackCountTopNForm> getTopNForm(Map<String, List<ZoneAttackCountTopNForm>> allCollectorForm, int topn) {
        int i;
        List<ZoneAttackCountTopNForm> allForm = new ArrayList<ZoneAttackCountTopNForm>();
        for (Map.Entry<String, List<ZoneAttackCountTopNForm>> entry : allCollectorForm.entrySet()) {
            allForm.addAll((Collection)entry.getValue());
        }
        for (i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (!allForm.get(i).getZoneId().equals(allForm.get(j).getZoneId())) continue;
                allForm.get(i).setAttackTimes(allForm.get(i).getAttackTimes() + allForm.get(j).getAttackTimes());
                allForm.remove(j);
            }
        }
        allForm = this.sortZoneAttackTimeTopNFormListByField(allForm, "attackTimes", "DESC");
        this.processData4Order(allForm);
        if (allForm.size() > topn) {
            for (i = allForm.size() - 1; i >= topn; --i) {
                allForm.remove(i);
            }
        }
        return allForm;
    }

    private void processData4Order(List<ZoneAttackCountTopNForm> orderformList) {
        for (int i = 0; i < orderformList.size(); ++i) {
            for (int j = i + 1; j < orderformList.size(); ++j) {
                if (!orderformList.get(i).getAttackTimes().equals(orderformList.get(j).getAttackTimes()) || orderformList.get(i).getZoneId() <= orderformList.get(j).getZoneId()) continue;
                ZoneAttackCountTopNForm temp = orderformList.get(i);
                orderformList.set(i, orderformList.get(j));
                orderformList.set(j, temp);
            }
        }
    }

    private List<ZoneAttackCountTopNForm> sortZoneAttackTimeTopNFormListByField(List<ZoneAttackCountTopNForm> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<ZoneAttackCountTopN> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<ZoneAttackCountTopN> dataList) {
        this.dataList = dataList;
    }
}

