/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.zoneattack;

import com.hs.atic.analysis.report.attack.zoneattack.ZoneAttackFlowPeakTopN;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.AttackFlowPeakTopNForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class ZoneAttackFlowPeakKBPSDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<ZoneAttackFlowPeakTopN> dataList = new ArrayList<ZoneAttackFlowPeakTopN>();
    private IDataStatService dataStatService;
    private long zoneId;

    public List<ZoneAttackFlowPeakTopN> sortListByField(List<ZoneAttackFlowPeakTopN> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<AttackFlowPeakTopNForm> sortAttackFlowPeakTopNFormListByField(List<AttackFlowPeakTopNForm> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<ZoneAttackFlowPeakTopN> orderedList = null;
        if (sortList != null) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<ZoneAttackFlowPeakTopN> list = new ArrayList<ZoneAttackFlowPeakTopN>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        Map<String, List<String>> prepareParasMap = ReportAnalysisUtil.getLogoAndNameMap(queryCond);
        ReportAnalysisUtil.getZoneAttackTitleAndColumnName(queryCond, prepareParasMap);
        this.logger.info((Object)("prepareParasMap is " + prepareParasMap.size()));
        return prepareParasMap;
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start ZoneAttackTimeTopNDataSet prepareData");
        List<AttackFlowPeakTopNForm> zoneTopNFormList = null;
        try {
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            List<AttackFlowPeakTopNForm> formDataList = new ArrayList<AttackFlowPeakTopNForm>();
            if (datastatConditionForm.getDeviceId() > 0L) {
                formDataList = this.getSingleDeviceData(datastatConditionForm);
            }
            zoneTopNFormList = this.getTopNForm(formDataList, datastatConditionForm.getTopn());
            this.dataList = this.getZoneAttackFlowPeakFormDate(zoneTopNFormList, queryCond);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"ZoneAttackTimeTopNDataSet prepareData() unknow exception", (Throwable)e);
        }
        this.logger.info((Object)"end ZoneAttackTimeTopNDataSet prepareData");
        return 0;
    }

    private List<ZoneAttackFlowPeakTopN> getZoneAttackFlowPeakFormDate(List<AttackFlowPeakTopNForm> zoneTopNFormList, Map<?, ?> queryCond) {
        ArrayList<ZoneAttackFlowPeakTopN> returnDataList = new ArrayList<ZoneAttackFlowPeakTopN>();
        IZoneService zoneService = ReportBisUtil.getZoneService();
        Locale locale = ReportAnalysisUtil.getCurrentUserLocale4Report(queryCond);
        for (int i = 0; i < zoneTopNFormList.size(); ++i) {
            ZoneAttackFlowPeakTopN data = new ZoneAttackFlowPeakTopN();
            ZoneInfoForm zoneForm = zoneService.getById(zoneTopNFormList.get(i).getZoneId());
            if (null == zoneForm || "".equals(zoneForm.getZoneDesc())) {
                this.logger.info((Object)("the zone not exist,zoneId = " + zoneTopNFormList.get(i).getZoneId()));
                data.setZoneName(AticUtil.getText((String)"atic.analysis.common.unknownZone", (Locale)locale) + zoneTopNFormList.get(i).getZoneId());
            } else {
                data.setZoneName(zoneForm.getZoneDesc());
            }
            data.setZoneId(zoneTopNFormList.get(i).getZoneId());
            data.setAttackFlowPeakkbps(zoneTopNFormList.get(i).getAttackFlowPeakkbps());
            data.setAttackFlowPeakpps(zoneTopNFormList.get(i).getAttackFlowPeakpps());
            returnDataList.add(data);
        }
        return returnDataList;
    }

    private List<AttackFlowPeakTopNForm> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        ArrayList<AttackFlowPeakTopNForm> returnData = new ArrayList<AttackFlowPeakTopNForm>();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewallId = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            Map<String, List<AttackFlowPeakTopNForm>> allCollectorForm = this.dataStatService.getZoneAttackFlowPeakTopN(datastatConditionForm, collectorInfo.getIpAddress());
            for (Map.Entry<String, List<AttackFlowPeakTopNForm>> entry : allCollectorForm.entrySet()) {
                returnData.addAll((Collection<AttackFlowPeakTopNForm>)entry.getValue());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return returnData;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItem.get(0).getValue());
        if (direction.matches("^[\\d]*$")) {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        } else {
            datastatConditionForm.setDirection(1);
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        datastatConditionForm.setTimeSpanType(ReportAnalysisUtil.getTimeSpanType(datastatConditionForm.getEndTime(), datastatConditionForm.getStartTime()));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
        String topn = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setTopn(Integer.parseInt(topn));
        String isInteReport = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
        if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true")) {
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "AbnormalOrAttackTopNTOPN");
            String topn4Inte = String.valueOf(jsonValueItem.get(0).getValue());
            Integer topn4InteValue = Integer.parseInt(topn4Inte);
            datastatConditionForm.setTopn(topn4InteValue);
        }
        if (this.zoneId > 0L) {
            datastatConditionForm.setZoneId(this.zoneId);
        } else {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
    }

    private List<AttackFlowPeakTopNForm> getTopNForm(List<AttackFlowPeakTopNForm> allForm, int topn) {
        List<AttackFlowPeakTopNForm> orderForm = this.sortAttackFlowPeakTopNFormListByField(allForm, "attackFlowPeakkbps", "DESC");
        if (orderForm.size() > topn) {
            for (int i = orderForm.size() - 1; i >= topn; --i) {
                orderForm.remove(i);
            }
        }
        return orderForm;
    }

    public List<ZoneAttackFlowPeakTopN> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<ZoneAttackFlowPeakTopN> dataList) {
        this.dataList = dataList;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(long zoneId) {
        this.zoneId = zoneId;
    }
}

