/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.zoneattack;

import com.hs.atic.analysis.report.attack.zoneattack.ZoneAttackTimeTopN;
import com.hs.atic.analysis.util.RedunDeviceForm;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.DeviceWorkTimeForm;
import com.hs.atic.sdk.analysis.form.ZoneAttackTimeTopNForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class ZoneAttackTimeTopNDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<ZoneAttackTimeTopN> dataList = new ArrayList<ZoneAttackTimeTopN>();
    private Long queryStartData;
    private Long queryEndData;
    private IDataStatService dataStatService;
    private long zoneId;

    public List<ZoneAttackTimeTopN> sortListByField(List<ZoneAttackTimeTopN> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<ZoneAttackTimeTopNForm> sortZoneAttackTimeTopNFormListByField(List<ZoneAttackTimeTopNForm> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<ZoneAttackTimeTopN> orderedList = null;
        if (sortList != null) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<ZoneAttackTimeTopN> list = new ArrayList<ZoneAttackTimeTopN>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getLogoAndNameMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start ZoneAttackTimeTopNDataSet prepareData");
        List<ZoneAttackTimeTopNForm> zoneTopNFormList = null;
        Map<String, List<ZoneAttackTimeTopNForm>> allCollectorForm = null;
        try {
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            List<ZoneAttackTimeTopNForm> formDataList = null;
            if (datastatConditionForm.getDeviceId() > 0L) {
                formDataList = this.getSingleDeviceData(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
                allCollectorForm = -2L == datastatConditionForm.getDeviceId() ? this.getAllDetectDeviceDate(firewallList, datastatConditionForm) : this.getAllCollectorIpTopNForm(firewallList, datastatConditionForm);
                formDataList = this.processMultZoneNE(allCollectorForm);
            }
            zoneTopNFormList = this.getTopNForm(formDataList, datastatConditionForm.getTopn());
            this.dataList = this.getZoneAttackFormDate(zoneTopNFormList, queryCond);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"ZoneAttackTimeTopNDataSet prepareData() unknow exception", (Throwable)e);
        }
        this.logger.info((Object)"end ZoneAttackTimeTopNDataSet prepareData");
        return 0;
    }

    private List<ZoneAttackTimeTopNForm> processMultZoneNE(Map<String, List<ZoneAttackTimeTopNForm>> allCollectorForm) {
        ArrayList<ZoneAttackTimeTopNForm> returnData = new ArrayList<ZoneAttackTimeTopNForm>();
        Map<Long, Map<String, List<ZoneAttackTimeTopNForm>>> zoneDeviceData = this.processMultNEZoneData(allCollectorForm);
        for (Map.Entry<Long, Map<String, List<ZoneAttackTimeTopNForm>>> entry : zoneDeviceData.entrySet()) {
            Object temp;
            if (1 == entry.getValue().size()) {
                Long totalDate = 0L;
                for (Map.Entry<String, List<ZoneAttackTimeTopNForm>> zoneData : entry.getValue().entrySet()) {
                    for (ZoneAttackTimeTopNForm form : zoneData.getValue()) {
                        totalDate = totalDate + form.getTotalDate();
                    }
                }
                temp = new ZoneAttackTimeTopNForm();
                ((ZoneAttackTimeTopNForm)temp).setZoneId(entry.getKey());
                ((ZoneAttackTimeTopNForm)temp).setTotalDate(totalDate);
                returnData.add((ZoneAttackTimeTopNForm)temp);
                continue;
            }
            ArrayList<ZoneAttackTimeTopNForm> zoneData = new ArrayList<ZoneAttackTimeTopNForm>();
            for (Map.Entry<String, List<ZoneAttackTimeTopNForm>> data : entry.getValue().entrySet()) {
                zoneData.addAll((Collection<ZoneAttackTimeTopNForm>)data.getValue());
            }
            temp = this.processZoneTotalData(zoneData);
            if (null == temp) continue;
            returnData.add((ZoneAttackTimeTopNForm)temp);
        }
        return returnData;
    }

    private Map<Long, Map<String, List<ZoneAttackTimeTopNForm>>> processMultNEZoneData(Map<String, List<ZoneAttackTimeTopNForm>> allCollectorForm) {
        HashMap<Long, Map<String, List<ZoneAttackTimeTopNForm>>> zoneDeviceData = new HashMap<Long, Map<String, List<ZoneAttackTimeTopNForm>>>();
        for (Map.Entry<String, List<ZoneAttackTimeTopNForm>> entry : allCollectorForm.entrySet()) {
            for (ZoneAttackTimeTopNForm zoneData : entry.getValue()) {
                List<ZoneAttackTimeTopNForm> list;
                Map deviceData;
                if (zoneDeviceData.containsKey(zoneData.getZoneId())) {
                    deviceData = (Map)zoneDeviceData.get(zoneData.getZoneId());
                    list = deviceData.containsKey(zoneData.getDeviceIp()) ? (List)deviceData.get(zoneData.getDeviceIp()) : new ArrayList();
                } else {
                    deviceData = new HashMap();
                    list = new ArrayList<ZoneAttackTimeTopNForm>();
                }
                list.add(zoneData);
                deviceData.put(zoneData.getDeviceIp(), list);
                zoneDeviceData.put(zoneData.getZoneId(), deviceData);
            }
        }
        return zoneDeviceData;
    }

    private ZoneAttackTimeTopNForm processZoneTotalData(List<ZoneAttackTimeTopNForm> zoneDataList) {
        if (null == zoneDataList || zoneDataList.isEmpty()) {
            return null;
        }
        List<ZoneAttackTimeTopNForm> orderForm = this.sortZoneAttackTimeTopNFormListByField(zoneDataList, "startDate", "ASC");
        ArrayList<ZoneAttackTimeTopNForm> unionList = new ArrayList<ZoneAttackTimeTopNForm>();
        unionList.add(orderForm.get(0));
        for (int i = 1; i < orderForm.size(); ++i) {
            ZoneAttackTimeTopNForm check = (ZoneAttackTimeTopNForm)unionList.get(unionList.size() - 1);
            if (orderForm.get(i).getEndData() <= check.getEndData()) continue;
            if (orderForm.get(i).getStartDate() > check.getEndData()) {
                unionList.add(orderForm.get(i));
                continue;
            }
            if (orderForm.get(i).getStartDate() > check.getEndData()) continue;
            ((ZoneAttackTimeTopNForm)unionList.get(unionList.size() - 1)).setEndData(orderForm.get(i).getEndData());
        }
        Long startTime = ((ZoneAttackTimeTopNForm)unionList.get(0)).getStartDate();
        Long endTime = ((ZoneAttackTimeTopNForm)unionList.get(unionList.size() - 1)).getEndData();
        if (this.queryStartData > startTime) {
            ((ZoneAttackTimeTopNForm)unionList.get(0)).setStartDate(this.queryStartData);
        }
        if (this.queryEndData < endTime) {
            ((ZoneAttackTimeTopNForm)unionList.get(unionList.size() - 1)).setEndData(this.queryEndData);
        }
        Long totalDate = 0L;
        for (ZoneAttackTimeTopNForm form : unionList) {
            totalDate = totalDate + (form.getEndData() - form.getStartDate());
        }
        ZoneAttackTimeTopNForm returnData = new ZoneAttackTimeTopNForm();
        returnData.setTotalDate(totalDate);
        returnData.setZoneId(((ZoneAttackTimeTopNForm)unionList.get(0)).getZoneId());
        return returnData;
    }

    private Map<String, List<ZoneAttackTimeTopNForm>> getAllDetectDeviceDate(List<AticDevice> firewallList, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<ZoneAttackTimeTopNForm>> allCollectorForm = new HashMap<String, List<ZoneAttackTimeTopNForm>>();
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        Map<Long, List<RedunDeviceForm>> redunMap = ReportAnalysisUtil.getRedunFirewallInfoList(firewallList);
        for (Map.Entry<Long, List<RedunDeviceForm>> redun : redunMap.entrySet()) {
            List<DeviceWorkTimeForm> workTimeList = ReportAnalysisUtil.getWorkTimeList(datastatConditionForm, redun);
            for (DeviceWorkTimeForm form : workTimeList) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(form.getDeviceIp());
                datastatConditionForm.setDeviceIpList(list);
                datastatConditionForm.setStartTime(form.getStartTime());
                datastatConditionForm.setEndTime(form.getEndTime());
                Map<Object, Object> tempFormMap = new HashMap();
                try {
                    tempFormMap = this.dataStatService.getZoneAttackTimeTopN(datastatConditionForm, form.getCollectorIp());
                }
                catch (Exception e) {
                    this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorIp = " + form.getCollectorIp()), (Throwable)e);
                }
                if (null == tempFormMap || tempFormMap.isEmpty()) continue;
                if (allCollectorForm.containsKey(form.getDeviceIp())) {
                    ((List)allCollectorForm.get(form.getDeviceIp())).addAll((Collection)tempFormMap.get(form.getDeviceIp()));
                    continue;
                }
                allCollectorForm.putAll(tempFormMap);
            }
        }
        List<AticDevice> redunFirewallList = ReportAnalysisUtil.getRedunFirewallList(redunMap);
        if (!redunFirewallList.isEmpty()) {
            firewallList.removeAll(redunFirewallList);
        }
        if (!firewallList.isEmpty()) {
            allCollectorForm.putAll(this.getAllCollectorIpTopNForm(firewallList, datastatConditionForm));
        }
        return allCollectorForm;
    }

    private List<ZoneAttackTimeTopN> getZoneAttackFormDate(List<ZoneAttackTimeTopNForm> zoneTopNFormList, Map<?, ?> queryCond) {
        ArrayList<ZoneAttackTimeTopN> returnDataList = new ArrayList<ZoneAttackTimeTopN>();
        IZoneService zoneService = ReportBisUtil.getZoneService();
        Locale locale = ReportAnalysisUtil.getCurrentUserLocale4Report(queryCond);
        for (int i = 0; i < zoneTopNFormList.size(); ++i) {
            ZoneAttackTimeTopN data = new ZoneAttackTimeTopN();
            data.setTotalDate(zoneTopNFormList.get(i).getTotalDate());
            data.setDisTotalDate(ReportAnalysisUtil.longTimeToTotalHMS(zoneTopNFormList.get(i).getTotalDate(), locale));
            ZoneInfoForm zoneForm = zoneService.getById(zoneTopNFormList.get(i).getZoneId());
            if (null == zoneForm || "".equals(zoneForm.getZoneDesc())) {
                this.logger.info((Object)("the zone not exist,zoneId = " + zoneTopNFormList.get(i).getZoneId()));
                data.setZoneName(AticUtil.getText((String)"atic.analysis.common.unknownZone", (Locale)locale) + zoneTopNFormList.get(i).getZoneId());
            } else {
                data.setZoneName(zoneForm.getZoneDesc());
            }
            data.setZoneId(zoneTopNFormList.get(i).getZoneId());
            returnDataList.add(data);
        }
        return returnDataList;
    }

    private List<ZoneAttackTimeTopNForm> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        ArrayList<ZoneAttackTimeTopNForm> returnData = new ArrayList<ZoneAttackTimeTopNForm>();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewallId = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            Map<String, List<ZoneAttackTimeTopNForm>> allCollectorForm = this.dataStatService.getZoneAttackTimeTopN(datastatConditionForm, collectorInfo.getIpAddress());
            for (Map.Entry<String, List<ZoneAttackTimeTopNForm>> entry : allCollectorForm.entrySet()) {
                returnData.addAll((Collection<ZoneAttackTimeTopNForm>)entry.getValue());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return returnData;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItem.get(0).getValue());
        if (direction.matches("^[\\d]*$")) {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        } else {
            datastatConditionForm.setDirection(1);
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        this.queryStartData = datastatConditionForm.getStartTime();
        this.queryEndData = datastatConditionForm.getEndTime();
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
        String topn = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setTopn(Integer.parseInt(topn));
        String isInteReport = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
        if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true")) {
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "AbnormalOrAttackTopNTOPN");
            String topn4Inte = String.valueOf(jsonValueItem.get(0).getValue());
            Integer topn4InteValue = Integer.parseInt(topn4Inte);
            datastatConditionForm.setTopn(topn4InteValue);
        }
        if (this.zoneId > 0L) {
            datastatConditionForm.setZoneId(this.zoneId);
        } else {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
    }

    private Map<String, List<ZoneAttackTimeTopNForm>> getAllCollectorIpTopNForm(List<AticDevice> firewallList, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<ZoneAttackTimeTopNForm>> allCollectorTopNFormData = new HashMap<String, List<ZoneAttackTimeTopNForm>>();
        if (!firewallList.isEmpty()) {
            Map<Long, List<AticDevice>> collectDevMap = ReportAnalysisUtil.getCollectDevMap(firewallList);
            for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
                String collectorIp = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue()).getIpAddress();
                datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                for (AticDevice firewall : entry.getValue()) {
                    if (null == datastatConditionForm.getDeviceIpList()) {
                        datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                    }
                    datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
                }
                this.dataStatService = ReportAnalysisUtil.getDataStatService();
                try {
                    allCollectorTopNFormData.putAll(this.dataStatService.getZoneAttackTimeTopN(datastatConditionForm, collectorIp));
                }
                catch (Exception e) {
                    this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey()), (Throwable)e);
                }
            }
        }
        return allCollectorTopNFormData;
    }

    private List<ZoneAttackTimeTopNForm> getTopNForm(List<ZoneAttackTimeTopNForm> allForm, int topn) {
        List<ZoneAttackTimeTopNForm> orderForm = this.sortZoneAttackTimeTopNFormListByField(allForm, "totalDate", "DESC");
        this.processData4Order(orderForm);
        if (orderForm.size() > topn) {
            for (int i = orderForm.size() - 1; i >= topn; --i) {
                orderForm.remove(i);
            }
        }
        return orderForm;
    }

    private void processData4Order(List<ZoneAttackTimeTopNForm> orderformList) {
        for (int i = 0; i < orderformList.size(); ++i) {
            for (int j = i + 1; j < orderformList.size(); ++j) {
                if (!orderformList.get(i).getTotalDate().equals(orderformList.get(j).getTotalDate()) || orderformList.get(i).getZoneId() <= orderformList.get(j).getZoneId()) continue;
                ZoneAttackTimeTopNForm temp = orderformList.get(i);
                orderformList.set(i, orderformList.get(j));
                orderformList.set(j, temp);
            }
        }
    }

    public Long getQueryStartData() {
        return this.queryStartData;
    }

    public void setQueryStartData(Long queryStartData) {
        this.queryStartData = queryStartData;
    }

    public Long getQueryEndData() {
        return this.queryEndData;
    }

    public void setQueryEndData(Long queryEndData) {
        this.queryEndData = queryEndData;
    }

    public List<ZoneAttackTimeTopN> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<ZoneAttackTimeTopN> dataList) {
        this.dataList = dataList;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(long zoneId) {
        this.zoneId = zoneId;
    }
}

