/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.dns.analyzesuccessrate;

import com.hs.atic.analysis.report.dns.analyzesuccessrate.AnalyzeSuccessRateComparator;
import com.hs.atic.analysis.report.dns.analyzesuccessrate.AnalyzeSuccessRateView;
import com.hs.atic.analysis.report.dns.analyzesuccessrate.TransmitAnalyzeSuccessRateData;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.sdk.analysis.form.AnalyzeSuccessRateForm;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AnalyzeSuccessRateTableDataSet
extends IJavaDataSource {
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<AnalyzeSuccessRateForm> cacheForTable = new ArrayList<AnalyzeSuccessRateForm>();

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return 0;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.cacheForTable.size();
    }

    private void getAnalyzeSuccessRateTableData(long sessionId) {
        List<AnalyzeSuccessRateForm> tableData = TransmitAnalyzeSuccessRateData.getInstance().getDataList(sessionId);
        TransmitAnalyzeSuccessRateData.getInstance().removeData(sessionId);
        if (null != tableData) {
            this.cacheForTable = tableData;
        }
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        this.log.info((Object)"start AnalyzeSuccessRateTableDataSet fetchData");
        ArrayList<AnalyzeSuccessRateView> resultList = new ArrayList<AnalyzeSuccessRateView>();
        try {
            this.getAnalyzeSuccessRateTableData(sessionId);
            ArrayList<AnalyzeSuccessRateForm> result = new ArrayList<AnalyzeSuccessRateForm>();
            this.processOrder(sortList);
            this.processPaging(pageIndex, pageSize, result);
            for (AnalyzeSuccessRateForm analyzeSuccessRateForm : result) {
                resultList.add((AnalyzeSuccessRateView)ReportAnalysisUtil.copyProperties(analyzeSuccessRateForm, new AnalyzeSuccessRateView()));
            }
        }
        catch (LegoCheckedException legoException) {
            resultList.clear();
            this.log.error((Object)("AnalyzeSuccessRateTableDataSet fetchData() LegoCheckedException :" + legoException.getErrorCode()));
        }
        catch (Exception e) {
            resultList.clear();
            this.log.error((Object)"AnalyzeSuccessRateTableDataSet fetchData() unknow exception", (Throwable)e);
        }
        this.log.info((Object)"end AnalyzeSuccessRateTableDataSet fetchData");
        return resultList;
    }

    private void processPaging(long pageIndex, long pageSize, List<AnalyzeSuccessRateForm> resultList) {
        if (pageIndex != 0L && pageSize != 0L) {
            int startIndex = (int)((pageIndex - 1L) * pageSize);
            if ((long)this.cacheForTable.size() >= (long)startIndex + pageSize) {
                resultList.addAll(this.cacheForTable.subList(startIndex, startIndex + (int)pageSize));
            } else {
                resultList.addAll(this.cacheForTable.subList(startIndex, this.cacheForTable.size()));
            }
        }
        if (pageIndex == 0L && pageSize == 0L) {
            resultList.addAll(this.cacheForTable);
        }
    }

    private void processOrder(OrderInfo sortList) {
        if (null != sortList) {
            Collections.sort(this.cacheForTable, AnalyzeSuccessRateComparator.getComparatorByFieldName(sortList.getOrderField(), sortList.getOrderType()));
        }
    }
}

