/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.dns.request;

import com.hs.atic.analysis.report.dns.request.RequestTrend;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.report.util.ReportConditionUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.RequestTrendForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestTrendChartDataSet
extends IJavaDataSource {
    private static final Long NUM_THREE_HUNDRED = 300L;
    private static final Long NUM_THREE_THOUND_SIX_HUNDRED = 3600L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<RequestTrend> dataList = new ArrayList<RequestTrend>();
    private IDataStatService dataStatService;

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        return this.dataList;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getPrepareParasMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"RequestTrendChartDataSet start prepareData()");
        List<RequestTrendForm> requestTrendFormList = null;
        Map<String, List<RequestTrendForm>> allCollectorRequestForm = null;
        try {
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            if (datastatConditionForm.getDeviceId() > 0L) {
                allCollectorRequestForm = this.getSingleDeviceData(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect4DnsAnalysis(datastatConditionForm, currentLogUserId);
                Map<Long, List<AticDevice>> collectDevMap = null;
                collectDevMap = ReportAnalysisUtil.getCollectDevMap(firewallList);
                allCollectorRequestForm = this.getAllCollectorIpTopNForm(collectDevMap, datastatConditionForm);
            }
            if (-2L == datastatConditionForm.getDeviceId()) {
                requestTrendFormList = this.getAllDetectTopNForm(allCollectorRequestForm);
            } else {
                ArrayList<RequestTrendForm> allForm = new ArrayList<RequestTrendForm>();
                for (Map.Entry<String, List<RequestTrendForm>> entry : allCollectorRequestForm.entrySet()) {
                    allForm.addAll((Collection<RequestTrendForm>)entry.getValue());
                }
                requestTrendFormList = this.getTopNForm(allForm, 1);
            }
            requestTrendFormList = this.getAllTimeData(requestTrendFormList, datastatConditionForm.getStartTime(), datastatConditionForm.getEndTime());
            this.getRequestTrendFormData(datastatConditionForm, requestTrendFormList);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"RequestTrendChartDataSet prepareData() unknow exception", (Throwable)e);
        }
        this.logger.info((Object)"RequestTrendChartDataSet end prepareData()");
        return 0;
    }

    private void getRequestTrendFormData(DataStatConditionForm datastatConditionForm, List<RequestTrendForm> requestTrendFormList) {
        Map<String, String> userDefineDN = this.getUserDefineDSN(datastatConditionForm);
        for (int i = 0; i < requestTrendFormList.size(); ++i) {
            RequestTrend data = new RequestTrend();
            data.setDateTime(requestTrendFormList.get(i).getDateTime() * 1000L);
            data.setRequestPackagePps(requestTrendFormList.get(i).getRequestPackagePps());
            if (requestTrendFormList.get(i).getRequestPackageName().equalsIgnoreCase("Total")) {
                data.setRequestPackageName(AticUtil.getText((String)"atic.analysis.report.dns.total"));
            } else if (requestTrendFormList.get(i).getRequestPackageName().equalsIgnoreCase("TCP")) {
                data.setRequestPackageName(requestTrendFormList.get(i).getRequestPackageName());
            } else if (requestTrendFormList.get(i).getRequestPackageName().equalsIgnoreCase("UDP")) {
                data.setRequestPackageName(requestTrendFormList.get(i).getRequestPackageName());
            } else if (userDefineDN.containsKey(requestTrendFormList.get(i).getRequestPackageName())) {
                data.setRequestPackageName(userDefineDN.get(requestTrendFormList.get(i).getRequestPackageName()));
            } else {
                if ("AAAAA_REQUEST_PPS".equalsIgnoreCase(requestTrendFormList.get(i).getRequestPackageName())) {
                    requestTrendFormList.get(i).setRequestPackageName("AAAA_REQUEST_PPS");
                }
                if ("CNNAME_REQUEST_PPS".equalsIgnoreCase(requestTrendFormList.get(i).getRequestPackageName())) {
                    requestTrendFormList.get(i).setRequestPackageName("CNAME_REQUEST_PPS");
                }
                data.setRequestPackageName("UDP_DNS " + requestTrendFormList.get(i).getRequestPackageName());
            }
            this.dataList.add(data);
        }
    }

    private Map<String, String> getUserDefineDSN(DataStatConditionForm datastatConditionForm) {
        HashMap<String, String> userDefineDNSStr = new HashMap<String, String>();
        if (null != datastatConditionForm.getDeviceId() && datastatConditionForm.getDeviceId() > 0L && null != datastatConditionForm.getZoneId() && datastatConditionForm.getZoneId() > 0L) {
            IZoneMgrNorthSerice zoneMgrNorthSerice = ReportAnalysisUtil.getZoneMgrNorthSerice();
            Map userDefineDNS = new HashMap();
            if (datastatConditionForm.getIsServiceGroup().booleanValue()) {
                for (Map.Entry<String, List<Long>> entry : datastatConditionForm.getServiceIds().entrySet()) {
                    if (!entry.getKey().equalsIgnoreCase("DEFAULT") && !entry.getKey().equalsIgnoreCase("UDP_DNS")) continue;
                    for (Long tempId : entry.getValue()) {
                        Map temp = zoneMgrNorthSerice.getUserDefDnsTypeCode(datastatConditionForm.getDeviceId(), datastatConditionForm.getZoneId(), tempId);
                        if (null == temp || temp.isEmpty()) continue;
                        userDefineDNS.putAll(temp);
                    }
                }
            } else {
                userDefineDNS = zoneMgrNorthSerice.getUserDefDnsTypeCode(datastatConditionForm.getDeviceId(), datastatConditionForm.getZoneId(), datastatConditionForm.getBisId());
            }
            for (Map.Entry<String, List<Long>> entry : userDefineDNS.entrySet()) {
                userDefineDNSStr.put(((Long)((Object)entry.getKey())).toString(), (String)((Object)entry.getValue()));
            }
        }
        return userDefineDNSStr;
    }

    private Map<String, List<RequestTrendForm>> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,fwId = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        HashMap<String, List<RequestTrendForm>> allCollectorRequestForm = new HashMap();
        try {
            allCollectorRequestForm = this.dataStatService.getRequestTrend(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return allCollectorRequestForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        String zoneId = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        if (!"0".equals(zoneId)) {
            datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        } else {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        String bisId = "0";
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
        if (null != jsonValueItem.get(0).getValue()) {
            bisId = String.valueOf(jsonValueItem.get(0).getValue());
        }
        ReportAnalysisUtil.processServiceCond(datastatConditionForm, bisId);
        String zoneIp = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip");
        zoneIp = String.valueOf(jsonValueItem.get(0).getValue());
        if (!AticUtil.isNull((String)zoneIp)) {
            datastatConditionForm.setZoneIp(zoneIp);
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "selectType");
        ArrayList<String> requestTrendType = new ArrayList<String>();
        this.getDNSSelectType(requestTrendType, jsonValueItem);
        datastatConditionForm.setRequestTrendType(requestTrendType);
    }

    private void getDNSSelectType(List<String> requestTrendType, List<JsonValueItem> jsonValueItem) {
        if (jsonValueItem.get(0).getValue() == null) {
            List<JsonValueItem> allSelectType = ReportConditionUtil.getSelectType();
            for (JsonValueItem item : allSelectType) {
                requestTrendType.add(item.getValue());
            }
        } else {
            for (JsonValueItem item : jsonValueItem) {
                requestTrendType.add(item.getValue());
            }
        }
    }

    private List<RequestTrendForm> getAllDetectTopNForm(Map<String, List<RequestTrendForm>> inputMap) {
        List<RequestTrendForm> distinctForm = new ArrayList<RequestTrendForm>();
        List listDefendGroupForm = ReportBisUtil.getDefendGroupService().getAll();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        for (DefendGroupForm defendGroupForm : listDefendGroupForm) {
            String[] devIds;
            ArrayList<RequestTrendForm> listForm = new ArrayList<RequestTrendForm>();
            if (null == defendGroupForm.getDevices() || "".equals(defendGroupForm.getDevices())) continue;
            for (String devId : devIds = defendGroupForm.getDevices().split(",")) {
                AticDevice firewall = firewallService.getDeviceByMoid(Long.parseLong(devId));
                if (null == firewall) continue;
                String devIp = firewall.getIpAddress();
                if (!inputMap.containsKey(devIp = AticUtil.formatIpAddress((String)devIp))) continue;
                listForm.addAll((Collection<RequestTrendForm>)inputMap.get(devIp));
                inputMap.remove(devIp);
            }
            if (listForm.isEmpty()) continue;
            distinctForm.addAll(this.getTopNForm(listForm, defendGroupForm.getDetectMode()));
        }
        for (Map.Entry entry : inputMap.entrySet()) {
            distinctForm.addAll((Collection)entry.getValue());
        }
        distinctForm = this.getTopNForm(distinctForm, 1);
        return distinctForm;
    }

    private List<RequestTrendForm> getAllTimeData(List<RequestTrendForm> requestTrendFormList, long startTime, long endTime) {
        startTime = ReportAnalysisUtil.getRealStartTime(startTime, endTime);
        long timeSlot = this.getTimeSlot(startTime, endTime);
        ArrayList<String> dnsNameList = new ArrayList<String>();
        Long minTime = 0L;
        Long maxTime = 0L;
        for (int i = 0; i < requestTrendFormList.size(); ++i) {
            RequestTrendForm form = requestTrendFormList.get(i);
            if (i == 0) {
                minTime = form.getDateTime();
                maxTime = form.getDateTime();
            } else {
                if (form.getDateTime() < minTime) {
                    minTime = form.getDateTime();
                }
                if (form.getDateTime() > maxTime) {
                    maxTime = form.getDateTime();
                }
            }
            this.getDnsNameList(form, dnsNameList);
        }
        HashMap<Long, List<RequestTrendForm>> map = new HashMap<Long, List<RequestTrendForm>>();
        while (minTime <= maxTime) {
            ArrayList<RequestTrendForm> tmpList = new ArrayList<RequestTrendForm>();
            for (RequestTrendForm form : requestTrendFormList) {
                if (!form.getDateTime().equals(minTime)) continue;
                tmpList.add(form);
            }
            map.put(minTime, tmpList);
            minTime = minTime + timeSlot;
        }
        this.getRequestTrendFormList(map, dnsNameList, requestTrendFormList);
        return requestTrendFormList;
    }

    private void getRequestTrendFormList(Map<Long, List<RequestTrendForm>> map, List<String> dnsNameList, List<RequestTrendForm> requestTrendFormList) {
        for (Map.Entry<Long, List<RequestTrendForm>> entry : map.entrySet()) {
            for (int i = 0; i < dnsNameList.size(); ++i) {
                boolean hasData = false;
                for (RequestTrendForm form : entry.getValue()) {
                    if (!form.getRequestPackageName().equals(dnsNameList.get(i))) continue;
                    hasData = true;
                    break;
                }
                if (hasData) continue;
                RequestTrendForm form = new RequestTrendForm();
                form.setDateTime(entry.getKey());
                form.setRequestPackagePps(0L);
                form.setRequestPackageName(dnsNameList.get(i));
                requestTrendFormList.add(form);
            }
        }
    }

    private void getDnsNameList(RequestTrendForm form, List<String> dnsNameList) {
        boolean hasData = false;
        for (int j = 0; j < dnsNameList.size(); ++j) {
            if (!form.getRequestPackageName().equals(dnsNameList.get(j))) continue;
            hasData = true;
            break;
        }
        if (!hasData) {
            dnsNameList.add(form.getRequestPackageName());
        }
    }

    private long getTimeSlot(long startTime, long endTime) {
        long timeSlot = 0L;
        int type = ReportAnalysisUtil.getTimeSpanType(endTime, startTime);
        timeSlot = type == AnalysisConstants.LESS_THAN_SEVEN_DAYS ? NUM_THREE_THOUND_SIX_HUNDRED : (type == AnalysisConstants.MORE_THAN_SEVEN_DAYS ? 24L * NUM_THREE_THOUND_SIX_HUNDRED : NUM_THREE_HUNDRED);
        return timeSlot;
    }

    private Map<String, List<RequestTrendForm>> getAllCollectorIpTopNForm(Map<Long, List<AticDevice>> collectDevMap, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<RequestTrendForm>> allCollectorRequestTrendForm = new HashMap<String, List<RequestTrendForm>>();
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
            String collectorIp = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue()).getIpAddress();
            datastatConditionForm.setDeviceIpList(new ArrayList<String>());
            for (AticDevice firewall : entry.getValue()) {
                if (null == datastatConditionForm.getDeviceIpList()) {
                    datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                }
                datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
            }
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            Map<Object, Object> tempMap = new HashMap();
            try {
                tempMap = this.dataStatService.getRequestTrend(datastatConditionForm, collectorIp);
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey()), (Throwable)e);
            }
            allCollectorRequestTrendForm.putAll(tempMap);
        }
        return allCollectorRequestTrendForm;
    }

    private List<RequestTrendForm> getTopNForm(List<RequestTrendForm> allForm, int netMode) {
        for (int i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (!allForm.get(i).getDateTime().equals(allForm.get(j).getDateTime()) || !allForm.get(i).getRequestPackageName().equals(allForm.get(j).getRequestPackageName())) continue;
                this.dealWithSame(allForm, netMode, i, j);
            }
        }
        return allForm;
    }

    private void dealWithSame(List<RequestTrendForm> allForm, int netMode, int i, int j) {
        if (netMode == 0) {
            if (allForm.get(i).getRequestPackagePps() > allForm.get(j).getRequestPackagePps()) {
                allForm.get(i).setRequestPackagePps(allForm.get(i).getRequestPackagePps());
            } else {
                allForm.get(i).setRequestPackagePps(allForm.get(j).getRequestPackagePps());
            }
            allForm.remove(j);
        } else if (netMode == 1) {
            allForm.get(i).setRequestPackagePps(allForm.get(i).getRequestPackagePps() + allForm.get(j).getRequestPackagePps());
            allForm.remove(j);
        }
    }
}

