/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.dns.request;

import com.hs.atic.analysis.report.dns.cache.TableHeader;
import com.hs.atic.analysis.report.dns.request.RequestTrend;
import com.hs.atic.analysis.report.dns.request.RequestTrendTable;
import com.hs.atic.analysis.report.dns.request.RequestTrendTableComparator;
import com.hs.atic.analysis.report.dns.request.TransmitRequestTrendData;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.IFlexTableData;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class RequestTrendTableDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<IFlexTableData> headList = new ArrayList<IFlexTableData>();
    private List<List<RequestTrendTable>> tableData = new ArrayList<List<RequestTrendTable>>();

    public List<RequestTrend> sortListByField(List<RequestTrend> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        if (pageIndex == 0L && pageSize == 0L) {
            return this.tableData;
        }
        ArrayList<List<RequestTrendTable>> list = new ArrayList<List<RequestTrendTable>>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= this.tableData.size()) {
            startIndex = this.tableData.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= this.tableData.size()) {
            endIndex = this.tableData.size();
        }
        if (this.tableData.isEmpty()) {
            return list;
        }
        list.addAll(this.tableData.subList(startIndex, endIndex));
        return list;
    }

    public List<IFlexTableData> getFlexTableHeader() {
        return this.headList;
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        try {
            List<JsonValueItem> jsonValueItem = null;
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
            String topn = String.valueOf(jsonValueItem.get(0).getValue());
            TableHeader item = new TableHeader();
            item.setDisplayTxt(AticUtil.getText((String)"atic.analysis.report.dns.cache.table.first"));
            this.headList.add(item);
            List<RequestTrend> dataList = TransmitRequestTrendData.getInstance().getDataList(sessionId);
            TransmitRequestTrendData.getInstance().removeData(sessionId);
            this.logger.info((Object)"removeDate from TransmitRequestTrendData");
            if (null == dataList || dataList.isEmpty()) {
                this.logger.info((Object)"dataList is null or empty");
                return 0;
            }
            List<String> dnsNameList = this.processHeadList(dataList);
            HashMap<Long, List<RequestTrend>> sourceDataMap = new HashMap<Long, List<RequestTrend>>();
            for (int i = 0; i < dataList.size(); ++i) {
                Long time = dataList.get(i).getDateTime();
                ArrayList<RequestTrend> tmpList = new ArrayList<RequestTrend>();
                tmpList.add(dataList.get(i));
                for (int j = dataList.size() - 1; j > i; --j) {
                    if (!time.equals(dataList.get(j).getDateTime())) continue;
                    tmpList.add(dataList.get(j));
                    dataList.remove(j);
                }
                sourceDataMap.put(time, tmpList);
            }
            Object[] times = sourceDataMap.keySet().toArray();
            Arrays.sort(times);
            this.getTableData(times, sourceDataMap, dnsNameList);
            if (!AticUtil.isNull((String)topn)) {
                this.fetchTopnData(Integer.parseInt(topn));
            }
            this.logger.info((Object)"end prepareData");
            return 0;
        }
        catch (LegoCheckedException legoException) {
            this.tableData.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.tableData.clear();
            this.logger.error((Object)"RequestTrendTableDataSet prepareData() unknow exception", (Throwable)e);
            return 0;
        }
    }

    private List<String> processHeadList(List<RequestTrend> dataList) {
        ArrayList<String> dnsNameList = new ArrayList<String>();
        for (int i = 0; i < dataList.size(); ++i) {
            RequestTrend requestTrend = dataList.get(i);
            if (i == 0) {
                String dnsName = requestTrend.getRequestPackageName();
                dnsNameList.add(dnsName);
                TableHeader item = new TableHeader();
                item.setDisplayTxt(dnsName);
                this.headList.add(item);
                continue;
            }
            boolean hasName = false;
            for (int j = 0; j < this.headList.size(); ++j) {
                if (!requestTrend.getRequestPackageName().equals(this.headList.get(j).getDisplayTxt())) continue;
                hasName = true;
                break;
            }
            if (hasName) continue;
            String dnsName = requestTrend.getRequestPackageName();
            dnsNameList.add(dnsName);
            TableHeader item = new TableHeader();
            item.setDisplayTxt(dnsName);
            this.headList.add(item);
        }
        return dnsNameList;
    }

    private void fetchTopnData(int topn) {
        int n;
        ArrayList<RequestTrendTable> totalList = new ArrayList<RequestTrendTable>();
        for (List<RequestTrendTable> list : this.tableData) {
            RequestTrendTable total = list.get(1);
            totalList.add(total);
        }
        Collections.sort(totalList, new RequestTrendTableComparator());
        ArrayList<List<RequestTrendTable>> tableDataList = new ArrayList<List<RequestTrendTable>>();
        for (RequestTrendTable total : totalList) {
            for (List<RequestTrendTable> rowList : this.tableData) {
                if (!rowList.contains(total)) continue;
                tableDataList.add(rowList);
            }
        }
        int n2 = tableDataList.size();
        if (n2 > topn) {
            n = topn;
        }
        this.tableData = tableDataList.subList(0, n);
    }

    private void getTableData(Object[] times, Map<Long, List<RequestTrend>> sourceDataMap, List<String> dnsNameList) {
        for (Object time : times) {
            ArrayList<RequestTrendTable> rowData = new ArrayList<RequestTrendTable>();
            RequestTrendTable data = new RequestTrendTable(AticUtil.convertTimeLong((Long)((Long)time / 1000L)));
            rowData.add(data);
            int checkZeroNum = 0;
            for (String name : dnsNameList) {
                checkZeroNum += this.getTableData0(rowData, name, time, sourceDataMap);
            }
            if (checkZeroNum >= dnsNameList.size()) continue;
            this.tableData.add(rowData);
        }
    }

    private int getTableData0(List<RequestTrendTable> rowData, String name, Object time, Map<Long, List<RequestTrend>> sourceDataMap) {
        int checkZeroNum = 0;
        String pps = "-";
        for (RequestTrend requestTrend : sourceDataMap.get(time)) {
            if (!name.equals(requestTrend.getRequestPackageName())) continue;
            pps = String.valueOf(requestTrend.getRequestPackagePps());
            if (0L != requestTrend.getRequestPackagePps()) continue;
            ++checkZeroNum;
        }
        rowData.add(new RequestTrendTable(pps));
        return checkZeroNum;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.tableData.size();
    }
}

