/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.dns.topn;

import com.hs.atic.analysis.report.dns.topn.DnsGraph;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.analysis.util.TopNPara4ReportPrepareObj;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class DnsRequestOutGraphDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<DnsGraph> dataList = new ArrayList<DnsGraph>();
    private Boolean isIn = false;
    private int reportType = 1;
    private Boolean isSrcIp = false;
    private String topnType4InteReport = "";
    private Boolean isDNSType = false;

    public List<DnsGraph> sortListByField(List<DnsGraph> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<DnsGraph> orderedList = null;
        if (null != sortList) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<DnsGraph> list = new ArrayList<DnsGraph>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getPrepareParasMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        try {
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            TopNPara4ReportPrepareObj topNPara4ReportPrepareObj = new TopNPara4ReportPrepareObj();
            topNPara4ReportPrepareObj.setTopnType(datastatConditionForm.getTopnType());
            topNPara4ReportPrepareObj.setReportId(reportId);
            topNPara4ReportPrepareObj.setDataSourceId(dataSourceId);
            topNPara4ReportPrepareObj.setQueryCond(queryCond);
            topNPara4ReportPrepareObj.setSessionId(sessionId);
            topNPara4ReportPrepareObj.setSrcIp(this.isSrcIp);
            this.dataList = ReportAnalysisUtil.getDataFromStaticData(topNPara4ReportPrepareObj);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"DnsGraphDataSet prepareData() unknow exception", (Throwable)e);
        }
        return 0;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        String unit;
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        String zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        if (0L == datastatConditionForm.getZoneId()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type");
        String type = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setAttackType(Integer.parseInt(type));
        if (this.isSrcIp.booleanValue()) {
            datastatConditionForm.setAttackType(1);
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "dnsType");
        ArrayList<String> requestTrendType = new ArrayList<String>();
        for (JsonValueItem item : jsonValueItem) {
            if (AticUtil.isNull((String)item.getValue())) continue;
            requestTrendType.add(item.getValue());
        }
        if (!requestTrendType.isEmpty()) {
            datastatConditionForm.setRequestTrendType(requestTrendType);
            this.isDNSType = true;
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type_combobox");
        String statType = String.valueOf(jsonValueItem.get(0).getValue());
        String isInteReport = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
        if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true")) {
            statType = "1";
        }
        datastatConditionForm.setAppType(Integer.parseInt(statType));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
        String topn = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setTopn(Integer.parseInt(topn));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "topnType");
        String topnType = String.valueOf(jsonValueItem.get(0).getValue());
        if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true") && !AticUtil.isNull((String)this.topnType4InteReport)) {
            topnType = this.topnType4InteReport;
        }
        if (!AticUtil.isNull((String)(unit = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit").get(0).getValue()))) {
            datastatConditionForm.setUnit(Integer.parseInt(unit));
        }
        ReportAnalysisUtil.processTopnType(datastatConditionForm, topnType, this.reportType, this.isIn);
    }

    public List<DnsGraph> getDataList() {
        return this.dataList;
    }

    public Boolean getIsIn() {
        return this.isIn;
    }

    public void setIsIn(Boolean isIn) {
        this.isIn = isIn;
    }

    public Boolean getIsSrcIp() {
        return this.isSrcIp;
    }

    public void setIsSrcIp(Boolean isSrcIp) {
        this.isSrcIp = isSrcIp;
    }

    public String getTopnType4InteReport() {
        return this.topnType4InteReport;
    }

    public void setTopnType4InteReport(String topnType4InteReport) {
        this.topnType4InteReport = topnType4InteReport;
    }

    public void setDataList(List<DnsGraph> dataList) {
        this.dataList = dataList;
    }

    public int getReportType() {
        return this.reportType;
    }

    public void setReportType(int reportType) {
        this.reportType = reportType;
    }

    public Boolean getIsDNSType() {
        return this.isDNSType;
    }

    public void setIsDNSType(Boolean isDNSType) {
        this.isDNSType = isDNSType;
    }
}

