/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.dns.topn;

import com.hs.atic.analysis.report.dns.topn.DnsGraph;
import com.hs.atic.analysis.report.dns.topn.DnsTopN;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.DnsGraphForm;
import com.hs.atic.sdk.analysis.form.DnsTopNForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.policy.util.PolicyUtil;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class DnsRequestOutTopNDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<DnsTopN> dataList = new ArrayList<DnsTopN>();
    private int success = 0;
    private boolean isDNSType = false;
    private boolean isIn = false;
    private int reportType = 1;
    private Boolean isSrcIp = false;
    private String topnType4InteReport = "9";
    private IDataStatService dataStatService;
    private boolean isCurrentTopn;

    public List<DnsTopN> sortListByField(List<DnsTopN> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<DnsTopN> orderedList = null;
        if (null != sortList) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<DnsTopN> list = new ArrayList<DnsTopN>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.dataList.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        Map<String, List<DnsTopNForm>> allCollectorDnsTopNForm = null;
        try {
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return this.success;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return this.success;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return this.success;
            }
            if (datastatConditionForm.getDeviceId() > 0L) {
                allCollectorDnsTopNForm = this.getSingleDeviceData(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                allCollectorDnsTopNForm = this.getMultiDeviceData(currentLogUserId, datastatConditionForm);
            }
            if (allCollectorDnsTopNForm == null) {
                this.logger.info((Object)"Map is null, no data !");
                return this.success;
            }
            List<DnsTopNForm> dnsTopNFormList = null;
            dnsTopNFormList = -2L == datastatConditionForm.getDeviceId() ? this.getAllDetectTopNForm(allCollectorDnsTopNForm, datastatConditionForm.getTopn(), datastatConditionForm.getAttackType()) : this.getTopNForm(allCollectorDnsTopNForm, datastatConditionForm.getTopn(), datastatConditionForm.getAttackType());
            dnsTopNFormList = this.processSameDnsName(dnsTopNFormList, datastatConditionForm.getAttackType());
            Map<String, List<DnsGraphForm>> allCollectorDnsGraphForm = null;
            if (datastatConditionForm.getDeviceId() > 0L) {
                allCollectorDnsGraphForm = this.getSingleDeviceData(datastatConditionForm, dnsTopNFormList);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                allCollectorDnsGraphForm = this.getMultiDeviceData(currentLogUserId, datastatConditionForm, dnsTopNFormList);
            }
            List<DnsGraphForm> dnsGraphFormList = null;
            dnsGraphFormList = -2L == datastatConditionForm.getDeviceId() ? this.getAllDetectTopNForm4Graph(allCollectorDnsGraphForm, datastatConditionForm.getAttackType()) : this.getTopNForm(allCollectorDnsGraphForm, datastatConditionForm.getAttackType());
            dnsGraphFormList = this.getallTimeData(dnsGraphFormList, datastatConditionForm.getStartTime(), datastatConditionForm.getEndTime(), datastatConditionForm.getAttackType());
            List<DnsGraph> returnDataList = this.processFinalData4Grahp(dnsGraphFormList, datastatConditionForm);
            this.processFinalData(returnDataList, datastatConditionForm);
            List<DnsGraph> topnGraphDataList = this.processTopnData4Graph(returnDataList, datastatConditionForm.getAttackType());
            ReportAnalysisUtil.processSaveDataToStaticData(topnGraphDataList, sessionId, datastatConditionForm.getTopnType(), this.isSrcIp);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            ReportAnalysisUtil.processDeleteDataToStaticData(sessionId, datastatConditionForm.getTopnType(), this.isSrcIp);
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            ReportAnalysisUtil.processDeleteDataToStaticData(sessionId, datastatConditionForm.getTopnType(), this.isSrcIp);
            this.logger.error((Object)"DnsTopNDataSet prepareData() unknow exception", (Throwable)e);
        }
        return this.success;
    }

    private List<DnsGraph> processTopnData4Graph(List<DnsGraph> returnDataList, int statType) {
        ArrayList<DnsGraph> dnsGraphList = new ArrayList<DnsGraph>();
        for (DnsTopN dnsTopN : this.dataList) {
            String dnsOrRequestType = "";
            dnsOrRequestType = 0 == statType ? (!this.isDNSType ? dnsTopN.getDnsName() : dnsTopN.getDnsName() + dnsTopN.getRequestType()) : dnsTopN.getSrcIp();
            for (DnsGraph temp : returnDataList) {
                String dnsOrRequestTypeGraph = "";
                dnsOrRequestTypeGraph = 0 == statType ? (!this.isDNSType ? temp.getDnsName() : temp.getDnsName() + temp.getRequestType()) : temp.getDisSrcIp();
                if (!dnsOrRequestTypeGraph.equals(dnsOrRequestType)) continue;
                dnsGraphList.add(temp);
            }
        }
        return dnsGraphList;
    }

    private List<DnsTopNForm> processSameDnsName(List<DnsTopNForm> tempDnsTopNFormList, int statType) {
        ArrayList<DnsTopNForm> dnsTopNFormList = new ArrayList<DnsTopNForm>();
        ArrayList<String> checkDnsName = new ArrayList<String>();
        for (DnsTopNForm tempDnsTopNForm : tempDnsTopNFormList) {
            String dnsOrRequestType = "";
            dnsOrRequestType = 0 == statType ? (!this.isDNSType ? tempDnsTopNForm.getDnsName() : tempDnsTopNForm.getDnsName() + tempDnsTopNForm.getRequestType()) : tempDnsTopNForm.getSrcIp();
            if (checkDnsName.contains(dnsOrRequestType)) continue;
            checkDnsName.add(dnsOrRequestType);
            dnsTopNFormList.add(tempDnsTopNForm);
        }
        return dnsTopNFormList;
    }

    private Map<String, List<DnsGraphForm>> getSingleDeviceData(DataStatConditionForm datastatConditionForm, List<DnsTopNForm> dnsTopNFormList) {
        HashMap<String, List<DnsGraphForm>> allCollectorDnsGraphForm = new HashMap<String, List<DnsGraphForm>>();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewallId = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        for (int i = 0; i < dnsTopNFormList.size(); ++i) {
            Map<Object, Object> tempMap = new HashMap();
            try {
                tempMap = this.dataStatService.getDnsGraph(datastatConditionForm, dnsTopNFormList.get(i), collectorInfo.getIpAddress());
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
            }
            for (Map.Entry<Object, Object> entryTemp : tempMap.entrySet()) {
                if (allCollectorDnsGraphForm.containsKey(entryTemp.getKey())) {
                    ((List)allCollectorDnsGraphForm.get(entryTemp.getKey())).addAll((Collection)entryTemp.getValue());
                    continue;
                }
                allCollectorDnsGraphForm.put((String)entryTemp.getKey(), (List<DnsGraphForm>)entryTemp.getValue());
            }
        }
        return allCollectorDnsGraphForm;
    }

    private Map<String, List<DnsGraphForm>> getMultiDeviceData(Long currentLogUserId, DataStatConditionForm datastatConditionForm, List<DnsTopNForm> dnsTopNFormList) {
        List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect4DnsAnalysis(datastatConditionForm, currentLogUserId);
        Map<Long, List<AticDevice>> collectDevMaps = ReportAnalysisUtil.getCollectDevMap(firewallList);
        HashMap<String, List<AticDevice>> colDevMap = new HashMap<String, List<AticDevice>>();
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMaps.entrySet()) {
            CollectorInfo collector = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue());
            if (null == collector) continue;
            String collectorIp = collector.getIpAddress();
            colDevMap.put(collectorIp, entry.getValue());
            datastatConditionForm.setDeviceIpList(new ArrayList<String>());
            for (AticDevice firewall : entry.getValue()) {
                if (null == datastatConditionForm.getDeviceIpList()) {
                    datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                }
                datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
            }
        }
        return this.processAllCollectorDnsGraphFormData(datastatConditionForm, dnsTopNFormList, colDevMap);
    }

    private Map<String, List<DnsGraphForm>> processAllCollectorDnsGraphFormData(DataStatConditionForm datastatConditionForm, List<DnsTopNForm> dnsTopNFormList, Map<String, List<AticDevice>> colDevMap) {
        HashMap<String, List<DnsGraphForm>> allCollectorDnsGraphForm = new HashMap<String, List<DnsGraphForm>>();
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        for (int i = 0; i < dnsTopNFormList.size(); ++i) {
            for (Map.Entry<String, List<AticDevice>> entry : colDevMap.entrySet()) {
                List<AticDevice> listFirewall = colDevMap.get(entry.getKey());
                datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                for (AticDevice firewall : listFirewall) {
                    datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
                }
                Map<Object, Object> tempMap = new HashMap();
                try {
                    tempMap = this.dataStatService.getDnsGraph(datastatConditionForm, dnsTopNFormList.get(i), entry.getKey());
                }
                catch (Exception e) {
                    this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey()), (Throwable)e);
                }
                for (Map.Entry<Object, Object> entryTemp : tempMap.entrySet()) {
                    if (allCollectorDnsGraphForm.containsKey(entryTemp.getKey())) {
                        ((List)allCollectorDnsGraphForm.get(entryTemp.getKey())).addAll((Collection)entryTemp.getValue());
                        continue;
                    }
                    allCollectorDnsGraphForm.put((String)entryTemp.getKey(), (List<DnsGraphForm>)entryTemp.getValue());
                }
            }
        }
        return allCollectorDnsGraphForm;
    }

    private List<DnsGraphForm> getAllDetectTopNForm4Graph(Map<String, List<DnsGraphForm>> inputMap, int type) {
        List<DnsGraphForm> distinctForm = new ArrayList<DnsGraphForm>();
        List listDefendGroupForm = ReportBisUtil.getDefendGroupService().getAll();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        for (DefendGroupForm defendGroupForm : listDefendGroupForm) {
            String[] devIds;
            ArrayList<DnsGraphForm> listForm = new ArrayList<DnsGraphForm>();
            if (null == defendGroupForm.getDevices() || "".equals(defendGroupForm.getDevices())) continue;
            for (String devId : devIds = defendGroupForm.getDevices().split(",")) {
                AticDevice firewall = firewallService.getDeviceByMoid(Long.parseLong(devId));
                if (null == firewall) continue;
                String devIp = firewall.getIpAddress();
                if (!inputMap.containsKey(devIp = AticUtil.formatIpAddress((String)devIp))) continue;
                listForm.addAll((Collection<DnsGraphForm>)inputMap.get(devIp));
                inputMap.remove(devIp);
            }
            if (listForm.isEmpty()) continue;
            distinctForm.addAll(this.getDistinctForm4Graph(listForm, defendGroupForm.getDetectMode(), type));
        }
        for (Map.Entry entry : inputMap.entrySet()) {
            distinctForm.addAll((Collection)entry.getValue());
        }
        distinctForm = this.getDistinctForm4Graph(distinctForm, 1, type);
        return distinctForm;
    }

    private List<DnsGraphForm> getDistinctForm4Graph(List<DnsGraphForm> allForm, int detectMode, int type) {
        for (int i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (0 == type) {
                    if (!allForm.get(i).getDnsName().equals(allForm.get(j).getDnsName())) continue;
                    if (this.isDNSType && allForm.get(i).getRequestType().equals(allForm.get(j).getRequestType()) && allForm.get(i).getDateTime().equals(allForm.get(j).getDateTime())) {
                        this.dealWithSame4Graph(allForm, detectMode, i, j);
                        continue;
                    }
                    if (this.isDNSType || !allForm.get(i).getDateTime().equals(allForm.get(j).getDateTime())) continue;
                    this.dealWithSame4Graph(allForm, detectMode, i, j);
                    continue;
                }
                if (!allForm.get(i).getSrcIp().equals(allForm.get(j).getSrcIp()) || !allForm.get(i).getDateTime().equals(allForm.get(j).getDateTime())) continue;
                this.dealWithSame4Graph(allForm, detectMode, i, j);
            }
        }
        return allForm;
    }

    private void dealWithSame4Graph(List<DnsGraphForm> allForm, int detectMode, int i, int j) {
        if (detectMode == 0) {
            if (allForm.get(i).getPps() > allForm.get(j).getPps()) {
                allForm.get(i).setPps(allForm.get(i).getPps());
                allForm.get(i).setKbps(allForm.get(i).getKbps());
            } else {
                allForm.get(i).setPps(allForm.get(j).getPps());
                allForm.get(i).setKbps(allForm.get(j).getKbps());
            }
            allForm.remove(j);
        } else if (detectMode == 1) {
            allForm.get(i).setPps(allForm.get(i).getPps() + allForm.get(j).getPps());
            allForm.get(i).setKbps(allForm.get(i).getKbps() + allForm.get(j).getKbps());
            allForm.remove(j);
        }
    }

    private List<DnsGraphForm> getTopNForm(Map<String, List<DnsGraphForm>> inputMap, int type) {
        List<DnsGraphForm> formList = new ArrayList<DnsGraphForm>();
        for (Map.Entry<String, List<DnsGraphForm>> entry : inputMap.entrySet()) {
            formList.addAll((Collection<DnsGraphForm>)entry.getValue());
        }
        formList = this.getDistinctForm4Graph(formList, 1, type);
        return formList;
    }

    private List<DnsGraphForm> getallTimeData(List<DnsGraphForm> dnsGraphFormList, long startTime, long endTime, int statType) {
        startTime = ReportAnalysisUtil.getRealStartTime(startTime, endTime);
        long timeSlot = this.getTimeSlot(startTime, endTime);
        ArrayList<String> dnsNameList = new ArrayList<String>();
        ArrayList<String> srcIpList = new ArrayList<String>();
        Long minTime = 0L;
        Long maxTime = 0L;
        for (int i = 0; i < dnsGraphFormList.size(); ++i) {
            DnsGraphForm form = dnsGraphFormList.get(i);
            if (i == 0) {
                minTime = form.getDateTime();
                maxTime = form.getDateTime();
            } else {
                if (form.getDateTime() < minTime) {
                    minTime = form.getDateTime();
                }
                if (form.getDateTime() > maxTime) {
                    maxTime = form.getDateTime();
                }
            }
            this.getNameOrIpList(form, statType, dnsNameList, srcIpList);
        }
        Map<Long, List<DnsGraphForm>> map = this.getMapData4LogTime(minTime, maxTime, timeSlot, dnsGraphFormList);
        for (Map.Entry<Long, List<DnsGraphForm>> entry : map.entrySet()) {
            if (statType == 0) {
                this.getGraphByDnsName(dnsNameList, entry, dnsGraphFormList);
                continue;
            }
            this.getGraphBySrcIp(srcIpList, entry, dnsGraphFormList);
        }
        return dnsGraphFormList;
    }

    private void getNameOrIpList(DnsGraphForm form, int statType, List<String> dnsNameList, List<String> srcIpList) {
        boolean hasData = false;
        if (statType == 0) {
            this.processDnsName(form, dnsNameList);
        } else {
            for (int j = 0; j < srcIpList.size(); ++j) {
                if (!form.getSrcIp().equals(srcIpList.get(j))) continue;
                hasData = true;
                break;
            }
            if (!hasData) {
                srcIpList.add(form.getSrcIp());
            }
        }
    }

    private void processDnsName(DnsGraphForm form, List<String> dnsNameList) {
        boolean hasData = false;
        for (int j = 0; j < dnsNameList.size(); ++j) {
            if (this.isDNSType) {
                if (!(form.getDnsName() + "-" + form.getRequestType()).equals(dnsNameList.get(j))) continue;
                hasData = true;
                break;
            }
            if (!form.getDnsName().equals(dnsNameList.get(j))) continue;
            hasData = true;
            break;
        }
        if (!hasData) {
            if (this.isDNSType) {
                dnsNameList.add(form.getDnsName() + "-" + form.getRequestType());
            } else {
                dnsNameList.add(form.getDnsName());
            }
        }
    }

    private void getGraphByDnsName(List<String> dnsNameList, Map.Entry<Long, List<DnsGraphForm>> entry, List<DnsGraphForm> dnsGraphFormList) {
        for (int i = 0; i < dnsNameList.size(); ++i) {
            boolean hasData = false;
            for (DnsGraphForm form : entry.getValue()) {
                if (this.isDNSType) {
                    if (!(form.getDnsName() + "-" + form.getRequestType()).equals(dnsNameList.get(i))) continue;
                    hasData = true;
                    break;
                }
                if (!form.getDnsName().equals(dnsNameList.get(i))) continue;
                hasData = true;
                break;
            }
            if (hasData) continue;
            DnsGraphForm form = new DnsGraphForm();
            form.setDateTime(entry.getKey());
            if (this.isDNSType) {
                form.setDnsName(dnsNameList.get(i).split("-")[0]);
                form.setRequestType(dnsNameList.get(i).split("-")[1]);
            } else {
                form.setDnsName(dnsNameList.get(i));
            }
            form.setPps(0L);
            form.setKbps(0L);
            dnsGraphFormList.add(form);
        }
    }

    private void getGraphBySrcIp(List<String> srcIpList, Map.Entry<Long, List<DnsGraphForm>> entry, List<DnsGraphForm> dnsGraphFormList) {
        for (int i = 0; i < srcIpList.size(); ++i) {
            boolean hasData = false;
            for (DnsGraphForm form : entry.getValue()) {
                if (!form.getSrcIp().equals(srcIpList.get(i))) continue;
                hasData = true;
                break;
            }
            if (hasData) continue;
            DnsGraphForm form = new DnsGraphForm();
            form.setDateTime(entry.getKey());
            form.setSrcIp(srcIpList.get(i));
            form.setPps(0L);
            form.setKbps(0L);
            dnsGraphFormList.add(form);
        }
    }

    private long getTimeSlot(long startTime, long endTime) {
        int type = ReportAnalysisUtil.getTimeSpanType(endTime, startTime);
        if (type == AnalysisConstants.LESS_THAN_SEVEN_DAYS) {
            return PolicyUtil.NUM_THREE_THOUSAND_SIX_HUNDRED;
        }
        if (type == AnalysisConstants.MORE_THAN_SEVEN_DAYS) {
            return 24L * PolicyUtil.NUM_THREE_THOUSAND_SIX_HUNDRED;
        }
        return PolicyUtil.NUM_THREE_HUNDRED;
    }

    private Map<Long, List<DnsGraphForm>> getMapData4LogTime(Long minTime, Long maxTime, long timeSlot, List<DnsGraphForm> dnsGraphFormList) {
        HashMap<Long, List<DnsGraphForm>> map = new HashMap<Long, List<DnsGraphForm>>();
        while (minTime <= maxTime) {
            ArrayList<DnsGraphForm> tmpList = new ArrayList<DnsGraphForm>();
            for (DnsGraphForm form : dnsGraphFormList) {
                if (!form.getDateTime().equals(minTime)) continue;
                tmpList.add(form);
            }
            map.put(minTime, tmpList);
            minTime = minTime + timeSlot;
        }
        return map;
    }

    private void processFinalData(List<DnsGraph> dnsTopNFormList, DataStatConditionForm datastatConditionForm) {
        HashMap dnsOrSrcIpMap = new HashMap();
        for (int i = 0; i < dnsTopNFormList.size(); ++i) {
            Iterator data = new DnsTopN();
            ((DnsTopN)((Object)data)).setLogTime(dnsTopNFormList.get(i).getDateTime() / 1000L);
            ((DnsTopN)((Object)data)).setLogtimeString(AticUtil.convertTimeLong((Long)((DnsTopN)((Object)data)).getLogTime()));
            ((DnsTopN)((Object)data)).setPps(dnsTopNFormList.get(i).getPps());
            ((DnsTopN)((Object)data)).setKbps(dnsTopNFormList.get(i).getKbps());
            String mapKey = "";
            if (datastatConditionForm.getAttackType() == 0) {
                if (this.isDNSType) {
                    ((DnsTopN)((Object)data)).setDnsName(dnsTopNFormList.get(i).getDnsName() + "-" + dnsTopNFormList.get(i).getRequestType());
                    ((DnsTopN)((Object)data)).setRequestType(dnsTopNFormList.get(i).getRequestType());
                } else {
                    ((DnsTopN)((Object)data)).setDnsName(dnsTopNFormList.get(i).getDnsName());
                    ((DnsTopN)((Object)data)).setRequestType("-");
                }
                mapKey = ((DnsTopN)((Object)data)).getDnsName() + ((DnsTopN)((Object)data)).getRequestType();
            } else {
                ((DnsTopN)((Object)data)).setSrcIp(IPUtil4Atic.compressIP((String)dnsTopNFormList.get(i).getDisSrcIp()));
                ((DnsTopN)((Object)data)).setDisplaySrcIp(IPUtil4Atic.compressIP((String)dnsTopNFormList.get(i).getDisSrcIp()));
                mapKey = ((DnsTopN)((Object)data)).getSrcIp();
            }
            if (dnsOrSrcIpMap.containsKey(mapKey)) {
                ((List)dnsOrSrcIpMap.get(mapKey)).add(data);
                continue;
            }
            ArrayList tempList = new ArrayList();
            tempList.add(data);
            dnsOrSrcIpMap.put(mapKey, tempList);
        }
        ArrayList<DnsTopN> finalDataList = new ArrayList<DnsTopN>();
        if (this.isCurrentTopn) {
            for (Map.Entry entry : dnsOrSrcIpMap.entrySet()) {
                long totalPps = 0L;
                long tatalKbps = 0L;
                for (DnsTopN dnsTopN : (List)entry.getValue()) {
                    totalPps += dnsTopN.getPps();
                    tatalKbps += dnsTopN.getKbps();
                }
                DnsTopN temp = (DnsTopN)((List)entry.getValue()).get(0);
                temp.setPps(totalPps / (long)((List)entry.getValue()).size());
                temp.setKbps(tatalKbps / (long)((List)entry.getValue()).size());
                finalDataList.add(temp);
            }
        } else {
            for (Map.Entry entry : dnsOrSrcIpMap.entrySet()) {
                List<DnsTopN> tempDataList = (List<DnsTopN>)entry.getValue();
                tempDataList = this.sortListByField(tempDataList, "logTime", "DESC");
                DnsTopN temp = tempDataList.get(0);
                finalDataList.add(temp);
            }
        }
        this.dataList = this.sortListByField(finalDataList, "pps", "DESC");
        if (this.dataList.size() > datastatConditionForm.getTopn()) {
            for (int i = this.dataList.size() - 1; i >= datastatConditionForm.getTopn(); --i) {
                this.dataList.remove(i);
            }
        }
    }

    private List<DnsGraph> processFinalData4Grahp(List<DnsGraphForm> dnsGraphFormList, DataStatConditionForm datastatConditionForm) {
        ArrayList<DnsGraph> returnDataList = new ArrayList<DnsGraph>();
        for (DnsGraphForm form : dnsGraphFormList) {
            DnsGraph dnsGraph = new DnsGraph();
            dnsGraph.setDateTime(form.getDateTime() * 1000L);
            dnsGraph.setDisDateTime(AticUtil.convertTimeLong((Long)form.getDateTime()));
            if (datastatConditionForm.getAttackType() == 0) {
                if (this.isDNSType) {
                    dnsGraph.setDnsName(form.getDnsName() + "-" + form.getRequestType());
                    dnsGraph.setRequestType(form.getRequestType());
                } else {
                    dnsGraph.setDnsName(form.getDnsName());
                    dnsGraph.setRequestType("--");
                }
            } else {
                dnsGraph.setDisSrcIp(IPUtil4Atic.compressIP((String)form.getSrcIp()));
            }
            dnsGraph.setPps(form.getPps());
            dnsGraph.setKbps(form.getKbps());
            returnDataList.add(dnsGraph);
        }
        return returnDataList;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        String unit;
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        String zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        if (0L == datastatConditionForm.getZoneId()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type");
        String type = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setAttackType(Integer.parseInt(type));
        if (this.isSrcIp.booleanValue()) {
            datastatConditionForm.setAttackType(1);
        }
        if ("0".equals(type)) {
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "dnsType");
            ArrayList<String> requestTrendType = new ArrayList<String>();
            for (JsonValueItem item : jsonValueItem) {
                if (AticUtil.isNull((String)item.getValue())) continue;
                requestTrendType.add(item.getValue());
            }
            if (!requestTrendType.isEmpty()) {
                datastatConditionForm.setRequestTrendType(requestTrendType);
                this.isDNSType = true;
            }
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type_combobox");
        String statType = String.valueOf(jsonValueItem.get(0).getValue());
        String isInteReport = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
        if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true")) {
            statType = "1";
        }
        this.isCurrentTopn = "1".equals(statType);
        datastatConditionForm.setAppType(Integer.parseInt(statType));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
        String topn = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setTopn(Integer.parseInt(topn));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "topnType");
        String topnType = String.valueOf(jsonValueItem.get(0).getValue());
        if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true") && !AticUtil.isNull((String)this.topnType4InteReport)) {
            topnType = this.topnType4InteReport;
        }
        if (!AticUtil.isNull((String)(unit = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit").get(0).getValue()))) {
            datastatConditionForm.setUnit(Integer.parseInt(unit));
        }
        ReportAnalysisUtil.processTopnType(datastatConditionForm, topnType, this.reportType, this.isIn);
        ReportAnalysisUtil.processTopnValue4Inte(datastatConditionForm, datastatConditionForm.getTopnType(), queryCond);
    }

    private Map<String, List<DnsTopNForm>> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<DnsTopNForm>> allCollectorDnsTopNForm = new HashMap();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewallId = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            allCollectorDnsTopNForm = this.dataStatService.getDnsTopN(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return allCollectorDnsTopNForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private Map<String, List<DnsTopNForm>> getMultiDeviceData(Long currentLogUserId, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<DnsTopNForm>> allCollectorDnsTopNForm = new HashMap<String, List<DnsTopNForm>>();
        List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect4DnsAnalysis(datastatConditionForm, currentLogUserId);
        if (null == firewallList) {
            this.logger.error((Object)("firewallList is null! devId:" + datastatConditionForm.getDeviceId()));
            return allCollectorDnsTopNForm;
        }
        Map<Long, List<AticDevice>> collectDevMaps = ReportAnalysisUtil.getCollectDevMap(firewallList);
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMaps.entrySet()) {
            CollectorInfo collector = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue());
            if (null == collector) continue;
            String collectorIp = collector.getIpAddress();
            datastatConditionForm.setDeviceIpList(new ArrayList<String>());
            for (AticDevice firewall : entry.getValue()) {
                datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
            }
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            Map<Object, Object> tempMap = new HashMap();
            try {
                tempMap = this.dataStatService.getDnsTopN(datastatConditionForm, collectorIp);
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey()), (Throwable)e);
            }
            for (Map.Entry<Object, Object> entryTemp : tempMap.entrySet()) {
                if (allCollectorDnsTopNForm.containsKey(entryTemp.getKey())) {
                    ((List)allCollectorDnsTopNForm.get(entryTemp.getKey())).addAll((Collection)entryTemp.getValue());
                    continue;
                }
                allCollectorDnsTopNForm.put((String)entryTemp.getKey(), (List<DnsTopNForm>)entryTemp.getValue());
            }
        }
        return allCollectorDnsTopNForm;
    }

    private List<DnsTopNForm> getAllDetectTopNForm(Map<String, List<DnsTopNForm>> inputMap, int topn, int type) {
        List<DnsTopNForm> distinctForm = new ArrayList<DnsTopNForm>();
        List listDefendGroupForm = ReportBisUtil.getDefendGroupService().getAll();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        for (DefendGroupForm defendGroupForm : listDefendGroupForm) {
            String[] devIds;
            ArrayList<DnsTopNForm> listForm = new ArrayList<DnsTopNForm>();
            if (null == defendGroupForm.getDevices() || "".equals(defendGroupForm.getDevices())) continue;
            for (String devId : devIds = defendGroupForm.getDevices().split(",")) {
                AticDevice firewall = firewallService.getDeviceByMoid(Long.parseLong(devId));
                if (null == firewall) continue;
                String devIp = firewall.getIpAddress();
                if (!inputMap.containsKey(devIp = AticUtil.formatIpAddress((String)devIp))) continue;
                listForm.addAll((Collection<DnsTopNForm>)inputMap.get(devIp));
                inputMap.remove(devIp);
            }
            if (listForm.isEmpty()) continue;
            distinctForm.addAll(this.getDistinctForm(listForm, defendGroupForm.getDetectMode(), type));
        }
        for (Map.Entry entry : inputMap.entrySet()) {
            distinctForm.addAll((Collection)entry.getValue());
        }
        distinctForm = this.getDistinctForm(distinctForm, 1, type);
        if ((distinctForm = this.sortListByField4Form(distinctForm, "pps", "DESC")).size() > 2 * topn) {
            for (int i = distinctForm.size() - 1; i >= 2 * topn; --i) {
                distinctForm.remove(i);
            }
        }
        return distinctForm;
    }

    private List<DnsTopNForm> getDistinctForm(List<DnsTopNForm> allForm, int netMode, int attackType) {
        for (int i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (attackType == 0) {
                    if (!allForm.get(i).getDnsName().equals(allForm.get(j).getDnsName())) continue;
                    if (this.isDNSType && allForm.get(i).getRequestType().equals(allForm.get(j).getRequestType())) {
                        this.dealWithSame(allForm, netMode, i, j);
                        continue;
                    }
                    this.dealWithSame(allForm, netMode, i, j);
                    continue;
                }
                if (!allForm.get(i).getSrcIp().equals(allForm.get(j).getSrcIp())) continue;
                this.dealWithSame(allForm, netMode, i, j);
            }
        }
        return allForm;
    }

    private void dealWithSame(List<DnsTopNForm> allForm, int netMode, int i, int j) {
        if (netMode == 0) {
            if (allForm.get(i).getPps() > allForm.get(j).getPps()) {
                allForm.get(i).setPps(allForm.get(i).getPps());
                allForm.get(i).setKbps(allForm.get(i).getKbps());
            } else {
                allForm.get(i).setPps(allForm.get(j).getPps());
                allForm.get(i).setKbps(allForm.get(j).getKbps());
            }
            allForm.remove(j);
        } else if (netMode == 1) {
            allForm.get(i).setPps(allForm.get(i).getPps() + allForm.get(j).getPps());
            allForm.get(i).setKbps(allForm.get(i).getKbps() + allForm.get(j).getKbps());
            allForm.remove(j);
        }
    }

    private List<DnsTopNForm> getTopNForm(Map<String, List<DnsTopNForm>> inputMap, int topn, int type) {
        List<DnsTopNForm> formList = new ArrayList<DnsTopNForm>();
        for (Map.Entry<String, List<DnsTopNForm>> entry : inputMap.entrySet()) {
            formList.addAll((Collection<DnsTopNForm>)entry.getValue());
        }
        if ((formList = this.sortListByField4Form(formList, "pps", "DESC")).size() > 2 * topn) {
            for (int i = formList.size() - 1; i >= 2 * topn; --i) {
                formList.remove(i);
            }
        }
        return formList;
    }

    public List<DnsTopNForm> sortListByField4Form(List<DnsTopNForm> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<DnsTopN> getDataList() {
        return this.dataList;
    }

    public Boolean getIsIn() {
        return this.isIn;
    }

    public void setIsIn(Boolean isIn) {
        this.isIn = isIn;
    }

    public Boolean getIsSrcIp() {
        return this.isSrcIp;
    }

    public void setIsSrcIp(Boolean isSrcIp) {
        this.isSrcIp = isSrcIp;
    }

    public String getTopnType4InteReport() {
        return this.topnType4InteReport;
    }

    public void setTopnType4InteReport(String topnType4InteReport) {
        this.topnType4InteReport = topnType4InteReport;
    }

    public void setDataList(List<DnsTopN> dataList) {
        this.dataList = dataList;
    }

    public Boolean getIsDNSType() {
        return this.isDNSType;
    }

    public void setIsDNSType(Boolean isDNSType) {
        this.isDNSType = isDNSType;
    }

    public int getReportType() {
        return this.reportType;
    }

    public void setReportType(int reportType) {
        this.reportType = reportType;
    }

    public boolean isCurrentTopn() {
        return this.isCurrentTopn;
    }

    public void setCurrentTopn(boolean checkIsCurrentTopn) {
        this.isCurrentTopn = checkIsCurrentTopn;
    }
}

