/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.flux.appflow;

import com.hs.atic.analysis.report.flux.appflow.AppFlow;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.DataSourceStub;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.AppFlowForm;
import com.hs.atic.sdk.analysis.form.BizTypePoJo;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.logserver.module.condition.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppFlowChartDataSet
extends IJavaDataSource {
    private static final Long NUM_THREE_HUNDRED = 300L;
    private static final Long NUM_THREE_THOUSAND_SIX_HUNDRED = 3600L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<AppFlow> dataList = new ArrayList<AppFlow>();
    private IDataStatService dataStatService;
    private boolean isBPS = false;

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        return this.dataList;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        JsonValueObj obj = (JsonValueObj)queryCond.get("bis_combobox");
        if (null != obj) {
            obj.setShowInfo("false");
        }
        return ReportAnalysisUtil.getPrepareParasMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"AppFlowChartDataSet start prepareData()");
        List<AppFlowForm> requestTrendFormList = null;
        Map<String, List<AppFlowForm>> allCollectorRequestForm = null;
        try {
            boolean needQuery4InteReport = ReportAnalysisUtil.checkNeedQuery4InteReport(queryCond, "AppFlowDis");
            if (!needQuery4InteReport) {
                return 0;
            }
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            if (datastatConditionForm.getDeviceId() > 0L) {
                allCollectorRequestForm = this.getSingleDeviceData(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect4DnsAnalysis(datastatConditionForm, currentLogUserId);
                Map<Long, List<AticDevice>> collectDevMap = null;
                collectDevMap = ReportAnalysisUtil.getCollectDevMap(firewallList);
                allCollectorRequestForm = this.getAllCollectorIpTopNForm(collectDevMap, datastatConditionForm);
            }
            if (-2L == datastatConditionForm.getDeviceId()) {
                requestTrendFormList = this.getAllDetectTopNForm(allCollectorRequestForm);
            } else {
                ArrayList<AppFlowForm> allForm = new ArrayList<AppFlowForm>();
                for (Map.Entry<String, List<AppFlowForm>> entry : allCollectorRequestForm.entrySet()) {
                    allForm.addAll((Collection<AppFlowForm>)entry.getValue());
                }
                requestTrendFormList = this.getTopNForm(allForm, 1);
            }
            requestTrendFormList = this.getAllTimeData(requestTrendFormList, datastatConditionForm.getStartTime(), datastatConditionForm.getEndTime());
            this.getRequestTrendFormData(requestTrendFormList);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"AppFlowChartDataSet prepareData() unknow exception", (Throwable)e);
        }
        this.logger.info((Object)"AppFlowChartDataSet end prepareData()");
        return 0;
    }

    private void getRequestTrendFormData(List<AppFlowForm> requestTrendFormList) {
        for (int i = 0; i < requestTrendFormList.size(); ++i) {
            AppFlow data = new AppFlow();
            data.setDateTime(requestTrendFormList.get(i).getDateTime() * 1000L);
            data.setAppValue(requestTrendFormList.get(i).getAppValue());
            data.setAppName(requestTrendFormList.get(i).getAppName());
            this.dataList.add(data);
        }
    }

    private Map<String, List<AppFlowForm>> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewallId = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        HashMap<String, List<AppFlowForm>> allCollectorRequestForm = new HashMap();
        try {
            allCollectorRequestForm = this.dataStatService.getAppFlowDis(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return allCollectorRequestForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        String zoneId = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        if (!"0".equals(zoneId)) {
            datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        } else {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        String zoneIp = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip");
        zoneIp = String.valueOf(jsonValueItem.get(0).getValue());
        if (!AticUtil.isNull((String)zoneIp)) {
            datastatConditionForm.setZoneIp(zoneIp);
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        String isBPSStr = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isBPS").get(0).getValue());
        if (!AticUtil.isNull((String)isBPSStr) && isBPSStr.equalsIgnoreCase("true")) {
            this.isBPS = true;
        }
        if (this.isBPS) {
            datastatConditionForm.setAttackType(1);
        } else {
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type");
            String type = String.valueOf(jsonValueItem.get(0).getValue());
            datastatConditionForm.setAttackType(Integer.parseInt(type));
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type_combobox");
        String statType = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setAppType(Integer.parseInt(statType));
        String isInteReport = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
        if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true")) {
            if (datastatConditionForm.getDeviceId() > 0L && datastatConditionForm.getZoneId() > 0L) {
                datastatConditionForm.setAppType(1);
            } else {
                datastatConditionForm.setAppType(2);
            }
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit");
        String unit = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setUnit(Integer.parseInt(unit));
        List<BizTypePoJo> bizType = this.getBizType(datastatConditionForm);
        datastatConditionForm.setBizTypeList4App(bizType);
    }

    private List<BizTypePoJo> getBizType(DataStatConditionForm datastatConditionForm) {
        BizTypePoJo tempBiz;
        DataSourceStub dataSourceStub = new DataSourceStub();
        List<Pair<String, String>> temp = dataSourceStub.getBisListForApp();
        List bizList = ReportBisUtil.getZoneMgrNorthSerice().getBizByZoneId(datastatConditionForm.getZoneId(), datastatConditionForm.getDeviceId());
        ArrayList<BizTypePoJo> returnList = new ArrayList<BizTypePoJo>();
        for (Pair<String, String> item : temp) {
            tempBiz = new BizTypePoJo();
            tempBiz.setBizId(Long.parseLong((String)item.getKey()));
            tempBiz.setBizName((String)item.getValue());
            tempBiz.setBizType((String)item.getValue());
            returnList.add(tempBiz);
        }
        for (ZoneServiceForm tempItem : bizList) {
            tempBiz = new BizTypePoJo();
            tempBiz.setBizId(tempItem.getPkid());
            tempBiz.setBizName(tempItem.getServiceName());
            tempBiz.setBizType(tempItem.getProtocol());
            returnList.add(tempBiz);
        }
        return returnList;
    }

    private List<AppFlowForm> getAllDetectTopNForm(Map<String, List<AppFlowForm>> inputMap) {
        List<AppFlowForm> distinctForm = new ArrayList<AppFlowForm>();
        List listDefendGroupForm = ReportBisUtil.getDefendGroupService().getAll();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        for (DefendGroupForm defendGroupForm : listDefendGroupForm) {
            String[] devIds;
            ArrayList<AppFlowForm> listForm = new ArrayList<AppFlowForm>();
            if (null == defendGroupForm.getDevices() || "".equals(defendGroupForm.getDevices())) continue;
            for (String devId : devIds = defendGroupForm.getDevices().split(",")) {
                AticDevice firewall = firewallService.getDeviceByMoid(Long.parseLong(devId));
                if (null == firewall) continue;
                String devIp = firewall.getIpAddress();
                if (!inputMap.containsKey(devIp = AticUtil.formatIpAddress((String)devIp))) continue;
                listForm.addAll((Collection<AppFlowForm>)inputMap.get(devIp));
                inputMap.remove(devIp);
            }
            if (listForm.isEmpty()) continue;
            distinctForm.addAll(this.getTopNForm(listForm, defendGroupForm.getDetectMode()));
        }
        for (Map.Entry entry : inputMap.entrySet()) {
            distinctForm.addAll((Collection)entry.getValue());
        }
        distinctForm = this.getTopNForm(distinctForm, 1);
        return distinctForm;
    }

    private List<AppFlowForm> getAllTimeData(List<AppFlowForm> requestTrendFormList, long startTime, long endTime) {
        startTime = ReportAnalysisUtil.getRealStartTime(startTime, endTime);
        long timeSlot = this.getTimeSlot(startTime, endTime);
        ArrayList<String> dnsNameList = new ArrayList<String>();
        Long minTime = 0L;
        Long maxTime = 0L;
        for (int i = 0; i < requestTrendFormList.size(); ++i) {
            AppFlowForm form = requestTrendFormList.get(i);
            if (i == 0) {
                minTime = form.getDateTime();
                maxTime = form.getDateTime();
            } else {
                if (form.getDateTime() < minTime) {
                    minTime = form.getDateTime();
                }
                if (form.getDateTime() > maxTime) {
                    maxTime = form.getDateTime();
                }
            }
            this.getDnsNameList(form, dnsNameList);
        }
        HashMap<Long, List<AppFlowForm>> map = new HashMap<Long, List<AppFlowForm>>();
        while (minTime <= maxTime) {
            ArrayList<AppFlowForm> tmpList = new ArrayList<AppFlowForm>();
            for (AppFlowForm form : requestTrendFormList) {
                if (!form.getDateTime().equals(minTime)) continue;
                tmpList.add(form);
            }
            map.put(minTime, tmpList);
            minTime = minTime + timeSlot;
        }
        this.getRequestTrendFormList(map, dnsNameList, requestTrendFormList);
        return requestTrendFormList;
    }

    private void getRequestTrendFormList(Map<Long, List<AppFlowForm>> map, List<String> dnsNameList, List<AppFlowForm> requestTrendFormList) {
        for (Map.Entry<Long, List<AppFlowForm>> entry : map.entrySet()) {
            for (int i = 0; i < dnsNameList.size(); ++i) {
                boolean hasData = false;
                for (AppFlowForm form : entry.getValue()) {
                    if (!form.getAppName().equals(dnsNameList.get(i))) continue;
                    hasData = true;
                    break;
                }
                if (hasData) continue;
                AppFlowForm form = new AppFlowForm();
                form.setDateTime(entry.getKey());
                form.setAppValue(0L);
                form.setAppName(dnsNameList.get(i));
                requestTrendFormList.add(form);
            }
        }
    }

    private void getDnsNameList(AppFlowForm form, List<String> dnsNameList) {
        boolean hasData = false;
        for (int j = 0; j < dnsNameList.size(); ++j) {
            if (!form.getAppName().equals(dnsNameList.get(j))) continue;
            hasData = true;
            break;
        }
        if (!hasData) {
            dnsNameList.add(form.getAppName());
        }
    }

    private long getTimeSlot(long startTime, long endTime) {
        long timeSlot = 0L;
        int type = ReportAnalysisUtil.getTimeSpanType(endTime, startTime);
        timeSlot = type == AnalysisConstants.LESS_THAN_SEVEN_DAYS ? NUM_THREE_THOUSAND_SIX_HUNDRED : (type == AnalysisConstants.MORE_THAN_SEVEN_DAYS ? 24L * NUM_THREE_THOUSAND_SIX_HUNDRED : NUM_THREE_HUNDRED);
        return timeSlot;
    }

    private Map<String, List<AppFlowForm>> getAllCollectorIpTopNForm(Map<Long, List<AticDevice>> collectDevMap, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<AppFlowForm>> allCollectorRequestTrendForm = new HashMap<String, List<AppFlowForm>>();
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
            String collectorIp = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue()).getIpAddress();
            Long deviceIdTemp = datastatConditionForm.getDeviceId();
            datastatConditionForm.setDeviceIpList(new ArrayList<String>());
            HashMap<String, List<BizTypePoJo>> bizTypeMap4AppDevice = new HashMap<String, List<BizTypePoJo>>();
            for (AticDevice firewall : entry.getValue()) {
                if (null == datastatConditionForm.getDeviceIpList()) {
                    datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                }
                datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
                List<BizTypePoJo> bizType = null;
                datastatConditionForm.setDeviceId(firewall.getMoId());
                bizType = this.getBizType(datastatConditionForm);
                bizTypeMap4AppDevice.put(firewall.getIpAddress(), bizType);
            }
            datastatConditionForm.setDeviceId(deviceIdTemp);
            datastatConditionForm.setBizTypeMap4AppDevice(bizTypeMap4AppDevice);
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            Map<Object, Object> tempMap = new HashMap();
            try {
                tempMap = this.dataStatService.getAppFlowDis(datastatConditionForm, collectorIp);
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey()), (Throwable)e);
            }
            allCollectorRequestTrendForm.putAll(tempMap);
        }
        return allCollectorRequestTrendForm;
    }

    private List<AppFlowForm> getTopNForm(List<AppFlowForm> allForm, int netMode) {
        for (int i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (!allForm.get(i).getDateTime().equals(allForm.get(j).getDateTime()) || !allForm.get(i).getAppName().equals(allForm.get(j).getAppName())) continue;
                this.dealWithSame(allForm, netMode, i, j);
            }
        }
        return allForm;
    }

    private void dealWithSame(List<AppFlowForm> allForm, int netMode, int i, int j) {
        if (netMode == 0) {
            if (allForm.get(i).getAppValue() > allForm.get(j).getAppValue()) {
                allForm.get(i).setAppValue(allForm.get(i).getAppValue());
            } else {
                allForm.get(i).setAppValue(allForm.get(j).getAppValue());
            }
            allForm.remove(j);
        } else if (netMode == 1) {
            allForm.get(i).setAppValue(allForm.get(i).getAppValue() + allForm.get(j).getAppValue());
            allForm.remove(j);
        }
    }

    public void setBPS(boolean isBPSBool) {
        this.isBPS = isBPSBool;
    }
}

