/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.flux.conncompare;

import com.hs.atic.analysis.report.flux.conncompare.ConnCompare;
import com.hs.atic.analysis.report.flux.conncompare.TransmitConnCompareData;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class ConnCompareTableDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<ConnCompare> dataList = new ArrayList<ConnCompare>();

    public List<ConnCompare> sortListByField(List<ConnCompare> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<ConnCompare> orderedList = null;
        if (null != sortList) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<ConnCompare> list = new ArrayList<ConnCompare>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"begin prepareData !");
        try {
            List<ConnCompare> connTableData = TransmitConnCompareData.getInstance().getConnDataList(sessionId);
            TransmitConnCompareData.getInstance().removeConnData(sessionId);
            if (null == connTableData) {
                this.logger.info((Object)"getConnCompareData is null !");
            } else {
                for (ConnCompare connCompare : connTableData) {
                    if (connCompare.getIncreaseConn() <= 0L && connCompare.getCurrentConn() <= 0L) continue;
                    this.dataList.add(connCompare);
                }
            }
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"ConnCompareTableDataSet prepareData happened exception !", (Throwable)e);
        }
        return 0;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }
}

