/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.flux.flowcompare;

import com.hs.atic.analysis.report.flux.flowcompare.FlowCompareComparator;
import com.hs.atic.analysis.report.flux.flowcompare.FlowCompareView;
import com.hs.atic.analysis.report.flux.flowcompare.TransmitFlowCompareOutBoundData;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.sdk.analysis.form.FlowCompareForm;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FlowCompareTableOutBoundDataSet
extends IJavaDataSource {
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<FlowCompareForm> cacheForTable = new ArrayList<FlowCompareForm>();
    private int avgOrMax;

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        this.log.info((Object)"start fetchData");
        ArrayList<FlowCompareView> resultList = new ArrayList<FlowCompareView>();
        try {
            this.getFlowCompareTableData(sessionId);
            ArrayList<FlowCompareForm> result = new ArrayList<FlowCompareForm>();
            this.processOrder(sortList);
            this.processPaging(pageIndex, pageSize, result);
            for (FlowCompareForm flowCompareForm : result) {
                resultList.add((FlowCompareView)ReportAnalysisUtil.copyProperties(flowCompareForm, new FlowCompareView()));
            }
        }
        catch (LegoCheckedException legoException) {
            resultList.clear();
            this.log.error((Object)("FlowCompareTableDataSet fetchData() LegoCheckedException :" + legoException.getErrorCode()));
        }
        catch (Exception e) {
            resultList.clear();
            this.log.error((Object)"FlowCompareTableDataSet fetchData() unknow exception", (Throwable)e);
        }
        this.log.info((Object)"end fetchData");
        return resultList;
    }

    private void getFlowCompareTableData(long sessionId) {
        List<FlowCompareForm> tableData = TransmitFlowCompareOutBoundData.getInstance().getDataList(sessionId);
        TransmitFlowCompareOutBoundData.getInstance().removeData(sessionId);
        if (null != tableData) {
            for (FlowCompareForm flowCompareForm : tableData) {
                if (2 == this.avgOrMax && (flowCompareForm.getInFlow() > 0L || null != flowCompareForm.getReplyInFlow() && flowCompareForm.getReplyInFlow() > 0L)) {
                    this.cacheForTable.add(flowCompareForm);
                }
                if (1 != this.avgOrMax || flowCompareForm.getMaxInFlow() <= 0L) continue;
                this.cacheForTable.add(flowCompareForm);
            }
        }
    }

    public long getAllCount(String s, long l) {
        return this.cacheForTable.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        List<JsonValueItem> jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type_combobox");
        this.avgOrMax = Integer.parseInt(jsonValueItemList.get(0).getValue());
        return 0;
    }

    private void processPaging(long pageIndex, long pageSize, List<FlowCompareForm> resultList) {
        if (pageIndex != 0L && pageSize != 0L) {
            int startIndex = (int)((pageIndex - 1L) * pageSize);
            if ((long)this.cacheForTable.size() >= (long)startIndex + pageSize) {
                resultList.addAll(this.cacheForTable.subList(startIndex, startIndex + (int)pageSize));
            } else {
                resultList.addAll(this.cacheForTable.subList(startIndex, this.cacheForTable.size()));
            }
        }
        if (pageIndex == 0L && pageSize == 0L) {
            resultList.addAll(this.cacheForTable);
        }
    }

    private void processOrder(OrderInfo sortList) {
        if (null != sortList) {
            Collections.sort(this.cacheForTable, FlowCompareComparator.getComparatorByFieldName(sortList.getOrderField(), sortList.getOrderType()));
        }
    }
}

