/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.flux.flowcompare;

import com.hs.atic.analysis.report.flux.flowcompare.FlowCompareComparator;
import com.hs.atic.analysis.report.flux.flowcompare.TransmitFlowCompareDataPPS4Integration;
import com.hs.atic.analysis.report.integration.AvgAndMaxView;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.FlowCompareForm;
import com.hs.atic.util.AticUtil;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FlowCompareTablePPS4Integration
extends IJavaDataSource {
    private List<AvgAndMaxView> resultList = new ArrayList<AvgAndMaxView>();
    private Long timeSpan = 1L;
    private int deviceType;

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        List<FlowCompareForm> tableData = TransmitFlowCompareDataPPS4Integration.getInstance().getDataList(sessionId);
        TransmitFlowCompareDataPPS4Integration.getInstance().removeData(sessionId);
        if (null != tableData) {
            this.resultList = this.processAvgAndMaxData4Table(tableData);
        }
        return this.resultList;
    }

    private List<AvgAndMaxView> processAvgAndMaxData4Table(List<FlowCompareForm> tableData) {
        AvgAndMaxView inFlow;
        ArrayList<AvgAndMaxView> resultLists = new ArrayList<AvgAndMaxView>();
        if (null == tableData || tableData.isEmpty()) {
            return resultLists;
        }
        Long timeNum = this.getTimeNum(tableData);
        Long totalInFlow = tableData.get(0).getInFlow();
        Long maxInFlow = tableData.get(0).getInFlow();
        Long maxInFlowTime = tableData.get(0).getLogTime();
        Long totalDropFlow = tableData.get(0).getAttackFlow();
        Long maxDropFlow = tableData.get(0).getAttackFlow();
        Long maxDropFlowTime = tableData.get(0).getLogTime();
        Long totalOutFlow = tableData.get(0).getOutFlow();
        Long maxOutFlow = tableData.get(0).getOutFlow();
        Long maxOutFlowTime = tableData.get(0).getLogTime();
        int i = 0;
        for (FlowCompareForm form : tableData) {
            if (i > 0) {
                totalInFlow = totalInFlow + form.getInFlow();
                maxInFlowTime = maxInFlow < form.getInFlow() ? Long.valueOf(form.getLogTime()) : maxInFlowTime;
                maxInFlow = maxInFlow < form.getInFlow() ? form.getInFlow() : maxInFlow;
                totalDropFlow = totalDropFlow + form.getAttackFlow();
                maxDropFlowTime = maxDropFlow < form.getAttackFlow() ? Long.valueOf(form.getLogTime()) : maxDropFlowTime;
                maxDropFlow = maxDropFlow < form.getAttackFlow() ? form.getAttackFlow() : maxDropFlow;
                totalOutFlow = totalOutFlow + form.getOutFlow();
                maxOutFlowTime = maxOutFlow < form.getOutFlow() ? Long.valueOf(form.getLogTime()) : maxOutFlowTime;
                maxOutFlow = maxOutFlow < form.getOutFlow() ? form.getOutFlow() : maxOutFlow;
            }
            ++i;
        }
        if (this.deviceType == 1) {
            inFlow = new AvgAndMaxView();
            inFlow.setNameColor(ReportAnalysisUtil.getFontColor("77,130,249"));
            inFlow.setName(AticUtil.getText((String)"atic.analysis.common.flux.detect"));
            inFlow.setAvgValue(totalInFlow / timeNum);
            inFlow.setMaxValue(maxInFlow);
            inFlow.setLogTime(maxInFlowTime);
            resultLists.add(inFlow);
        } else {
            inFlow = new AvgAndMaxView();
            inFlow.setNameColor(ReportAnalysisUtil.getFontColor("77,130,249"));
            inFlow.setName(AticUtil.getText((String)"atic.analysis.common.flux.in"));
            inFlow.setAvgValue(totalInFlow / timeNum);
            inFlow.setMaxValue(maxInFlow);
            inFlow.setLogTime(maxInFlowTime);
            resultLists.add(inFlow);
            AvgAndMaxView dropFlow = new AvgAndMaxView();
            dropFlow.setNameColor(ReportAnalysisUtil.getFontColor("209,78,57"));
            dropFlow.setName(AticUtil.getText((String)"atic.analysis.common.flux.attack"));
            dropFlow.setAvgValue(totalDropFlow / timeNum);
            dropFlow.setMaxValue(maxDropFlow);
            dropFlow.setLogTime(maxDropFlowTime);
            resultLists.add(dropFlow);
            AvgAndMaxView outFlow = new AvgAndMaxView();
            outFlow.setNameColor(ReportAnalysisUtil.getFontColor("94,237,79"));
            outFlow.setName(AticUtil.getText((String)"atic.analysis.common.flux.out"));
            outFlow.setAvgValue(totalOutFlow / timeNum);
            outFlow.setMaxValue(maxOutFlow);
            outFlow.setLogTime(maxOutFlowTime);
            resultLists.add(outFlow);
        }
        return resultLists;
    }

    private Long getTimeNum(List<FlowCompareForm> tableData) {
        if (null == tableData || tableData.isEmpty()) {
            return 1L;
        }
        Collections.sort(tableData, FlowCompareComparator.getComparatorByFieldName("logTime", "desc"));
        Long endTime = tableData.get(0).getLogTime();
        Long startTime = tableData.get(tableData.size() - 1).getLogTime();
        Long returnTimeNum = 1L;
        returnTimeNum = this.timeSpan.equals(2L) ? Long.valueOf((endTime - startTime) / 3600000L + 1L) : (this.timeSpan.equals(3L) ? Long.valueOf((endTime - startTime) / 86400000L + 1L) : Long.valueOf((endTime - startTime) / 300000L + 1L));
        return returnTimeNum;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return 0L;
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        Map<String, List<String>> timeSpanMap = ReportAnalysisUtil.getPrepareParasMap(queryCond);
        String timeSpanStr = timeSpanMap.get("timeLevel").get(0);
        this.timeSpan = Long.parseLong(timeSpanStr);
        List<JsonValueItem> jsonValueItem = null;
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        this.deviceType = datastatConditionForm.getDevSerType();
        return 0;
    }

    public boolean splitTask(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return true;
    }
}

