/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.flux.fluxdistribute;

import com.hs.atic.analysis.report.flux.fluxdistribute.FluxDisComparator;
import com.hs.atic.analysis.report.flux.fluxdistribute.FluxDistribute;
import com.hs.atic.analysis.report.flux.fluxdistribute.TransmitFluxDistributeData;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.FlowDistributeForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class InFluxDistributeDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<FluxDistribute> dataList = new ArrayList<FluxDistribute>();
    private IDataStatService dataStatService;

    public List<FluxDistribute> sortListByField(List<FluxDistribute> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<FluxDistribute> orderedList = null;
        orderedList = null != sortList ? this.sortListByField(this.dataList, sortList.getOrderField(), sortList.getOrderType()) : this.dataList;
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<FluxDistribute> list = new ArrayList<FluxDistribute>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        try {
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!this.isQueryDevice(datastatConditionForm).booleanValue() && null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            List<FlowDistributeForm> flowDistributeFormList = null;
            if (datastatConditionForm.getDeviceId() > 0L) {
                flowDistributeFormList = this.getSingleDeviceInFlowDis(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                flowDistributeFormList = this.getMultiDeviceInFlowDis(currentLogUserId, datastatConditionForm);
            }
            this.dataList = this.getFluxDisList(flowDistributeFormList);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            TransmitFluxDistributeData.getInstance().removeInFluxData(sessionId);
            this.logger.error((Object)"InFluxDistributeDataSet prepareData happened exception !", (Throwable)e);
        }
        return 0;
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getLogoAndNameMap(queryCond);
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        String zoneIp;
        List<JsonValueItem> jsonValueItemList = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "switchOption");
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItemList.get(0).getValue());
        if (AticUtil.isNull((String)direction) || !direction.matches("^(0|1|2)$")) {
            datastatConditionForm.setDirection(1);
        } else {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItemList.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        String zoneId = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        zoneId = String.valueOf(jsonValueItemList.get(0).getValue());
        if (!"0".equals(zoneId)) {
            datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        }
        if (!AticUtil.isNull((String)(zoneIp = String.valueOf((jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip")).get(0).getValue())))) {
            datastatConditionForm.setZoneIp(zoneIp);
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit");
        String unit = String.valueOf(jsonValueItemList.get(0).getValue());
        datastatConditionForm.setUnit(Integer.parseInt(unit));
        datastatConditionForm.setIsClean(1);
        Boolean isQueryDevice = this.isQueryDevice(datastatConditionForm);
        if (!isQueryDevice.booleanValue() && null == datastatConditionForm.getZoneId()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
    }

    private Boolean isQueryDevice(DataStatConditionForm datastatConditionForm) {
        Boolean isQueryDevice = false;
        if (null == datastatConditionForm.getZoneId() && null == datastatConditionForm.getZoneIp()) {
            isQueryDevice = true;
        }
        return isQueryDevice;
    }

    private List<FlowDistributeForm> getSingleDeviceInFlowDis(DataStatConditionForm datastatConditionForm) {
        List<FlowDistributeForm> formList = new ArrayList<FlowDistributeForm>();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            return formList;
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            formList = this.dataStatService.getFlowDis(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return formList;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<FlowDistributeForm> getMultiDeviceInFlowDis(Long currentLogUserId, DataStatConditionForm datastatConditionForm) {
        List<FlowDistributeForm> formList = null;
        List<AticDevice> firewallList = null;
        firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
        Map<Long, List<AticDevice>> collectDevMap = ReportAnalysisUtil.getCollectDevMap(firewallList);
        formList = -2L == datastatConditionForm.getDeviceId() ? this.getAllDetectFlowDis(collectDevMap, datastatConditionForm) : this.getAllCleanFlowDis(collectDevMap, datastatConditionForm);
        return formList;
    }

    private List<FlowDistributeForm> getAllCleanFlowDis(Map<Long, List<AticDevice>> collectDevMap, DataStatConditionForm datastatConditionForm) {
        ArrayList<FlowDistributeForm> formList = new ArrayList<FlowDistributeForm>();
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
            CollectorInfo collector = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue());
            if (null == collector) continue;
            ArrayList<String> deviceIpList = new ArrayList<String>();
            for (AticDevice firewall : entry.getValue()) {
                deviceIpList.add(firewall.getIpAddress());
            }
            datastatConditionForm.setDeviceIpList(deviceIpList);
            List<Object> tempFormList = new ArrayList();
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            try {
                tempFormList = this.dataStatService.getFlowDis(datastatConditionForm, collector.getIpAddress());
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey()), (Throwable)e);
            }
            if (null == tempFormList) continue;
            formList.addAll(tempFormList);
        }
        return formList;
    }

    private List<FlowDistributeForm> getAllDetectFlowDis(Map<Long, List<AticDevice>> collectDevMap, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<FlowDistributeForm>> flowDisFormMap = new HashMap<String, List<FlowDistributeForm>>();
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
            CollectorInfo collector = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue());
            if (null == collector) continue;
            ArrayList<String> deviceIpList = new ArrayList<String>();
            for (AticDevice firewall : entry.getValue()) {
                deviceIpList.add(firewall.getIpAddress());
            }
            datastatConditionForm.setDeviceIpList(deviceIpList);
            Map<Object, Object> tempFormMap = new HashMap();
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            try {
                tempFormMap = this.dataStatService.getAllDetectFlowDis(datastatConditionForm, collector.getIpAddress());
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey()), (Throwable)e);
            }
            if (null == tempFormMap) continue;
            flowDisFormMap.putAll(tempFormMap);
        }
        List<FlowDistributeForm> formList = new ArrayList<FlowDistributeForm>();
        if (!flowDisFormMap.isEmpty()) {
            formList = this.getAllDetectFormList(flowDisFormMap, datastatConditionForm.getStartTime(), datastatConditionForm.getEndTime());
        }
        return formList;
    }

    private List<FlowDistributeForm> getAllDetectFormList(Map<String, List<FlowDistributeForm>> flowDisFormMap, Long start, Long end) {
        ArrayList<FlowDistributeForm> distinctFormList = new ArrayList<FlowDistributeForm>();
        List listDefendGroupForm = ReportBisUtil.getDefendGroupService().getAll();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        for (DefendGroupForm defendGroupForm : listDefendGroupForm) {
            String[] devIds;
            ArrayList<FlowDistributeForm> listForm = new ArrayList<FlowDistributeForm>();
            if (null == defendGroupForm.getDevices() || "".equals(defendGroupForm.getDevices())) continue;
            for (String devId : devIds = defendGroupForm.getDevices().split(",")) {
                AticDevice firewall = firewallService.getDeviceByMoid(Long.parseLong(devId));
                if (null == firewall) continue;
                String devIp = firewall.getIpAddress();
                if (!flowDisFormMap.containsKey(devIp = AticUtil.formatIpAddress((String)devIp))) continue;
                listForm.addAll((Collection<FlowDistributeForm>)flowDisFormMap.get(devIp));
                flowDisFormMap.remove(devIp);
            }
            if (listForm.isEmpty()) continue;
            List<FlowDistributeForm> formList = this.getDistinctForm(listForm, defendGroupForm.getDetectMode());
            distinctFormList.addAll(this.getFlowForm(formList, start, end));
        }
        for (Map.Entry entry : flowDisFormMap.entrySet()) {
            distinctFormList.addAll(this.getFlowForm((List)entry.getValue(), start, end));
        }
        return distinctFormList;
    }

    private List<FlowDistributeForm> getFlowForm(List<FlowDistributeForm> formList, Long start, Long end) {
        double tcpFlow = 0.0;
        double udpFlow = 0.0;
        double icmpFlow = 0.0;
        double otherFlow = 0.0;
        for (FlowDistributeForm tempForm : formList) {
            tcpFlow += (double)tempForm.getTcpFlow().longValue();
            udpFlow += (double)tempForm.getUdpFlow().longValue();
            icmpFlow += (double)tempForm.getIcmpFlow().longValue();
            otherFlow += (double)tempForm.getOtherFlow().longValue();
        }
        FlowDistributeForm tcpFlowForm = new FlowDistributeForm();
        FlowDistributeForm udpFlowForm = new FlowDistributeForm();
        FlowDistributeForm icmpFlowForm = new FlowDistributeForm();
        FlowDistributeForm otherFlowForm = new FlowDistributeForm();
        ArrayList<FlowDistributeForm> flowFormList = new ArrayList<FlowDistributeForm>();
        int gra = ReportAnalysisUtil.getGra(start, end);
        tcpFlowForm.setProtocol(1);
        tcpFlowForm.setFlow(tcpFlow / (double)gra);
        flowFormList.add(tcpFlowForm);
        udpFlowForm.setProtocol(2);
        udpFlowForm.setFlow(udpFlow / (double)gra);
        flowFormList.add(udpFlowForm);
        icmpFlowForm.setProtocol(3);
        icmpFlowForm.setFlow(icmpFlow / (double)gra);
        flowFormList.add(icmpFlowForm);
        otherFlowForm.setProtocol(4);
        otherFlowForm.setFlow(otherFlow / (double)gra);
        flowFormList.add(otherFlowForm);
        return flowFormList;
    }

    private List<FlowDistributeForm> getDistinctForm(List<FlowDistributeForm> listForm, int detectMode) {
        if (detectMode == 0) {
            return this.processRedunData(listForm);
        }
        if (detectMode == 1) {
            return this.processBalanData(listForm);
        }
        return new ArrayList<FlowDistributeForm>();
    }

    private List<FlowDistributeForm> processBalanData(List<FlowDistributeForm> listForm) {
        ArrayList<FlowDistributeForm> result = new ArrayList<FlowDistributeForm>();
        Collections.sort(listForm, new FluxDisComparator("logTime"));
        ListIterator<FlowDistributeForm> iter = listForm.listIterator();
        int endIndex = 0;
        block0: while (iter.hasNext()) {
            FlowDistributeForm tempForm = new FlowDistributeForm();
            FlowDistributeForm first = iter.next();
            int startIndex = endIndex;
            if (!iter.hasNext()) {
                result.add(first);
            }
            while (iter.hasNext()) {
                boolean isEqual = iter.next().getLogTime().equals(first.getLogTime());
                if (isEqual) {
                    ++endIndex;
                    if (iter.hasNext()) continue;
                }
                List<FlowDistributeForm> subList = listForm.subList(startIndex, endIndex + 1);
                long tcpFlow = 0L;
                long udpFlow = 0L;
                long icmpFlow = 0L;
                long otherFlow = 0L;
                for (FlowDistributeForm form : subList) {
                    tcpFlow += form.getTcpFlow().longValue();
                    udpFlow += form.getUdpFlow().longValue();
                    icmpFlow += form.getIcmpFlow().longValue();
                    otherFlow += form.getOtherFlow().longValue();
                }
                tempForm.setLogTime(subList.get(0).getLogTime());
                tempForm.setTcpFlow(tcpFlow);
                tempForm.setUdpFlow(udpFlow);
                tempForm.setIcmpFlow(icmpFlow);
                tempForm.setOtherFlow(otherFlow);
                result.add(tempForm);
                if (isEqual) continue block0;
                ++endIndex;
                iter = listForm.listIterator(iter.previousIndex());
                continue block0;
            }
        }
        return result;
    }

    private List<FlowDistributeForm> processRedunData(List<FlowDistributeForm> listForm) {
        ArrayList<FlowDistributeForm> result = new ArrayList<FlowDistributeForm>();
        Collections.sort(listForm, new FluxDisComparator("logTime"));
        ListIterator<FlowDistributeForm> iter = listForm.listIterator();
        int endIndex = 0;
        block0: while (iter.hasNext()) {
            FlowDistributeForm tempForm = new FlowDistributeForm();
            FlowDistributeForm first = iter.next();
            int startIndex = endIndex;
            if (!iter.hasNext()) {
                result.add(first);
            }
            while (iter.hasNext()) {
                boolean isEqual = iter.next().getLogTime().equals(first.getLogTime());
                if (isEqual) {
                    ++endIndex;
                    if (iter.hasNext()) continue;
                }
                List<FlowDistributeForm> subList = listForm.subList(startIndex, endIndex + 1);
                tempForm.setLogTime(subList.get(0).getLogTime());
                Collections.sort(subList, new FluxDisComparator("tcpFlow"));
                tempForm.setTcpFlow(subList.get(0).getTcpFlow());
                Collections.sort(subList, new FluxDisComparator("udpFlow"));
                tempForm.setUdpFlow(subList.get(0).getUdpFlow());
                Collections.sort(subList, new FluxDisComparator("icmpFlow"));
                tempForm.setIcmpFlow(subList.get(0).getIcmpFlow());
                Collections.sort(subList, new FluxDisComparator("otherFlow"));
                tempForm.setOtherFlow(subList.get(0).getOtherFlow());
                result.add(tempForm);
                if (isEqual) continue block0;
                ++endIndex;
                iter = listForm.listIterator(iter.previousIndex());
                continue block0;
            }
        }
        return result;
    }

    private List<FluxDistribute> getFluxDisList(List<FlowDistributeForm> flowDisFormList) {
        ArrayList<FluxDistribute> fluxDisList = new ArrayList<FluxDistribute>();
        if (null == flowDisFormList || flowDisFormList.isEmpty()) {
            return fluxDisList;
        }
        for (FlowDistributeForm flowForm : flowDisFormList) {
            FluxDistribute tcp = new FluxDistribute();
            FluxDistribute udp = new FluxDistribute();
            FluxDistribute icmp = new FluxDistribute();
            FluxDistribute other = new FluxDistribute();
            Integer protocol = flowForm.getProtocol();
            switch (protocol) {
                case 1: {
                    tcp.setProtocolType("TCP");
                    tcp.setFlow((long)flowForm.getFlow());
                    tcp.setLogTime(flowForm.getLogTime());
                    fluxDisList.add(tcp);
                    break;
                }
                case 2: {
                    udp.setProtocolType("UDP");
                    udp.setFlow((long)flowForm.getFlow());
                    udp.setLogTime(flowForm.getLogTime());
                    fluxDisList.add(udp);
                    break;
                }
                case 3: {
                    icmp.setProtocolType("ICMP");
                    icmp.setFlow((long)flowForm.getFlow());
                    icmp.setLogTime(flowForm.getLogTime());
                    fluxDisList.add(icmp);
                    break;
                }
                case 4: {
                    other.setProtocolType("OTHER");
                    other.setFlow((long)flowForm.getFlow());
                    other.setLogTime(flowForm.getLogTime());
                    fluxDisList.add(other);
                    break;
                }
            }
        }
        return fluxDisList;
    }
}

