/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.flux.fluxdistribute;

import com.hs.atic.analysis.report.flux.fluxdistribute.FluxDistribute;
import com.hs.atic.analysis.report.flux.fluxdistribute.TransmitFluxDistributeData;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.FlowDistributeForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class OutFluxDistributeDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<FluxDistribute> dataList = new ArrayList<FluxDistribute>();
    private IDataStatService dataStatService;

    public List<FluxDistribute> sortListByField(List<FluxDistribute> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<FluxDistribute> orderedList = null;
        orderedList = null != sortList ? this.sortListByField(this.dataList, sortList.getOrderField(), sortList.getOrderType()) : this.dataList;
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<FluxDistribute> list = new ArrayList<FluxDistribute>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    private Boolean isQueryDevice(DataStatConditionForm datastatConditionForm) {
        Boolean isQueryDevice = false;
        if (null == datastatConditionForm.getZoneId() && null == datastatConditionForm.getZoneIp()) {
            isQueryDevice = true;
        }
        return isQueryDevice;
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        try {
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!this.isQueryDevice(datastatConditionForm).booleanValue() && null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            List<FlowDistributeForm> flowDistributeFormList = null;
            if (datastatConditionForm.getDeviceId() > 0L) {
                flowDistributeFormList = this.getSingleDeviceOutFlow(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                flowDistributeFormList = this.getMultiDeviceOutFlow(currentLogUserId, datastatConditionForm);
            }
            this.dataList = this.getFluxDisList(flowDistributeFormList);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            TransmitFluxDistributeData.getInstance().removeOutFluxData(sessionId);
            this.logger.error((Object)"OutFluxDistributeDataSet prepareData happened exception !", (Throwable)e);
        }
        return 0;
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getLogoAndNameMap(queryCond);
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        String zoneIp;
        List<JsonValueItem> jsonValueItemList = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "switchOption");
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItemList.get(0).getValue());
        if (AticUtil.isNull((String)direction) || !direction.matches("^[\\d]*$")) {
            datastatConditionForm.setDirection(1);
        } else {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItemList.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        if (1 == datastatConditionForm.getDevSerType()) {
            datastatConditionForm.setIsClean(1);
        } else {
            datastatConditionForm.setIsClean(2);
        }
        String zoneId = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        zoneId = String.valueOf(jsonValueItemList.get(0).getValue());
        if (!"0".equals(zoneId)) {
            datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        }
        if (!AticUtil.isNull((String)(zoneIp = String.valueOf((jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip")).get(0).getValue())))) {
            datastatConditionForm.setZoneIp(zoneIp);
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit");
        String unit = String.valueOf(jsonValueItemList.get(0).getValue());
        datastatConditionForm.setUnit(Integer.parseInt(unit));
        Boolean isQueryDevice = this.isQueryDevice(datastatConditionForm);
        if (!isQueryDevice.booleanValue() && null == datastatConditionForm.getZoneId()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
    }

    private List<FlowDistributeForm> getSingleDeviceOutFlow(DataStatConditionForm datastatConditionForm) {
        List<FlowDistributeForm> outFormList = new ArrayList<FlowDistributeForm>();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            return outFormList;
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            outFormList = this.dataStatService.getFlowDis(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return outFormList;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<FlowDistributeForm> getMultiDeviceOutFlow(Long currentLogUserId, DataStatConditionForm datastatConditionForm) {
        ArrayList<FlowDistributeForm> formList = new ArrayList<FlowDistributeForm>();
        List<AticDevice> firewallList = null;
        firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
        Map<Long, List<AticDevice>> collectDevMap = ReportAnalysisUtil.getCollectDevMap(firewallList);
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
            CollectorInfo collector = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue());
            if (null == collector) continue;
            ArrayList<String> deviceIpList = new ArrayList<String>();
            for (AticDevice firewall : entry.getValue()) {
                deviceIpList.add(firewall.getIpAddress());
            }
            datastatConditionForm.setDeviceIpList(deviceIpList);
            List<Object> tempFormList = new ArrayList();
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            try {
                tempFormList = this.dataStatService.getFlowDis(datastatConditionForm, collector.getIpAddress());
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey()), (Throwable)e);
            }
            formList.addAll(tempFormList);
        }
        return formList;
    }

    private List<FluxDistribute> getFluxDisList(List<FlowDistributeForm> flowDisFormList) {
        ArrayList<FluxDistribute> fluxDisList = new ArrayList<FluxDistribute>();
        if (null == flowDisFormList || flowDisFormList.isEmpty()) {
            return fluxDisList;
        }
        for (FlowDistributeForm flowForm : flowDisFormList) {
            FluxDistribute tcp = new FluxDistribute();
            FluxDistribute udp = new FluxDistribute();
            FluxDistribute icmp = new FluxDistribute();
            FluxDistribute other = new FluxDistribute();
            Integer protocol = flowForm.getProtocol();
            switch (protocol) {
                case 1: {
                    tcp.setProtocolType("TCP");
                    tcp.setFlow((long)flowForm.getFlow());
                    tcp.setLogTime(flowForm.getLogTime());
                    fluxDisList.add(tcp);
                    break;
                }
                case 2: {
                    udp.setProtocolType("UDP");
                    udp.setFlow((long)flowForm.getFlow());
                    udp.setLogTime(flowForm.getLogTime());
                    fluxDisList.add(udp);
                    break;
                }
                case 3: {
                    icmp.setProtocolType("ICMP");
                    icmp.setFlow((long)flowForm.getFlow());
                    icmp.setLogTime(flowForm.getLogTime());
                    fluxDisList.add(icmp);
                    break;
                }
                case 4: {
                    other.setProtocolType("OTHER");
                    other.setFlow((long)flowForm.getFlow());
                    other.setLogTime(flowForm.getLogTime());
                    fluxDisList.add(other);
                    break;
                }
            }
        }
        return fluxDisList;
    }
}

