/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.flux.iplocation;

import com.hs.atic.analysis.report.flux.iplocation.IpLocationTopN;
import com.hs.atic.analysis.report.flux.iplocation.IpLocationTopNStaticData;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.IpLocationTopNForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.opensymphony.xwork2.ActionContext;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class IpLocationTopNTableDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<IpLocationTopN> dataList = new ArrayList<IpLocationTopN>();
    private String statisticalDimension = "0";
    private int success = 0;
    private IDataStatService dataStatService;

    public List<IpLocationTopN> sortListByField(List<IpLocationTopN> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<IpLocationTopNForm> sortListByFieldByFlowValue(List<IpLocationTopNForm> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        if (pageSize > 100L) {
            for (IpLocationTopN ipLocationTopN : this.dataList) {
                ipLocationTopN.setIpLocationName(ipLocationTopN.getIpLocationShortName());
            }
        }
        List<IpLocationTopN> orderedList = null;
        if (null != sortList) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        ArrayList<IpLocationTopN> result = new ArrayList<IpLocationTopN>();
        if (null != orderedList) {
            for (IpLocationTopN ipLocationTopN : orderedList) {
                if (null == ipLocationTopN) continue;
                ipLocationTopN.setIpLocationShortName(null != ipLocationTopN.getIpLocationShortName() && ipLocationTopN.getIpLocationShortName().indexOf("/") == 0 ? ipLocationTopN.getIpLocationShortName().replaceFirst("/", "") : ipLocationTopN.getIpLocationShortName());
                String temp = null != ipLocationTopN.getIpLocationName() && ipLocationTopN.getIpLocationName().indexOf("/> ") != 0 ? ipLocationTopN.getIpLocationName().substring(0, ipLocationTopN.getIpLocationName().indexOf("/> ") + "/> ".length()) + ipLocationTopN.getIpLocationName().substring(ipLocationTopN.getIpLocationName().indexOf("/> ") + "/> ".length(), ipLocationTopN.getIpLocationName().length()).substring(ipLocationTopN.getIpLocationName().substring(ipLocationTopN.getIpLocationName().indexOf("/> ") + "/> ".length(), ipLocationTopN.getIpLocationName().length()).lastIndexOf("/") + 1, ipLocationTopN.getIpLocationName().substring(ipLocationTopN.getIpLocationName().indexOf("/> ") + "/> ".length(), ipLocationTopN.getIpLocationName().length()).length()) : ipLocationTopN.getIpLocationName();
                ipLocationTopN.setIpLocationName(temp);
                result.add(ipLocationTopN);
            }
            orderedList = result;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<IpLocationTopN> list = new ArrayList<IpLocationTopN>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getPrepareParasMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        JsonValueObj temp = (JsonValueObj)queryCond.get("statisticalDimension_combobox");
        this.statisticalDimension = null != temp && null != temp.getValueList() && temp.getValueList().size() > 0 ? ((JsonValueItem)temp.getValueList().get(0)).getValue() : "0";
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        datastatConditionForm.setStatisticalDimension(this.statisticalDimension);
        Map<String, List<IpLocationTopNForm>> allCollectorIpLocationTopNForm = null;
        try {
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return this.success;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return this.success;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return this.success;
            }
            if (datastatConditionForm.getDeviceId() > 0L) {
                allCollectorIpLocationTopNForm = this.getSingleDeviceData(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                allCollectorIpLocationTopNForm = this.getMultiDeviceData(currentLogUserId, datastatConditionForm);
            }
            List<IpLocationTopNForm> dnsTopNFormList = null;
            dnsTopNFormList = -2L == datastatConditionForm.getDeviceId() ? this.getAllDetectTopNForm(allCollectorIpLocationTopNForm, datastatConditionForm.getTopn()) : this.getTopNForm(allCollectorIpLocationTopNForm, datastatConditionForm.getTopn());
            this.processFinalData(dnsTopNFormList);
            IpLocationTopNStaticData.getInstance().addDataList(dnsTopNFormList, sessionId);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            IpLocationTopNStaticData.getInstance().removeData(sessionId);
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            IpLocationTopNStaticData.getInstance().removeData(sessionId);
            this.logger.error((Object)"IpLocationTopNDataSet prepareData() unknow exception", (Throwable)e);
        }
        return this.success;
    }

    private void processFinalData(List<IpLocationTopNForm> dnsTopNFormList) {
        double base = 1.0;
        long totalFlow = 0L;
        for (IpLocationTopNForm ipLocationTopNForm : dnsTopNFormList) {
            totalFlow += ipLocationTopNForm.getFlowValue().longValue();
        }
        HashMap<String, Integer> sameIpNameNum = new HashMap<String, Integer>();
        for (IpLocationTopNForm ipLocationTopNForm : dnsTopNFormList) {
            String locationName = ReportAnalysisUtil.getIpLocationName(ipLocationTopNForm.getIpLocationId());
            ipLocationTopNForm.setIpLocationName(locationName);
            ipLocationTopNForm.setIpLocationShortName(ReportAnalysisUtil.getIpLocationShortName(ipLocationTopNForm.getIpLocationId()));
            ipLocationTopNForm.setPercent(this.formatPercent((double)ipLocationTopNForm.getFlowValue().longValue() * base / (double)totalFlow));
            ipLocationTopNForm.setPercentStr(ipLocationTopNForm.getPercent() + "%");
            if (sameIpNameNum.containsKey(locationName)) {
                int newNum = (Integer)sameIpNameNum.get(locationName) + 1;
                sameIpNameNum.put(locationName, newNum);
                continue;
            }
            sameIpNameNum.put(locationName, 1);
        }
        Set set = sameIpNameNum.entrySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Integer num = (Integer)entry.getValue();
            if (num > 1) continue;
            iter.remove();
        }
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        String contextPath = "";
        if (null != request) {
            contextPath = request.getContextPath();
        }
        for (IpLocationTopNForm ipLocationTopNForm : dnsTopNFormList) {
            IpLocationTopN data = new IpLocationTopN();
            data.setFlowValue(ipLocationTopNForm.getFlowValue());
            data.setIpLocationId(ipLocationTopNForm.getIpLocationId());
            data.setIpLocationShortName(ipLocationTopNForm.getIpLocationShortName());
            data.setPercent(ipLocationTopNForm.getPercent());
            data.setPercentStr(ipLocationTopNForm.getPercentStr());
            String key = ipLocationTopNForm.getIpLocationName();
            if (sameIpNameNum.containsKey(key) && (Integer)sameIpNameNum.get(key) > 0) {
                int tempNum = (Integer)sameIpNameNum.get(key);
                data.setIpLocationName(key + "(" + tempNum + ")");
                sameIpNameNum.put(key, tempNum - 1);
            } else {
                data.setIpLocationName(key);
            }
            ipLocationTopNForm.setIpLocationName(data.getIpLocationName());
            data.setIpLocationShortName(data.getIpLocationName());
            String shortName = ipLocationTopNForm.getIpLocationShortName().toLowerCase(Locale.getDefault());
            if (AticUtil.isNull((String)shortName)) {
                shortName = "location";
            }
            String flag = "<img src=\"" + contextPath + "/vsm/atic/resource/skins/images/nationalFlag/" + shortName + ".gif\" />";
            data.setIpLocationName(flag + " " + data.getIpLocationName());
            this.dataList.add(data);
        }
    }

    private double formatPercent(double percent) {
        long tmp = Math.round(percent * 1000.0);
        double base = 10.0;
        return (double)tmp / base;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        String unit;
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        String zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        if (0L == datastatConditionForm.getZoneId()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type");
        String type = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setAttackType(Integer.parseInt(type));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
        String topn = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setTopn(Integer.parseInt(topn));
        String isInteReport = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
        if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true")) {
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "IpLocationTopNTOPN");
            String topn4Inte = String.valueOf(jsonValueItem.get(0).getValue());
            Integer topn4InteValue = Integer.parseInt(topn4Inte);
            datastatConditionForm.setTopn(topn4InteValue);
        }
        if (!AticUtil.isNull((String)(unit = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit").get(0).getValue()))) {
            datastatConditionForm.setUnit(Integer.parseInt(unit));
        }
    }

    private Map<String, List<IpLocationTopNForm>> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<IpLocationTopNForm>> allCollectorIpLocationTopNForm = new HashMap();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewallId = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            allCollectorIpLocationTopNForm = this.dataStatService.getIpLocationTopNTable(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return allCollectorIpLocationTopNForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private Map<String, List<IpLocationTopNForm>> getMultiDeviceData(Long currentLogUserId, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<IpLocationTopNForm>> allCollectorIpLocationTopNForm = new HashMap<String, List<IpLocationTopNForm>>();
        List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect4DnsAnalysis(datastatConditionForm, currentLogUserId);
        Map<Long, List<AticDevice>> collectDevMaps = ReportAnalysisUtil.getCollectDevMap(firewallList);
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMaps.entrySet()) {
            CollectorInfo collector = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue());
            if (null == collector) continue;
            String collectorIp = collector.getIpAddress();
            datastatConditionForm.setDeviceIpList(new ArrayList<String>());
            for (AticDevice firewall : entry.getValue()) {
                datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
            }
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            Map<Object, Object> tempMap = new HashMap();
            try {
                tempMap = this.dataStatService.getIpLocationTopNTable(datastatConditionForm, collectorIp);
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey()), (Throwable)e);
            }
            for (Map.Entry<Object, Object> entryTemp : tempMap.entrySet()) {
                if (allCollectorIpLocationTopNForm.containsKey(entryTemp.getKey())) {
                    ((List)allCollectorIpLocationTopNForm.get(entryTemp.getKey())).addAll((Collection)entryTemp.getValue());
                    continue;
                }
                allCollectorIpLocationTopNForm.put((String)entryTemp.getKey(), (List<IpLocationTopNForm>)entryTemp.getValue());
            }
        }
        return allCollectorIpLocationTopNForm;
    }

    private List<IpLocationTopNForm> getAllDetectTopNForm(Map<String, List<IpLocationTopNForm>> inputMap, int topn) {
        List<IpLocationTopNForm> distinctForm = new ArrayList<IpLocationTopNForm>();
        List listDefendGroupForm = ReportBisUtil.getDefendGroupService().getAll();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        for (DefendGroupForm defendGroupForm : listDefendGroupForm) {
            String[] devIds;
            ArrayList<IpLocationTopNForm> listForm = new ArrayList<IpLocationTopNForm>();
            if (null == defendGroupForm.getDevices() || "".equals(defendGroupForm.getDevices())) continue;
            for (String devId : devIds = defendGroupForm.getDevices().split(",")) {
                AticDevice firewall = firewallService.getDeviceByMoid(Long.parseLong(devId));
                if (null == firewall) continue;
                String devIp = firewall.getIpAddress();
                if (!inputMap.containsKey(devIp = AticUtil.formatIpAddress((String)devIp))) continue;
                listForm.addAll((Collection<IpLocationTopNForm>)inputMap.get(devIp));
                inputMap.remove(devIp);
            }
            if (listForm.isEmpty()) continue;
            distinctForm.addAll(this.getDistinctForm(listForm, defendGroupForm.getDetectMode()));
        }
        for (Map.Entry entry : inputMap.entrySet()) {
            distinctForm.addAll((Collection)entry.getValue());
        }
        distinctForm = this.getDistinctForm(distinctForm, 1);
        if ((distinctForm = this.sortListByFieldByFlowValue(distinctForm, "flowValue", "DESC")).size() > topn) {
            for (int i = distinctForm.size() - 1; i >= topn; --i) {
                distinctForm.remove(i);
            }
        }
        return distinctForm;
    }

    private List<IpLocationTopNForm> getDistinctForm(List<IpLocationTopNForm> allForm, int netMode) {
        for (int i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (allForm.get(i).getIpLocationId() != allForm.get(j).getIpLocationId()) continue;
                this.dealWithSame(allForm, netMode, i, j);
            }
        }
        return allForm;
    }

    private void dealWithSame(List<IpLocationTopNForm> allForm, int netMode, int i, int j) {
        if (netMode == 0) {
            if (allForm.get(i).getFlowValue() > allForm.get(j).getFlowValue()) {
                allForm.get(i).setFlowValue(allForm.get(i).getFlowValue());
            } else {
                allForm.get(i).setFlowValue(allForm.get(j).getFlowValue());
            }
            allForm.remove(j);
        } else if (netMode == 1) {
            allForm.get(i).setFlowValue(allForm.get(i).getFlowValue() + allForm.get(j).getFlowValue());
            allForm.remove(j);
        }
    }

    private List<IpLocationTopNForm> getTopNForm(Map<String, List<IpLocationTopNForm>> inputMap, int topn) {
        List<IpLocationTopNForm> formList = new ArrayList<IpLocationTopNForm>();
        for (Map.Entry<String, List<IpLocationTopNForm>> entry : inputMap.entrySet()) {
            formList.addAll((Collection<IpLocationTopNForm>)entry.getValue());
        }
        formList = this.getDistinctForm(formList, 1);
        if ((formList = this.sortListByFieldByFlowValue(formList, "flowValue", "DESC")).size() > topn) {
            for (int i = formList.size() - 1; i >= topn; --i) {
                formList.remove(i);
            }
        }
        return formList;
    }

    public List<IpLocationTopN> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<IpLocationTopN> dataList) {
        this.dataList = dataList;
    }
}

