/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.flux.slotflow;

import com.hs.atic.analysis.report.flux.slotflow.SlotFlow;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.SlotFlowForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.policy.util.PolicyUtil;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class SlotFlowDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<SlotFlow> dataList = new ArrayList<SlotFlow>();
    private IDataStatService dataStatService;

    public List<SlotFlow> sortListByField(List<SlotFlow> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<SlotFlow> orderedList = null;
        orderedList = null != sortList ? this.sortListByField(this.dataList, sortList.getOrderField(), sortList.getOrderType()) : this.dataList;
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<SlotFlow> list = new ArrayList<SlotFlow>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        ArrayList<String> unit = new ArrayList<String>();
        List<JsonValueItem> jsonValueItemList = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit");
        String unitStr = String.valueOf(jsonValueItemList.get(0).getValue());
        if (unitStr.equals("0")) {
            unit.add("kbit/s");
        } else {
            unit.add("pps");
        }
        Map<String, List<String>> prepareParasMap = ReportAnalysisUtil.getPrepareParasMap(queryCond);
        prepareParasMap.put("unit", unit);
        this.logger.info((Object)("prepareParasMap is " + prepareParasMap.size()));
        return prepareParasMap;
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        try {
            this.getConditionForm(queryCond, datastatConditionForm);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            List<SlotFlowForm> slotFlowFormList = null;
            if (datastatConditionForm.getDeviceId() > 0L) {
                slotFlowFormList = this.getSingleDeviceSlotFlow(datastatConditionForm);
            } else {
                this.logger.info((Object)"Slot flow only to single device !");
            }
            this.processSlotFlowDisplay(slotFlowFormList, datastatConditionForm.getStartTime(), datastatConditionForm.getEndTime());
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"SlotFlow prepareData() unknow exception", (Throwable)e);
        }
        return 0;
    }

    private void processSlotFlowDisplay(List<SlotFlowForm> slotFlowFormList, Long startTime, Long endTime) {
        if (null == slotFlowFormList || slotFlowFormList.isEmpty()) {
            this.logger.info((Object)"getSlotFlow list isEmpty !");
            return;
        }
        slotFlowFormList = this.fillAllTimeData(slotFlowFormList, startTime, endTime);
        for (SlotFlowForm form : slotFlowFormList) {
            SlotFlow flow = new SlotFlow();
            AticUtil.copyProperties((Object)form, (Object)flow);
            flow.setLogTime(form.getLogTime() * 1000L);
            if (null == form.getAttackFlow()) {
                flow.setAttackFlow(0L);
            }
            flow.setOutFlow(flow.getInFlow() - flow.getAttackFlow());
            flow.setSlotName("slot_" + form.getSlotId());
            this.dataList.add(flow);
        }
    }

    private List<SlotFlowForm> getSingleDeviceSlotFlow(DataStatConditionForm datastatConditionForm) {
        List<SlotFlowForm> slotFlowFormList = new ArrayList<SlotFlowForm>();
        AticDevice firewall = ReportBisUtil.getIFirewallService().getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("No device exist, deviceId = " + datastatConditionForm.getDeviceId()));
            return slotFlowFormList;
        }
        if (!(firewall instanceof AticDevice)) {
            this.logger.error((Object)("SIG device no slot flow. deviceId = " + datastatConditionForm.getDeviceId()));
            return slotFlowFormList;
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,fwId = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            slotFlowFormList = this.dataStatService.getSlotFlow(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return slotFlowFormList;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm) {
        List<JsonValueItem> jsonValueItemList = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "switchOption");
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItemList.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItemList.get(0).getValue());
        if (direction.matches("^[\\d]*$")) {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        } else {
            datastatConditionForm.setDirection(1);
        }
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "protocol_combobox");
        String protocol = String.valueOf(jsonValueItemList.get(0).getValue());
        if (protocol.matches("^[\\d]*$")) {
            datastatConditionForm.setProtocol(Integer.parseInt(protocol));
        } else {
            datastatConditionForm.setProtocol(-1);
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit");
        String unit = String.valueOf(jsonValueItemList.get(0).getValue());
        datastatConditionForm.setUnit(Integer.parseInt(unit));
    }

    private List<SlotFlowForm> fillAllTimeData(List<SlotFlowForm> slotFlowFormList, long startTime, long endTime) {
        startTime = ReportAnalysisUtil.getRealStartTime(startTime, endTime);
        long timeSlot = this.getTimeSlot(startTime, endTime);
        ArrayList<Long> slotIdList = new ArrayList<Long>();
        Long minTime = 0L;
        Long maxTime = 0L;
        for (int i = 0; i < slotFlowFormList.size(); ++i) {
            SlotFlowForm form = slotFlowFormList.get(i);
            if (i == 0) {
                minTime = form.getLogTime();
                maxTime = form.getLogTime();
            } else {
                if (form.getLogTime() < minTime) {
                    minTime = form.getLogTime();
                }
                if (form.getLogTime() > maxTime) {
                    maxTime = form.getLogTime();
                }
            }
            this.getSlotIdList(form, slotIdList);
        }
        HashMap map = new HashMap();
        while (minTime <= maxTime) {
            ArrayList<SlotFlowForm> tmpList = new ArrayList<SlotFlowForm>();
            for (SlotFlowForm form : slotFlowFormList) {
                if (form.getLogTime() != minTime.longValue()) continue;
                tmpList.add(form);
            }
            map.put(minTime, tmpList);
            minTime = minTime + timeSlot;
        }
        for (Map.Entry<Long, List<SlotFlowForm>> entry : map.entrySet()) {
            this.getSlotFormListData(entry, slotIdList, slotFlowFormList);
        }
        return slotFlowFormList;
    }

    private long getTimeSlot(long startTime, long endTime) {
        int type = ReportAnalysisUtil.getTimeSpanType(endTime, startTime);
        if (type == AnalysisConstants.LESS_THAN_SEVEN_DAYS) {
            return PolicyUtil.NUM_THREE_THOUSAND_SIX_HUNDRED;
        }
        if (type == AnalysisConstants.MORE_THAN_SEVEN_DAYS) {
            return 24L * PolicyUtil.NUM_THREE_THOUSAND_SIX_HUNDRED;
        }
        return PolicyUtil.NUM_THREE_HUNDRED;
    }

    private void getSlotIdList(SlotFlowForm form, List<Long> slotIdList) {
        boolean hasData = false;
        for (int j = 0; j < slotIdList.size(); ++j) {
            if (form.getSlotId() != slotIdList.get(j).longValue()) continue;
            hasData = true;
            break;
        }
        if (!hasData) {
            slotIdList.add(form.getSlotId());
        }
    }

    private void getSlotFormListData(Map.Entry<Long, List<SlotFlowForm>> entry, List<Long> slotIdList, List<SlotFlowForm> slotFlowFormList) {
        for (int i = 0; i < slotIdList.size(); ++i) {
            boolean hasData = false;
            for (SlotFlowForm form : entry.getValue()) {
                if (form.getSlotId() != slotIdList.get(i).longValue()) continue;
                hasData = true;
                break;
            }
            if (hasData) continue;
            SlotFlowForm form = new SlotFlowForm();
            form.setLogTime(entry.getKey());
            form.setSlotId(slotIdList.get(i));
            form.setInFlow(0L);
            form.setAttackFlow(0L);
            form.setOutFlow(0L);
            slotFlowFormList.add(form);
        }
    }
}

