/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.flux.zonetopn;

import com.hs.atic.analysis.report.flux.zonetopn.ZoneFluxTopN;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.ZoneTopNForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class ZoneFluxTopNDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<ZoneFluxTopN> dataList = new ArrayList<ZoneFluxTopN>();
    private IDataStatService dataStatService;

    public List<ZoneFluxTopN> sortListByField(List<ZoneFluxTopN> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<ZoneFluxTopN> orderedList = null;
        orderedList = sortList != null ? this.sortListByField(this.dataList, sortList.getOrderField(), sortList.getOrderType()) : this.dataList;
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<ZoneFluxTopN> list = new ArrayList<ZoneFluxTopN>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getLogoAndNameMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start ZoneFluxTopNDataSet prepareData");
        List<ZoneTopNForm> zoneTopNFormList = null;
        Map<String, List<ZoneTopNForm>> allCollectorZoneTopNForm = new HashMap<String, List<ZoneTopNForm>>();
        try {
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            HashMap<Long, List<AticDevice>> collectDevMap = new HashMap<Long, List<AticDevice>>();
            if (datastatConditionForm.getDeviceId() > 0L) {
                allCollectorZoneTopNForm = this.getSingleDeviceData(collectDevMap, datastatConditionForm);
            }
            zoneTopNFormList = this.getTopNForm(allCollectorZoneTopNForm, datastatConditionForm.getTopn(), datastatConditionForm.getUnit());
            this.getZoneFluxTopNFormData(zoneTopNFormList);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            this.logger.error((Object)("ZoneFluxTopNDataSet prepareData() exception:" + legoException.getErrorCode()), (Throwable)legoException);
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"ZoneFluxTopNDataSet prepareData() unknow exception", (Throwable)e);
        }
        this.logger.info((Object)"end ZoneFluxTopNDataSet prepareData");
        return 0;
    }

    private void getZoneFluxTopNFormData(List<ZoneTopNForm> zoneTopNFormList) {
        IZoneService zoneService = ReportBisUtil.getZoneService();
        for (int i = 0; i < zoneTopNFormList.size(); ++i) {
            ZoneFluxTopN data = new ZoneFluxTopN();
            data.setKbps(zoneTopNFormList.get(i).getKbps());
            data.setPps(zoneTopNFormList.get(i).getPps());
            ZoneInfoForm zoneForm = zoneService.getById(zoneTopNFormList.get(i).getZoneId());
            if (null == zoneForm || "".equals(zoneForm.getZoneDesc())) {
                this.logger.info((Object)("the zone not exist,zoneId = " + zoneTopNFormList.get(i).getZoneId()));
                data.setZoneName(AticUtil.getText((String)"atic.analysis.common.unknownZone") + zoneTopNFormList.get(i).getZoneId());
            } else {
                data.setZoneName(zoneForm.getZoneDesc());
            }
            this.dataList.add(data);
        }
    }

    private Map<String, List<ZoneTopNForm>> getSingleDeviceData(Map<Long, List<AticDevice>> collectDevMap, DataStatConditionForm datastatConditionForm) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,fwId = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        ArrayList<AticDevice> tempList = new ArrayList<AticDevice>();
        tempList.add(firewall);
        collectDevMap.put(collectorInfo.getId(), tempList);
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        HashMap<String, List<ZoneTopNForm>> allCollectorZoneTopNForm = new HashMap();
        try {
            allCollectorZoneTopNForm = this.dataStatService.getZoneFlux(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return allCollectorZoneTopNForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, long sessionId) {
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItem.get(0).getValue());
        if (AticUtil.isNull((String)direction) || !direction.matches("^(0|1|2)$")) {
            datastatConditionForm.setDirection(1);
        } else {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type");
        String type = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setAttackType(Integer.parseInt(type));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type_combobox");
        String statType = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setAppType(Integer.parseInt(statType));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "protocol_combobox");
        String protocol = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setProtocol(Integer.parseInt(protocol));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit");
        String unit = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setUnit(Integer.parseInt(unit));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
        String topn = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setTopn(Integer.parseInt(topn));
        String isInteReport = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
        if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true")) {
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "FlowTopNTOPN");
            String topn4Inte = String.valueOf(jsonValueItem.get(0).getValue());
            Integer topn4InteValue = Integer.parseInt(topn4Inte);
            datastatConditionForm.setTopn(topn4InteValue);
        }
        ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
    }

    private List<ZoneTopNForm> getTopNForm(Map<String, List<ZoneTopNForm>> inputMap, int topn, int unit) {
        ArrayList<ZoneTopNForm> formList = new ArrayList<ZoneTopNForm>();
        for (Map.Entry<String, List<ZoneTopNForm>> entry : inputMap.entrySet()) {
            formList.addAll((Collection<ZoneTopNForm>)entry.getValue());
        }
        List<ZoneTopNForm> orderformList = null;
        orderformList = this.processDataSortByIp(formList, unit);
        if (orderformList.size() > topn) {
            for (int i = orderformList.size() - 1; i >= topn; --i) {
                orderformList.remove(i);
            }
        }
        return orderformList;
    }

    private List<ZoneTopNForm> processDataSortByIp(List<ZoneTopNForm> formList, int unit) {
        List<ZoneTopNForm> orderformList = new ArrayList<ZoneTopNForm>();
        if (null == formList || formList.isEmpty()) {
            return orderformList;
        }
        orderformList = formList;
        if (unit == 0) {
            orderformList = this.sortDataZoneTopNFormListByField(orderformList, "kbps", "DESC");
            this.processData4Kbps(orderformList);
        } else {
            orderformList = this.sortDataZoneTopNFormListByField(orderformList, "pps", "DESC");
            this.processData4Pps(orderformList);
        }
        return orderformList;
    }

    private void processData4Kbps(List<ZoneTopNForm> orderformList) {
        for (int i = 0; i < orderformList.size(); ++i) {
            for (int j = i + 1; j < orderformList.size(); ++j) {
                if (!orderformList.get(i).getKbps().equals(orderformList.get(j).getKbps()) || orderformList.get(i).getZoneId() <= orderformList.get(j).getZoneId()) continue;
                ZoneTopNForm temp = orderformList.get(i);
                orderformList.set(i, orderformList.get(j));
                orderformList.set(j, temp);
            }
        }
    }

    private void processData4Pps(List<ZoneTopNForm> orderformList) {
        for (int i = 0; i < orderformList.size(); ++i) {
            for (int j = i + 1; j < orderformList.size(); ++j) {
                if (!orderformList.get(i).getPps().equals(orderformList.get(j).getPps()) || orderformList.get(i).getZoneId() <= orderformList.get(j).getZoneId()) continue;
                ZoneTopNForm temp = orderformList.get(i);
                orderformList.set(i, orderformList.get(j));
                orderformList.set(j, temp);
            }
        }
    }

    private List<ZoneTopNForm> sortDataZoneTopNFormListByField(List<ZoneTopNForm> orderformList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(orderformList, comparator);
        return orderformList;
    }

    public List<ZoneFluxTopN> getDataList() {
        return this.dataList;
    }
}

