/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.integration;

import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TotalData4InteDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private Map<String, Integer> dataList = new HashMap<String, Integer>();
    private IDataStatService dataStatService;

    public Map<String, Integer> processTotalData(Map<?, ?> queryCond, long sessionId) {
        Map<String, Map<String, Integer>> allCollectorForm = null;
        try {
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return this.dataList;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return this.dataList;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return this.dataList;
            }
            if (datastatConditionForm.getDeviceId() > 0L) {
                allCollectorForm = this.getSingleDeviceData(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
                allCollectorForm = this.getAllCollectorIpTopNForm(firewallList, datastatConditionForm);
            }
            if (null != allCollectorForm) {
                this.processFinalTotalData(allCollectorForm);
            } else {
                this.logger.error((Object)"allCollectorForm is null");
            }
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"processTotalData prepareData() unknow exception", (Throwable)e);
        }
        this.logger.info((Object)"end processTotalData prepareData");
        return this.dataList;
    }

    private void processFinalTotalData(Map<String, Map<String, Integer>> allCollectorForm) {
        for (Map.Entry<String, Map<String, Integer>> entry : allCollectorForm.entrySet()) {
            for (Map.Entry<String, Integer> entryTemp : entry.getValue().entrySet()) {
                if (this.dataList.containsKey(entryTemp.getKey())) {
                    int tempValue = this.dataList.get(entryTemp.getKey());
                    this.dataList.put(entryTemp.getKey(), tempValue + entryTemp.getValue());
                    continue;
                }
                this.dataList.put(entryTemp.getKey(), entryTemp.getValue());
            }
        }
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        String direction = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox").get(0).getValue();
        if (AticUtil.isNull((String)direction) || !direction.matches("^(0|1|2)$")) {
            datastatConditionForm.setDirection(1);
        } else {
            if ("0".equals(direction)) {
                direction = "1";
            }
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        String zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        if (0L == datastatConditionForm.getZoneId()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
    }

    private Map<String, Map<String, Integer>> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        HashMap<String, Map<String, Integer>> allCollectorForm = new HashMap();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            allCollectorForm = this.dataStatService.getTotalCount(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return allCollectorForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private Map<String, Map<String, Integer>> getAllCollectorIpTopNForm(List<AticDevice> firewallList, DataStatConditionForm datastatConditionForm) {
        HashMap<String, Map<String, Integer>> allCollectFormData = new HashMap<String, Map<String, Integer>>();
        if (null != firewallList && !firewallList.isEmpty()) {
            Map<Long, List<AticDevice>> collectDevMap = ReportAnalysisUtil.getCollectDevMap(firewallList);
            for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
                String collectorIp = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue()).getIpAddress();
                datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                for (AticDevice firewall : entry.getValue()) {
                    if (null == datastatConditionForm.getDeviceIpList()) {
                        datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                    }
                    datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
                }
                this.dataStatService = ReportAnalysisUtil.getDataStatService();
                try {
                    allCollectFormData.putAll(this.dataStatService.getTotalCount(datastatConditionForm, collectorIp));
                }
                catch (Exception e) {
                    this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey()), (Throwable)e);
                }
            }
        }
        return allCollectFormData;
    }
}

