/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.integration.zone;

import com.hs.atic.analysis.report.integration.zone.ZoneInfo;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class ZoneInfoDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<ZoneInfo> dataList = new ArrayList<ZoneInfo>();
    private int success = 0;
    private Locale locale;

    public List<ZoneInfo> sortListByField(List<ZoneInfo> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<ZoneInfo> orderedList = null;
        if (null != sortList) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<ZoneInfo> list = new ArrayList<ZoneInfo>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.dataList.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return this.success;
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        try {
            IZoneService zoneService = ReportBisUtil.getZoneService();
            this.locale = ReportAnalysisUtil.getCurrentUserLocale4Report(queryCond);
            List<JsonValueItem> jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
            Long zoneId = Long.parseLong(jsonValueItem.get(0).getValue());
            ZoneInfoForm zoneForm = zoneService.getById(zoneId);
            String userName = AticUtil.isNull((String)zoneForm.getZoneName()) ? "" : zoneForm.getZoneName();
            String zoneType = "";
            zoneType = Constant.ZONE_TYPE_OF_DEFAULT.equals(zoneForm.getZoneType()) ? AticUtil.getText((String)"atic.user.type.default4ReportInte", (Locale)this.locale) : AticUtil.getText((String)"atic.user.type.custome4ReportInte", (Locale)this.locale);
            String zoneName = AticUtil.isNull((String)zoneForm.getZoneDesc()) ? "" : zoneForm.getZoneDesc();
            String linkman = AticUtil.isNull((String)zoneForm.getContact()) ? "" : zoneForm.getContact();
            String telphone = AticUtil.isNull((String)zoneForm.getTelephone()) ? "" : zoneForm.getTelephone();
            String moblephone = AticUtil.isNull((String)zoneForm.getMobile()) ? "" : zoneForm.getMobile();
            String postCode = AticUtil.isNull((String)zoneForm.getPost()) ? "" : zoneForm.getPost();
            String email = AticUtil.isNull((String)zoneForm.getEmail()) ? "" : zoneForm.getEmail();
            String address = AticUtil.isNull((String)zoneForm.getAddress()) ? "" : zoneForm.getAddress();
            ZoneInfo userNameObj = new ZoneInfo();
            userNameObj.setLable(AticUtil.getText((String)"atic.report.zoneInfo.userNameLable", (Locale)this.locale));
            userNameObj.setValue(userName);
            this.dataList.add(userNameObj);
            ZoneInfo zoneTypeObj = new ZoneInfo();
            zoneTypeObj.setLable(AticUtil.getText((String)"atic.report.zoneInfo.zoneTypeLable", (Locale)this.locale));
            zoneTypeObj.setValue(zoneType);
            this.dataList.add(zoneTypeObj);
            ZoneInfo zoneNameObj = new ZoneInfo();
            zoneNameObj.setLable(AticUtil.getText((String)"atic.report.zoneInfo.zoneNameLable", (Locale)this.locale));
            zoneNameObj.setValue(zoneName);
            this.dataList.add(zoneNameObj);
            ZoneInfo linkmanObj = new ZoneInfo();
            linkmanObj.setLable(AticUtil.getText((String)"atic.report.zoneInfo.linkmanLable", (Locale)this.locale));
            linkmanObj.setValue(linkman);
            this.dataList.add(linkmanObj);
            ZoneInfo telphoneObj = new ZoneInfo();
            telphoneObj.setLable(AticUtil.getText((String)"atic.report.zoneInfo.telphoneLable", (Locale)this.locale));
            telphoneObj.setValue(telphone);
            this.dataList.add(telphoneObj);
            ZoneInfo moblephoneObj = new ZoneInfo();
            moblephoneObj.setLable(AticUtil.getText((String)"atic.report.zoneInfo.moblephoneLable", (Locale)this.locale));
            moblephoneObj.setValue(moblephone);
            this.dataList.add(moblephoneObj);
            ZoneInfo postCodeObj = new ZoneInfo();
            postCodeObj.setLable(AticUtil.getText((String)"atic.report.zoneInfo.postCodeLable", (Locale)this.locale));
            postCodeObj.setValue(postCode);
            this.dataList.add(postCodeObj);
            ZoneInfo emailObj = new ZoneInfo();
            emailObj.setLable("Email");
            emailObj.setValue(email);
            this.dataList.add(emailObj);
            ZoneInfo addressObj = new ZoneInfo();
            addressObj.setLable(AticUtil.getText((String)"atic.report.zoneInfo.addressLable", (Locale)this.locale));
            addressObj.setValue(address);
            this.dataList.add(addressObj);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"ZoneInfoDataSet getPrepareParasMap() unknow exception", (Throwable)e);
        }
        return map;
    }
}

