/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.integration.zone;

import com.hs.atic.analysis.report.integration.zone.ZoneIpAddress;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneListIpForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class ZoneIpAddressDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<ZoneIpAddress> dataList = new ArrayList<ZoneIpAddress>();
    private int success = 0;
    private Locale locale;

    public List<ZoneIpAddress> sortListByField(List<ZoneIpAddress> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<ZoneIpAddress> orderedList = null;
        if (null != sortList) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<ZoneIpAddress> list = new ArrayList<ZoneIpAddress>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.dataList.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return this.success;
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        try {
            IZoneService zoneService = ReportBisUtil.getZoneService();
            this.locale = ReportAnalysisUtil.getCurrentUserLocale4Report(queryCond);
            List<JsonValueItem> jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
            Long zoneId = Long.parseLong(jsonValueItem.get(0).getValue());
            ZoneInfoForm zoneForm = zoneService.getById(zoneId);
            String userName = AticUtil.isNull((String)zoneForm.getZoneName()) ? "" : zoneForm.getZoneName();
            String zoneType = "";
            zoneType = Constant.ZONE_TYPE_OF_DEFAULT.equals(zoneForm.getZoneType()) ? AticUtil.getText((String)"atic.user.type.default4ReportInte", (Locale)this.locale) : AticUtil.getText((String)"atic.user.type.custome4ReportInte", (Locale)this.locale);
            String zoneName = AticUtil.isNull((String)zoneForm.getZoneDesc()) ? "" : zoneForm.getZoneDesc();
            String linkman = AticUtil.isNull((String)zoneForm.getContact()) ? "" : zoneForm.getContact();
            String telphone = AticUtil.isNull((String)zoneForm.getTelephone()) ? "" : zoneForm.getTelephone();
            String moblephone = AticUtil.isNull((String)zoneForm.getMobile()) ? "" : zoneForm.getMobile();
            String postCode = AticUtil.isNull((String)zoneForm.getPost()) ? "" : zoneForm.getPost();
            String email = AticUtil.isNull((String)zoneForm.getEmail()) ? "" : zoneForm.getEmail();
            String address = AticUtil.isNull((String)zoneForm.getAddress()) ? "" : zoneForm.getAddress();
            String description = AticUtil.isNull((String)zoneForm.getRemark()) ? "" : zoneForm.getRemark();
            ArrayList<String> userNameList = new ArrayList<String>();
            userNameList.add(userName);
            map.put("userName", userNameList);
            ArrayList<String> zoneTypeList = new ArrayList<String>();
            zoneTypeList.add(zoneType);
            map.put("zoneType", zoneTypeList);
            ArrayList<String> zoneNameList = new ArrayList<String>();
            zoneNameList.add(zoneName);
            map.put("zoneName", zoneNameList);
            ArrayList<String> linkmanList = new ArrayList<String>();
            linkmanList.add(linkman);
            map.put("linkman", linkmanList);
            ArrayList<String> telphoneList = new ArrayList<String>();
            telphoneList.add(telphone);
            map.put("telphone", telphoneList);
            ArrayList<String> moblephoneList = new ArrayList<String>();
            moblephoneList.add(moblephone);
            map.put("moblephone", moblephoneList);
            ArrayList<String> postCodeList = new ArrayList<String>();
            postCodeList.add(postCode);
            map.put("postCode", postCodeList);
            ArrayList<String> emailList = new ArrayList<String>();
            emailList.add(email);
            map.put("email", emailList);
            ArrayList<String> addressList = new ArrayList<String>();
            addressList.add(address);
            map.put("address", addressList);
            ArrayList<String> descriptionList = new ArrayList<String>();
            descriptionList.add(description);
            map.put("description", descriptionList);
            this.processZoneIpAddress(zoneForm);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"ZoneIpAddressDataSet getPrepareParasMap() unknow exception", (Throwable)e);
        }
        return map;
    }

    private void processZoneIpAddress(ZoneInfoForm zoneForm) {
        List tempIpList = zoneForm.getZoneListIpFormList();
        if (null != tempIpList && !tempIpList.isEmpty()) {
            ArrayList<String> containIpStr = new ArrayList<String>();
            ArrayList<String> removeIpStr = new ArrayList<String>();
            for (ZoneListIpForm zoneListIpForm : tempIpList) {
                String tempIp = "";
                tempIp = 0 == zoneListIpForm.getMaskType() ? zoneListIpForm.getZoneIp() + "/" + zoneListIpForm.getIntMask() : zoneListIpForm.getStartIp() + "/" + zoneListIpForm.getEndIp();
                if (0 == zoneListIpForm.getIpType()) {
                    containIpStr.add(tempIp);
                    continue;
                }
                removeIpStr.add(tempIp);
            }
            int ipLength = containIpStr.size() > removeIpStr.size() ? containIpStr.size() : removeIpStr.size();
            ArrayList<ZoneIpAddress> ipList = new ArrayList<ZoneIpAddress>();
            for (int i = 0; i < ipLength; ++i) {
                ZoneIpAddress tempObj = new ZoneIpAddress();
                if (i < containIpStr.size()) {
                    tempObj.setZoneIpAddressIn((String)containIpStr.get(i));
                }
                if (i < removeIpStr.size()) {
                    tempObj.setZoneIpAddressOut((String)removeIpStr.get(i));
                }
                ipList.add(tempObj);
            }
            this.dataList.clear();
            this.dataList.addAll(ipList);
        }
    }
}

