/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.service;

import com.hs.atic.analysis.dao.ReportConfigDAO;
import com.hs.atic.collector.entity.homepage.DashboardQueryBean;
import com.hs.atic.collector.entity.homepage.FlowTopNObj;
import com.hs.atic.collector.entity.log.AnalyzeSuccessRate;
import com.hs.atic.collector.entity.log.AnalyzeSuccessRateCondition;
import com.hs.atic.collector.entity.log.AppFlow;
import com.hs.atic.collector.entity.log.AttackCountCompare;
import com.hs.atic.collector.entity.log.AttackCountTrend;
import com.hs.atic.collector.entity.log.AttackExactFlow;
import com.hs.atic.collector.entity.log.AttackExactLog;
import com.hs.atic.collector.entity.log.AttackFlowPeakTopN;
import com.hs.atic.collector.entity.log.AttackIpCountTrend;
import com.hs.atic.collector.entity.log.AttackLog;
import com.hs.atic.collector.entity.log.AttackTopn;
import com.hs.atic.collector.entity.log.AttackTrend;
import com.hs.atic.collector.entity.log.AttackTypeDistributing;
import com.hs.atic.collector.entity.log.BisAttackCountTopN;
import com.hs.atic.collector.entity.log.BisAttackTimeTopN;
import com.hs.atic.collector.entity.log.BisTopN;
import com.hs.atic.collector.entity.log.BizTypePoJo;
import com.hs.atic.collector.entity.log.ConnCompare;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.entity.log.DeviceStopTime;
import com.hs.atic.collector.entity.log.DeviceStopTimeQueryForm;
import com.hs.atic.collector.entity.log.DnsCache;
import com.hs.atic.collector.entity.log.DnsDefendLog;
import com.hs.atic.collector.entity.log.DnsDefendTopN;
import com.hs.atic.collector.entity.log.DnsGraph;
import com.hs.atic.collector.entity.log.DnsTopN;
import com.hs.atic.collector.entity.log.DropTrend;
import com.hs.atic.collector.entity.log.FlowCompare;
import com.hs.atic.collector.entity.log.FlowCompareCondition;
import com.hs.atic.collector.entity.log.FlowDistributing;
import com.hs.atic.collector.entity.log.IpAttackCountTopN;
import com.hs.atic.collector.entity.log.IpAttackTimeTopN;
import com.hs.atic.collector.entity.log.IpLocationTopN;
import com.hs.atic.collector.entity.log.IpTopN;
import com.hs.atic.collector.entity.log.NormalAbnormalCondition;
import com.hs.atic.collector.entity.log.NormalAndExceptObject;
import com.hs.atic.collector.entity.log.RequestTrend;
import com.hs.atic.collector.entity.log.RmiTuple;
import com.hs.atic.collector.entity.log.SlotFlow;
import com.hs.atic.collector.entity.log.ZoneAttackCountTopN;
import com.hs.atic.collector.entity.log.ZoneAttackTimeTopN;
import com.hs.atic.collector.entity.log.ZoneTopN;
import com.hs.atic.rmi.AnalyzeSuccessRateService;
import com.hs.atic.rmi.DataStatService;
import com.hs.atic.rmi.FlowCompareService;
import com.hs.atic.rmi.NormalAndExceptService;
import com.hs.atic.rmi.ReportCollectorRMIProxy;
import com.hs.atic.sdk.analysis.form.AnalyzeSuccessRateConditionForm;
import com.hs.atic.sdk.analysis.form.AnalyzeSuccessRateForm;
import com.hs.atic.sdk.analysis.form.AppFlowForm;
import com.hs.atic.sdk.analysis.form.AttackCountCompareForm;
import com.hs.atic.sdk.analysis.form.AttackCountTrendForm;
import com.hs.atic.sdk.analysis.form.AttackExactFlowForm;
import com.hs.atic.sdk.analysis.form.AttackExactLogForm;
import com.hs.atic.sdk.analysis.form.AttackFlowPeakTopNForm;
import com.hs.atic.sdk.analysis.form.AttackIpCountTrendForm;
import com.hs.atic.sdk.analysis.form.AttackLogForm;
import com.hs.atic.sdk.analysis.form.AttackTopnForm;
import com.hs.atic.sdk.analysis.form.AttackTrendForm;
import com.hs.atic.sdk.analysis.form.AttackTypeDistributeForm;
import com.hs.atic.sdk.analysis.form.BisAttackCountTopNForm;
import com.hs.atic.sdk.analysis.form.BisAttackTimeTopNForm;
import com.hs.atic.sdk.analysis.form.BisTopNForm;
import com.hs.atic.sdk.analysis.form.ConnCompareForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.DeviceStopTimeForm;
import com.hs.atic.sdk.analysis.form.DnsCacheForm;
import com.hs.atic.sdk.analysis.form.DnsDefendLogForm;
import com.hs.atic.sdk.analysis.form.DnsDefendTopNForm;
import com.hs.atic.sdk.analysis.form.DnsGraphForm;
import com.hs.atic.sdk.analysis.form.DnsTopNForm;
import com.hs.atic.sdk.analysis.form.DropTrendForm;
import com.hs.atic.sdk.analysis.form.FlowCompareConditionForm;
import com.hs.atic.sdk.analysis.form.FlowCompareForm;
import com.hs.atic.sdk.analysis.form.FlowDistributeForm;
import com.hs.atic.sdk.analysis.form.IpAttackCountTopNForm;
import com.hs.atic.sdk.analysis.form.IpAttackTimeTopNForm;
import com.hs.atic.sdk.analysis.form.IpLocationTopNForm;
import com.hs.atic.sdk.analysis.form.IpTopNForm;
import com.hs.atic.sdk.analysis.form.NormalAbnormalConditionForm;
import com.hs.atic.sdk.analysis.form.NormalAbnormalForm;
import com.hs.atic.sdk.analysis.form.RequestTrendForm;
import com.hs.atic.sdk.analysis.form.SlotFlowForm;
import com.hs.atic.sdk.analysis.form.StopTimeQueryForm;
import com.hs.atic.sdk.analysis.form.ZoneAttackCountTopNForm;
import com.hs.atic.sdk.analysis.form.ZoneAttackTimeTopNForm;
import com.hs.atic.sdk.analysis.form.ZoneTopNForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.homepage.model.FlowTopNForm;
import com.hs.atic.sdk.homepage.model.SecReportTrafficObject;
import com.hs.atic.sdk.homepage.model.ZoneCompareObj;
import com.hs.atic.sdk.homepage.model.ZoneCompareTrafficObj;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.IpLocationUtil;
import com.hs.lego.cbb.fault.service.NotifyScheduler;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataStatServiceImpl
implements IDataStatService {
    private ReportConfigDAO reportConfigDAO;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private ReportCollectorRMIProxy reportCollectorRMIProxy;

    @Override
    public Map<String, List<IpTopNForm>> getIPFlux(DataStatConditionForm dataStatConditonForm, String collectorIp) {
        this.logger.info((Object)"begin getIPFlux()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditonForm, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        Map ipTopNList = null;
        HashMap<String, List<IpTopNForm>> returnMap = new HashMap<String, List<IpTopNForm>>();
        try {
            ipTopNList = client.getIPFlux(dsc);
            if (null != ipTopNList) {
                for (Map.Entry entry : ipTopNList.entrySet()) {
                    ArrayList<IpTopNForm> formList = new ArrayList<IpTopNForm>();
                    for (IpTopN iptopn : (List)entry.getValue()) {
                        IpTopNForm form = new IpTopNForm();
                        AticUtil.copyProperties((Object)iptopn, (Object)form);
                        formList.add(form);
                    }
                    returnMap.put((String)entry.getKey(), (List<IpTopNForm>)formList);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"query ipFlux failed! exception:", (Throwable)e);
        }
        this.logger.info((Object)"end getIPFlux()...");
        return returnMap;
    }

    @Override
    public Map<String, List<ZoneTopNForm>> getZoneFlux(DataStatConditionForm dataStatConditonForm, String collectorIp) {
        this.logger.info((Object)"begin getZoneFlux()...");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditonForm, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Map zoneTopNList = null;
        try {
            zoneTopNList = client.getZoneFlux(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query zoneFlux failed : ", (Throwable)e);
        }
        HashMap<String, List<ZoneTopNForm>> returnMap = new HashMap<String, List<ZoneTopNForm>>();
        if (null != zoneTopNList) {
            for (Map.Entry entry : zoneTopNList.entrySet()) {
                ArrayList<ZoneTopNForm> formList = new ArrayList<ZoneTopNForm>();
                for (ZoneTopN zoneTopn : (List)entry.getValue()) {
                    ZoneTopNForm form = new ZoneTopNForm();
                    AticUtil.copyProperties((Object)zoneTopn, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<ZoneTopNForm>)formList);
            }
        }
        this.logger.info((Object)"end getZoneFlux()...");
        return returnMap;
    }

    @Override
    public Map<String, List<ZoneTopNForm>> getZoneFlux(DataStatConditionForm cds, String collectorIp, List<ZoneTopNForm> zoneTopNFormList) {
        this.logger.info((Object)"begin getZoneFlux() Max");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        ArrayList<ZoneTopN> zoneTopNList = new ArrayList<ZoneTopN>();
        for (ZoneTopNForm form : zoneTopNFormList) {
            ZoneTopN zoneTopn = new ZoneTopN();
            AticUtil.copyProperties((Object)form, (Object)zoneTopn);
            zoneTopNList.add(zoneTopn);
        }
        Map zoneTopNMap = new HashMap();
        try {
            zoneTopNMap = client.getZoneFlux(dsc, zoneTopNList);
        }
        catch (Exception e) {
            this.logger.error((Object)"query zoneFlux Max failed : ", (Throwable)e);
        }
        HashMap<String, List<ZoneTopNForm>> returnMap = new HashMap<String, List<ZoneTopNForm>>();
        for (Map.Entry entry : zoneTopNMap.entrySet()) {
            ArrayList<ZoneTopNForm> formList = new ArrayList<ZoneTopNForm>();
            for (ZoneTopN zoneTopn : (List)entry.getValue()) {
                ZoneTopNForm form = new ZoneTopNForm();
                AticUtil.copyProperties((Object)zoneTopn, (Object)form);
                formList.add(form);
            }
            returnMap.put((String)entry.getKey(), (List<ZoneTopNForm>)formList);
        }
        this.logger.info((Object)"end getZoneFlux() Max");
        return returnMap;
    }

    @Override
    public Map<String, List<BisTopNForm>> getBisFlux(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getBisFlux()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        Map bisTopNList = null;
        try {
            bisTopNList = client.getBisFlux(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query bisFlux failed! exception:", (Throwable)e);
        }
        HashMap<String, List<BisTopNForm>> returnMap = new HashMap<String, List<BisTopNForm>>();
        if (null != bisTopNList) {
            for (Map.Entry entry : bisTopNList.entrySet()) {
                ArrayList<BisTopNForm> formList = new ArrayList<BisTopNForm>();
                for (BisTopN bistopn : (List)entry.getValue()) {
                    BisTopNForm form = new BisTopNForm();
                    AticUtil.copyProperties((Object)bistopn, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<BisTopNForm>)formList);
            }
        }
        this.logger.info((Object)"end getBisFlux()...");
        return returnMap;
    }

    @Override
    public List<FlowDistributeForm> getFlowDis(DataStatConditionForm dataStatConditon, String collectorIp) {
        this.logger.info((Object)"begin getFlowDis()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditon, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        List flowDisList = new ArrayList();
        try {
            flowDisList = client.getFlowDis(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query flowdsitributing failed : ", (Throwable)e);
        }
        ArrayList<FlowDistributeForm> formList = new ArrayList<FlowDistributeForm>();
        if (null != flowDisList && !flowDisList.isEmpty()) {
            for (FlowDistributing flowDistribute : flowDisList) {
                FlowDistributeForm flowForm = new FlowDistributeForm();
                AticUtil.copyProperties((Object)flowDistribute, (Object)flowForm);
                formList.add(flowForm);
            }
        }
        this.logger.info((Object)"end getFlowDis()...");
        return formList;
    }

    @Override
    public Map<String, List<FlowDistributeForm>> getAllDetectFlowDis(DataStatConditionForm dataStatConditon, String collectorIp) {
        this.logger.info((Object)"begin getAllDetectFlowDis()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditon, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        Map flowDisMap = new HashMap();
        try {
            flowDisMap = client.getAllDetectFlowDis(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query all detect flowdsitributing failed : ", (Throwable)e);
        }
        HashMap<String, List<FlowDistributeForm>> formMap = new HashMap<String, List<FlowDistributeForm>>();
        for (Map.Entry entry : flowDisMap.entrySet()) {
            ArrayList<FlowDistributeForm> flowFormList = new ArrayList<FlowDistributeForm>();
            for (FlowDistributing flowDis : (List)entry.getValue()) {
                FlowDistributeForm flowForm = new FlowDistributeForm();
                AticUtil.copyProperties((Object)flowDis, (Object)flowForm);
                flowFormList.add(flowForm);
            }
            formMap.put((String)entry.getKey(), (List<FlowDistributeForm>)flowFormList);
        }
        this.logger.info((Object)"end getAllDetectFlowDis()...");
        return formMap;
    }

    @Override
    public Map<String, List<DnsTopNForm>> getDnsTopN(DataStatConditionForm dataStatConditon, String collectorIp) {
        this.logger.info((Object)"begin getDnsTopN()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditon, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        Map dnsTopNMap = null;
        try {
            dnsTopNMap = client.getDnsTopN(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query dnsTopN failed! exception: ", (Throwable)e);
        }
        HashMap<String, List<DnsTopNForm>> returnMap = new HashMap<String, List<DnsTopNForm>>();
        if (null != dnsTopNMap) {
            for (Map.Entry entry : dnsTopNMap.entrySet()) {
                ArrayList<DnsTopNForm> formList = new ArrayList<DnsTopNForm>();
                for (DnsTopN dnstopn : (List)entry.getValue()) {
                    DnsTopNForm form = new DnsTopNForm();
                    AticUtil.copyProperties((Object)dnstopn, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<DnsTopNForm>)formList);
            }
        }
        this.logger.info((Object)"end getDnsTopN()...");
        return returnMap;
    }

    @Override
    public Map<String, List<ZoneAttackCountTopNForm>> getZoneAttackCountTopN(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getZoneAttackCountTopN()...");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Map zoneAttackCountTopNList = null;
        try {
            zoneAttackCountTopNList = client.getZoneAttackCountTopN(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query ZoneAttackCountTopN failed : ", (Throwable)e);
        }
        HashMap<String, List<ZoneAttackCountTopNForm>> returnMap = new HashMap<String, List<ZoneAttackCountTopNForm>>();
        if (null != zoneAttackCountTopNList) {
            for (Map.Entry entry : zoneAttackCountTopNList.entrySet()) {
                ArrayList<ZoneAttackCountTopNForm> formList = new ArrayList<ZoneAttackCountTopNForm>();
                for (ZoneAttackCountTopN zoneAttackCountTopN : (List)entry.getValue()) {
                    ZoneAttackCountTopNForm form = new ZoneAttackCountTopNForm();
                    AticUtil.copyProperties((Object)zoneAttackCountTopN, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<ZoneAttackCountTopNForm>)formList);
            }
        }
        this.logger.info((Object)"end getZoneAttackCountTopN()...");
        return returnMap;
    }

    @Override
    public Map<String, List<ZoneAttackTimeTopNForm>> getZoneAttackTimeTopN(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getZoneAttackTimeTopN()...");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Map zoneAttackTimeTopNFormList = null;
        try {
            zoneAttackTimeTopNFormList = client.getZoneAttackTimeTopN(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query ZoneAttackTimeTopN failed : ", (Throwable)e);
        }
        HashMap<String, List<ZoneAttackTimeTopNForm>> returnMap = new HashMap<String, List<ZoneAttackTimeTopNForm>>();
        if (null != zoneAttackTimeTopNFormList) {
            for (Map.Entry entry : zoneAttackTimeTopNFormList.entrySet()) {
                ArrayList<ZoneAttackTimeTopNForm> formList = new ArrayList<ZoneAttackTimeTopNForm>();
                for (ZoneAttackTimeTopN zoneAttackTimeTopN : (List)entry.getValue()) {
                    ZoneAttackTimeTopNForm form = new ZoneAttackTimeTopNForm();
                    AticUtil.copyProperties((Object)zoneAttackTimeTopN, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<ZoneAttackTimeTopNForm>)formList);
            }
        }
        this.logger.info((Object)"end getZoneAttackTimeTopN()...");
        return returnMap;
    }

    @Override
    public Map<String, List<BisAttackCountTopNForm>> getBisAttackCountTopN(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getBisAttackCountTopN()...");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Map bisAttackCountTopNList = null;
        try {
            bisAttackCountTopNList = client.getBisAttackCountTopN(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query BisAttackCountTopN failed : ", (Throwable)e);
        }
        HashMap<String, List<BisAttackCountTopNForm>> returnMap = new HashMap<String, List<BisAttackCountTopNForm>>();
        if (null != bisAttackCountTopNList) {
            for (Map.Entry entry : bisAttackCountTopNList.entrySet()) {
                ArrayList<BisAttackCountTopNForm> formList = new ArrayList<BisAttackCountTopNForm>();
                for (BisAttackCountTopN bisAttackCountTopN : (List)entry.getValue()) {
                    BisAttackCountTopNForm form = new BisAttackCountTopNForm();
                    AticUtil.copyProperties((Object)bisAttackCountTopN, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<BisAttackCountTopNForm>)formList);
            }
        }
        this.logger.info((Object)"end getBisAttackCountTopN()...");
        return returnMap;
    }

    @Override
    public Map<String, List<BisAttackTimeTopNForm>> getBisAttackTimeTopN(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getBisAttackTimeTopN()...");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Map bisAttackTimeTopNFormList = null;
        try {
            bisAttackTimeTopNFormList = client.getBisAttackTimeTopN(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query BisAttackTimeTopN failed : ", (Throwable)e);
        }
        HashMap<String, List<BisAttackTimeTopNForm>> returnMap = new HashMap<String, List<BisAttackTimeTopNForm>>();
        if (null != bisAttackTimeTopNFormList) {
            for (Map.Entry entry : bisAttackTimeTopNFormList.entrySet()) {
                ArrayList<BisAttackTimeTopNForm> formList = new ArrayList<BisAttackTimeTopNForm>();
                for (BisAttackTimeTopN bisAttackTimeTopN : (List)entry.getValue()) {
                    BisAttackTimeTopNForm form = new BisAttackTimeTopNForm();
                    AticUtil.copyProperties((Object)bisAttackTimeTopN, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<BisAttackTimeTopNForm>)formList);
            }
        }
        this.logger.info((Object)"end getBisAttackTimeTopN()...");
        return returnMap;
    }

    @Override
    public Map<String, List<IpAttackCountTopNForm>> getIpAttackCountTopN(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getIpAttackCountTopN()...");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Map ipAttackCountTopNList = null;
        try {
            ipAttackCountTopNList = client.getIpAttackCountTopN(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query IpAttackCountTopN failed : ", (Throwable)e);
        }
        HashMap<String, List<IpAttackCountTopNForm>> returnMap = new HashMap<String, List<IpAttackCountTopNForm>>();
        if (null != ipAttackCountTopNList) {
            for (Map.Entry entry : ipAttackCountTopNList.entrySet()) {
                ArrayList<IpAttackCountTopNForm> formList = new ArrayList<IpAttackCountTopNForm>();
                for (IpAttackCountTopN ipAttackCountTopN : (List)entry.getValue()) {
                    IpAttackCountTopNForm form = new IpAttackCountTopNForm();
                    AticUtil.copyProperties((Object)ipAttackCountTopN, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<IpAttackCountTopNForm>)formList);
            }
        }
        this.logger.info((Object)"end getIpAttackCountTopN()...");
        return returnMap;
    }

    @Override
    public Map<String, List<IpAttackTimeTopNForm>> getIpAttackTimeTopN(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getIpAttackTimeTopN()...");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Map ipAttackTimeTopNFormList = null;
        try {
            ipAttackTimeTopNFormList = client.getIpAttackTimeTopN(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query IpAttackTimeTopN failed : ", (Throwable)e);
        }
        HashMap<String, List<IpAttackTimeTopNForm>> returnMap = new HashMap<String, List<IpAttackTimeTopNForm>>();
        if (null != ipAttackTimeTopNFormList) {
            for (Map.Entry entry : ipAttackTimeTopNFormList.entrySet()) {
                ArrayList<IpAttackTimeTopNForm> formList = new ArrayList<IpAttackTimeTopNForm>();
                for (IpAttackTimeTopN ipAttackTimeTopN : (List)entry.getValue()) {
                    IpAttackTimeTopNForm form = new IpAttackTimeTopNForm();
                    AticUtil.copyProperties((Object)ipAttackTimeTopN, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<IpAttackTimeTopNForm>)formList);
            }
        }
        this.logger.info((Object)"end getIpAttackTimeTopN()...");
        return returnMap;
    }

    @Override
    public List<FlowCompareForm> queryFlowCompare(FlowCompareConditionForm flowCompareConditionForm, String collectorIp) {
        this.logger.info((Object)"begin queryFlowCompare()...");
        FlowCompareCondition flowCompareCondition = (FlowCompareCondition)AticUtil.copyProperties((Object)flowCompareConditionForm, (Object)new FlowCompareCondition());
        flowCompareCondition.setQueryRequestOrReply(flowCompareConditionForm.isIsQueryRequestOrReply());
        FlowCompareService client = this.reportCollectorRMIProxy.getFlowCompareService(collectorIp);
        if (null == client) {
            throw new LegoCheckedException(570504L);
        }
        List flowCompareList = new ArrayList();
        try {
            flowCompareList = client.queryFlowCompare(flowCompareCondition);
        }
        catch (Exception e) {
            this.logger.error((Object)"query flowcompare failed : ", (Throwable)e);
        }
        ArrayList<FlowCompareForm> flowCompareFormList = new ArrayList<FlowCompareForm>();
        if (null != flowCompareList && !flowCompareList.isEmpty()) {
            for (FlowCompare flowCompare : flowCompareList) {
                flowCompareFormList.add((FlowCompareForm)AticUtil.copyProperties((Object)flowCompare, (Object)new FlowCompareForm()));
            }
        }
        this.logger.info((Object)"end queryFlowCompare()...");
        return flowCompareFormList;
    }

    @Override
    public Map<String, List<DnsGraphForm>> getDnsGraph(DataStatConditionForm dataStatConditon, DnsTopNForm dnsTopNform, String collectorIp) {
        this.logger.info((Object)"begin getDnsGraph()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditon, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        Map dnsGraphMap = null;
        try {
            dnsGraphMap = client.getDnsGraph(dsc, (DnsTopN)AticUtil.copyProperties((Object)dnsTopNform, (Object)new DnsTopN()));
        }
        catch (Exception e) {
            this.logger.error((Object)"query dns graph failed! Exception:", (Throwable)e);
        }
        HashMap<String, List<DnsGraphForm>> returnMap = new HashMap<String, List<DnsGraphForm>>();
        if (null != dnsGraphMap) {
            for (Map.Entry entry : dnsGraphMap.entrySet()) {
                ArrayList<DnsGraphForm> formList = new ArrayList<DnsGraphForm>();
                for (DnsGraph dnsgraph : (List)entry.getValue()) {
                    DnsGraphForm form = new DnsGraphForm();
                    AticUtil.copyProperties((Object)dnsgraph, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<DnsGraphForm>)formList);
            }
        }
        this.logger.info((Object)"end getDnsGraph()...");
        return returnMap;
    }

    @Override
    public Map<String, List<DnsCacheForm>> getDnsCache(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getDnsCache()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        Map dnsCacheMap = null;
        try {
            dnsCacheMap = client.getDnsCache(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query dnsCache failed! Exception:", (Throwable)e);
        }
        HashMap<String, List<DnsCacheForm>> returnMap = new HashMap<String, List<DnsCacheForm>>();
        if (null != dnsCacheMap) {
            for (Map.Entry entry : dnsCacheMap.entrySet()) {
                ArrayList<DnsCacheForm> formList = new ArrayList<DnsCacheForm>();
                for (DnsCache dnsCache : (List)entry.getValue()) {
                    DnsCacheForm form = new DnsCacheForm();
                    AticUtil.copyProperties((Object)dnsCache, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<DnsCacheForm>)formList);
            }
        }
        this.logger.info((Object)"end getDnsCache()...");
        return returnMap;
    }

    @Override
    public List<AttackLogForm> getAttackLog(DataStatConditionForm cds, String collectorIp, String sortField, String sortType) {
        this.logger.info((Object)"begin getAttackLog()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        RmiTuple attackLogList = null;
        try {
            attackLogList = client.getAttackLog(dsc, sortField, sortType);
        }
        catch (Exception e) {
            this.logger.error((Object)"query attack log failed : ", (Throwable)e);
        }
        ArrayList<AttackLogForm> formList = new ArrayList<AttackLogForm>();
        if (null != attackLogList) {
            for (AttackLog attackLog : (List)attackLogList.getObjs()) {
                AttackLogForm form = new AttackLogForm();
                AticUtil.copyProperties((Object)attackLog, (Object)form);
                formList.add(form);
            }
        }
        this.logger.info((Object)"end getAttackLog()...");
        return formList;
    }

    @Override
    public Map<String, List<AttackTypeDistributeForm>> getAttackPacketsDis(DataStatConditionForm dataStatConditon, String collectorIp) {
        this.logger.info((Object)"begin getAttackPacketsDis()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditon, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        Map attackPacketDisMap = new HashMap();
        try {
            attackPacketDisMap = client.getAttackPacketsDis(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query getAttackPacketsDistribute failed : ", (Throwable)e);
        }
        HashMap<String, List<AttackTypeDistributeForm>> attackPacketFormMap = new HashMap<String, List<AttackTypeDistributeForm>>();
        for (Map.Entry attackType : attackPacketDisMap.entrySet()) {
            ArrayList<AttackTypeDistributeForm> formList = new ArrayList<AttackTypeDistributeForm>();
            for (AttackTypeDistributing attackTypeDis : (List)attackType.getValue()) {
                AttackTypeDistributeForm attackTypeDisForm = new AttackTypeDistributeForm();
                AticUtil.copyProperties((Object)attackTypeDis, (Object)attackTypeDisForm);
                formList.add(attackTypeDisForm);
            }
            attackPacketFormMap.put((String)attackType.getKey(), (List<AttackTypeDistributeForm>)formList);
        }
        this.logger.info((Object)"end getAttackPacketsDis()...");
        return attackPacketFormMap;
    }

    @Override
    public Map<String, List<AttackTypeDistributeForm>> getAttackCountsDis(DataStatConditionForm dataStatConditon, String collectorIp) {
        this.logger.info((Object)"begin getAttackCountsDis()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditon, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        Map attackCountDisMap = new HashMap();
        try {
            attackCountDisMap = client.getAttackCountsDis(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query getAttackCountsDistribute failed : ", (Throwable)e);
        }
        HashMap<String, List<AttackTypeDistributeForm>> attackCountFormMap = new HashMap<String, List<AttackTypeDistributeForm>>();
        for (Map.Entry attackType : attackCountDisMap.entrySet()) {
            ArrayList<AttackTypeDistributeForm> formList = new ArrayList<AttackTypeDistributeForm>();
            for (AttackTypeDistributing attackTypeDis : (List)attackType.getValue()) {
                AttackTypeDistributeForm attackTypeDisForm = new AttackTypeDistributeForm();
                AticUtil.copyProperties((Object)attackTypeDis, (Object)attackTypeDisForm);
                formList.add(attackTypeDisForm);
            }
            attackCountFormMap.put((String)attackType.getKey(), (List<AttackTypeDistributeForm>)formList);
        }
        this.logger.info((Object)"end getAttackCountsDis()...");
        return attackCountFormMap;
    }

    @Override
    public List<AnalyzeSuccessRateForm> queryAnalyzeSuccessRate(AnalyzeSuccessRateConditionForm analyzeSuccessRateConditionForm, String collectorIp) {
        this.logger.info((Object)"begin queryAnalyzeSuccessRate()...");
        AnalyzeSuccessRateCondition analyzeSuccessRateCondition = (AnalyzeSuccessRateCondition)AticUtil.copyProperties((Object)analyzeSuccessRateConditionForm, (Object)new AnalyzeSuccessRateCondition());
        AnalyzeSuccessRateService client = this.reportCollectorRMIProxy.getAnalyzeSuccessRateService(collectorIp);
        if (null == client) {
            throw new LegoCheckedException(570504L);
        }
        List analyzeSuccessRateList = new ArrayList();
        try {
            analyzeSuccessRateList = client.queryAnalyzeSuccessRate(analyzeSuccessRateCondition);
        }
        catch (Exception e) {
            this.logger.error((Object)"query analyzeSuccessRate failed : ", (Throwable)e);
        }
        ArrayList<AnalyzeSuccessRateForm> analyzeSuccessRateFormList = new ArrayList<AnalyzeSuccessRateForm>();
        for (AnalyzeSuccessRate analyzeSuccessRate : analyzeSuccessRateList) {
            analyzeSuccessRateFormList.add((AnalyzeSuccessRateForm)AticUtil.copyProperties((Object)analyzeSuccessRate, (Object)new AnalyzeSuccessRateForm()));
        }
        this.logger.info((Object)"end queryAnalyzeSuccessRate()...");
        return analyzeSuccessRateFormList;
    }

    @Override
    public Map<String, List<RequestTrendForm>> getRequestTrend(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getRequestTrend().....");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        this.logger.info((Object)("collector ip is :" + collectorIp));
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Map requestTrendFormList = null;
        try {
            requestTrendFormList = client.getRequestTrend(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query RequestTrend failed : ", (Throwable)e);
        }
        HashMap<String, List<RequestTrendForm>> returnMap = new HashMap<String, List<RequestTrendForm>>();
        if (null != requestTrendFormList) {
            for (Map.Entry entry : requestTrendFormList.entrySet()) {
                ArrayList<RequestTrendForm> formList = new ArrayList<RequestTrendForm>();
                for (RequestTrend requestTrend : (List)entry.getValue()) {
                    RequestTrendForm form = new RequestTrendForm();
                    AticUtil.copyProperties((Object)requestTrend, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<RequestTrendForm>)formList);
            }
        }
        this.logger.info((Object)"end getRequestTrend().....");
        return returnMap;
    }

    @Override
    public Map<String, List<DropTrendForm>> getDropTrend(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getDropTrend().....");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        this.logger.info((Object)("collector ip is :" + collectorIp));
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Map dropTrendFormList = null;
        try {
            dropTrendFormList = client.getDropTrend(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query DropTrend failed : ", (Throwable)e);
        }
        HashMap<String, List<DropTrendForm>> returnMap = new HashMap<String, List<DropTrendForm>>();
        if (null != dropTrendFormList) {
            for (Map.Entry entry : dropTrendFormList.entrySet()) {
                ArrayList<DropTrendForm> formList = new ArrayList<DropTrendForm>();
                for (DropTrend dropTrend : (List)entry.getValue()) {
                    DropTrendForm form = new DropTrendForm();
                    AticUtil.copyProperties((Object)dropTrend, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<DropTrendForm>)formList);
            }
        }
        this.logger.info((Object)"end getDropTrend().....");
        return returnMap;
    }

    @Override
    public Map<String, List<AttackTrendForm>> getAttackTrend(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getAttackTrend().....");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        this.logger.info((Object)("collector ip is :" + collectorIp));
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Map attackTrendFormList = null;
        try {
            attackTrendFormList = client.getAttackTrend(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query AttackTrend failed : ", (Throwable)e);
        }
        HashMap<String, List<AttackTrendForm>> returnMap = new HashMap<String, List<AttackTrendForm>>();
        if (null != attackTrendFormList) {
            for (Map.Entry entry : attackTrendFormList.entrySet()) {
                ArrayList<AttackTrendForm> formList = new ArrayList<AttackTrendForm>();
                for (AttackTrend attackTrend : (List)entry.getValue()) {
                    AttackTrendForm form = new AttackTrendForm();
                    AticUtil.copyProperties((Object)attackTrend, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<AttackTrendForm>)formList);
            }
        }
        this.logger.info((Object)"end getAttackTrend().....");
        return returnMap;
    }

    @Override
    public List<AttackExactLogForm> getAttackExactLog(Long attackLogPkid, String collectorIp, String language, int direction) {
        this.logger.info((Object)"begin getAttackExactLog()...");
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        RmiTuple attackExactLogList = null;
        try {
            attackExactLogList = client.getAttackExactLog(attackLogPkid, direction);
        }
        catch (Exception e) {
            this.logger.error((Object)"query attack log failed! exception:", (Throwable)e);
        }
        ArrayList<AttackExactLogForm> formList = new ArrayList<AttackExactLogForm>();
        if (null != attackExactLogList) {
            for (AttackExactLog attackExactLog : (List)attackExactLogList.getObjs()) {
                AttackExactLogForm form = new AttackExactLogForm();
                AticUtil.copyProperties((Object)attackExactLog, (Object)form);
                this.logger.info((Object)("srcip :" + form.getSrcIp()));
                formList.add(form);
            }
        }
        this.logger.info((Object)"end getAttackExactLog()...");
        return formList;
    }

    @Override
    public List<AttackExactLogForm> getAttackExactLog4AttackEvent(DataStatConditionForm dataStatConditon, String collectorIp, String language) {
        this.logger.info((Object)"begin getAttackExactLog4AttackEvent()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditon, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        RmiTuple attackExactLogList = null;
        try {
            attackExactLogList = client.getAttackExactLog4AttackEvent(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query getAttackExactLog4AttackEvent failed! exception:", (Throwable)e);
        }
        ArrayList<AttackExactLogForm> formList = new ArrayList<AttackExactLogForm>();
        if (null != attackExactLogList) {
            for (AttackExactLog attackExactLog : (List)attackExactLogList.getObjs()) {
                AttackExactLogForm form = new AttackExactLogForm();
                AticUtil.copyProperties((Object)attackExactLog, (Object)form);
                this.logger.info((Object)("srcip :" + form.getSrcIp()));
                if ("67".equals(form.getAttackType()) || 67 == form.getAttackTypeValue()) {
                    String names = IpLocationUtil.getCountryName((String)form.getSrcIp(), (String)language, (String)form.getDeviceIp());
                    form.setSrcIp(names);
                }
                formList.add(form);
            }
        }
        this.logger.info((Object)"end getAttackExactLog4AttackEvent()...");
        return formList;
    }

    @Override
    public Map<String, List<ConnCompareForm>> getConnCompare(DataStatConditionForm dataStatConditon, String collectorIp) {
        this.logger.info((Object)"begin getConnCompare()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditon, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        Map connCompareMap = new HashMap();
        try {
            connCompareMap = client.getConnCompare(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query connCompare failed : ", (Throwable)e);
        }
        HashMap<String, List<ConnCompareForm>> connCompareFormMap = new HashMap<String, List<ConnCompareForm>>();
        for (Map.Entry entry : connCompareMap.entrySet()) {
            ArrayList<ConnCompareForm> connCompareList = new ArrayList<ConnCompareForm>();
            for (ConnCompare connCompare : (List)entry.getValue()) {
                ConnCompareForm connCompareForm = new ConnCompareForm();
                AticUtil.copyProperties((Object)connCompare, (Object)connCompareForm);
                connCompareList.add(connCompareForm);
            }
            connCompareFormMap.put((String)entry.getKey(), (List<ConnCompareForm>)connCompareList);
        }
        this.logger.info((Object)"end getConnCompare()...");
        return connCompareFormMap;
    }

    @Override
    public List<NormalAbnormalForm> queryNormalAndException(NormalAbnormalConditionForm normalAndExceptionConditionForm, String collectorIp) {
        this.logger.info((Object)"begin queryNormalAndException()...");
        NormalAbnormalCondition normalAndExceptionCondition = (NormalAbnormalCondition)AticUtil.copyProperties((Object)normalAndExceptionConditionForm, (Object)new NormalAbnormalCondition());
        NormalAndExceptService client = this.reportCollectorRMIProxy.getNormalAndExceptionService(collectorIp);
        if (null == client) {
            throw new LegoCheckedException(570504L);
        }
        List normalAndExceptionList = null;
        try {
            normalAndExceptionList = client.queryNormalAndException(normalAndExceptionCondition);
        }
        catch (Exception e) {
            this.logger.error((Object)"query normalAndException failed : ", (Throwable)e);
        }
        ArrayList<NormalAbnormalForm> normalAndExceptionFormList = new ArrayList<NormalAbnormalForm>();
        if (null != normalAndExceptionList) {
            for (NormalAndExceptObject normalAndException : normalAndExceptionList) {
                normalAndExceptionFormList.add((NormalAbnormalForm)AticUtil.copyProperties((Object)normalAndException, (Object)new NormalAbnormalForm()));
            }
        }
        this.logger.info((Object)"end queryNormalAndException()...");
        return normalAndExceptionFormList;
    }

    @Override
    public Map<String, List<IpTopNForm>> getIPFlux(DataStatConditionForm cds, String collectorIp, List<IpTopNForm> ipTopNFormList) {
        this.logger.info((Object)"begin getIPFlux() Max");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            throw new LegoCheckedException(570504L);
        }
        ArrayList<IpTopN> ipTopNList = new ArrayList<IpTopN>();
        for (IpTopNForm form : ipTopNFormList) {
            IpTopN iptopn = new IpTopN();
            AticUtil.copyProperties((Object)form, (Object)iptopn);
            ipTopNList.add(iptopn);
        }
        Map ipTopNMap = null;
        try {
            ipTopNMap = client.getIPFlux(dsc, ipTopNList);
        }
        catch (Exception e) {
            this.logger.error((Object)"query ipFlux Max failed : ", (Throwable)e);
        }
        HashMap<String, List<IpTopNForm>> returnMap = new HashMap<String, List<IpTopNForm>>();
        if (null != ipTopNMap) {
            for (Map.Entry entry : ipTopNMap.entrySet()) {
                ArrayList<IpTopNForm> formList = new ArrayList<IpTopNForm>();
                for (IpTopN iptopn : (List)entry.getValue()) {
                    IpTopNForm form = new IpTopNForm();
                    AticUtil.copyProperties((Object)iptopn, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<IpTopNForm>)formList);
            }
        }
        this.logger.info((Object)"end getIPFlux() Max");
        return returnMap;
    }

    public void setReportCollectorRMIProxy(ReportCollectorRMIProxy reportCollectorRMIProxy) {
        this.reportCollectorRMIProxy = reportCollectorRMIProxy;
    }

    @Override
    public Map<String, List<BisTopNForm>> getBisFlux(DataStatConditionForm cds, String collectorIp, List<BisTopNForm> bisTopNFormList) {
        this.logger.info((Object)"begin getBisFlux() Max");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            throw new LegoCheckedException(570504L);
        }
        ArrayList<BisTopN> bisTopNList = new ArrayList<BisTopN>();
        for (BisTopNForm form : bisTopNFormList) {
            BisTopN bistopn = new BisTopN();
            AticUtil.copyProperties((Object)form, (Object)bistopn);
            bisTopNList.add(bistopn);
        }
        Map bisTopNMap = null;
        try {
            bisTopNMap = client.getBisFlux(dsc, bisTopNList);
        }
        catch (Exception e) {
            this.logger.error((Object)"query BisFlux Max failed : ", (Throwable)e);
        }
        HashMap<String, List<BisTopNForm>> returnMap = new HashMap<String, List<BisTopNForm>>();
        if (bisTopNMap != null) {
            for (Map.Entry entry : bisTopNMap.entrySet()) {
                ArrayList<BisTopNForm> formList = new ArrayList<BisTopNForm>();
                for (BisTopN bistopn : (List)entry.getValue()) {
                    BisTopNForm form = new BisTopNForm();
                    AticUtil.copyProperties((Object)bistopn, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<BisTopNForm>)formList);
            }
        }
        this.logger.info((Object)"end getBisFlux() Max");
        return returnMap;
    }

    @Override
    public Map<String, List<DeviceStopTimeForm>> getDeviceStopTimeList(StopTimeQueryForm queryForm, String collectorIp) {
        this.logger.info((Object)"begin getDeviceWorkTimeList()");
        DeviceStopTimeQueryForm tempQueryForm = new DeviceStopTimeQueryForm();
        AticUtil.copyProperties((Object)queryForm, (Object)tempQueryForm);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        Map stopTimeMap = new HashMap();
        try {
            stopTimeMap = client.getDeviceStopTimeList(tempQueryForm);
        }
        catch (Exception e) {
            this.logger.error((Object)"get deviceWorkTime failed : ", (Throwable)e);
        }
        HashMap<String, List<DeviceStopTimeForm>> stopMap = new HashMap<String, List<DeviceStopTimeForm>>();
        for (Map.Entry stopTime : stopTimeMap.entrySet()) {
            ArrayList<DeviceStopTimeForm> stopTimeList = new ArrayList<DeviceStopTimeForm>();
            for (DeviceStopTime stop : (List)stopTime.getValue()) {
                DeviceStopTimeForm stopForm = new DeviceStopTimeForm();
                AticUtil.copyProperties((Object)stop, (Object)stopForm);
                stopForm.setCollectorIp(collectorIp);
                stopTimeList.add(stopForm);
            }
            stopMap.put((String)stopTime.getKey(), (List<DeviceStopTimeForm>)stopTimeList);
        }
        this.logger.info((Object)"end getDeviceWorkTimeList()");
        return stopMap;
    }

    @Override
    public Integer getAttackLogNum(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getAttackLogNum()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        Integer total = 0;
        try {
            total = client.getAttackLogNum(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query attack log failed : ", (Throwable)e);
        }
        this.logger.info((Object)"end getAttackLogNum()...");
        return total;
    }

    @Override
    public List<AttackTopnForm> getAttackTopn(DataStatConditionForm dataStatConditon, String collectorIp) {
        this.logger.info((Object)"begin getAttackTopn()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditon, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        List attackTopnList = null;
        try {
            attackTopnList = client.getAttackEventTopn(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query getAttackTopn failed! exception:", (Throwable)e);
        }
        ArrayList<AttackTopnForm> attackTopnFormList = new ArrayList<AttackTopnForm>();
        if (null != attackTopnList) {
            for (AttackTopn attackTopn : attackTopnList) {
                AttackTopnForm form = new AttackTopnForm();
                AticUtil.copyProperties((Object)attackTopn, (Object)form);
                attackTopnFormList.add(form);
            }
        }
        this.logger.info((Object)"end getAttackTopn()...");
        return attackTopnFormList;
    }

    @Override
    public List<AttackExactFlowForm> getSingleAttackExactFlow(String exactLogId, String collectorIp) {
        this.logger.info((Object)"begin getSingleAttackExactFlow()...");
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        List attackExactFlowList = null;
        try {
            attackExactFlowList = client.getSingleAttackExactFlow(exactLogId);
        }
        catch (Exception e) {
            this.logger.error((Object)"query single attack exact flow failed! exception:", (Throwable)e);
        }
        ArrayList<AttackExactFlowForm> formList = new ArrayList<AttackExactFlowForm>();
        if (null != attackExactFlowList) {
            for (AttackExactFlow attackExactFlow : attackExactFlowList) {
                AttackExactFlowForm form = new AttackExactFlowForm();
                AticUtil.copyProperties((Object)attackExactFlow, (Object)form);
                formList.add(form);
            }
        }
        this.logger.info((Object)"end getSingleAttackExactFlow()...");
        return formList;
    }

    @Override
    public List<AttackExactFlowForm> getSingleAttackExactFlow(DataStatConditionForm dataStatConditon, String collectorIp) {
        this.logger.info((Object)"begin getSingleAttackExactFlow()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditon, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        List attackExactFlowList = null;
        try {
            attackExactFlowList = client.getSingleAttackExactFlow(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query single attack exact flow failed! exception:", (Throwable)e);
        }
        ArrayList<AttackExactFlowForm> formList = new ArrayList<AttackExactFlowForm>();
        if (null != attackExactFlowList) {
            for (AttackExactFlow attackExactFlow : attackExactFlowList) {
                AttackExactFlowForm form = new AttackExactFlowForm();
                AticUtil.copyProperties((Object)attackExactFlow, (Object)form);
                formList.add(form);
            }
        }
        this.logger.info((Object)"end getSingleAttackExactFlow()...");
        return formList;
    }

    @Override
    public List<SlotFlowForm> getSlotFlow(DataStatConditionForm dataStatConditon, String collectorIp) {
        this.logger.info((Object)"begin getSlotFlow()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditon, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        List slotFlowList = null;
        try {
            slotFlowList = client.getSlotFlow(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query slotFlow failed! exception:", (Throwable)e);
        }
        ArrayList<SlotFlowForm> slotFlowFormList = new ArrayList<SlotFlowForm>();
        if (null != slotFlowList) {
            for (SlotFlow slotFlow : slotFlowList) {
                SlotFlowForm slotForm = new SlotFlowForm();
                AticUtil.copyProperties((Object)slotFlow, (Object)slotForm);
                slotFlowFormList.add(slotForm);
            }
        }
        this.logger.info((Object)"end getSlotFlow()...");
        return slotFlowFormList;
    }

    @Override
    public List<DnsDefendLogForm> getDnsDefendLog(DataStatConditionForm cds, String collectorIp, String sortField, String sortType) {
        this.logger.info((Object)"begin getDnsDefendLog()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        RmiTuple botLogList = null;
        try {
            botLogList = client.getDnsDefendLog(dsc, sortField, sortType);
        }
        catch (Exception e) {
            this.logger.error((Object)"query getDnsDefendLog log failed : ", (Throwable)e);
        }
        ArrayList<DnsDefendLogForm> formList = new ArrayList<DnsDefendLogForm>();
        if (null != botLogList) {
            for (DnsDefendLog botLog : (List)botLogList.getObjs()) {
                DnsDefendLogForm form = new DnsDefendLogForm();
                AticUtil.copyProperties((Object)botLog, (Object)form);
                formList.add(form);
            }
        }
        this.logger.info((Object)"end getDnsDefendLog()...");
        return formList;
    }

    @Override
    public Integer getDnsDefendLogNum(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getDnsDefendLogNum()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        Integer total = 0;
        try {
            total = client.getDnsDefendLogNum(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query getDnsDefendLogNum log failed : ", (Throwable)e);
        }
        this.logger.info((Object)"end getDnsDefendLogNum()...");
        return total;
    }

    @Override
    public Map<String, List<DnsDefendTopNForm>> getDnsDefendTopN(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getDnsDefendTopN().....");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        this.logger.info((Object)("collector ip is :" + collectorIp));
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Map requestTrendFormList = null;
        try {
            requestTrendFormList = client.getDnsDefendTopN(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query getDnsDefendTopN failed : ", (Throwable)e);
        }
        HashMap<String, List<DnsDefendTopNForm>> returnMap = new HashMap<String, List<DnsDefendTopNForm>>();
        if (null != requestTrendFormList) {
            for (Map.Entry entry : requestTrendFormList.entrySet()) {
                ArrayList<DnsDefendTopNForm> formList = new ArrayList<DnsDefendTopNForm>();
                for (DnsDefendTopN requestTrend : (List)entry.getValue()) {
                    DnsDefendTopNForm form = new DnsDefendTopNForm();
                    AticUtil.copyProperties((Object)requestTrend, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<DnsDefendTopNForm>)formList);
            }
        }
        this.logger.info((Object)"end getDnsDefendTopN().....");
        return returnMap;
    }

    @Override
    public Map<String, List<AttackCountTrendForm>> getAttackCountTrend(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getAttackCountTrend().....");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        this.logger.info((Object)("collector ip is :" + collectorIp));
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Map attackTrendFormList = null;
        try {
            attackTrendFormList = client.getAttackCountTrend(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query getAttackCountTrend failed : ", (Throwable)e);
        }
        HashMap<String, List<AttackCountTrendForm>> returnMap = new HashMap<String, List<AttackCountTrendForm>>();
        if (null != attackTrendFormList) {
            for (Map.Entry entry : attackTrendFormList.entrySet()) {
                ArrayList<AttackCountTrendForm> formList = new ArrayList<AttackCountTrendForm>();
                for (AttackCountTrend attackTrend : (List)entry.getValue()) {
                    AttackCountTrendForm form = new AttackCountTrendForm();
                    AticUtil.copyProperties((Object)attackTrend, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<AttackCountTrendForm>)formList);
            }
        }
        this.logger.info((Object)"end getAttackCountTrend().....");
        return returnMap;
    }

    @Override
    public Map<String, List<AttackIpCountTrendForm>> getAttackIpCountTrend(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getAttackIpCountTrend().....");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        this.logger.info((Object)("collector ip is :" + collectorIp));
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Map attackTrendFormList = null;
        try {
            attackTrendFormList = client.getAttackIpCountTrend(dsc);
        }
        catch (RemoteException e) {
            this.logger.error((Object)"query getAttackIpCountTrend failed : ", (Throwable)e);
        }
        HashMap<String, List<AttackIpCountTrendForm>> returnMap = new HashMap<String, List<AttackIpCountTrendForm>>();
        if (null != attackTrendFormList) {
            for (Map.Entry entry : attackTrendFormList.entrySet()) {
                ArrayList<AttackIpCountTrendForm> formList = new ArrayList<AttackIpCountTrendForm>();
                for (AttackIpCountTrend attackTrend : (List)entry.getValue()) {
                    AttackIpCountTrendForm form = new AttackIpCountTrendForm();
                    AticUtil.copyProperties((Object)attackTrend, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<AttackIpCountTrendForm>)formList);
            }
        }
        this.logger.info((Object)"end getAttackIpCountTrend().....");
        return returnMap;
    }

    @Override
    public Map<String, List<AttackCountCompareForm>> getAttackCountCompare(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getAttackCountCompare().....");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        this.logger.info((Object)("collector ip is :" + collectorIp));
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Map attackTrendFormList = null;
        try {
            attackTrendFormList = client.getAttackCountCompare(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query getAttackCountCompare failed : ", (Throwable)e);
        }
        HashMap<String, List<AttackCountCompareForm>> returnMap = new HashMap<String, List<AttackCountCompareForm>>();
        if (null != attackTrendFormList) {
            for (Map.Entry entry : attackTrendFormList.entrySet()) {
                ArrayList<AttackCountCompareForm> formList = new ArrayList<AttackCountCompareForm>();
                for (AttackCountCompare attackTrend : (List)entry.getValue()) {
                    AttackCountCompareForm form = new AttackCountCompareForm();
                    AticUtil.copyProperties((Object)attackTrend, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<AttackCountCompareForm>)formList);
            }
        }
        this.logger.info((Object)"end getAttackCountCompare().....");
        return returnMap;
    }

    @Override
    public Map<String, Map<String, Integer>> getTotalCount(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getTotalCount().....");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        this.logger.info((Object)("collector ip is :" + collectorIp));
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Map attackData = null;
        try {
            attackData = client.getTotalCount(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query getTotalCount failed : ", (Throwable)e);
        }
        this.logger.info((Object)"end getTotalCount().....");
        return attackData;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, List<AppFlowForm>> getAppFlowDis(DataStatConditionForm cds, String collectorIp) {
        void var6_11;
        this.logger.info((Object)"begin getAppFlowDis().....");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        ArrayList<BizTypePoJo> bizTypeList4App = new ArrayList<BizTypePoJo>();
        for (com.hs.atic.sdk.analysis.form.BizTypePoJo bizTypePoJo : cds.getBizTypeList4App()) {
            BizTypePoJo bizTypePoJo2 = new BizTypePoJo();
            bizTypePoJo2.setBizId(bizTypePoJo.getBizId());
            bizTypePoJo2.setBizName(bizTypePoJo.getBizName());
            bizTypePoJo2.setBizType(bizTypePoJo.getBizType());
            bizTypeList4App.add(bizTypePoJo2);
        }
        dsc.setBizTypeList4App(bizTypeList4App);
        if (null != cds.getBizTypeMap4AppDevice() && !cds.getBizTypeMap4AppDevice().isEmpty()) {
            HashMap bizTypeMap4AppDevice = new HashMap();
            for (Map.Entry<String, List<com.hs.atic.sdk.analysis.form.BizTypePoJo>> entry : cds.getBizTypeMap4AppDevice().entrySet()) {
                ArrayList<BizTypePoJo> bizTypeList4AppTemp = new ArrayList<BizTypePoJo>();
                for (com.hs.atic.sdk.analysis.form.BizTypePoJo temp : entry.getValue()) {
                    BizTypePoJo item = new BizTypePoJo();
                    item.setBizId(temp.getBizId());
                    item.setBizName(temp.getBizName());
                    item.setBizType(temp.getBizType());
                    bizTypeList4AppTemp.add(item);
                }
                bizTypeMap4AppDevice.put(entry.getKey(), bizTypeList4AppTemp);
            }
            dsc.setBizTypeMap4AppDevice(bizTypeMap4AppDevice);
        }
        this.logger.info((Object)("collector ip is :" + collectorIp));
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Object var6_9 = null;
        try {
            Map map = client.getAppFlowDis(dsc);
        }
        catch (Exception exception) {
            this.logger.error((Object)"query getAppFlowDis failed : ", (Throwable)exception);
        }
        HashMap<String, List<AppFlowForm>> hashMap = new HashMap<String, List<AppFlowForm>>();
        if (null != var6_11) {
            for (Map.Entry entry : var6_11.entrySet()) {
                ArrayList<AppFlowForm> formList = new ArrayList<AppFlowForm>();
                for (AppFlow attackTrend : (List)entry.getValue()) {
                    AppFlowForm form = new AppFlowForm();
                    AticUtil.copyProperties((Object)attackTrend, (Object)form);
                    formList.add(form);
                }
                hashMap.put((String)entry.getKey(), (List<AppFlowForm>)formList);
            }
        }
        this.logger.info((Object)"end getAppFlowDis().....");
        return hashMap;
    }

    @Override
    public Map<String, String> getReportConfig() {
        return this.reportConfigDAO.getReportConfig();
    }

    public ReportConfigDAO getReportConfigDAO() {
        return this.reportConfigDAO;
    }

    public void setReportConfigDAO(ReportConfigDAO reportConfigDAO) {
        this.reportConfigDAO = reportConfigDAO;
    }

    @Override
    public void saveReportConfig(Map<String, String> parameter) {
        String companyName = parameter.get("companyName");
        NotifyScheduler.setCompanyName((String)companyName);
        try {
            this.reportConfigDAO.saveReportConf(parameter);
        }
        catch (Exception e) {
            this.logger.error((Object)("saveReportConfig error: " + e));
        }
    }

    @Override
    public void deleteReportConfig() {
        try {
            this.reportConfigDAO.deleteAll();
        }
        catch (Exception e) {
            this.logger.error((Object)("deleteReportConfig error: " + e));
        }
    }

    @Override
    public List<ZoneCompareTrafficObj> queryDashboardData(List<ZoneCompareObj> zoneCompareObjList) {
        ArrayList<ZoneCompareTrafficObj> returnList = new ArrayList<ZoneCompareTrafficObj>();
        this.logger.info((Object)"begin queryDashboardData()...");
        if (zoneCompareObjList.isEmpty()) {
            return returnList;
        }
        HashMap collectZoneObjMap = new HashMap();
        for (ZoneCompareObj zoneCompareObj : zoneCompareObjList) {
            if (collectZoneObjMap.containsKey(zoneCompareObj.getCollectorIp())) {
                ((List)collectZoneObjMap.get(zoneCompareObj.getCollectorIp())).add(zoneCompareObj);
                continue;
            }
            ArrayList<ZoneCompareObj> temp = new ArrayList<ZoneCompareObj>();
            temp.add(zoneCompareObj);
            collectZoneObjMap.put(zoneCompareObj.getCollectorIp(), temp);
        }
        try {
            Long currentLogTime = System.currentTimeMillis() / 1000L;
            this.logger.error((Object)currentLogTime);
            for (Map.Entry entry : collectZoneObjMap.entrySet()) {
                DataStatService client = this.reportCollectorRMIProxy.getDataStatService((String)entry.getKey());
                if (null == client) {
                    this.logger.error((Object)("get collector service failed! collector ip:" + (String)entry.getKey()));
                    continue;
                }
                ArrayList<DashboardQueryBean> queryBeans = new ArrayList<DashboardQueryBean>();
                for (ZoneCompareObj zoneCompareObj : (List)entry.getValue()) {
                    DashboardQueryBean dashboardQueryBean = new DashboardQueryBean();
                    dashboardQueryBean.setDevIp(zoneCompareObj.getDeviceIp());
                    dashboardQueryBean.setDevType(zoneCompareObj.getDevType());
                    dashboardQueryBean.setZoneId(zoneCompareObj.getZoneId().longValue());
                    dashboardQueryBean.setMax(zoneCompareObj.isMax());
                    dashboardQueryBean.setDirection(zoneCompareObj.getDirection());
                    if (!AticUtil.isNull((String)zoneCompareObj.getZoneIp())) {
                        dashboardQueryBean.setZoneIp(zoneCompareObj.getZoneIp());
                    }
                    queryBeans.add(dashboardQueryBean);
                }
                List dataList = client.queryDashboardData(queryBeans);
                if (null == dataList || dataList.isEmpty()) continue;
                for (DashboardQueryBean dashboardQueryBean : dataList) {
                    ZoneCompareTrafficObj zoneCompareTrafficObj = new ZoneCompareTrafficObj();
                    zoneCompareTrafficObj.setDeviceIp(dashboardQueryBean.getDevIp());
                    zoneCompareTrafficObj.setDeviceType(dashboardQueryBean.getDevType());
                    zoneCompareTrafficObj.setZoneId(dashboardQueryBean.getZoneId());
                    zoneCompareTrafficObj.setMax(dashboardQueryBean.isMax());
                    zoneCompareTrafficObj.setDirection(dashboardQueryBean.getDirection());
                    if (!AticUtil.isNull((String)dashboardQueryBean.getZoneIp())) {
                        zoneCompareTrafficObj.setZoneIp(dashboardQueryBean.getZoneIp());
                    }
                    zoneCompareTrafficObj.setLogTime(currentLogTime);
                    zoneCompareTrafficObj.setInKbps(dashboardQueryBean.getInFlowKbps());
                    zoneCompareTrafficObj.setOutKbps(dashboardQueryBean.getOutFlowKbps());
                    zoneCompareTrafficObj.setInPps(dashboardQueryBean.getInFlowPps());
                    zoneCompareTrafficObj.setOutPps(dashboardQueryBean.getOutFlowPps());
                    zoneCompareTrafficObj.setForwardKbps(dashboardQueryBean.getForwardFlowKbps());
                    zoneCompareTrafficObj.setForwardPps(dashboardQueryBean.getForwardFlowPps());
                    zoneCompareTrafficObj.setTcpInFlowPps(dashboardQueryBean.getTcpInFlowPps());
                    zoneCompareTrafficObj.setTcpInFlowKbps(dashboardQueryBean.getTcpInFlowKbps());
                    zoneCompareTrafficObj.setTcpOutFlowPps(dashboardQueryBean.getTcpOutFlowPps());
                    zoneCompareTrafficObj.setTcpOutFlowKbps(dashboardQueryBean.getTcpOutFlowKbps());
                    zoneCompareTrafficObj.setTcpForwardFlowKbps(dashboardQueryBean.getTcpForwardFlowKbps());
                    zoneCompareTrafficObj.setTcpForwardFlowPps(dashboardQueryBean.getTcpForwardFlowPps());
                    zoneCompareTrafficObj.setUdpInFlowPps(dashboardQueryBean.getUdpInFlowPps());
                    zoneCompareTrafficObj.setUdpInFlowKbps(dashboardQueryBean.getUdpInFlowKbps());
                    zoneCompareTrafficObj.setUdpOutFlowPps(dashboardQueryBean.getUdpOutFlowPps());
                    zoneCompareTrafficObj.setUdpOutFlowKbps(dashboardQueryBean.getUdpOutFlowKbps());
                    zoneCompareTrafficObj.setUdpForwardFlowKbps(dashboardQueryBean.getUdpForwardFlowKbps());
                    zoneCompareTrafficObj.setUdpForwardFlowPps(dashboardQueryBean.getUdpForwardFlowPps());
                    zoneCompareTrafficObj.setIcmpInFlowPps(dashboardQueryBean.getIcmpInFlowPps());
                    zoneCompareTrafficObj.setIcmpInFlowKbps(dashboardQueryBean.getIcmpInFlowKbps());
                    zoneCompareTrafficObj.setIcmpOutFlowPps(dashboardQueryBean.getIcmpOutFlowPps());
                    zoneCompareTrafficObj.setIcmpOutFlowKbps(dashboardQueryBean.getIcmpOutFlowKbps());
                    zoneCompareTrafficObj.setIcmpForwardFlowKbps(dashboardQueryBean.getIcmpForwardFlowKbps());
                    zoneCompareTrafficObj.setIcmpForwardFlowPps(dashboardQueryBean.getIcmpForwardFlowPps());
                    zoneCompareTrafficObj.setOtherInFlowPps(dashboardQueryBean.getOtherInFlowPps());
                    zoneCompareTrafficObj.setOtherInFlowKbps(dashboardQueryBean.getOtherInFlowKbps());
                    zoneCompareTrafficObj.setOtherOutFlowPps(dashboardQueryBean.getOtherOutFlowPps());
                    zoneCompareTrafficObj.setOtherOutFlowKbps(dashboardQueryBean.getOtherOutFlowKbps());
                    zoneCompareTrafficObj.setOtherForwardFlowKbps(dashboardQueryBean.getOtherForwardFlowKbps());
                    zoneCompareTrafficObj.setOtherForwardFlowPps(dashboardQueryBean.getOtherForwardFlowPps());
                    zoneCompareTrafficObj.setTcpFragInFlowKbps(dashboardQueryBean.getTcpFragInFlowKbps());
                    zoneCompareTrafficObj.setTcpFragInFlowPps(dashboardQueryBean.getTcpFragInFlowPps());
                    zoneCompareTrafficObj.setTcpFragOutFlowKbps(dashboardQueryBean.getTcpFragOutFlowKbps());
                    zoneCompareTrafficObj.setTcpFragOutFlowPps(dashboardQueryBean.getTcpFragOutFlowPps());
                    zoneCompareTrafficObj.setTcpFragForwardFlowKbps(dashboardQueryBean.getTcpFragForwardFlowKbps());
                    zoneCompareTrafficObj.setTcpFragForwardFlowPps(dashboardQueryBean.getTcpFragForwardFlowPps());
                    zoneCompareTrafficObj.setUdpFragInFlowKbps(dashboardQueryBean.getUdpFragInFlowKbps());
                    zoneCompareTrafficObj.setUdpFragInFlowPps(dashboardQueryBean.getUdpFragInFlowPps());
                    zoneCompareTrafficObj.setUdpFragOutFlowKbps(dashboardQueryBean.getUdpFragOutFlowKbps());
                    zoneCompareTrafficObj.setUdpFragOutFlowPps(dashboardQueryBean.getUdpFragOutFlowPps());
                    zoneCompareTrafficObj.setUdpFragForwardFlowKbps(dashboardQueryBean.getUdpFragForwardFlowPps());
                    zoneCompareTrafficObj.setSynInFlowPps(dashboardQueryBean.getSynInFlowPps());
                    zoneCompareTrafficObj.setSynOutFlowPps(dashboardQueryBean.getSynOutFlowPps());
                    zoneCompareTrafficObj.setSynForwardFlowPps(dashboardQueryBean.getSynForwardFlowPps());
                    zoneCompareTrafficObj.setSynAckInFlowPps(dashboardQueryBean.getSynAckInFlowPps());
                    zoneCompareTrafficObj.setSynAckOutFlowPps(dashboardQueryBean.getSynAckOutFlowPps());
                    zoneCompareTrafficObj.setSynAckForwardFlowPps(dashboardQueryBean.getSynAckForwardFlowPps());
                    zoneCompareTrafficObj.setAckInFlowPps(dashboardQueryBean.getAckInFlowPps());
                    zoneCompareTrafficObj.setAckOutFlowPps(dashboardQueryBean.getAckOutFlowPps());
                    zoneCompareTrafficObj.setAckForwardFlowPps(dashboardQueryBean.getAckForwardFlowPps());
                    zoneCompareTrafficObj.setFinRstInFlowPps(dashboardQueryBean.getFinRstInFlowPps());
                    zoneCompareTrafficObj.setFinRstOutFlowPps(dashboardQueryBean.getFinRstOutFlowPps());
                    zoneCompareTrafficObj.setFinRstForwardFlowPps(dashboardQueryBean.getFinRstForwardFlowPps());
                    returnList.add(zoneCompareTrafficObj);
                }
            }
        }
        catch (RemoteException e) {
            this.logger.error((Object)"query queryDashboardData failed! exception:", (Throwable)e);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"query queryDashboardData failed! exception:", (Throwable)e);
        }
        this.logger.info((Object)"end queryDashboardData()...");
        return returnList;
    }

    @Override
    public Map<String, List<IpLocationTopNForm>> getIpLocationGraph(DataStatConditionForm dataStatConditon, IpLocationTopNForm form, String collectorIp) {
        this.logger.info((Object)"begin getIpLocationGraph()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditon, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        Map dnsGraphMap = null;
        try {
            dnsGraphMap = client.getIpLocationGraph(dsc, (IpLocationTopN)AticUtil.copyProperties((Object)form, (Object)new IpLocationTopN()));
        }
        catch (Exception e) {
            this.logger.error((Object)"query getIpLocationGraph failed! Exception:", (Throwable)e);
        }
        HashMap<String, List<IpLocationTopNForm>> returnMap = new HashMap<String, List<IpLocationTopNForm>>();
        if (null != dnsGraphMap) {
            for (Map.Entry entry : dnsGraphMap.entrySet()) {
                ArrayList<IpLocationTopNForm> formList = new ArrayList<IpLocationTopNForm>();
                for (IpLocationTopN dnsgraph : (List)entry.getValue()) {
                    IpLocationTopNForm ipLocationTopNForm = new IpLocationTopNForm();
                    AticUtil.copyProperties((Object)dnsgraph, (Object)ipLocationTopNForm);
                    ipLocationTopNForm.setIpLocationName(form.getIpLocationName());
                    formList.add(ipLocationTopNForm);
                }
                returnMap.put((String)entry.getKey(), (List<IpLocationTopNForm>)formList);
            }
        }
        this.logger.info((Object)"end getIpLocationGraph()...");
        return returnMap;
    }

    @Override
    public Map<String, List<IpLocationTopNForm>> getIpLocationTopNGraph(DataStatConditionForm dataStatConditon, IpLocationTopNForm form, String collectorIp) {
        this.logger.info((Object)"begin getIpLocationTopNGraph()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditon, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        Map dnsGraphMap = null;
        try {
            dnsGraphMap = client.getIpLocationTopNGraph(dsc, (IpLocationTopN)AticUtil.copyProperties((Object)form, (Object)new IpLocationTopN()));
        }
        catch (Exception e) {
            this.logger.error((Object)"query getIpLocationTopNGraph failed! Exception:", (Throwable)e);
        }
        HashMap<String, List<IpLocationTopNForm>> returnMap = new HashMap<String, List<IpLocationTopNForm>>();
        if (null != dnsGraphMap) {
            for (Map.Entry entry : dnsGraphMap.entrySet()) {
                ArrayList<IpLocationTopNForm> formList = new ArrayList<IpLocationTopNForm>();
                for (IpLocationTopN dnsgraph : (List)entry.getValue()) {
                    IpLocationTopNForm ipLocationTopNForm = new IpLocationTopNForm();
                    AticUtil.copyProperties((Object)dnsgraph, (Object)ipLocationTopNForm);
                    ipLocationTopNForm.setIpLocationName(form.getIpLocationName());
                    formList.add(ipLocationTopNForm);
                }
                returnMap.put((String)entry.getKey(), (List<IpLocationTopNForm>)formList);
            }
        }
        this.logger.info((Object)"end getIpLocationTopNGraph()...");
        return returnMap;
    }

    @Override
    public Map<String, List<IpLocationTopNForm>> getIpLocationTopNTable(DataStatConditionForm dataStatConditon, String collectorIp) {
        this.logger.info((Object)"begin getIpLocationTopNTable()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditon, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        Map dnsTopNMap = null;
        try {
            dnsTopNMap = client.getIpLocationTopNTable(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query getIpLocationTopNTable failed! exception: ", (Throwable)e);
        }
        HashMap<String, List<IpLocationTopNForm>> returnMap = new HashMap<String, List<IpLocationTopNForm>>();
        if (null != dnsTopNMap) {
            for (Map.Entry entry : dnsTopNMap.entrySet()) {
                ArrayList<IpLocationTopNForm> formList = new ArrayList<IpLocationTopNForm>();
                for (IpLocationTopN dnstopn : (List)entry.getValue()) {
                    IpLocationTopNForm form = new IpLocationTopNForm();
                    AticUtil.copyProperties((Object)dnstopn, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<IpLocationTopNForm>)formList);
            }
        }
        this.logger.info((Object)"end getIpLocationTopNTable()...");
        return returnMap;
    }

    @Override
    public List<FlowTopNForm> queryDashboardTopNData(FlowTopNForm flowTopNForm, boolean isAdmin, List<Long> zoneIds) {
        ArrayList<FlowTopNForm> returnList = new ArrayList<FlowTopNForm>();
        List dataListFromRmi = null;
        this.logger.info((Object)"begin queryDashboardTopNData()...");
        FlowTopNObj flowTopNObj = new FlowTopNObj();
        AticUtil.copyProperties((Object)flowTopNForm, (Object)flowTopNObj);
        try {
            DataStatService client = this.reportCollectorRMIProxy.getDataStatService(flowTopNObj.getCollectorIp());
            if (null == client) {
                this.logger.error((Object)("get collector service failed! collector ip:" + flowTopNObj.getCollectorIp()));
            } else {
                dataListFromRmi = client.queryDashBoardTopnData(flowTopNObj, isAdmin, zoneIds);
                if (null != dataListFromRmi && !dataListFromRmi.isEmpty()) {
                    for (FlowTopNObj item : dataListFromRmi) {
                        FlowTopNForm form = new FlowTopNForm();
                        AticUtil.copyProperties((Object)item, (Object)form);
                        returnList.add(form);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"query queryDashboardTopNData failed! exception:", (Throwable)e);
        }
        this.logger.info((Object)"end queryDashboardTopNData()...");
        return returnList;
    }

    @Override
    public List<AttackLogForm> getCur10AttackIpLog(List<String> deviceIpList, List<Long> zoneIdList, String collectorIp) {
        this.logger.info((Object)"begin getCur10AttackIpLog()...");
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        List attackLogList = null;
        try {
            attackLogList = client.getCur10AttackIpLog(deviceIpList, zoneIdList);
        }
        catch (Exception e) {
            this.logger.error((Object)"query getCur10AttackIpLog failed : ", (Throwable)e);
        }
        ArrayList<AttackLogForm> formList = new ArrayList<AttackLogForm>();
        if (null != attackLogList) {
            for (AttackLog attackLog : attackLogList) {
                AttackLogForm form = new AttackLogForm();
                AticUtil.copyProperties((Object)attackLog, (Object)form);
                formList.add(form);
            }
        }
        this.logger.info((Object)"end getCur10AttackIpLog()...");
        return formList;
    }

    @Override
    public AttackExactLogForm getAttackSrcFlow(Long attackExactLogPkid, String collectorIp) {
        this.logger.info((Object)"begin getAttackSrcFlow()...");
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        AttackExactLog attackExactLog = null;
        try {
            attackExactLog = client.getAttackSrcFlow(attackExactLogPkid);
        }
        catch (Exception e) {
            this.logger.error((Object)"query getAttackSrcFlow failed! exception:", (Throwable)e);
        }
        AttackExactLogForm attackExactLogForm = new AttackExactLogForm();
        if (null != attackExactLog) {
            AticUtil.copyProperties((Object)attackExactLog, (Object)attackExactLogForm);
        }
        this.logger.info((Object)"end getAttackSrcFlow()...");
        return attackExactLogForm;
    }

    @Override
    public List<SecReportTrafficObject> queryDashboardData4SecReport(List<ZoneCompareObj> secReportList) {
        ArrayList<SecReportTrafficObject> returnList = new ArrayList<SecReportTrafficObject>();
        this.logger.info((Object)"begin queryDashboardData4SecReport()...");
        if (secReportList.isEmpty()) {
            return returnList;
        }
        HashMap secReportObjMap = new HashMap();
        for (ZoneCompareObj secReportObj : secReportList) {
            if (secReportObjMap.containsKey(secReportObj.getCollectorIp())) {
                ((List)secReportObjMap.get(secReportObj.getCollectorIp())).add(secReportObj);
                continue;
            }
            ArrayList<ZoneCompareObj> temp = new ArrayList<ZoneCompareObj>();
            temp.add(secReportObj);
            secReportObjMap.put(secReportObj.getCollectorIp(), temp);
        }
        try {
            Long currentLogTime = System.currentTimeMillis() / 1000L;
            this.logger.error((Object)currentLogTime);
            for (Map.Entry entry : secReportObjMap.entrySet()) {
                DataStatService client = this.reportCollectorRMIProxy.getDataStatService((String)entry.getKey());
                if (null == client) {
                    this.logger.error((Object)("get collector service failed! collector ip:" + (String)entry.getKey()));
                    continue;
                }
                ArrayList<DashboardQueryBean> queryBeans = new ArrayList<DashboardQueryBean>();
                for (ZoneCompareObj secReportObj : (List)entry.getValue()) {
                    DashboardQueryBean dashboardQueryBean = new DashboardQueryBean();
                    dashboardQueryBean.setDevIp(secReportObj.getDeviceIp());
                    dashboardQueryBean.setDevType(secReportObj.getDevType());
                    dashboardQueryBean.setDirection(secReportObj.getDirection());
                    if (!AticUtil.isNull((String)secReportObj.getZoneIp())) {
                        dashboardQueryBean.setZoneIp(secReportObj.getZoneIp());
                    }
                    queryBeans.add(dashboardQueryBean);
                }
                List dataList = client.querySecondFlowEvents(queryBeans);
                if (null == dataList || dataList.isEmpty()) continue;
                for (DashboardQueryBean dashboardQueryBean : dataList) {
                    SecReportTrafficObject secReportTrafficObject = new SecReportTrafficObject();
                    secReportTrafficObject.setDeviceIp(dashboardQueryBean.getDevIp());
                    secReportTrafficObject.setDeviceType(dashboardQueryBean.getDevType());
                    secReportTrafficObject.setDirection(dashboardQueryBean.getDirection());
                    if (!AticUtil.isNull((String)dashboardQueryBean.getZoneIp())) {
                        secReportTrafficObject.setZoneIp(dashboardQueryBean.getZoneIp());
                    }
                    secReportTrafficObject.setLogTime(currentLogTime);
                    secReportTrafficObject.setInKbps(dashboardQueryBean.getInFlowKbps());
                    secReportTrafficObject.setOutKbps(dashboardQueryBean.getOutFlowKbps());
                    secReportTrafficObject.setInPps(dashboardQueryBean.getInFlowPps());
                    secReportTrafficObject.setOutPps(dashboardQueryBean.getOutFlowPps());
                    returnList.add(secReportTrafficObject);
                }
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"query queryDashboardData failed! exception:", (Throwable)e);
        }
        this.logger.info((Object)"end queryDashboardData()...");
        return returnList;
    }

    @Override
    public Map<String, List<AttackFlowPeakTopNForm>> getIpAttackFlowPeakTopN(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getIpAttackFlowPeakTopN()...");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Map ipAttackFlowPeakTopNList = null;
        try {
            ipAttackFlowPeakTopNList = client.getIpAttackFlowPeakTopN(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query IpAttackFlowPeakTopN failed : ", (Throwable)e);
        }
        HashMap<String, List<AttackFlowPeakTopNForm>> returnMap = new HashMap<String, List<AttackFlowPeakTopNForm>>();
        if (null != ipAttackFlowPeakTopNList) {
            for (Map.Entry entry : ipAttackFlowPeakTopNList.entrySet()) {
                ArrayList<AttackFlowPeakTopNForm> formList = new ArrayList<AttackFlowPeakTopNForm>();
                for (AttackFlowPeakTopN attackFlowPeakTopN : (List)entry.getValue()) {
                    AttackFlowPeakTopNForm form = new AttackFlowPeakTopNForm();
                    AticUtil.copyProperties((Object)attackFlowPeakTopN, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<AttackFlowPeakTopNForm>)formList);
            }
        }
        this.logger.info((Object)"end getIpAttackFlowPeakTopN()...");
        return returnMap;
    }

    @Override
    public Map<String, List<AttackFlowPeakTopNForm>> getZoneAttackFlowPeakTopN(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getZoneAttackFlowPeakTopN()...");
        this.logger.info((Object)("CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        Map zoneAttackFlowPeakTopNList = null;
        try {
            zoneAttackFlowPeakTopNList = client.getZoneAttackFlowPeakTopN(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query ZoneAttackFlowPeakTopN failed : ", (Throwable)e);
        }
        HashMap<String, List<AttackFlowPeakTopNForm>> returnMap = new HashMap<String, List<AttackFlowPeakTopNForm>>();
        if (null != zoneAttackFlowPeakTopNList) {
            for (Map.Entry entry : zoneAttackFlowPeakTopNList.entrySet()) {
                ArrayList<AttackFlowPeakTopNForm> formList = new ArrayList<AttackFlowPeakTopNForm>();
                for (AttackFlowPeakTopN attackFlowPeakTopN : (List)entry.getValue()) {
                    AttackFlowPeakTopNForm form = new AttackFlowPeakTopNForm();
                    AticUtil.copyProperties((Object)attackFlowPeakTopN, (Object)form);
                    formList.add(form);
                }
                returnMap.put((String)entry.getKey(), (List<AttackFlowPeakTopNForm>)formList);
            }
        }
        this.logger.info((Object)"end getZoneAttackFlowPeakTopN()...");
        return returnMap;
    }

    @Override
    public List<AttackTypeDistributeForm> getAttackDurationAndTrafficPeakCountsDis(DataStatConditionForm dataStatConditon, String collectorIp) {
        this.logger.info((Object)"begin getAttackCountsDis()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditon, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        List attackCountDisList = new ArrayList();
        try {
            attackCountDisList = client.getAttackDurationAndTrafficPeakCountsDis(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query getAttackCountsDistribute failed : ", (Throwable)e);
        }
        ArrayList<AttackTypeDistributeForm> attackCountFormList = new ArrayList<AttackTypeDistributeForm>();
        for (AttackTypeDistributing attackType : attackCountDisList) {
            AttackTypeDistributeForm attackTypeDisForm = new AttackTypeDistributeForm();
            AticUtil.copyProperties((Object)attackType, (Object)attackTypeDisForm);
            attackCountFormList.add(attackTypeDisForm);
        }
        this.logger.info((Object)"end getAttackCountsDis()...");
        return attackCountFormList;
    }

    @Override
    public List<AttackTypeDistributeForm> getAttackVectorCountsDis(DataStatConditionForm dataStatConditon, String collectorIp) {
        this.logger.info((Object)"begin getAttackCountsDis()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)dataStatConditon, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        List attackCountDisList = new ArrayList();
        try {
            attackCountDisList = client.getAttackVectorCountsDis(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query getAttackCountsDistribute failed : ", (Throwable)e);
        }
        ArrayList<AttackTypeDistributeForm> attackCountFormList = new ArrayList<AttackTypeDistributeForm>();
        for (AttackTypeDistributing attackType : attackCountDisList) {
            AttackTypeDistributeForm attackTypeDisForm = new AttackTypeDistributeForm();
            AticUtil.copyProperties((Object)attackType, (Object)attackTypeDisForm);
            attackCountFormList.add(attackTypeDisForm);
        }
        this.logger.info((Object)"end getAttackCountsDis()...");
        return attackCountFormList;
    }

    @Override
    public List<AttackTrendForm> getAttackTypeAnalysis(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getAttackTypeAnalysis().....");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        this.logger.info((Object)("collector ip is :" + collectorIp));
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! CollectorIP : " + collectorIp + "(" + AticUtil.convertIpFromStr2Long((String)collectorIp) + ")"));
            throw new LegoCheckedException(570504L);
        }
        List attackTrendFormList = null;
        try {
            attackTrendFormList = client.getAttackTypeAnalysis(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query Attack Type Analysis failed : ", (Throwable)e);
        }
        ArrayList<AttackTrendForm> formList = new ArrayList<AttackTrendForm>();
        if (null != attackTrendFormList) {
            for (AttackTrend attackTrend : attackTrendFormList) {
                AttackTrendForm form = new AttackTrendForm();
                AticUtil.copyProperties((Object)attackTrend, (Object)form);
                formList.add(form);
            }
        }
        this.logger.info((Object)"end getAttackTypeAnalysis().....");
        return formList;
    }

    public ReportCollectorRMIProxy getReportCollectorRMIProxy() {
        return this.reportCollectorRMIProxy;
    }

    @Override
    public List<AttackExactLogForm> getAbnormalOrAttackCount(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getAbnormalOrAttackCount()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        List attackLogList = null;
        try {
            attackLogList = client.getAbnormalOrAttackCount(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query attack count failed : ", (Throwable)e);
        }
        ArrayList<AttackExactLogForm> formList = new ArrayList<AttackExactLogForm>();
        if (null != attackLogList) {
            for (AttackExactLog attackLog : attackLogList) {
                AttackExactLogForm form = new AttackExactLogForm();
                AticUtil.copyProperties((Object)attackLog, (Object)form);
                formList.add(form);
            }
        }
        this.logger.info((Object)"end getAbnormalOrAttackCount()...");
        return formList;
    }

    @Override
    public List<AttackExactLogForm> getAttackTypeLog(DataStatConditionForm cds, String collectorIp, String sortField, String sortType) {
        this.logger.info((Object)"begin getAttackTypeLog()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        List attackLogList = null;
        try {
            attackLogList = client.getAttackTypeLog(dsc, sortField, sortType);
        }
        catch (Exception e) {
            this.logger.error((Object)"query attack type log failed : ", (Throwable)e);
        }
        ArrayList<AttackExactLogForm> formList = new ArrayList<AttackExactLogForm>();
        if (null != attackLogList) {
            for (AttackExactLog attackLog : attackLogList) {
                AttackExactLogForm form = new AttackExactLogForm();
                AticUtil.copyProperties((Object)attackLog, (Object)form);
                formList.add(form);
            }
        }
        this.logger.info((Object)"end getAttackTypeLog()...");
        return formList;
    }

    @Override
    public Integer getAttackTypeLogNum(DataStatConditionForm cds, String collectorIp) {
        this.logger.info((Object)"begin getAttackTypeLogNum()...");
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorIp);
        if (null == client) {
            this.logger.error((Object)("get collector service failed! collector ip:" + collectorIp));
            throw new LegoCheckedException(570504L);
        }
        Integer total = 0;
        try {
            total = client.getAttackTypeLogNum(dsc);
        }
        catch (Exception e) {
            this.logger.error((Object)"query attack type log failed : ", (Throwable)e);
        }
        this.logger.info((Object)"end getAttackTypeLogNum()...");
        return total;
    }
}

