/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.util;

import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.opensymphony.xwork2.ActionContext;
import com.security.logserver.module.condition.load.IApplicationContextAware;
import com.security.logserver.module.condition.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationContext;

public class DataSourceStub
implements IApplicationContextAware {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    public void setApplicationContext(ApplicationContext arg0) {
    }

    public List<Pair<String, String>> getDDosDeviceList() {
        ArrayList<Pair<String, String>> listDev = new ArrayList<Pair<String, String>>();
        List<Pair<String, String>> singleDeviceList = this.getDeviceList4AttackLog();
        listDev.addAll(singleDeviceList);
        return listDev;
    }

    public List<Pair<String, String>> getDeviceList() {
        ArrayList<Pair<String, String>> listDev = new ArrayList<Pair<String, String>>();
        List<Pair<String, String>> singleDeviceList = this.getDeviceList4AttackLog();
        listDev.addAll(singleDeviceList);
        return listDev;
    }

    public List<Pair<String, String>> getDeviceListAndNFA() {
        ArrayList<Pair<String, String>> listDev = new ArrayList<Pair<String, String>>();
        listDev.addAll(this.getDeviceList());
        listDev.addAll(this.getNFADeviceList());
        return listDev;
    }

    private List<Pair<String, String>> getNFADeviceList() {
        ArrayList<Pair<String, String>> listDev = new ArrayList<Pair<String, String>>();
        try {
            HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            List lstFireWall = ReportBisUtil.getIFirewallService().getClusterAndNfa(currentUser.getUserID());
            List accessDevIds = ReportBisUtil.getICollectorDeviceService().getAllDeviceAccess();
            if (null == lstFireWall || lstFireWall.isEmpty()) {
                return listDev;
            }
            this.processAccessFireWall4Security(lstFireWall, accessDevIds);
            if (lstFireWall.isEmpty()) {
                return listDev;
            }
            for (int i = 0; i < lstFireWall.size(); ++i) {
                Pair pair = new Pair();
                String key = ((AticDevice)lstFireWall.get(i)).getMoId() + "_" + 1 + "_" + "2";
                String devType = AticUtil.getText((String)"atic.analysis.common.detect");
                pair.setKey((Object)key);
                pair.setValue((Object)(((AticDevice)lstFireWall.get(i)).getName() + devType));
                listDev.add((Pair<String, String>)pair);
            }
        }
        catch (LegoCheckedException legoException) {
            logger.error((Object)("getNFADeviceList LegoCheckedException error:" + legoException.getErrorCode()), (Throwable)legoException);
            throw legoException;
        }
        catch (Exception e) {
            logger.error((Object)"getNFADeviceList unknow error", (Throwable)e);
            throw new LegoCheckedException(570507L, (Throwable)e);
        }
        return listDev;
    }

    public List<AticDevice> getCleanDeviceList() {
        ArrayList<AticDevice> listDev = new ArrayList<AticDevice>();
        List lstFireWall = ReportBisUtil.getIFirewallService().getAntiDDoSDevice();
        List accessDevIds = ReportBisUtil.getICollectorDeviceService().getAllDeviceAccess();
        if (null == lstFireWall || lstFireWall.isEmpty()) {
            return listDev;
        }
        this.processAccessFireWall4Security(lstFireWall, accessDevIds);
        if (lstFireWall.isEmpty()) {
            return listDev;
        }
        int fireWallSize = lstFireWall.size();
        for (int i = 0; i < fireWallSize; ++i) {
            int deviceType = ((AticDevice)lstFireWall.get(i)).getDdosType();
            if (0 != deviceType && 2 != deviceType) continue;
            listDev.add((AticDevice)lstFireWall.get(i));
        }
        return listDev;
    }

    public List<Pair<String, String>> getDeviceList4AttackLogAndNfa() {
        List<Pair<String, String>> listDev = this.getDeviceList4AttackLog();
        List<Pair<String, String>> nfaList = this.getNFADeviceList();
        listDev.addAll(nfaList);
        return listDev;
    }

    public List<Pair<String, String>> getDeviceList4AttackLog() {
        ArrayList<Pair<String, String>> listDev = new ArrayList<Pair<String, String>>();
        try {
            HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            List lstFireWall = ReportBisUtil.getIFirewallService().getAntiDDoSDevice(currentUser.getUserID());
            List accessDevIds = ReportBisUtil.getICollectorDeviceService().getAllDeviceAccess();
            if (null == lstFireWall || lstFireWall.isEmpty()) {
                return listDev;
            }
            this.processAccessFireWall4Security(lstFireWall, accessDevIds);
            if (lstFireWall.isEmpty()) {
                return listDev;
            }
            this.processSingelDevice(lstFireWall, listDev);
        }
        catch (LegoCheckedException legoException) {
            logger.error((Object)("getDeviceList4AttackLog LegoCheckedException error:" + legoException.getErrorCode()));
            throw legoException;
        }
        catch (Exception e) {
            logger.error((Object)"getDeviceList4AttackLog unknow error", (Throwable)e);
            throw new LegoCheckedException(570507L, (Throwable)e);
        }
        return listDev;
    }

    private void processAccessFireWall4Security(List<AticDevice> lstFireWall, List<Long> accessDevIds) {
        for (int i = lstFireWall.size() - 1; i >= 0; --i) {
            AticDevice securityNE = lstFireWall.get(i);
            boolean isContain = false;
            for (Long devId : accessDevIds) {
                if (!devId.equals(securityNE.getMoId())) continue;
                isContain = true;
                break;
            }
            if (isContain) continue;
            lstFireWall.remove(i);
        }
    }

    private void processSingelDevice(List<AticDevice> lstFireWall, List<Pair<String, String>> listDev) {
        for (int i = 0; i < lstFireWall.size(); ++i) {
            Pair pair = new Pair();
            int deviceType = ReportAnalysisUtil.getDeviceDdos(lstFireWall.get(i));
            String name = "";
            if (0 == deviceType) {
                name = AticUtil.getText((String)"atic.analysis.common.clean");
                pair.setKey((Object)(lstFireWall.get(i).getMoId() + "_" + 0));
                pair.setValue((Object)(lstFireWall.get(i).getName() + name));
                listDev.add((Pair<String, String>)pair);
                continue;
            }
            if (1 == deviceType) {
                String key = lstFireWall.get(i).getMoId() + "_" + 1;
                pair.setKey((Object)key);
                name = AticUtil.getText((String)"atic.analysis.common.detect");
                pair.setValue((Object)(lstFireWall.get(i).getName() + name));
                listDev.add((Pair<String, String>)pair);
                continue;
            }
            if (2 != deviceType) continue;
            name = AticUtil.getText((String)"atic.analysis.common.detect");
            pair.setKey((Object)(lstFireWall.get(i).getMoId() + "_" + 1));
            pair.setValue((Object)(lstFireWall.get(i).getName() + name));
            listDev.add((Pair<String, String>)pair);
            Pair pair1 = new Pair();
            name = AticUtil.getText((String)"atic.analysis.common.clean");
            pair1.setKey((Object)(lstFireWall.get(i).getMoId() + "_" + 0));
            pair1.setValue((Object)(lstFireWall.get(i).getName() + name));
            listDev.add((Pair<String, String>)pair1);
        }
    }

    public List<Pair<String, String>> getDeviceList4SlotFlow() {
        ArrayList<Pair<String, String>> listDev = new ArrayList<Pair<String, String>>();
        try {
            ActionContext ctx = ActionContext.getContext();
            HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            List lstFireWall = ReportBisUtil.getIFirewallService().getAntiDDoSDevice(currentUser.getUserID());
            List accessDevIds = ReportBisUtil.getICollectorDeviceService().getAllDeviceAccess();
            if (null == lstFireWall || lstFireWall.isEmpty()) {
                return listDev;
            }
            this.processAccessFireWall(lstFireWall, accessDevIds);
            if (lstFireWall.isEmpty()) {
                return listDev;
            }
            this.processNoSigDevice(lstFireWall, listDev);
        }
        catch (LegoCheckedException legoException) {
            logger.error((Object)("getDeviceList4AttackLog LegoCheckedException error:" + legoException.getErrorCode()));
            throw legoException;
        }
        catch (Exception e) {
            logger.error((Object)"getDeviceList4AttackLog unknow error", (Throwable)e);
            throw new LegoCheckedException(570507L, (Throwable)e);
        }
        return listDev;
    }

    private void processAccessFireWall(List<AticDevice> lstFireWall, List<Long> accessDevIds) {
        for (int i = lstFireWall.size() - 1; i >= 0; --i) {
            AticDevice firewall = lstFireWall.get(i);
            boolean isContain = false;
            for (Long devId : accessDevIds) {
                if (!devId.equals(firewall.getMoId())) continue;
                isContain = true;
                break;
            }
            if (isContain) continue;
            lstFireWall.remove(i);
        }
    }

    private void processNoSigDevice(List<AticDevice> lstFireWall, List<Pair<String, String>> listDev) {
        for (int i = 0; i < lstFireWall.size(); ++i) {
            Pair pair = new Pair();
            int deviceType = ReportAnalysisUtil.getDeviceDdos(lstFireWall.get(i));
            String name = "";
            if (0 == deviceType) {
                name = AticUtil.getText((String)"atic.analysis.common.clean");
                pair.setKey((Object)(lstFireWall.get(i).getMoId() + "_" + 0));
                pair.setValue((Object)(lstFireWall.get(i).getName() + name));
                listDev.add((Pair<String, String>)pair);
                continue;
            }
            if (1 == deviceType) {
                name = AticUtil.getText((String)"atic.analysis.common.detect");
                pair.setKey((Object)(lstFireWall.get(i).getMoId() + "_" + 1));
                pair.setValue((Object)(lstFireWall.get(i).getName() + name));
                listDev.add((Pair<String, String>)pair);
                continue;
            }
            if (2 != deviceType) continue;
            name = AticUtil.getText((String)"atic.analysis.common.detect");
            pair.setKey((Object)(lstFireWall.get(i).getMoId() + "_" + 1));
            pair.setValue((Object)(lstFireWall.get(i).getName() + name));
            listDev.add((Pair<String, String>)pair);
            Pair pair1 = new Pair();
            name = AticUtil.getText((String)"atic.analysis.common.clean");
            pair1.setKey((Object)(lstFireWall.get(i).getMoId() + "_" + 0));
            pair1.setValue((Object)(lstFireWall.get(i).getName() + name));
            listDev.add((Pair<String, String>)pair1);
        }
    }

    public List<Pair<String, String>> getZoneList() {
        ArrayList<Pair<String, String>> listZone = new ArrayList<Pair<String, String>>();
        Pair pairAll = new Pair();
        pairAll.setKey((Object)"0");
        pairAll.setValue((Object)AticUtil.getText((String)"atic.analysis.common.all"));
        listZone.add(pairAll);
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        User currentUser = (User)request.getSession().getAttribute("currentUser");
        Boolean isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
        List lstZone = ReportBisUtil.getZoneService().getDeployZoneInfoByDeviceType(Long.valueOf(currentUser.getUserID()), isAdmin, 0);
        if (null == lstZone || lstZone.isEmpty()) {
            return listZone;
        }
        for (int i = 0; i < lstZone.size(); ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)((ZoneInfoForm)lstZone.get(i)).getZoneId().toString());
            pair.setValue((Object)((ZoneInfoForm)lstZone.get(i)).getZoneDesc());
            listZone.add((Pair<String, String>)pair);
        }
        return listZone;
    }

    public List<Pair<String, String>> getBisList() {
        ArrayList<Pair<String, String>> listBis = new ArrayList<Pair<String, String>>();
        Pair pairAll = new Pair();
        pairAll.setKey((Object)"0");
        pairAll.setValue((Object)AticUtil.getText((String)"atic.analysis.common.all"));
        listBis.add(pairAll);
        return listBis;
    }

    public List<Pair<String, String>> getCountTypeList() {
        ArrayList<Pair<String, String>> listBis = new ArrayList<Pair<String, String>>();
        Pair pair1 = new Pair();
        pair1.setKey((Object)"1");
        pair1.setValue((Object)AticUtil.getText((String)"atic.analysis.report.tab.counttype.attackDuration"));
        listBis.add(pair1);
        Pair pair0 = new Pair();
        pair0.setKey((Object)"0");
        pair0.setValue((Object)AticUtil.getText((String)"atic.analysis.report.tab.counttype.dropMaxKbps"));
        listBis.add(pair0);
        Pair pair4 = new Pair();
        pair4.setKey((Object)"4");
        pair4.setValue((Object)AticUtil.getText((String)"atic.analysis.report.tab.counttype.dropMaxPps"));
        listBis.add(pair4);
        return listBis;
    }

    public List<Pair<String, String>> getCountTypeListOfV1R1() {
        ArrayList<Pair<String, String>> listBis = new ArrayList<Pair<String, String>>();
        Pair pair1 = new Pair();
        pair1.setKey((Object)"1");
        pair1.setValue((Object)AticUtil.getText((String)"atic.analysis.report.tab.counttype.attackDuration"));
        listBis.add(pair1);
        Pair pair0 = new Pair();
        pair0.setKey((Object)"0");
        pair0.setValue((Object)AticUtil.getText((String)"atic.analysis.report.tab.counttype.dropMaxKbps"));
        listBis.add(pair0);
        Pair pair4 = new Pair();
        pair4.setKey((Object)"4");
        pair4.setValue((Object)AticUtil.getText((String)"atic.analysis.report.tab.counttype.dropMaxPps"));
        listBis.add(pair4);
        return listBis;
    }

    public List<Pair<String, String>> getStatisticalDimensionList() {
        ArrayList<Pair<String, String>> listBis = new ArrayList<Pair<String, String>>();
        Pair pair1 = new Pair();
        pair1.setKey((Object)"0");
        pair1.setValue((Object)AticUtil.getText((String)"atic.analysis.common.statisticalDimension.global"));
        listBis.add(pair1);
        Pair pair2 = new Pair();
        pair2.setKey((Object)"1");
        pair2.setValue((Object)AticUtil.getText((String)"atic.analysis.common.statisticalDimension.china"));
        listBis.add(pair2);
        return listBis;
    }

    public List<Pair<String, String>> getIpLocInitList() {
        ArrayList<Pair<String, String>> ipLocList = new ArrayList<Pair<String, String>>();
        return ipLocList;
    }

    public List<Pair<String, String>> getBisListForCompare() {
        ArrayList<Pair<String, String>> listBis = new ArrayList<Pair<String, String>>();
        Pair pairAll = new Pair();
        pairAll.setKey((Object)"0");
        pairAll.setValue((Object)AticUtil.getText((String)"atic.analysis.common.all"));
        listBis.add(pairAll);
        return listBis;
    }

    public List<Pair<String, String>> getBisListForApp() {
        ArrayList<Pair<String, String>> listBis = new ArrayList<Pair<String, String>>();
        Pair pairHttp = new Pair();
        pairHttp.setKey((Object)"-2");
        pairHttp.setValue((Object)"HTTP");
        listBis.add(pairHttp);
        Pair pairHttps = new Pair();
        pairHttps.setKey((Object)"-3");
        pairHttps.setValue((Object)"HTTPS");
        listBis.add(pairHttps);
        Pair pairDns = new Pair();
        pairDns.setKey((Object)"-4");
        pairDns.setValue((Object)"UDP_DNS");
        listBis.add(pairDns);
        Pair pairSip = new Pair();
        pairSip.setKey((Object)"-5");
        pairSip.setValue((Object)"SIP");
        listBis.add(pairSip);
        return listBis;
    }

    public List<Pair<String, String>> getFluxType() {
        ArrayList<Pair<String, String>> listFluxType = new ArrayList<Pair<String, String>>();
        return listFluxType;
    }

    public List<Pair<String, String>> getProtocol() {
        ArrayList<Pair<String, String>> listProtocol = new ArrayList<Pair<String, String>>();
        String[] arg = new String[]{AticUtil.getText((String)"atic.analysis.common.all"), AticUtil.getText((String)"atic.analysis.common.protocol.tcp"), AticUtil.getText((String)"atic.analysis.common.protocol.udp"), AticUtil.getText((String)"atic.analysis.common.protocol.icmp"), AticUtil.getText((String)"atic.analysis.common.protocol.other")};
        String[] key = new String[]{"0", "1", "2", "3", "4"};
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listProtocol.add((Pair<String, String>)pair);
        }
        return listProtocol;
    }

    public List<Pair<String, String>> getFlowCompareProtocol() {
        return ReportAnalysisUtil.getDefaultProtocolList();
    }

    public List<Pair<String, String>> getUnit() {
        ArrayList<Pair<String, String>> listUnit = new ArrayList<Pair<String, String>>();
        String[] arg = new String[]{AticUtil.getText((String)"atic.analysis.common.unit.pps"), AticUtil.getText((String)"atic.analysis.common.unit.kbps")};
        String[] key = new String[]{"1", "0"};
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listUnit.add((Pair<String, String>)pair);
        }
        return listUnit;
    }

    public List<Pair<String, String>> getUnit4Http() {
        ArrayList<Pair<String, String>> listUnit = new ArrayList<Pair<String, String>>();
        String[] arg = new String[]{"pps", "qps"};
        String[] key = new String[]{String.valueOf(1), String.valueOf(2)};
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listUnit.add((Pair<String, String>)pair);
        }
        return listUnit;
    }

    public List<Pair<String, String>> getUnit4AppFlow() {
        ArrayList<Pair<String, String>> listUnit = new ArrayList<Pair<String, String>>();
        String[] arg = new String[]{AticUtil.getText((String)"atic.analysis.common.unit.pps"), AticUtil.getText((String)"atic.analysis.common.unit.kbps"), "qps"};
        String[] key = new String[]{"1", "0", "2"};
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listUnit.add((Pair<String, String>)pair);
        }
        return listUnit;
    }

    public List<Pair<String, String>> getTopNFluxType() {
        ArrayList<Pair<String, String>> listFluxType = new ArrayList<Pair<String, String>>();
        String[] arg = new String[2];
        String[] key = new String[2];
        arg[0] = AticUtil.getText((String)"atic.analysis.common.flux.in");
        arg[1] = AticUtil.getText((String)"atic.analysis.common.flux.attack");
        key[0] = "1";
        key[1] = "2";
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listFluxType.add((Pair<String, String>)pair);
        }
        return listFluxType;
    }

    public List<Pair<String, String>> getFlowTopnType() {
        ArrayList<Pair<String, String>> listFluxType = new ArrayList<Pair<String, String>>();
        String[] arg = new String[3];
        String[] key = new String[3];
        arg[0] = AticUtil.getText((String)"atic.analysis.common.flux.in");
        arg[1] = AticUtil.getText((String)"atic.analysis.common.flux.attack");
        arg[2] = AticUtil.getText((String)"atic.analysis.common.flux.out");
        key[0] = "1";
        key[1] = "2";
        key[2] = "3";
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listFluxType.add((Pair<String, String>)pair);
        }
        return listFluxType;
    }

    public List<Pair<String, String>> getMaxOrAvgFlux() {
        ArrayList<Pair<String, String>> listMaxOrAvgFlux = new ArrayList<Pair<String, String>>();
        String[] arg = null;
        String[] key = new String[]{"1"};
        arg = new String[]{AticUtil.getText((String)"atic.analysis.common.flux.max")};
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listMaxOrAvgFlux.add((Pair<String, String>)pair);
        }
        return listMaxOrAvgFlux;
    }

    public List<Pair<String, String>> getMaxAndAvgFlux() {
        ArrayList<Pair<String, String>> listMaxOrAvgFlux = new ArrayList<Pair<String, String>>();
        String[] arg = new String[2];
        String[] key = new String[]{"1", "2"};
        arg[0] = AticUtil.getText((String)"atic.analysis.common.flux.max");
        arg[1] = AticUtil.getText((String)"atic.analysis.common.flux.avg");
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listMaxOrAvgFlux.add((Pair<String, String>)pair);
        }
        return listMaxOrAvgFlux;
    }

    public List<Pair<String, String>> getDnsRequestType() {
        ArrayList<Pair<String, String>> listDnsReqType = new ArrayList<Pair<String, String>>();
        String[] arg = null;
        String[] key = new String[]{"0", "1"};
        arg = new String[]{AticUtil.getText((String)"atic.analysis.dns.topn.request.domain"), AticUtil.getText((String)"atic.analysis.dns.topn.request.ip")};
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listDnsReqType.add((Pair<String, String>)pair);
        }
        return listDnsReqType;
    }

    public List<Pair<String, String>> getDnsTopNStatType() {
        ArrayList<Pair<String, String>> listDnsStatType = new ArrayList<Pair<String, String>>();
        String[] arg = null;
        String[] key = new String[]{"1", "0"};
        arg = new String[]{AticUtil.getText((String)"atic.analysis.dns.topn.stattype.average"), AticUtil.getText((String)"atic.analysis.dns.topn.stattype.current")};
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listDnsStatType.add((Pair<String, String>)pair);
        }
        return listDnsStatType;
    }

    public List<Pair<String, String>> getAttackLogType() {
        ArrayList<Pair<String, String>> listLogType = new ArrayList<Pair<String, String>>();
        String[] arg = new String[3];
        String[] key = new String[]{"0", "1", "2"};
        arg[0] = AticUtil.getText((String)"atic.analysis.common.all");
        arg[1] = AticUtil.getText((String)"atic.analysis.report.log.type.abnormal");
        arg[2] = AticUtil.getText((String)"atic.analysis.report.log.type.attack");
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listLogType.add((Pair<String, String>)pair);
        }
        return listLogType;
    }

    public List<Pair<String, String>> getAttackTypeDistribute() {
        ArrayList<Pair<String, String>> listLogType = new ArrayList<Pair<String, String>>();
        String[] arg = new String[2];
        String[] key = new String[]{"2", "1"};
        arg[0] = AticUtil.getText((String)"atic.analysis.report.log.type.attack");
        arg[1] = AticUtil.getText((String)"atic.analysis.report.log.type.abnormal");
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listLogType.add((Pair<String, String>)pair);
        }
        return listLogType;
    }

    public List<Pair<String, String>> getSelectType() {
        ArrayList<Pair<String, String>> selectTypeList = new ArrayList<Pair<String, String>>();
        String[] arg = new String[3];
        String[] key = new String[3];
        arg[0] = AticUtil.getText((String)"atic.analysis.report.dns.total");
        key[0] = "Total";
        arg[1] = "TCP";
        key[1] = "TCP";
        arg[2] = "UDP";
        key[2] = "UDP";
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            selectTypeList.add((Pair<String, String>)pair);
        }
        return selectTypeList;
    }

    public List<Pair<String, String>> getBisListForConn() {
        ArrayList<Pair<String, String>> listBis = new ArrayList<Pair<String, String>>();
        Pair pairAll = new Pair();
        pairAll.setKey((Object)"-1");
        pairAll.setValue((Object)AticUtil.getText((String)"atic.analysis.common.all"));
        listBis.add(pairAll);
        listBis.add(new Pair((Object)"0", (Object)"DEFAULT"));
        listBis.add(new Pair((Object)"1", (Object)"TCP"));
        listBis.add(new Pair((Object)"2", (Object)"UDP"));
        listBis.add(new Pair((Object)"3", (Object)"HTTP"));
        listBis.add(new Pair((Object)"4", (Object)"HTTPS"));
        listBis.add(new Pair((Object)"5", (Object)"DNS"));
        listBis.add(new Pair((Object)"6", (Object)"SIP"));
        return listBis;
    }

    public List<Pair<String, String>> getAvgOrMaxOfConn() {
        ArrayList<Pair<String, String>> listAvgOrMaxOfConn = new ArrayList<Pair<String, String>>();
        String[] key = new String[1];
        String[] value = new String[1];
        key[0] = "2";
        value[0] = AticUtil.getText((String)"atic.analysis.common.flux.avg");
        for (int i = 0; i < key.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)value[i]);
            listAvgOrMaxOfConn.add((Pair<String, String>)pair);
        }
        return listAvgOrMaxOfConn;
    }

    public List<Pair<String, String>> getAllDisplayAttackType() {
        ArrayList<Integer> tempLong = new ArrayList<Integer>();
        tempLong.add(0);
        tempLong.add(17);
        tempLong.add(21);
        tempLong.add(45);
        tempLong.add(46);
        tempLong.add(47);
        tempLong.add(48);
        ArrayList<Pair<String, String>> attackType = new ArrayList<Pair<String, String>>();
        for (int i = 0; i <= 2000; ++i) {
            if (tempLong.contains(i) || AnalysisConstants.NOT_REPORT_ATTACKTYPE.contains(i) || "ips".equalsIgnoreCase(AnalysisConstants.getInstance().getReportType()) && AnalysisConstants.NIP_NOT_CONTAIN_ATTACK_TYPE.contains(i)) continue;
            String attackTypeStr = AticUtil.getText((String)("atic.attack.type." + i));
            if (("atic.attack.type." + i).equals(attackTypeStr)) continue;
            Pair pair = new Pair();
            pair.setKey((Object)(i + ""));
            pair.setValue((Object)attackTypeStr);
            attackType.add((Pair<String, String>)pair);
        }
        for (Integer temp : tempLong) {
            if ("ips".equalsIgnoreCase(AnalysisConstants.getInstance().getReportType()) && AnalysisConstants.NIP_NOT_CONTAIN_ATTACK_TYPE.contains(temp)) continue;
            String attackTypeStr = AticUtil.getText((String)("atic.attack.type." + temp));
            if (("atic.attack.type." + temp).equals(attackTypeStr)) continue;
            Pair pair = new Pair();
            pair.setKey((Object)(temp + ""));
            pair.setValue((Object)attackTypeStr);
            attackType.add((Pair<String, String>)pair);
        }
        return attackType;
    }

    public List<Pair<String, String>> getAttackTopnSortType() {
        ArrayList<Pair<String, String>> listTopnSortType = new ArrayList<Pair<String, String>>();
        String[] arg = null;
        String[] key = new String[]{"0", "1"};
        arg = new String[]{AticUtil.getText((String)"atic.analysis.attack.topn.type.attacktime"), AticUtil.getText((String)"atic.analysis.attack.topn.type.droppackets")};
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listTopnSortType.add((Pair<String, String>)pair);
        }
        return listTopnSortType;
    }

    public List<Pair<String, String>> getOnlyCleanDeviceList() {
        try {
            if ("ips".equalsIgnoreCase(AnalysisConstants.getInstance().getReportType())) {
                return this.getDeviceList();
            }
            return this.processDeviceData4Atic();
        }
        catch (LegoCheckedException legoException) {
            logger.error((Object)("getDeviceList4AttackLog LegoCheckedException error:" + legoException.getErrorCode()));
            throw legoException;
        }
        catch (Exception e) {
            logger.error((Object)"getDeviceList4AttackLog unknow error", (Throwable)e);
            throw new LegoCheckedException(570507L, (Throwable)e);
        }
    }

    private List<Pair<String, String>> processDeviceData4Atic() {
        ArrayList<Pair<String, String>> listDev = new ArrayList<Pair<String, String>>();
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        User currentUser = (User)request.getSession().getAttribute("currentUser");
        List lstFireWall = ReportBisUtil.getIFirewallService().getAntiDDoSDevice(currentUser.getUserID());
        List accessDevIds = ReportBisUtil.getICollectorDeviceService().getAllDeviceAccess();
        if (null == lstFireWall || lstFireWall.isEmpty()) {
            return listDev;
        }
        for (int i = lstFireWall.size() - 1; i >= 0; --i) {
            AticDevice firewall = (AticDevice)lstFireWall.get(i);
            boolean isContain = false;
            for (Long devId : accessDevIds) {
                if (!devId.equals(firewall.getMoId())) continue;
                isContain = true;
                break;
            }
            if (isContain) continue;
            lstFireWall.remove(i);
        }
        if (lstFireWall.isEmpty()) {
            return listDev;
        }
        this.processCleanDevice(lstFireWall, listDev);
        return listDev;
    }

    private void processCleanDevice(List<AticDevice> lstFireWall, List<Pair<String, String>> listDev) {
        for (int i = 0; i < lstFireWall.size(); ++i) {
            Pair pair = new Pair();
            int deviceType = lstFireWall.get(i).getDdosType();
            String name = "";
            if (0 != deviceType && 2 != deviceType) continue;
            name = AticUtil.getText((String)"atic.analysis.common.clean");
            pair.setKey((Object)(lstFireWall.get(i).getMoId() + "_" + 0));
            pair.setValue((Object)(lstFireWall.get(i).getName() + name));
            listDev.add((Pair<String, String>)pair);
        }
    }

    public List<Pair<String, String>> getDeviceList4DnsAnalysis() {
        List<Pair<String, String>> singleDeviceList = this.getDeviceList4SlotFlow();
        return singleDeviceList;
    }

    public List<Pair<String, String>> getDNSType() {
        ArrayList<Pair<String, String>> selectTypeList = new ArrayList<Pair<String, String>>();
        String[] arg = new String[6];
        String[] key = new String[6];
        arg[0] = "DNS A";
        key[0] = "A";
        arg[1] = "DNS NS";
        key[1] = "NS";
        arg[2] = "DNS MX";
        key[2] = "MX";
        arg[3] = "DNS CNAME";
        key[3] = "CNNAME";
        arg[4] = "DNS SOA";
        key[4] = "SOA";
        arg[5] = "DNS AAAA";
        key[5] = "AAAA";
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            selectTypeList.add((Pair<String, String>)pair);
        }
        return selectTypeList;
    }

    public List<Pair<String, String>> getDNSRequestOrReplyType() {
        ArrayList<Pair<String, String>> selectTypeList = new ArrayList<Pair<String, String>>();
        String[] arg = new String[2];
        String[] key = new String[2];
        arg[0] = AticUtil.getText((String)"atic.analysis.common.dnsRequestType.request");
        key[0] = "request";
        arg[1] = AticUtil.getText((String)"atic.analysis.common.dnsRequestType.reply");
        key[1] = "reply";
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            selectTypeList.add((Pair<String, String>)pair);
        }
        return selectTypeList;
    }

    public List<Pair<String, String>> getBotType() {
        ArrayList<Pair<String, String>> botType = new ArrayList<Pair<String, String>>();
        String[] arg = null;
        String[] key = new String[]{"-1", "1", "2", "3"};
        arg = new String[]{AticUtil.getText((String)"atic.analysis.common.all"), "Worm", "Botnet", "DDoS"};
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            botType.add((Pair<String, String>)pair);
        }
        return botType;
    }

    public List<Pair<String, String>> getQueryType() {
        ArrayList<Pair<String, String>> botType = new ArrayList<Pair<String, String>>();
        String[] arg = null;
        String[] key = new String[]{"0", "1", "2"};
        arg = new String[]{AticUtil.getText((String)"atic.analysis.report.queryType.name"), AticUtil.getText((String)"atic.analysis.report.queryType.sourceIp"), AticUtil.getText((String)"atic.analysis.report.queryType.descIp")};
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            botType.add((Pair<String, String>)pair);
        }
        return botType;
    }

    public List<Pair<String, String>> getReportTopnType() {
        ArrayList<Pair<String, String>> botType = new ArrayList<Pair<String, String>>();
        String[] arg = null;
        String[] key = new String[2];
        key[1] = "0";
        key[0] = "2";
        arg = new String[2];
        arg[1] = AticUtil.getText((String)"atic.analysis.report.tab.zonetopn");
        arg[0] = AticUtil.getText((String)"atic.analysis.report.tab.iptopn");
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            botType.add((Pair<String, String>)pair);
        }
        return botType;
    }

    public List<Pair<String, String>> getAppFlowReportType() {
        ArrayList<Pair<String, String>> botType = new ArrayList<Pair<String, String>>();
        String[] arg = null;
        String[] key = new String[]{"0", "1"};
        arg = new String[]{AticUtil.getText((String)"atic.analysis.report.tab.flowcompare"), AticUtil.getText((String)"atic.analysis.report.tab.flowAppDistribute")};
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            botType.add((Pair<String, String>)pair);
        }
        return botType;
    }

    public List<Pair<String, String>> getAttackReportTopnType() {
        ArrayList<Pair<String, String>> botType = new ArrayList<Pair<String, String>>();
        String[] arg = new String[2];
        String[] key = new String[2];
        key[1] = "0";
        key[0] = "2";
        arg[1] = AticUtil.getText((String)"atic.analysis.report.tab.zoneAttackTopN");
        arg[0] = AticUtil.getText((String)"atic.analysis.report.tab.ipAttackTopN");
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            botType.add((Pair<String, String>)pair);
        }
        return botType;
    }

    public List<Pair<String, String>> getTcpConIpType() {
        ArrayList<Pair<String, String>> listDnsReqType = new ArrayList<Pair<String, String>>();
        String[] arg = null;
        String[] key = new String[]{"0", "1"};
        arg = new String[]{AticUtil.getText((String)"atic.analysis.dns.topn.request.decIp"), AticUtil.getText((String)"atic.analysis.dns.topn.request.srcIp")};
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listDnsReqType.add((Pair<String, String>)pair);
        }
        return listDnsReqType;
    }

    public List<Pair<String, String>> getDirection() {
        ArrayList<Pair<String, String>> direction = new ArrayList<Pair<String, String>>();
        String[] arg = new String[2];
        String[] key = new String[]{"1", "2"};
        arg[0] = "Inbound";
        arg[1] = "Outbound";
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            direction.add((Pair<String, String>)pair);
        }
        return direction;
    }

    public List<Pair<String, String>> getDirection4Compare() {
        ArrayList<Pair<String, String>> direction = new ArrayList<Pair<String, String>>();
        String[] arg = new String[3];
        String[] key = new String[]{"1", "2", "0"};
        arg[0] = "Inbound";
        arg[1] = "Outbound";
        arg[2] = "All";
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            direction.add((Pair<String, String>)pair);
        }
        return direction;
    }

    public List<Pair<String, String>> getPort() {
        ArrayList<Pair<String, String>> portList = new ArrayList<Pair<String, String>>();
        String[] arg = new String[2];
        String[] key = new String[]{"0", "1"};
        arg[0] = AticUtil.getText((String)"atic.analysis.common.all");
        arg[1] = AticUtil.getText((String)"atic.analysis.common.inputPort");
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            portList.add((Pair<String, String>)pair);
        }
        return portList;
    }
}

