/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.util;

import com.hs.atic.analysis.util.StopTimeComparator;
import com.hs.atic.analysis.util.WrokTimeComparator;
import com.hs.atic.sdk.analysis.form.DeviceStopTimeForm;
import com.hs.atic.sdk.analysis.form.DeviceWorkTimeForm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DeviceWrokTimeUtil {
    public List<DeviceWorkTimeForm> getDeviceWorkTimeList(Map<String, List<DeviceStopTimeForm>> stopMap, Long startTime, Long endTime) {
        ArrayList<DeviceWorkTimeForm> allWorkList = new ArrayList<DeviceWorkTimeForm>();
        HashMap<String, List<DeviceWorkTimeForm>> workMap = new HashMap<String, List<DeviceWorkTimeForm>>();
        if (null == stopMap) {
            return allWorkList;
        }
        for (Map.Entry<String, List<DeviceStopTimeForm>> stop : stopMap.entrySet()) {
            List<DeviceWorkTimeForm> workTimeList = this.getDeviceWorkList(stop.getValue(), startTime, endTime);
            if (null == workTimeList || workTimeList.isEmpty()) continue;
            workMap.put(stop.getKey(), workTimeList);
        }
        List<DeviceStopTimeForm> stopList = null;
        Iterator iterator = workMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry workOne = iterator.next();
            allWorkList.addAll((Collection)workOne.getValue());
            stopList = stopMap.get(workOne.getKey());
            workMap.remove(workOne.getKey());
        }
        for (Map.Entry workTwo : workMap.entrySet()) {
            if (null == stopList || stopList.isEmpty()) break;
            List<DeviceWorkTimeForm> workList = this.getWorkTimeList(stopList, (List)workTwo.getValue());
            if (!workList.isEmpty()) {
                allWorkList.addAll(workList);
            }
            stopList = this.getDeviceStopList(allWorkList, startTime, endTime);
        }
        return allWorkList;
    }

    public List<DeviceWorkTimeForm> getDeviceWorkList(List<DeviceStopTimeForm> stopList, Long startTime, Long endTime) {
        if (null == stopList) {
            return null;
        }
        Collections.sort(stopList, new StopTimeComparator());
        DeviceWorkTimeForm work = null;
        ArrayList<DeviceWorkTimeForm> workTimeList = new ArrayList<DeviceWorkTimeForm>();
        DeviceStopTimeForm prior = stopList.get(0);
        if (prior.getStopTime() > startTime) {
            work = new DeviceWorkTimeForm();
            work.setDeviceIp(prior.getDeviceIp());
            work.setDeviceType(prior.getDeviceType());
            work.setCollectorIp(prior.getCollectorIp());
            work.setStartTime(startTime);
            work.setEndTime(prior.getStopTime());
            workTimeList.add(work);
        }
        for (int i = 1; i < stopList.size(); ++i) {
            work = new DeviceWorkTimeForm();
            DeviceStopTimeForm next = stopList.get(i);
            if (prior.getStartTime().compareTo(next.getStopTime()) != 0) {
                work.setDeviceIp(next.getDeviceIp());
                work.setDeviceType(next.getDeviceType());
                work.setCollectorIp(next.getCollectorIp());
                work.setStartTime(prior.getStartTime());
                work.setEndTime(next.getStopTime());
                workTimeList.add(work);
            }
            prior = next;
        }
        if (prior.getStartTime() < endTime) {
            work = new DeviceWorkTimeForm();
            work.setDeviceIp(prior.getDeviceIp());
            work.setDeviceType(prior.getDeviceType());
            work.setCollectorIp(prior.getCollectorIp());
            work.setStartTime(prior.getStartTime());
            work.setEndTime(endTime);
            workTimeList.add(work);
        }
        return workTimeList;
    }

    public List<DeviceWorkTimeForm> getWorkTimeList(List<DeviceStopTimeForm> stopList, List<DeviceWorkTimeForm> workList) {
        ArrayList<DeviceWorkTimeForm> deviceWorkList = new ArrayList<DeviceWorkTimeForm>();
        if (null == stopList) {
            return deviceWorkList;
        }
        Long startTime = null;
        Long endTime = null;
        for (DeviceStopTimeForm stop : stopList) {
            startTime = stop.getStopTime();
            endTime = stop.getStartTime();
            for (DeviceWorkTimeForm work : workList) {
                DeviceWorkTimeForm tempWork;
                if (work.getStartTime() <= startTime && work.getEndTime() >= endTime) {
                    tempWork = new DeviceWorkTimeForm();
                    tempWork.setDeviceIp(work.getDeviceIp());
                    tempWork.setDeviceType(work.getDeviceType());
                    tempWork.setCollectorIp(work.getCollectorIp());
                    tempWork.setStartTime(startTime);
                    tempWork.setEndTime(endTime);
                    deviceWorkList.add(tempWork);
                    continue;
                }
                if (work.getStartTime() <= startTime && work.getEndTime() < endTime && work.getEndTime() > startTime) {
                    tempWork = new DeviceWorkTimeForm();
                    tempWork.setDeviceIp(work.getDeviceIp());
                    tempWork.setDeviceType(work.getDeviceType());
                    tempWork.setCollectorIp(work.getCollectorIp());
                    tempWork.setStartTime(startTime);
                    tempWork.setEndTime(work.getEndTime());
                    deviceWorkList.add(tempWork);
                    continue;
                }
                if (work.getStartTime() > startTime && work.getStartTime() < endTime && work.getEndTime() >= endTime) {
                    tempWork = new DeviceWorkTimeForm();
                    tempWork.setDeviceIp(work.getDeviceIp());
                    tempWork.setDeviceType(work.getDeviceType());
                    tempWork.setCollectorIp(work.getCollectorIp());
                    tempWork.setStartTime(work.getStartTime());
                    tempWork.setEndTime(endTime);
                    deviceWorkList.add(tempWork);
                    continue;
                }
                if (work.getStartTime() - startTime <= 0L || work.getEndTime() - endTime >= 0L || work.getStartTime() - work.getEndTime() == 0L) continue;
                tempWork = new DeviceWorkTimeForm();
                tempWork.setDeviceIp(work.getDeviceIp());
                tempWork.setDeviceType(work.getDeviceType());
                tempWork.setCollectorIp(work.getCollectorIp());
                tempWork.setStartTime(work.getStartTime());
                tempWork.setEndTime(work.getEndTime());
                deviceWorkList.add(tempWork);
            }
        }
        return deviceWorkList;
    }

    public List<DeviceStopTimeForm> getDeviceStopList(List<DeviceWorkTimeForm> workList, Long startTime, Long endTime) {
        ArrayList<DeviceStopTimeForm> stopTimeList = new ArrayList<DeviceStopTimeForm>();
        if (null == workList) {
            return stopTimeList;
        }
        Collections.sort(workList, new WrokTimeComparator());
        DeviceStopTimeForm stop = null;
        DeviceWorkTimeForm prior = workList.get(0);
        if (prior.getStartTime() > startTime) {
            stop = new DeviceStopTimeForm();
            stop.setStopTime(startTime);
            stop.setStartTime(prior.getStartTime());
            stopTimeList.add(stop);
        }
        for (int i = 1; i < workList.size(); ++i) {
            stop = new DeviceStopTimeForm();
            DeviceWorkTimeForm next = workList.get(i);
            if (prior.getEndTime().compareTo(next.getStartTime()) != 0) {
                stop.setStopTime(prior.getEndTime());
                stop.setStartTime(next.getStartTime());
                stopTimeList.add(stop);
            }
            prior = next;
        }
        if (prior.getEndTime() < endTime) {
            stop = new DeviceStopTimeForm();
            stop.setStopTime(prior.getEndTime());
            stop.setStartTime(endTime);
            stopTimeList.add(stop);
        }
        return stopTimeList;
    }

    public DeviceWorkTimeForm getWorkForm(Map<String, List<DeviceStopTimeForm>> formMap) {
        DeviceWorkTimeForm workForm = null;
        for (Map.Entry<String, List<DeviceStopTimeForm>> map : formMap.entrySet()) {
            for (DeviceStopTimeForm stopTime : map.getValue()) {
                if (stopTime.getHave() != 0) continue;
                workForm = new DeviceWorkTimeForm();
                workForm.setDeviceIp(stopTime.getDeviceIp());
                workForm.setDeviceType(stopTime.getDeviceType());
                return workForm;
            }
        }
        return workForm;
    }
}

