/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.util;

import com.hs.atic.analysis.report.attack.attackcounttrend.AttackCountTrend;
import com.hs.atic.analysis.report.attack.attacktype.AtackTypeDistribute;
import com.hs.atic.analysis.report.dns.topn.DnsGraph;
import com.hs.atic.analysis.report.dns.topn.DnsReplyInTopNDataSet;
import com.hs.atic.analysis.report.dns.topn.DnsReplyInTopNStaticData;
import com.hs.atic.analysis.report.dns.topn.DnsRequestInTopNDataSet;
import com.hs.atic.analysis.report.dns.topn.DnsRequestInTopNStaticData;
import com.hs.atic.analysis.report.dns.topn.DnsRequestOutTopNDataSet;
import com.hs.atic.analysis.report.dns.topn.DnsRequestOutTopNStaticData;
import com.hs.atic.analysis.report.dns.topn.DnsRequestSrcIpInTopNStaticData;
import com.hs.atic.analysis.report.dns.topn.DnsRequestSrcIpOutTopNStaticData;
import com.hs.atic.analysis.report.dns.topn.HttpHostInTopNDataSet;
import com.hs.atic.analysis.report.dns.topn.HttpHostInTopNStaticData;
import com.hs.atic.analysis.report.dns.topn.HttpSrcInTopNDataSet;
import com.hs.atic.analysis.report.dns.topn.HttpSrcInTopNStaticData;
import com.hs.atic.analysis.report.dns.topn.HttpSrcOutTopNDataSet;
import com.hs.atic.analysis.report.dns.topn.HttpSrcOutTopNStaticData;
import com.hs.atic.analysis.report.dns.topn.HttpUrlInTopNDataSet;
import com.hs.atic.analysis.report.dns.topn.HttpUrlInTopNStaticData;
import com.hs.atic.analysis.report.dns.topn.HttpsSrcInTopNDataSet;
import com.hs.atic.analysis.report.dns.topn.HttpsSrcInTopNStaticData;
import com.hs.atic.analysis.report.dns.topn.HttpsSrcOutTopNDataSet;
import com.hs.atic.analysis.report.dns.topn.HttpsSrcOutTopNStaticData;
import com.hs.atic.analysis.report.dns.topn.SipCalleeInTopNDataSet;
import com.hs.atic.analysis.report.dns.topn.SipCalleeInTopNStaticData;
import com.hs.atic.analysis.report.dns.topn.SipCallerInTopNDataSet;
import com.hs.atic.analysis.report.dns.topn.SipCallerInTopNStaticData;
import com.hs.atic.analysis.report.dns.topn.SipSrcInTopNDataSet;
import com.hs.atic.analysis.report.dns.topn.SipSrcInTopNStaticData;
import com.hs.atic.analysis.report.flux.flowcompare.FlowCompareComparator;
import com.hs.atic.analysis.report.integration.AvgAndMaxView;
import com.hs.atic.analysis.report.integration.TransmitAttackCountTrendData;
import com.hs.atic.analysis.report.integration.datasource.AllReportHaveDataCache;
import com.hs.atic.analysis.report.integration.datasource.TransmitAttackDurationData;
import com.hs.atic.analysis.report.integration.datasource.TransmitAttackTrafficPeak;
import com.hs.atic.analysis.report.integration.datasource.TransmitAttackVectorData;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.DataEncodeUtil;
import com.hs.atic.analysis.util.DataSourceStub;
import com.hs.atic.analysis.util.DeviceWrokTimeUtil;
import com.hs.atic.analysis.util.RedunDeviceForm;
import com.hs.atic.analysis.util.ReportAticUtil;
import com.hs.atic.analysis.util.TopNPara4ReportPrepareObj;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.AnalyzeSuccessRateConditionForm;
import com.hs.atic.sdk.analysis.form.AttackExactLogForm;
import com.hs.atic.sdk.analysis.form.AttackTopnForm;
import com.hs.atic.sdk.analysis.form.BaseConditionForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.DeviceStopTimeForm;
import com.hs.atic.sdk.analysis.form.DeviceWorkTimeForm;
import com.hs.atic.sdk.analysis.form.FlowCompareConditionForm;
import com.hs.atic.sdk.analysis.form.FlowCompareForm;
import com.hs.atic.sdk.analysis.form.NormalAbnormalConditionForm;
import com.hs.atic.sdk.analysis.form.StopTimeQueryForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.bis.form.IpLocation;
import com.hs.atic.sdk.bis.form.LocationCustomForm;
import com.hs.atic.sdk.bis.service.ILibraryFileService;
import com.hs.atic.sdk.bis.service.ILocationCustomService;
import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.vsm.common.sdk.ireport.service.IReportEmailInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.sdk.bis.service.IDefendGroupService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import com.huawei.atic.util.CommonUtil;
import com.opensymphony.xwork2.ActionContext;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportUtil;
import com.security.logserver.module.condition.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.BeanUtils;

public final class ReportAnalysisUtil {
    public static final String TAB_SPACE = "   ";
    private static final int R = 0;
    private static final int G = 1;
    private static final int B = 2;
    private static final Long NUM_THREE_HUNDRED = 300L;
    private static final Long NUM_THREE_THOUSAND_SIX_HUNDRED = 3600L;
    private static final Long NUM_SIXTY = 60L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static final String IREPORT_DB_PATH = "/vsm_conf/ireport/IreportDB.conf";
    private static Boolean checkReadDBFile = false;
    private static String driveClass = "";
    private static String url = "";
    private static String userName = "";
    private static String password = "";
    private static String iReportDBType = "";

    private ReportAnalysisUtil() {
    }

    public static IDataStatService getDataStatService() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            IDataStatService dataStatService = (IDataStatService)context.getService("dataStatService", IDataStatService.class);
            if (dataStatService != null) {
                return dataStatService;
            }
            throw new LegoCheckedException(570506L);
        }
        throw new LegoCheckedException(570506L);
    }

    public static IUserMgr getUserMgr() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            IUserMgr userMgr = (IUserMgr)context.getService("userMgr", IUserMgr.class);
            if (userMgr != null) {
                return userMgr;
            }
            logger.error((Object)"get user/usermgr service error");
            throw new LegoCheckedException(570506L);
        }
        logger.error((Object)"get user/usermgr service error");
        throw new LegoCheckedException(570506L);
    }

    public static ISysOptLog getSysOptLog() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            ISysOptLog sysOptLog = (ISysOptLog)context.getService("sysLogService", ISysOptLog.class);
            if (sysOptLog != null) {
                return sysOptLog;
            }
            logger.error((Object)"get sysLogService service error");
            throw new LegoCheckedException(570506L);
        }
        logger.error((Object)"get sysLogService service error");
        throw new LegoCheckedException(570506L);
    }

    public static IZoneMgrNorthSerice getZoneMgrNorthSerice() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            IZoneMgrNorthSerice zoneMgrNorthSerice = (IZoneMgrNorthSerice)context.getService("zoneMgrNorthSerice", IZoneMgrNorthSerice.class);
            if (zoneMgrNorthSerice != null) {
                return zoneMgrNorthSerice;
            }
            throw new LegoCheckedException(570506L);
        }
        throw new LegoCheckedException(570506L);
    }

    public static ICommonUtilService getCommonUtilService() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            ICommonUtilService commonUtilService = (ICommonUtilService)context.getService("commonUtilService", ICommonUtilService.class);
            if (commonUtilService != null) {
                return commonUtilService;
            }
            throw new LegoCheckedException(570506L);
        }
        throw new LegoCheckedException(570506L);
    }

    public static String toIsoCode(String s) {
        s = ReportAnalysisUtil.changeReportFileName(s);
        String name = "";
        try {
            byte[] b = s.getBytes("gbk");
            name = new String(b, "iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"toIsoCode error", (Throwable)e);
        }
        return name;
    }

    public static String changeReportFileName(String name) {
        return name.replaceAll("[/\\:*?\"<>|]", "-");
    }

    public static Integer getTimeSpanType(long endTime, long startTime) {
        Long spanTime = endTime - startTime;
        if (spanTime < (long)AnalysisConstants.ONE_DAY_BY_SECOND.intValue()) {
            return AnalysisConstants.LESS_THAN_ONE_DAY;
        }
        if (spanTime < (long)AnalysisConstants.SEVEN_DAY_BY_SECOND.intValue() && spanTime >= (long)AnalysisConstants.ONE_DAY_BY_SECOND.intValue()) {
            return AnalysisConstants.LESS_THAN_SEVEN_DAYS;
        }
        return AnalysisConstants.MORE_THAN_SEVEN_DAYS;
    }

    public static long getRealStartTime(long start, long end) {
        long span = end - start;
        long gra = 0L;
        if (span < (long)AnalysisConstants.ONE_DAY_BY_SECOND.intValue() && span >= 0L) {
            gra = NUM_THREE_HUNDRED;
        } else if (span < (long)AnalysisConstants.SEVEN_DAY_BY_SECOND.intValue() && span >= (long)AnalysisConstants.ONE_DAY_BY_SECOND.intValue()) {
            gra = NUM_THREE_THOUSAND_SIX_HUNDRED;
        } else if (span >= (long)AnalysisConstants.SEVEN_DAY_BY_SECOND.intValue()) {
            return ReportAnalysisUtil.processStartTime(start);
        }
        return start - start % gra;
    }

    public static long processStartTime(long startTime) {
        if (Long.valueOf(startTime) == null) {
            return 0L;
        }
        long timeLong = 0L;
        try {
            SimpleDateFormat fromate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date(startTime * 1000L);
            String timeString = fromate.format(date);
            StringBuffer bufferTime = new StringBuffer(timeString.split(" ")[0]);
            bufferTime.append(" 00:00:00");
            Date startDate = fromate.parse(bufferTime.toString().trim());
            timeLong = startDate.getTime() / 1000L;
        }
        catch (ParseException ex) {
            logger.error((Object)"Parse time exception to start time !", (Throwable)ex);
        }
        return timeLong;
    }

    public static String getDisplayAttackType(String attackType) {
        if (null == attackType || "".equals(attackType.trim())) {
            return "-";
        }
        String[] ats = attackType.split(",");
        StringBuffer returnStr = new StringBuffer();
        for (int i = 0; i < ats.length; ++i) {
            String attackTypeStr = "";
            attackTypeStr = Long.parseLong(ats[i]) >= 0L && Long.parseLong(ats[i]) < 10L ? AticUtil.getText((String)"atic.attack.type.0") : (Long.parseLong(ats[i]) >= 2000L && Long.parseLong(ats[i]) < 80000L ? ReportAticUtil.processFilterSubAttackName(Long.parseLong(ats[i])) : (Long.parseLong(ats[i]) >= 80000L ? ReportAticUtil.processNPFilterSubAttackName(Long.parseLong(ats[i])) : AticUtil.getText((String)("atic.attack.type." + Long.parseLong(ats[i])))));
            if (0 == i) {
                returnStr.append(attackTypeStr);
                continue;
            }
            returnStr.append(";" + attackTypeStr);
        }
        return returnStr.toString();
    }

    public static String longTimeToHMS(long time) {
        long temp = time % NUM_THREE_THOUSAND_SIX_HUNDRED;
        long h = (time - temp) / 3600L;
        long temp2 = temp % NUM_SIXTY;
        long m = (temp - temp2) / 60L;
        return (h < 10L ? "0" + h : Long.valueOf(h)) + ":" + (m < 10L ? "0" + m : Long.valueOf(m)) + ":" + (temp2 < 10L ? "0" + temp2 : Long.valueOf(temp2));
    }

    public static String longTimeToTotalHMS(long time, Locale locale) {
        long temp = time % NUM_THREE_THOUSAND_SIX_HUNDRED;
        long h = (time - temp) / 3600L;
        long temp2 = temp % NUM_SIXTY;
        long m = (temp - temp2) / 60L;
        return h + AticUtil.getText((String)"atic.analysis.report.totalTime.hour", (Locale)locale) + (m < 10L ? "0" + m : Long.valueOf(m)) + AticUtil.getText((String)"atic.analysis.report.totalTime.minute", (Locale)locale) + (temp2 < 10L ? "0" + temp2 : Long.valueOf(temp2)) + AticUtil.getText((String)"atic.analysis.report.totalTime.second", (Locale)locale);
    }

    public static Boolean isV1(AticDevice firewall) {
        if (null == firewall) {
            return false;
        }
        try {
            ICommonUtilService commonUtilService = ReportAnalysisUtil.getCommonUtilService();
            String versionStr = commonUtilService.getDDoSVersion(firewall.getIpAddress());
            if ("1".equals(versionStr) || "2".equals(versionStr)) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.error((Object)"check device version is v1 error", (Throwable)e);
            return false;
        }
    }

    public static List<Pair<String, String>> processDafaultBizPro(Boolean isV1, String zoneId, String displayZoneIp) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        if (0L == ReportAnalysisUtil.processStr2Long(zoneId) && AticUtil.isNull((String)displayZoneIp)) {
            result.addAll(ReportAnalysisUtil.getDefaultProtocolList());
        } else if (ReportAnalysisUtil.processStr2Long(zoneId) > 0L && AticUtil.isNull((String)displayZoneIp)) {
            result.addAll(ReportAnalysisUtil.getDefaultProtocolList());
            if (isV1.booleanValue()) {
                result.addAll(AnalysisConstants.PROTOCOL_V1_LIST);
            }
        } else if (!AticUtil.isNull((String)displayZoneIp)) {
            result.addAll(ReportAnalysisUtil.getProtocolList());
            if (isV1.booleanValue()) {
                result.addAll(AnalysisConstants.PROTOCOL_V1_LIST);
            }
        } else {
            result.addAll(ReportAnalysisUtil.getDefaultProtocolList());
        }
        return result;
    }

    public static boolean isAllDetect(String deviceId) {
        return !ReportAnalysisUtil.isMixed(deviceId) && -2 == Integer.parseInt(deviceId);
    }

    public static boolean isAllClean(String deviceId) {
        return !ReportAnalysisUtil.isMixed(deviceId) && -1 == Integer.parseInt(deviceId);
    }

    public static boolean isMixed(String deviceId) {
        return deviceId.contains("_");
    }

    public static List<AticDevice> processDeviceParam(String deviceId, BaseConditionForm conditionForm, Long currentLogUserId) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        List<Object> firewallList = null;
        if (ReportAnalysisUtil.isAllClean(deviceId)) {
            conditionForm.setDeviceType(0);
            datastatConditionForm.setDeviceId(Long.parseLong(deviceId));
            firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
        } else if (ReportAnalysisUtil.isAllDetect(deviceId)) {
            conditionForm.setDeviceType(1);
            datastatConditionForm.setDeviceId(Long.parseLong(deviceId));
            firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
        } else {
            firewallList = new ArrayList();
            AticDevice firewall = null;
            if (ReportAnalysisUtil.isMixed(deviceId)) {
                datastatConditionForm.setDeviceId(Long.parseLong(deviceId.split("_")[0]));
                firewall = firewallService.getDeviceByMoid(Long.parseLong(deviceId.split("_")[0]));
            } else {
                datastatConditionForm.setDeviceId(Long.parseLong(deviceId));
                firewall = firewallService.getDeviceByMoid(Long.parseLong(deviceId));
            }
            firewallList.add(firewall);
            int ddosType = ReportAnalysisUtil.getDeviceDdos(firewall);
            conditionForm.setDeviceType(ReportAnalysisUtil.isMixed(deviceId) ? Integer.parseInt(deviceId.split("_")[1]) : ddosType);
        }
        return firewallList;
    }

    public static List<AticDevice> processDeviceParam4DnsAnalysis(String deviceId, BaseConditionForm conditionForm, Long currentLogUserId) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        List<Object> firewallList = null;
        if (ReportAnalysisUtil.isAllClean(deviceId)) {
            conditionForm.setDeviceType(0);
            datastatConditionForm.setDeviceId(Long.parseLong(deviceId));
            firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect4DnsAnalysis(datastatConditionForm, currentLogUserId);
        } else if (ReportAnalysisUtil.isAllDetect(deviceId)) {
            conditionForm.setDeviceType(1);
            datastatConditionForm.setDeviceId(Long.parseLong(deviceId));
            firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect4DnsAnalysis(datastatConditionForm, currentLogUserId);
        } else {
            firewallList = new ArrayList();
            AticDevice firewall = null;
            if (ReportAnalysisUtil.isMixed(deviceId)) {
                datastatConditionForm.setDeviceId(Long.parseLong(deviceId.split("_")[0]));
                firewall = firewallService.getDeviceByMoid(Long.parseLong(deviceId.split("_")[0]));
            } else {
                datastatConditionForm.setDeviceId(Long.parseLong(deviceId));
                firewall = firewallService.getDeviceByMoid(Long.parseLong(deviceId));
            }
            firewallList.add(firewall);
            int ddosType = ReportAnalysisUtil.getDeviceDdos(firewall);
            conditionForm.setDeviceType(ReportAnalysisUtil.isMixed(deviceId) ? Integer.parseInt(deviceId.split("_")[1]) : ddosType);
        }
        return firewallList;
    }

    public static int getDeviceDdos(AticDevice firewall) {
        int ddosType = 1;
        if (firewall instanceof AticDevice) {
            AticDevice temp = firewall;
            ddosType = temp.getDdosType();
        }
        return ddosType;
    }

    public static Map<Long, List<AticDevice>> getCollectDevMap(List<AticDevice> firewallList) {
        ICollectorService collectorService = ReportBisUtil.getICollectorService();
        HashMap<Long, List<AticDevice>> returnMap = new HashMap<Long, List<AticDevice>>();
        for (AticDevice firewall : firewallList) {
            Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
            if (null == collectorId || null == collectorService.getCollectorInfo(collectorId.longValue())) {
                logger.warn((Object)("no collector found, device is : " + firewall.getName()));
                continue;
            }
            if (2 == collectorService.getCollectorInfo(collectorId.longValue()).getStatus()) {
                logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + collectorService.getCollectorInfo(collectorId.longValue()).getIpAddress()));
                throw new LegoCheckedException(570504L);
            }
            if (null != returnMap.get(collectorId)) {
                ((List)returnMap.get(collectorId)).add(firewall);
                continue;
            }
            ArrayList<AticDevice> tmpList = new ArrayList<AticDevice>();
            tmpList.add(firewall);
            returnMap.put(collectorId, tmpList);
        }
        return returnMap;
    }

    public static Map<String, List<String>> generateCollectorDeviceMap(String deviceId, List<AticDevice> firewallList, Map<String, List<String>> collectorDeviceMap) {
        ICollectorService collectorService = ReportBisUtil.getICollectorService();
        for (AticDevice firewall : firewallList) {
            if (!ReportAnalysisUtil.isAllClean(deviceId) && !ReportAnalysisUtil.isAllDetect(deviceId) && null == firewall) {
                logger.error((Object)("no device exist,deviceId = " + deviceId));
                throw new LegoCheckedException(570502L);
            }
            CollectorInfo collectorInfo = null;
            Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
            if (null == collectorId || null == (collectorInfo = collectorService.getCollectorInfo(collectorId.longValue()))) {
                logger.warn((Object)("no collector found, device is : " + firewall.getName()));
                if (ReportAnalysisUtil.isAllClean(deviceId) || ReportAnalysisUtil.isAllDetect(deviceId)) continue;
                throw new LegoCheckedException(570512L);
            }
            if (2 == collectorInfo.getStatus()) {
                logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + collectorService.getCollectorInfo(collectorId.longValue()).getIpAddress()));
                throw new LegoCheckedException(570504L);
            }
            List<String> deviceIpList = collectorDeviceMap.get(collectorInfo.getIpAddress());
            if (null == deviceIpList) {
                deviceIpList = new ArrayList<String>();
                collectorDeviceMap.put(collectorInfo.getIpAddress(), deviceIpList);
            }
            if (deviceIpList.contains(firewall.getIpAddress())) continue;
            deviceIpList.add(firewall.getIpAddress());
        }
        return collectorDeviceMap;
    }

    public static Object copyProperties(Object source, Object target) {
        if (null == source || null == target) {
            return null;
        }
        try {
            BeanUtils.copyProperties((Object)source, (Object)target);
        }
        catch (Exception e) {
            logger.error((Object)"exception occured in AnalyzeUtil.copyProperties method", (Throwable)e);
        }
        return target;
    }

    public static int getGra(Long start, Long end) {
        Long startTime = ReportAnalysisUtil.getRealStartTime(start, end);
        Date date = new Date();
        Long now = date.getTime();
        if (end > now / 1000L) {
            end = now / 1000L;
        }
        long span = end - startTime;
        int gra = 1;
        if (span < AnalysisConstants.ONE_DAY && span >= 0L) {
            gra = (int)(span / AnalysisConstants.FIVE_MIN) + 1;
        } else if (span < AnalysisConstants.ONE_WEEK && span >= AnalysisConstants.ONE_DAY) {
            gra = (int)(span / AnalysisConstants.ONE_HOUR) + 1;
        } else if (span < AnalysisConstants.ONE_YEAR && span >= AnalysisConstants.ONE_WEEK) {
            gra = (int)(span / AnalysisConstants.ONE_DAY) + 1;
        }
        return gra;
    }

    public static List<Pair<String, String>> getProtocolList() {
        ArrayList<Pair<String, String>> protocolList = new ArrayList<Pair<String, String>>();
        protocolList.add(new Pair((Object)"0", (Object)AticUtil.getText((String)"atic.analysis.common.all")));
        protocolList.add(new Pair((Object)"1", (Object)"TCP"));
        protocolList.add(new Pair((Object)"2", (Object)"UDP"));
        protocolList.add(new Pair((Object)"3", (Object)"ICMP"));
        protocolList.add(new Pair((Object)"4", (Object)"OTHER"));
        protocolList.add(new Pair((Object)"5", (Object)"TCP Fragment"));
        protocolList.add(new Pair((Object)"6", (Object)"UDP Fragment"));
        protocolList.add(new Pair((Object)"7", (Object)"SYN"));
        protocolList.add(new Pair((Object)"8", (Object)"SYN-ACK"));
        protocolList.add(new Pair((Object)"9", (Object)"ACK"));
        protocolList.add(new Pair((Object)"10", (Object)"FIN/RST"));
        return protocolList;
    }

    public static List<Pair<String, String>> getDefaultProtocolList() {
        ArrayList<Pair<String, String>> protocolList = new ArrayList<Pair<String, String>>();
        protocolList.add(new Pair((Object)"0", (Object)AticUtil.getText((String)"atic.analysis.common.all")));
        protocolList.add(new Pair((Object)"1", (Object)"TCP"));
        protocolList.add(new Pair((Object)"2", (Object)"UDP"));
        protocolList.add(new Pair((Object)"3", (Object)"ICMP"));
        protocolList.add(new Pair((Object)"4", (Object)"OTHER"));
        return protocolList;
    }

    public static Map<String, List<Pair<String, String>>> getBizType2ProtocolTypeMap(Boolean isV1) {
        HashMap<String, List<Pair<String, String>>> resultMap = new HashMap<String, List<Pair<String, String>>>();
        if (isV1.booleanValue()) {
            ArrayList<Pair<String, String>> temp = new ArrayList<Pair<String, String>>();
            temp.addAll(ReportAnalysisUtil.getProtocolList());
            temp.addAll(AnalysisConstants.PROTOCOL_V1_LIST);
            resultMap.put("-1", temp);
            resultMap.put("0", temp);
        } else {
            resultMap.put("-1", ReportAnalysisUtil.getProtocolList());
            resultMap.put("0", ReportAnalysisUtil.getProtocolList());
        }
        ArrayList<Pair> tCP0HTTP0S0LIST = new ArrayList<Pair>();
        tCP0HTTP0S0LIST.add(new Pair((Object)"1", (Object)"TCP"));
        tCP0HTTP0S0LIST.add(new Pair((Object)"7", (Object)"SYN"));
        tCP0HTTP0S0LIST.add(new Pair((Object)"8", (Object)"SYN-ACK"));
        tCP0HTTP0S0LIST.add(new Pair((Object)"9", (Object)"ACK"));
        tCP0HTTP0S0LIST.add(new Pair((Object)"10", (Object)"FIN/RST"));
        resultMap.put("1", tCP0HTTP0S0LIST);
        resultMap.put("3", tCP0HTTP0S0LIST);
        resultMap.put("4", tCP0HTTP0S0LIST);
        resultMap.put("5", tCP0HTTP0S0LIST);
        ArrayList<Pair> uDPSIP = new ArrayList<Pair>();
        uDPSIP.add(new Pair((Object)"2", (Object)"UDP"));
        resultMap.put("2", uDPSIP);
        resultMap.put("7", uDPSIP);
        resultMap.put("6", uDPSIP);
        ArrayList<Pair> other = new ArrayList<Pair>();
        other.add(new Pair((Object)"16", (Object)"Other"));
        resultMap.put("8", other);
        return resultMap;
    }

    public static Map<String, String> getExactLogAttackStatus(Locale locale) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("0", AticUtil.getText((String)"atic.analysis.exact.log.status.end", (Locale)locale));
        resultMap.put("1", AticUtil.getText((String)"atic.analysis.exact.log.status.abnormal", (Locale)locale));
        resultMap.put("2", AticUtil.getText((String)"atic.analysis.exact.log.status.attack", (Locale)locale));
        return resultMap;
    }

    public static Map<String, String> getExactLogAttackStatus() {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("0", AticUtil.getText((String)"atic.analysis.exact.log.status.end"));
        resultMap.put("1", AticUtil.getText((String)"atic.analysis.exact.log.status.abnormal"));
        resultMap.put("2", AticUtil.getText((String)"atic.analysis.exact.log.status.attack"));
        return resultMap;
    }

    public static Map<String, String> getLogAttackStatus() {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("0", "atic.analysis.exact.log.status.end");
        resultMap.put("1", "atic.analysis.exact.log.status.abnormal");
        resultMap.put("2", "atic.analysis.exact.log.status.attack");
        return resultMap;
    }

    public static int getGapTime(int spanTimeType) {
        if (spanTimeType == AnalysisConstants.LESS_THAN_ONE_DAY) {
            return 300000;
        }
        if (spanTimeType == AnalysisConstants.LESS_THAN_SEVEN_DAYS) {
            return 3600000;
        }
        return 86400000;
    }

    public static List<List<String>> getRedunFirewallIpList(List<AticDevice> firewallList) {
        IDefendGroupService defendGroupService = ReportBisUtil.getDefendGroupService();
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        List defendGroupList = defendGroupService.getAll();
        for (DefendGroupForm form : defendGroupList) {
            if (form.getDetectMode() != 0) continue;
            List<Object> ipList = new ArrayList();
            if (null != firewallList) {
                ipList = ReportAnalysisUtil.everyRedunDefendGroupIpList(form, firewallList);
            }
            if (ipList.isEmpty()) continue;
            result.add(ipList);
        }
        return result;
    }

    private static List<String> everyRedunDefendGroupIpList(DefendGroupForm form, List<AticDevice> firewallList) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        ArrayList<String> ipList = new ArrayList<String>();
        if (null == form) {
            return ipList;
        }
        for (Long firewallId : form.getFirewallIds()) {
            AticDevice firewall = firewallService.getDeviceByMoid(firewallId.longValue());
            Iterator<AticDevice> iter = firewallList.iterator();
            while (iter.hasNext()) {
                AticDevice fireallLoop = iter.next();
                if (fireallLoop.getMoId() != firewall.getMoId()) continue;
                String devIp = AticUtil.formatIpAddress((String)firewall.getIpAddress());
                ipList.add(devIp);
                iter.remove();
            }
        }
        return ipList;
    }

    public static boolean checkDeviceAuthority(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm) {
        Boolean checkDeviceAuthority = true;
        if (null != datastatConditionForm.getDeviceId() && datastatConditionForm.getDeviceId() > 0L) {
            List<AticDevice> firewallListDetect;
            checkDeviceAuthority = false;
            Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
            IUserMgr userMgr = ReportAnalysisUtil.getUserMgr();
            Boolean isAdmin = userMgr.checkUserIsAdmin(currentLogUserId.longValue());
            if (isAdmin.booleanValue()) {
                checkDeviceAuthority = true;
                return checkDeviceAuthority;
            }
            Long deviceId = datastatConditionForm.getDeviceId();
            ArrayList<AticDevice> firewallList = new ArrayList<AticDevice>();
            IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
            List firewallListClean = firewallService.getCleanDevice(currentLogUserId.longValue());
            if (null != firewallListClean && !firewallListClean.isEmpty()) {
                firewallList.addAll(firewallListClean);
            }
            if (!(firewallListDetect = ReportAnalysisUtil.getAllDetectList4Cluster(firewallService, currentLogUserId)).isEmpty()) {
                firewallList.addAll(firewallListDetect);
            }
            for (AticDevice securityNE : firewallList) {
                if (securityNE.getMoId() != deviceId.longValue()) continue;
                checkDeviceAuthority = true;
                break;
            }
        }
        return checkDeviceAuthority;
    }

    public static boolean checkDeviceAuthority(User currentUser, Long deviceId) {
        if ("true".equals(currentUser.getIsAdmin())) {
            return true;
        }
        Boolean hasAuthority = false;
        long currUserId = currentUser.getUserID();
        if (null != deviceId && deviceId > 0L) {
            List<AticDevice> firewallListDetect;
            ArrayList<AticDevice> firewallList = new ArrayList<AticDevice>();
            IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
            List firewallListClean = firewallService.getCleanDevice(currUserId);
            if (null != firewallListClean && !firewallListClean.isEmpty()) {
                firewallList.addAll(firewallListClean);
            }
            if (!(firewallListDetect = ReportAnalysisUtil.getAllDetectList4Cluster(firewallService, currUserId)).isEmpty()) {
                firewallList.addAll(firewallListDetect);
            }
            for (AticDevice securityNE : firewallList) {
                if (securityNE.getMoId() != deviceId.longValue()) continue;
                hasAuthority = true;
                break;
            }
        }
        return hasAuthority;
    }

    public static boolean checkExportDeviceAuthority(int ddosType, User currentUser, Long deviceId) {
        if ("true".equals(currentUser.getIsAdmin())) {
            return true;
        }
        Boolean hasAuthority = false;
        long currUserId = currentUser.getUserID();
        if (null != deviceId && deviceId > 0L) {
            ArrayList firewallList = new ArrayList();
            IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
            List deviceLists = firewallService.getAntiddosDevice(ddosType, currUserId, Boolean.valueOf(currentUser.getIsAdmin()).booleanValue());
            if (null != deviceLists && !deviceLists.isEmpty()) {
                firewallList.addAll(deviceLists);
            }
            for (AticDevice securityNE : firewallList) {
                if (securityNE.getMoId() != deviceId.longValue()) continue;
                hasAuthority = true;
                break;
            }
        }
        return hasAuthority;
    }

    public static boolean checkZoneAuthority(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm) {
        Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
        IUserMgr userMgr = ReportAnalysisUtil.getUserMgr();
        Boolean isAdmin = userMgr.checkUserIsAdmin(currentLogUserId.longValue());
        List lstZone = null;
        lstZone = ReportBisUtil.getZoneService().getAll(currentLogUserId, isAdmin);
        Boolean checkZoneAuthority = true;
        if (null != datastatConditionForm.getZoneId() && datastatConditionForm.getZoneId() > 0L) {
            checkZoneAuthority = false;
            Long zoneId = datastatConditionForm.getZoneId();
            for (ZoneInfoForm zoneInfoForm : lstZone) {
                if (!zoneInfoForm.getZoneId().equals(zoneId)) continue;
                checkZoneAuthority = true;
                break;
            }
        }
        return checkZoneAuthority;
    }

    public static List<AticDevice> getFireWallOfCleanOrDetect(DataStatConditionForm datastatConditionForm, Long currentLogUserId) {
        ArrayList<AticDevice> firewallList = new ArrayList();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        ActionContext ctx = ActionContext.getContext();
        if (null != ctx) {
            HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            currentLogUserId = currentUser.getUserID();
            logger.info((Object)("get clean or detect Device by Sessioin,currentUserId = " + currentUser.getUserID()));
        } else {
            logger.info((Object)("reportTask get cleanor Detect Device,currentUserId = " + currentLogUserId));
        }
        if (datastatConditionForm.getDeviceId() == -1L) {
            List firewallListTemp = firewallService.getCleanDevice(currentLogUserId.longValue());
            if (null != firewallListTemp) {
                firewallList.addAll(firewallListTemp);
            }
        } else {
            firewallList = ReportAnalysisUtil.getAllDetectList4Cluster(firewallService, currentLogUserId);
        }
        return firewallList;
    }

    public static List<AticDevice> getFireWallOfCleanOrDetect4DnsAnalysis(DataStatConditionForm datastatConditionForm, Long currentLogUserId) {
        ArrayList<AticDevice> firewallList = new ArrayList<AticDevice>();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        ActionContext ctx = ActionContext.getContext();
        if (null != ctx) {
            HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            currentLogUserId = currentUser.getUserID();
            logger.info((Object)("get clean or detect Device by Sessioin,currentUserId = " + currentUser.getUserID()));
        } else {
            logger.info((Object)("reportTask get cleanor Detect Device,currentUserId = " + currentLogUserId));
        }
        if (datastatConditionForm.getDeviceId() == -1L) {
            List firewallListTemp = firewallService.getCleanDevice(currentLogUserId.longValue());
            if (null != firewallListTemp) {
                firewallList.addAll(firewallListTemp);
            }
        } else {
            List securityNElListTemp = firewallService.getAntiDDoSDevice(currentLogUserId.longValue());
            if (securityNElListTemp != null) {
                for (AticDevice securityNE : securityNElListTemp) {
                    if (securityNE.getDdosType() != 1 && securityNE.getDdosType() != 2) continue;
                    firewallList.add(securityNE);
                }
            }
        }
        return firewallList;
    }

    public static Long getCurrentLogUserId(Map<?, ?> queryCond) {
        ActionContext ctx = ActionContext.getContext();
        try {
            if (null != ctx) {
                HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
                User currentUser = (User)request.getSession().getAttribute("currentUser");
                return currentUser.getUserID();
            }
        }
        catch (NullPointerException e) {
            JsonValueObj obj = (JsonValueObj)queryCond.get("currentLogUserId");
            List list = null;
            if (null == obj || obj.getValueList().isEmpty()) {
                return 0L;
            }
            list = obj.getValueList();
            return Long.parseLong(((JsonValueItem)list.get(0)).getValue());
        }
        JsonValueObj obj = (JsonValueObj)queryCond.get("currentLogUserId");
        List list = null;
        if (null == obj || obj.getValueList().isEmpty()) {
            return 0L;
        }
        list = obj.getValueList();
        return Long.parseLong(((JsonValueItem)list.get(0)).getValue());
    }

    public static String getCurrentLogUserName(Map<?, ?> queryCond) {
        ActionContext ctx = ActionContext.getContext();
        try {
            if (null != ctx) {
                HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
                User currentUser = (User)request.getSession().getAttribute("currentUser");
                return currentUser.getUserName();
            }
        }
        catch (NullPointerException e) {
            JsonValueObj obj = (JsonValueObj)queryCond.get("currentLogUserId");
            List list = null;
            if (null == obj || obj.getValueList().isEmpty()) {
                return "";
            }
            list = obj.getValueList();
            return ((JsonValueItem)list.get(0)).getText();
        }
        JsonValueObj obj = (JsonValueObj)queryCond.get("currentLogUserId");
        List list = null;
        if (null == obj || obj.getValueList().isEmpty()) {
            return "";
        }
        list = obj.getValueList();
        return ((JsonValueItem)list.get(0)).getText();
    }

    public static String getReportType(Map<?, ?> queryCond, Locale locale) {
        JsonValueObj obj = (JsonValueObj)queryCond.get("schedule");
        List list = null;
        if (null == obj || obj.getValueList().isEmpty()) {
            return "";
        }
        list = obj.getValueList();
        String reportType = ((JsonValueItem)list.get(0)).getValue();
        if (AticUtil.isNull((String)reportType)) {
            return "";
        }
        String returnStr = "";
        if (reportType.equalsIgnoreCase("day")) {
            returnStr = AticUtil.getText((String)"report.type.day", (Locale)locale);
        } else if (reportType.equalsIgnoreCase("week")) {
            returnStr = AticUtil.getText((String)"report.type.week", (Locale)locale);
        } else if (reportType.equalsIgnoreCase("month")) {
            returnStr = AticUtil.getText((String)"report.type.month", (Locale)locale);
        } else if (reportType.equalsIgnoreCase("year")) {
            returnStr = AticUtil.getText((String)"report.type.year", (Locale)locale);
        }
        return returnStr;
    }

    public static void addZoneSecurityToQueryCondition(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, long sessionId) {
        Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
        IUserMgr userMgr = ReportAnalysisUtil.getUserMgr();
        Boolean isAdmin = userMgr.checkUserIsAdmin(currentLogUserId.longValue());
        if (!isAdmin.booleanValue()) {
            List lstZone = null;
            ArrayList<Long> zoneIdList = new ArrayList<Long>();
            lstZone = datastatConditionForm.getDeviceId() == -1L ? ReportBisUtil.getZoneService().getDeployZoneInfoByDeviceType(currentLogUserId, isAdmin, 0) : (datastatConditionForm.getDeviceId() == -2L ? ReportBisUtil.getZoneService().getDeployZoneInfoByDeviceType(currentLogUserId, isAdmin, 1) : ReportBisUtil.getZoneService().getDeployZoneInfoByDeviceId(currentLogUserId, isAdmin, datastatConditionForm.getDeviceId()));
            for (ZoneInfoForm zoneInfoForm : lstZone) {
                zoneIdList.add(zoneInfoForm.getZoneId());
            }
            datastatConditionForm.setSessionId(sessionId);
            datastatConditionForm.setZoneIdList(zoneIdList);
        }
    }

    public static void addZoneSecurityToQueryCondition(Map<?, ?> queryCond, String deviceId, BaseConditionForm conditionForm, Long sessionId) {
        if (deviceId.contains("_")) {
            String[] dev = deviceId.split("_");
            deviceId = dev[0];
        }
        Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
        IUserMgr userMgr = ReportAnalysisUtil.getUserMgr();
        Boolean isAdmin = userMgr.checkUserIsAdmin(currentLogUserId.longValue());
        if (!isAdmin.booleanValue()) {
            List lstZone = null;
            ArrayList<Long> zoneIdList = new ArrayList<Long>();
            lstZone = Long.parseLong(deviceId) == -1L ? ReportBisUtil.getZoneService().getDeployZoneInfoByDeviceType(currentLogUserId, isAdmin, 0) : (Long.parseLong(deviceId) == -2L ? ReportBisUtil.getZoneService().getDeployZoneInfoByDeviceType(currentLogUserId, isAdmin, 1) : ReportBisUtil.getZoneService().getDeployZoneInfoByDeviceId(currentLogUserId, isAdmin, Long.valueOf(Long.parseLong(deviceId))));
            for (ZoneInfoForm zoneInfoForm : lstZone) {
                zoneIdList.add(zoneInfoForm.getZoneId());
            }
            conditionForm.setSessionId(sessionId);
            conditionForm.setZoneIdList(zoneIdList);
        }
    }

    public static Map<Long, List<RedunDeviceForm>> getRedunFirewallInfoList(List<AticDevice> firewallList) {
        IDefendGroupService defendGroupService = ReportBisUtil.getDefendGroupService();
        HashMap<Long, List<RedunDeviceForm>> result = new HashMap<Long, List<RedunDeviceForm>>();
        List defendGroupList = defendGroupService.getAll();
        for (DefendGroupForm form : defendGroupList) {
            if (form.getDetectMode() != 0) continue;
            List<Object> redunDeviceList = new ArrayList();
            if (null != firewallList) {
                redunDeviceList = ReportAnalysisUtil.oneRedunDefendGroupInfoList(form, firewallList);
            }
            if (redunDeviceList.isEmpty()) continue;
            result.put(form.getId(), redunDeviceList);
        }
        return result;
    }

    private static List<RedunDeviceForm> oneRedunDefendGroupInfoList(DefendGroupForm form, List<AticDevice> firewallList) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        ICollectorDeviceService collectorDeviceService = ReportBisUtil.getICollectorDeviceService();
        ArrayList<RedunDeviceForm> redunDeviceList = new ArrayList<RedunDeviceForm>();
        if (null == form) {
            return redunDeviceList;
        }
        for (Long firewallId : form.getFirewallIds()) {
            AticDevice firewall = firewallService.getDeviceByMoid(firewallId.longValue());
            Iterator<AticDevice> iter = firewallList.iterator();
            while (iter.hasNext()) {
                AticDevice fireallLoop = iter.next();
                if (fireallLoop.getMoId() != firewall.getMoId()) continue;
                RedunDeviceForm redunDeviceInfo = new RedunDeviceForm();
                redunDeviceInfo.setDeviceId(firewall.getMoId());
                String devIp = AticUtil.formatIpAddress((String)firewall.getIpAddress());
                redunDeviceInfo.setDeviceIp(devIp);
                redunDeviceInfo.setCollectorId(collectorDeviceService.getCollectorIdByDevId(Long.valueOf(firewall.getMoId())));
                redunDeviceList.add(redunDeviceInfo);
                iter.remove();
            }
        }
        return redunDeviceList;
    }

    public static List<AticDevice> getRedunFirewallList(Map<Long, List<RedunDeviceForm>> redunMap) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        ArrayList<AticDevice> firewallList = new ArrayList<AticDevice>();
        for (Map.Entry<Long, List<RedunDeviceForm>> redun : redunMap.entrySet()) {
            for (RedunDeviceForm info : redun.getValue()) {
                AticDevice firewall = firewallService.getDeviceByMoid(info.getDeviceId().longValue());
                firewallList.add(firewall);
            }
        }
        return firewallList;
    }

    public static List<DeviceWorkTimeForm> getWorkTimeList(DataStatConditionForm datastatConditionForm, Map.Entry<Long, List<RedunDeviceForm>> redun) {
        List<DeviceWorkTimeForm> workTimeList = new ArrayList<DeviceWorkTimeForm>();
        if (null == redun || null == redun.getValue()) {
            logger.error((Object)"get Entry is null Or get RedunDeviceForm list is null !");
            return workTimeList;
        }
        DeviceWrokTimeUtil util = new DeviceWrokTimeUtil();
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        IDataStatService dataStatService = ReportAnalysisUtil.getDataStatService();
        Long startTime = datastatConditionForm.getStartTime();
        Long endTime = datastatConditionForm.getEndTime();
        HashMap sameCtrMap = new HashMap();
        for (RedunDeviceForm temp : redun.getValue()) {
            if (sameCtrMap.containsKey(temp.getCollectorId())) {
                ((List)sameCtrMap.get(temp.getCollectorId())).add(temp.getDeviceIp());
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(temp.getDeviceIp());
            sameCtrMap.put(temp.getCollectorId(), list);
        }
        HashMap<String, List<DeviceStopTimeForm>> stopMap = new HashMap<String, List<DeviceStopTimeForm>>();
        for (Map.Entry sameMap : sameCtrMap.entrySet()) {
            CollectorInfo collectorInfo = collectorService.getCollectorInfo(((Long)sameMap.getKey()).longValue());
            if (null == collectorInfo) {
                logger.error((Object)("collector is null, collectorId= " + sameMap.getKey()));
                continue;
            }
            StopTimeQueryForm queryForm = new StopTimeQueryForm();
            queryForm.setDeviceIpList((List)sameMap.getValue());
            queryForm.setDevSerType(datastatConditionForm.getDevSerType());
            queryForm.setStartTime(startTime);
            queryForm.setEndTime(endTime);
            Map<Object, Object> formMap = new HashMap();
            try {
                formMap = dataStatService.getDeviceStopTimeList(queryForm, collectorInfo.getIpAddress());
            }
            catch (Exception e) {
                logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorInfo.getId()), (Throwable)e);
            }
            if (null == formMap || formMap.isEmpty()) continue;
            DeviceWorkTimeForm workForm = util.getWorkForm(formMap);
            if (null != workForm) {
                workForm.setCollectorIp(collectorInfo.getIpAddress());
                workForm.setStartTime(startTime);
                workForm.setEndTime(endTime);
                workTimeList.add(workForm);
                break;
            }
            stopMap.putAll(formMap);
        }
        if (workTimeList.isEmpty()) {
            workTimeList = util.getDeviceWorkTimeList(stopMap, startTime, endTime);
        }
        return workTimeList;
    }

    public static String formateTime(long time) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formate.format(new Date(time * 1000L));
    }

    public static void processServiceCond(DataStatConditionForm datastatConditionForm, String bisId) {
        datastatConditionForm.setIsServiceGroup(false);
        if (!"0".equals(bisId)) {
            if (bisId.contains("_")) {
                Long serviceId = Long.parseLong(bisId.split("_")[0]);
                String serviceType = bisId.split("_")[1];
                if ("service".equalsIgnoreCase(serviceType)) {
                    datastatConditionForm.setIsServiceGroup(false);
                    datastatConditionForm.setBisId(serviceId);
                    datastatConditionForm.setBisType(ReportAnalysisUtil.processBizParam(serviceId));
                }
            }
        } else {
            datastatConditionForm.setIsServiceGroup(false);
            datastatConditionForm.setBisId(Long.parseLong(bisId));
        }
    }

    public static void processServiceCond(BaseConditionForm conditionForm, String bisId) {
        try {
            conditionForm.setIsServiceGroup(false);
            if (!"0".equals(bisId)) {
                if (bisId.contains("_")) {
                    ReportAnalysisUtil.processBizData4BaseCond(conditionForm, bisId);
                } else {
                    conditionForm.setIsServiceGroup(false);
                    conditionForm.setBizId(Long.parseLong(bisId));
                    conditionForm.setBizType(Integer.parseInt("0"));
                }
            } else {
                conditionForm.setIsServiceGroup(false);
                conditionForm.setBizType(Integer.valueOf("-1"));
                conditionForm.setBizId(Long.parseLong(bisId));
            }
        }
        catch (NumberFormatException e) {
            Long serviceId = 0L;
            if (bisId.contains("_")) {
                serviceId = Long.parseLong(bisId.split("_")[0]);
            }
            conditionForm.setIsServiceGroup(false);
            conditionForm.setBizType(Integer.valueOf("-1"));
            conditionForm.setBizId(serviceId);
        }
    }

    private static void processBizData4BaseCond(BaseConditionForm conditionForm, String bisId) {
        if (bisId.contains("_")) {
            Long serviceId = Long.parseLong(bisId.split("_")[0]);
            String serviceType = bisId.split("_")[1];
            if ("service".equalsIgnoreCase(serviceType)) {
                conditionForm.setIsServiceGroup(false);
                conditionForm.setBizId(serviceId);
                IZoneMgrNorthSerice zoneMgrNorthSerice = ReportAnalysisUtil.getZoneMgrNorthSerice();
                Integer bizType = Integer.valueOf(AnalysisConstants.BIZ_STR_TO_ID.get(zoneMgrNorthSerice.getBizTypeById(serviceId).getProtocol()));
                conditionForm.setBizType(bizType);
            }
        }
    }

    public static String processBizParam(Long bizId) {
        String bizType;
        try {
            if (0L == bizId) {
                bizType = "";
            } else {
                IZoneMgrNorthSerice zoneMgrNorthSerice = ReportAnalysisUtil.getZoneMgrNorthSerice();
                bizType = zoneMgrNorthSerice.getBizTypeById(bizId).getProtocol();
            }
        }
        catch (RuntimeException e) {
            bizType = "";
        }
        return bizType;
    }

    public static Long processStr2Long(String strValue) {
        Long returnLongValue = 0L;
        try {
            returnLongValue = Long.parseLong(strValue);
        }
        catch (NumberFormatException e) {
            logger.error((Object)"processStr2Integer formate string to Long error");
        }
        return returnLongValue;
    }

    public static Integer processStr2Integer(String strValue) {
        Integer returnLongValue = 0;
        try {
            returnLongValue = Integer.parseInt(strValue);
        }
        catch (NumberFormatException e) {
            logger.error((Object)"processStr2Integer formate string to Integer error");
        }
        return returnLongValue;
    }

    public static IReportEmailInfoService getReportEmailInfoService() {
        IReportEmailInfoService reportEmailInfoService = (IReportEmailInfoService)AticUtil.getServiceContext().getService("reportEmailInfoService", IReportEmailInfoService.class);
        if (reportEmailInfoService == null) {
            throw new LegoCheckedException(570506L);
        }
        return reportEmailInfoService;
    }

    public static Connection getDbConnection2Report() {
        Connection conn = null;
        try {
            ReportAnalysisUtil.readDBFile();
            Class.forName(driveClass);
            conn = DriverManager.getConnection(url, userName, password);
            logger.info((Object)"end getDbConnection2Report");
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"getDbConnection2Report error", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"getDbConnection2Report error", (Throwable)e);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readDBFile() {
        InputStream inStream = null;
        Properties properties = null;
        try {
            if (!checkReadDBFile.booleanValue()) {
                int indexOther;
                int index = IReportUtil.getRealPath().lastIndexOf("\\");
                int realIndex = index > (indexOther = IReportUtil.getRealPath().lastIndexOf("/")) ? index : indexOther;
                String appPath = IReportUtil.getRealPath().substring(0, realIndex);
                String fileName = appPath + IREPORT_DB_PATH;
                File file = new File(fileName);
                properties = new Properties();
                inStream = new FileInputStream(file);
                properties.load(inStream);
                driveClass = properties.getProperty("driverClass");
                url = properties.getProperty("url");
                userName = properties.getProperty("username");
                password = properties.getProperty("password");
                String temp = properties.getProperty("dbtype");
                if (!AticUtil.isNull((String)temp) && temp.equalsIgnoreCase("MySQL")) {
                    iReportDBType = "mysql";
                } else if (!AticUtil.isNull((String)temp) && temp.equalsIgnoreCase("MicroSoft SQL Server")) {
                    iReportDBType = "sqlserver";
                }
                IReportConfigUtil.getInstance().setConfig("ireport.db.type", iReportDBType);
                logger.info((Object)("load IreportDB.conf success, driveClass:" + driveClass + ", userName:" + userName + ", iReportDBType:" + iReportDBType));
                checkReadDBFile = true;
            }
        }
        catch (IOException e) {
            logger.error((Object)"load IreportDB.conf error", (Throwable)e);
        }
        finally {
            try {
                if (null != inStream) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"Close param.properties error", (Throwable)e);
            }
        }
    }

    public static void processDeviceInfo(DataStatConditionForm datastatConditionForm, String deviceId) {
        if (deviceId.contains("_")) {
            datastatConditionForm.setDeviceId(Long.parseLong(deviceId.split("_")[0]));
            datastatConditionForm.setDevSerType(Integer.parseInt(deviceId.split("_")[1]));
        } else if (-2L == Long.parseLong(deviceId)) {
            datastatConditionForm.setDeviceId(Long.parseLong(deviceId));
            datastatConditionForm.setDevSerType(1);
        } else if (-1L == Long.parseLong(deviceId)) {
            datastatConditionForm.setDeviceId(Long.parseLong(deviceId));
            datastatConditionForm.setDevSerType(0);
        } else {
            datastatConditionForm.setDeviceId(Long.parseLong(deviceId));
            AticDevice firewall = ReportBisUtil.getIFirewallService().getDeviceByMoid(Long.parseLong(deviceId));
            datastatConditionForm.setDevSerType(ReportAnalysisUtil.getDeviceDdos(firewall));
        }
    }

    public static String getCustomAttackTypeStr(Long zoneId, String deviceIp, Integer protocol, Integer port) {
        String attackTypeName = "";
        ZoneServiceForm zoneService = null;
        try {
            zoneService = ReportBisUtil.getZoneMgrNorthSerice().getZoneServiceFormByProtocolAndPort(zoneId, deviceIp, protocol, port);
        }
        catch (Exception e) {
            logger.error((Object)"getZoneServiceForm happened error !", (Throwable)e);
        }
        attackTypeName = null != zoneService ? AticUtil.getText((String)"atic.attack.type.0") + "(" + zoneService.getServiceName() + ")" : AticUtil.getText((String)"atic.attack.type.0") + "(protocol:" + ReportBisUtil.getProtocolString(protocol) + ",port:" + port + ")";
        return attackTypeName;
    }

    private static Long compareSystemCurrentTime(Long time) {
        Date date = new Date();
        Long currentTime = date.getTime() / 1000L;
        if (time > currentTime) {
            return currentTime;
        }
        return time;
    }

    public static String getCompanyName() {
        Map<String, String> parameter = ReportAnalysisUtil.getDataStatService().getReportConfig();
        String companyName = parameter.get("companyName");
        if (AticUtil.isNull((String)companyName)) {
            companyName = "ATIC";
        }
        return companyName;
    }

    public static String getCompaneLog() {
        Map<String, String> parameter = ReportAnalysisUtil.getDataStatService().getReportConfig();
        String companyLogo = parameter.get("companyLogo");
        if (AticUtil.isNull((String)companyLogo)) {
            companyLogo = "pageHeaderIcon_hw.JPG";
        } else {
            String picPathTemp = "/iReport/iReportBiz/jasperTemplete/" + companyLogo;
            String realPath = IReportUtil.getRealPath();
            File file = new File(realPath + picPathTemp);
            if (file.exists() && file.length() <= 0L || !file.exists()) {
                companyLogo = "pageHeaderIcon_hw.JPG";
            }
        }
        return companyLogo;
    }

    public static Map<String, List<String>> getPrepareParasMap(Map<?, ?> queryCond) {
        Long startTimeTemp;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Long endTime = null;
        Long startTime = null;
        List<JsonValueItem> jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "dateRange");
        if (null != jsonValueItemList && jsonValueItemList.size() > 1) {
            endTime = ReportAnalysisUtil.compareSystemCurrentTime(AticUtil.convertTimeString((String)ReportAnalysisUtil.getJsonValueItemList(queryCond, "dateRange").get(1).getText()));
            startTimeTemp = ReportAnalysisUtil.compareSystemCurrentTime(AticUtil.convertTimeString((String)ReportAnalysisUtil.getJsonValueItemList(queryCond, "dateRange").get(0).getText()));
            startTimeTemp = startTimeTemp > endTime ? endTime : startTimeTemp;
            startTime = ReportAnalysisUtil.getRealStartTime(startTimeTemp, endTime);
        } else {
            endTime = ReportAnalysisUtil.compareSystemCurrentTime(Long.parseLong(ReportAnalysisUtil.getJsonValueItemList(queryCond, "endTime").get(0).getText()));
            startTimeTemp = ReportAnalysisUtil.compareSystemCurrentTime(Long.parseLong(ReportAnalysisUtil.getJsonValueItemList(queryCond, "startTime").get(0).getText()));
            startTimeTemp = startTimeTemp > endTime ? endTime : startTimeTemp;
            startTime = ReportAnalysisUtil.getRealStartTime(startTimeTemp, endTime);
        }
        Integer timeSpan = ReportAnalysisUtil.getTimeSpanType(endTime, startTime);
        long timeSpanKey = 0L;
        timeSpanKey = timeSpan.equals(AnalysisConstants.LESS_THAN_ONE_DAY) ? 1L : (timeSpan.equals(AnalysisConstants.LESS_THAN_SEVEN_DAYS) ? 2L : 3L);
        ArrayList<String> value = new ArrayList<String>();
        value.add(String.valueOf(timeSpanKey));
        map.put("timeLevel", value);
        ArrayList<String> companyName = new ArrayList<String>();
        companyName.add(ReportAnalysisUtil.getCompanyName());
        map.put("companyName", companyName);
        ArrayList<String> logUrl = new ArrayList<String>();
        logUrl.add(ReportAnalysisUtil.getCompaneLog());
        map.put("logImageUrl", logUrl);
        return map;
    }

    public static Map<String, List<String>> getLogoAndNameMap(Map<?, ?> queryCond) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<String> companyName = new ArrayList<String>();
        companyName.add(ReportAnalysisUtil.getCompanyName());
        map.put("companyName", companyName);
        ArrayList<String> logUrl = new ArrayList<String>();
        logUrl.add(ReportAnalysisUtil.getCompaneLog());
        map.put("logImageUrl", logUrl);
        return map;
    }

    public static Map<String, List<String>> getPrepareParasMap4OnlyHourDay(Map<?, ?> queryCond) {
        Long startTimeTemp;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Long endTime = null;
        Long startTime = null;
        List<JsonValueItem> jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "dateRange");
        if (null != jsonValueItemList && jsonValueItemList.size() > 1) {
            endTime = ReportAnalysisUtil.compareSystemCurrentTime(AticUtil.convertTimeString((String)ReportAnalysisUtil.getJsonValueItemList(queryCond, "dateRange").get(1).getText()));
            startTimeTemp = ReportAnalysisUtil.compareSystemCurrentTime(AticUtil.convertTimeString((String)ReportAnalysisUtil.getJsonValueItemList(queryCond, "dateRange").get(0).getText()));
            startTimeTemp = startTimeTemp > endTime ? endTime : startTimeTemp;
            startTime = ReportAnalysisUtil.getRealStartTime(startTimeTemp, endTime);
        } else {
            endTime = ReportAnalysisUtil.compareSystemCurrentTime(Long.parseLong(ReportAnalysisUtil.getJsonValueItemList(queryCond, "endTime").get(0).getText()));
            startTimeTemp = ReportAnalysisUtil.compareSystemCurrentTime(Long.parseLong(ReportAnalysisUtil.getJsonValueItemList(queryCond, "startTime").get(0).getText()));
            startTimeTemp = startTimeTemp > endTime ? endTime : startTimeTemp;
            startTime = ReportAnalysisUtil.getRealStartTime(startTimeTemp, endTime);
        }
        Integer timeSpan = ReportAnalysisUtil.getTimeSpanType(endTime, startTime);
        long timeSpanKey = 0L;
        timeSpanKey = timeSpan.equals(AnalysisConstants.LESS_THAN_ONE_DAY) ? 2L : (timeSpan.equals(AnalysisConstants.LESS_THAN_SEVEN_DAYS) ? 2L : 3L);
        ArrayList<String> value = new ArrayList<String>();
        value.add(String.valueOf(timeSpanKey));
        map.put("timeLevel", value);
        return map;
    }

    public static List<JsonValueItem> getJsonValueItemList(Map<?, ?> queryCond, String queryKey) {
        JsonValueObj obj = (JsonValueObj)queryCond.get(queryKey);
        ArrayList<JsonValueItem> list = null;
        if (null == obj || obj.getValueList().isEmpty()) {
            list = new ArrayList<JsonValueItem>();
            list.add(new JsonValueItem());
            return list;
        }
        list = obj.getValueList();
        return list;
    }

    public static void setDateRange(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm) {
        List<JsonValueItem> jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "dateRange");
        if (null != jsonValueItemList && jsonValueItemList.size() > 1) {
            long startTime = ReportAnalysisUtil.compareSystemCurrentTime(AticUtil.convertTimeString((String)jsonValueItemList.get(0).getText()));
            datastatConditionForm.setStartTime(startTime);
            long endTime = ReportAnalysisUtil.compareSystemCurrentTime(AticUtil.convertTimeString((String)jsonValueItemList.get(1).getText()));
            datastatConditionForm.setEndTime(endTime);
        } else {
            long startTime = ReportAnalysisUtil.compareSystemCurrentTime(Long.parseLong(ReportAnalysisUtil.getJsonValueItemList(queryCond, "startTime").get(0).getText()));
            datastatConditionForm.setStartTime(startTime);
            long endTime = ReportAnalysisUtil.compareSystemCurrentTime(Long.parseLong(ReportAnalysisUtil.getJsonValueItemList(queryCond, "endTime").get(0).getText()));
            datastatConditionForm.setEndTime(endTime);
        }
    }

    public static void processTimeParams(Map<?, ?> queryCond, AnalyzeSuccessRateConditionForm analyzeSuccessRateConditionForm) {
        Long endTime = ReportAnalysisUtil.compareSystemCurrentTime(AticUtil.convertTimeString((String)ReportAnalysisUtil.getJsonValueItemList(queryCond, "dateRange").get(1).getText()));
        Long startTimeTemp = ReportAnalysisUtil.compareSystemCurrentTime(AticUtil.convertTimeString((String)ReportAnalysisUtil.getJsonValueItemList(queryCond, "dateRange").get(0).getText()));
        startTimeTemp = startTimeTemp > endTime ? endTime : startTimeTemp;
        Long startTime = ReportAnalysisUtil.getRealStartTime(startTimeTemp, endTime);
        analyzeSuccessRateConditionForm.setStartTime(startTime);
        analyzeSuccessRateConditionForm.setEndTime(endTime);
        analyzeSuccessRateConditionForm.setTimeSpanType(ReportAnalysisUtil.getTimeSpanType(endTime, startTime));
    }

    public static void processTimeParams(Map<?, ?> queryCond, FlowCompareConditionForm flowCompareConditionForm) {
        List<JsonValueItem> jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "dateRange");
        List<JsonValueItem> endTimeItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "endTime");
        List<JsonValueItem> startTimeItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "startTime");
        Long endTime = 0L;
        Long startTime = 0L;
        if (null != endTimeItemList.get(0).getText() && null != startTimeItemList.get(0).getText()) {
            endTime = ReportAnalysisUtil.compareSystemCurrentTime(Long.parseLong(ReportAnalysisUtil.getJsonValueItemList(queryCond, "endTime").get(0).getText()));
            Long startTimeTemp = ReportAnalysisUtil.compareSystemCurrentTime(Long.parseLong(ReportAnalysisUtil.getJsonValueItemList(queryCond, "startTime").get(0).getText()));
            startTimeTemp = startTimeTemp > endTime ? endTime : startTimeTemp;
            startTime = ReportAnalysisUtil.getRealStartTime(startTimeTemp, endTime);
        } else if (null != jsonValueItemList && jsonValueItemList.size() > 1) {
            endTime = ReportAnalysisUtil.compareSystemCurrentTime(AticUtil.convertTimeString((String)ReportAnalysisUtil.getJsonValueItemList(queryCond, "dateRange").get(1).getText()));
            Long startTimeTemp = ReportAnalysisUtil.compareSystemCurrentTime(AticUtil.convertTimeString((String)ReportAnalysisUtil.getJsonValueItemList(queryCond, "dateRange").get(0).getText()));
            startTimeTemp = startTimeTemp > endTime ? endTime : startTimeTemp;
            startTime = ReportAnalysisUtil.getRealStartTime(startTimeTemp, endTime);
        }
        flowCompareConditionForm.setStartTime(startTime);
        flowCompareConditionForm.setEndTime(endTime);
        flowCompareConditionForm.setTimeSpanType(ReportAnalysisUtil.getTimeSpanType(endTime, startTime));
    }

    public static void processTimeParams(Map<?, ?> queryCond, NormalAbnormalConditionForm normalAndExceptionConditionForm) {
        Long endTime = ReportAnalysisUtil.compareSystemCurrentTime(AticUtil.convertTimeString((String)ReportAnalysisUtil.getJsonValueItemList(queryCond, "dateRange").get(1).getText()));
        Long startTimeTemp = ReportAnalysisUtil.compareSystemCurrentTime(AticUtil.convertTimeString((String)ReportAnalysisUtil.getJsonValueItemList(queryCond, "dateRange").get(0).getText()));
        startTimeTemp = startTimeTemp > endTime ? endTime : startTimeTemp;
        Long startTime = ReportAnalysisUtil.getRealStartTime(startTimeTemp, endTime);
        normalAndExceptionConditionForm.setStartTime(startTime);
        normalAndExceptionConditionForm.setEndTime(endTime);
        normalAndExceptionConditionForm.setTimeSpanType(ReportAnalysisUtil.getTimeSpanType(endTime, startTime));
    }

    public static String getFontColor(String rgbString) {
        try {
            String[] rgbStringArray = rgbString.split(",");
            String hexString = ReportAnalysisUtil.toHexString(Integer.parseInt(rgbStringArray[0].trim())) + ReportAnalysisUtil.toHexString(Integer.parseInt(rgbStringArray[1].trim())) + ReportAnalysisUtil.toHexString(Integer.parseInt(rgbStringArray[2].trim()));
            return "#" + hexString;
        }
        catch (NumberFormatException e) {
            logger.info((Object)"NumberFormatException");
            return "#000000";
        }
    }

    private static String toHexString(int r) {
        String result = Integer.toHexString(r);
        if (1 == result.length()) {
            result = "0" + result;
        }
        return result;
    }

    public static Integer getDeviceType(String deviceId) {
        if (deviceId.contains("_")) {
            return Integer.parseInt(deviceId.split("_")[1]);
        }
        if (-2L == Long.parseLong(deviceId)) {
            return 1;
        }
        if (-1L == Long.parseLong(deviceId)) {
            return 0;
        }
        AticDevice firewall = ReportBisUtil.getIFirewallService().getDeviceByMoid(Long.parseLong(deviceId));
        return ReportAnalysisUtil.getDeviceDdos(firewall);
    }

    public static Locale getCurrentUserLocale4Report(Map<?, ?> queryCond) {
        Locale locale = LocaleUtil.INSTANCE.getCurrentUserLocale();
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "localLanguageType");
        String localLanguageType = String.valueOf(jsonValueItem.get(0).getValue());
        if (!AticUtil.isNull((String)localLanguageType)) {
            locale = localLanguageType.contains("_") ? new Locale(localLanguageType.split("_")[0], localLanguageType.split("_")[1]) : new Locale(localLanguageType);
        }
        logger.info((Object)("localLanguageType is " + localLanguageType + ",and now locale is:" + locale.toString()));
        return locale;
    }

    public static String getStrContent4HtmlFile(String content, int printHtmlLength) {
        String bASECHART = "[a-zA-Z0-9]";
        String pUNCHART = "[\"#$&'*+,./:;<=>@^_`|~-]|\\(|\\)|\\[|\\]|\\{|\\}|\\!|\\?|\\%";
        Pattern htmlKeyPattern = Pattern.compile("(" + bASECHART + "|" + pUNCHART + "){" + printHtmlLength + "}");
        Matcher macher = null;
        if (null != content) {
            macher = htmlKeyPattern.matcher(content);
        }
        StringBuffer sb = new StringBuffer();
        String tempLend = content;
        if (tempLend != null && tempLend.length() > 0) {
            macher.reset(content);
            sb.delete(0, sb.length());
            int startIndex = 0;
            int endIndex = 0;
            int tempIndex = 0;
            while (macher.find()) {
                startIndex = macher.start();
                endIndex = macher.end();
                sb.append(tempLend.substring(tempIndex, startIndex));
                sb.append(tempLend.substring(startIndex, endIndex)).append('\r');
                tempIndex = endIndex;
            }
            sb.append(tempLend.substring(endIndex));
            tempLend = sb.toString();
        }
        return tempLend;
    }

    public static void processTopnValue4Inte(DataStatConditionForm datastatConditionForm, int topnType, Map<?, ?> queryCond) {
        List<JsonValueItem> jsonValueItem = null;
        String isInteReport = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
        if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true")) {
            String topn;
            if (8 == topnType || 9 == topnType) {
                jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "DnsRequestTopNTOPN");
                String topn2 = String.valueOf(jsonValueItem.get(0).getValue());
                if (!AticUtil.isNull((String)topn2)) {
                    datastatConditionForm.setTopn(Integer.parseInt(topn2));
                }
            } else if (6 == topnType || 7 == topnType) {
                jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "SrcIpRequestTopNTOPN");
                String topn3 = String.valueOf(jsonValueItem.get(0).getValue());
                if (!AticUtil.isNull((String)topn3)) {
                    datastatConditionForm.setTopn(Integer.parseInt(topn3));
                }
            } else if (1 == topnType || 2 == topnType) {
                jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "HttpSrcTopNTOPN");
                String topn4 = String.valueOf(jsonValueItem.get(0).getValue());
                if (!AticUtil.isNull((String)topn4)) {
                    datastatConditionForm.setTopn(Integer.parseInt(topn4));
                }
            } else if (14 == topnType) {
                jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "HttpURlTopNTOPN");
                String topn5 = String.valueOf(jsonValueItem.get(0).getValue());
                if (!AticUtil.isNull((String)topn5)) {
                    datastatConditionForm.setTopn(Integer.parseInt(topn5));
                }
            } else if (11 == topnType) {
                jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "SipSrcTopNTOPN");
                String topn6 = String.valueOf(jsonValueItem.get(0).getValue());
                if (!AticUtil.isNull((String)topn6)) {
                    datastatConditionForm.setTopn(Integer.parseInt(topn6));
                }
            } else if (12 == topnType && !AticUtil.isNull((String)(topn = String.valueOf((jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "SipCallerTopNTOPN")).get(0).getValue())))) {
                datastatConditionForm.setTopn(Integer.parseInt(topn));
            }
        }
    }

    public static void processTopnType(DataStatConditionForm datastatConditionForm, String topnType, int reportType, Boolean isIn) {
        if (AticUtil.isNull((String)topnType)) {
            int topnTypeInt = 0;
            if (1 == datastatConditionForm.getAttackType()) {
                topnTypeInt = ReportAnalysisUtil.processSrcIp4TopnType(reportType, isIn, datastatConditionForm.getUnit());
            } else if (0 == datastatConditionForm.getAttackType()) {
                topnTypeInt = isIn != false ? 8 : 9;
            }
            datastatConditionForm.setTopnType(topnTypeInt);
        } else {
            datastatConditionForm.setTopnType(Integer.parseInt(topnType));
        }
    }

    private static int processSrcIp4TopnType(int reportType, Boolean isIn, Integer unit) {
        int topnTypeInt = 0;
        if (1 == reportType) {
            topnTypeInt = isIn.booleanValue() ? 6 : 7;
        } else if (2 == reportType) {
            topnTypeInt = isIn.booleanValue() ? (unit == 2 ? 16 : 1) : (unit == 2 ? 17 : 2);
        } else if (3 == reportType) {
            topnTypeInt = isIn != false ? 3 : 4;
        }
        return topnTypeInt;
    }

    public static void processSaveDataToStaticData(List<DnsGraph> dnsTopNFormList, long sessionId, int topnType, boolean isSrcIp) {
        ReportAnalysisUtil.processDnsSaveData(dnsTopNFormList, sessionId, topnType, isSrcIp);
        ReportAnalysisUtil.processHttpSaveData(dnsTopNFormList, sessionId, topnType);
        ReportAnalysisUtil.processSipSaveData(dnsTopNFormList, sessionId, topnType);
    }

    private static void processSipSaveData(List<DnsGraph> dnsTopNFormList, long sessionId, int topnType) {
        if (11 == topnType) {
            SipSrcInTopNStaticData.getInstance().addDataList(new ArrayList<DnsGraph>(dnsTopNFormList), sessionId);
        } else if (12 == topnType) {
            SipCallerInTopNStaticData.getInstance().addDataList(new ArrayList<DnsGraph>(dnsTopNFormList), sessionId);
        } else if (13 == topnType) {
            SipCalleeInTopNStaticData.getInstance().addDataList(new ArrayList<DnsGraph>(dnsTopNFormList), sessionId);
        }
    }

    private static void processHttpSaveData(List<DnsGraph> dnsTopNFormList, long sessionId, int topnType) {
        if (1 == topnType || 16 == topnType) {
            HttpSrcInTopNStaticData.getInstance().addDataList(new ArrayList<DnsGraph>(dnsTopNFormList), sessionId);
        } else if (2 == topnType || 17 == topnType) {
            HttpSrcOutTopNStaticData.getInstance().addDataList(new ArrayList<DnsGraph>(dnsTopNFormList), sessionId);
        } else if (3 == topnType) {
            HttpsSrcInTopNStaticData.getInstance().addDataList(new ArrayList<DnsGraph>(dnsTopNFormList), sessionId);
        } else if (4 == topnType) {
            HttpsSrcOutTopNStaticData.getInstance().addDataList(new ArrayList<DnsGraph>(dnsTopNFormList), sessionId);
        } else if (14 == topnType) {
            HttpUrlInTopNStaticData.getInstance().addDataList(new ArrayList<DnsGraph>(dnsTopNFormList), sessionId);
        } else if (15 == topnType) {
            HttpHostInTopNStaticData.getInstance().addDataList(new ArrayList<DnsGraph>(dnsTopNFormList), sessionId);
        }
    }

    private static void processDnsSaveData(List<DnsGraph> dnsTopNFormList, long sessionId, int topnType, boolean isSrcIp) {
        if (6 == topnType || 8 == topnType) {
            if (isSrcIp) {
                DnsRequestSrcIpInTopNStaticData.getInstance().addDataList(new ArrayList<DnsGraph>(dnsTopNFormList), sessionId);
            } else {
                DnsRequestInTopNStaticData.getInstance().addDataList(new ArrayList<DnsGraph>(dnsTopNFormList), sessionId);
            }
        } else if (7 == topnType || 9 == topnType) {
            if (isSrcIp) {
                DnsRequestSrcIpOutTopNStaticData.getInstance().addDataList(new ArrayList<DnsGraph>(dnsTopNFormList), sessionId);
            } else {
                DnsRequestOutTopNStaticData.getInstance().addDataList(new ArrayList<DnsGraph>(dnsTopNFormList), sessionId);
            }
        } else if (10 == topnType) {
            DnsReplyInTopNStaticData.getInstance().addDataList(new ArrayList<DnsGraph>(dnsTopNFormList), sessionId);
        }
    }

    public static void processDeleteDataToStaticData(long sessionId, int topnType, boolean isSrcIp) {
        ReportAnalysisUtil.processDnsQueryAndReplyDelData(sessionId, topnType, isSrcIp);
        ReportAnalysisUtil.processHttpDelData(sessionId, topnType);
        ReportAnalysisUtil.processSipDelData(sessionId, topnType);
    }

    private static void processSipDelData(long sessionId, int topnType) {
        if (11 == topnType) {
            SipSrcInTopNStaticData.getInstance().removeData(sessionId);
        } else if (12 == topnType) {
            SipCallerInTopNStaticData.getInstance().removeData(sessionId);
        } else if (13 == topnType) {
            SipCalleeInTopNStaticData.getInstance().removeData(sessionId);
        }
    }

    private static void processHttpDelData(long sessionId, int topnType) {
        if (1 == topnType || 16 == topnType) {
            HttpSrcInTopNStaticData.getInstance().removeData(sessionId);
        } else if (2 == topnType || 17 == topnType) {
            HttpSrcOutTopNStaticData.getInstance().removeData(sessionId);
        } else if (3 == topnType) {
            HttpsSrcInTopNStaticData.getInstance().removeData(sessionId);
        } else if (4 == topnType) {
            HttpsSrcOutTopNStaticData.getInstance().removeData(sessionId);
        } else if (14 == topnType) {
            HttpUrlInTopNStaticData.getInstance().removeData(sessionId);
        } else if (15 == topnType) {
            HttpHostInTopNStaticData.getInstance().removeData(sessionId);
        }
    }

    private static void processDnsQueryAndReplyDelData(long sessionId, int topnType, boolean isSrcIp) {
        if (6 == topnType || 8 == topnType) {
            if (isSrcIp) {
                DnsRequestSrcIpInTopNStaticData.getInstance().removeData(sessionId);
            } else {
                DnsRequestInTopNStaticData.getInstance().removeData(sessionId);
            }
        } else if (7 == topnType || 9 == topnType) {
            if (isSrcIp) {
                DnsRequestSrcIpOutTopNStaticData.getInstance().removeData(sessionId);
            } else {
                DnsRequestOutTopNStaticData.getInstance().removeData(sessionId);
            }
        } else if (10 == topnType) {
            DnsReplyInTopNStaticData.getInstance().removeData(sessionId);
        }
    }

    public static List<DnsGraph> getDataFromStaticData(TopNPara4ReportPrepareObj topNPara4ReportPrepareObj) {
        int topnType = topNPara4ReportPrepareObj.getTopnType();
        String reportId = topNPara4ReportPrepareObj.getReportId();
        String dataSourceId = topNPara4ReportPrepareObj.getDataSourceId();
        Map<?, ?> queryCond = topNPara4ReportPrepareObj.getQueryCond();
        long sessionId = topNPara4ReportPrepareObj.getSessionId();
        HashMap<Integer, List<DnsGraph>> dataMap4TopnType = new HashMap<Integer, List<DnsGraph>>();
        List<DnsGraph> dnsTopNHttpSrcIpIn = ReportAnalysisUtil.processHttpSrcIpInData(topnType, reportId, dataSourceId, queryCond, sessionId);
        dataMap4TopnType.put(1, dnsTopNHttpSrcIpIn);
        dataMap4TopnType.put(16, dnsTopNHttpSrcIpIn);
        List<DnsGraph> dnsTopNHttpSrcIpOut = ReportAnalysisUtil.processHttpSrcIpOutData(topnType, reportId, dataSourceId, queryCond, sessionId);
        dataMap4TopnType.put(2, dnsTopNHttpSrcIpOut);
        dataMap4TopnType.put(17, dnsTopNHttpSrcIpOut);
        List<DnsGraph> dnsTopNHttpsSrcIpIn = ReportAnalysisUtil.processHttpsSrcIpInData(topnType, reportId, dataSourceId, queryCond, sessionId);
        dataMap4TopnType.put(3, dnsTopNHttpsSrcIpIn);
        List<DnsGraph> dnsTopNHttpsSrcIpOut = ReportAnalysisUtil.processHttpsSrcIpOutData(topnType, reportId, dataSourceId, queryCond, sessionId);
        dataMap4TopnType.put(4, dnsTopNHttpsSrcIpOut);
        List<DnsGraph> dnsTopNDnsQueryIn = ReportAnalysisUtil.processDnsQueryInData(topNPara4ReportPrepareObj);
        dataMap4TopnType.put(6, dnsTopNDnsQueryIn);
        dataMap4TopnType.put(8, dnsTopNDnsQueryIn);
        List<DnsGraph> dnsTopNDnsQueryOut = ReportAnalysisUtil.processDnsQueryOutData(topNPara4ReportPrepareObj);
        dataMap4TopnType.put(7, dnsTopNDnsQueryOut);
        dataMap4TopnType.put(9, dnsTopNDnsQueryOut);
        List<DnsGraph> dnsTopNDnsReplyIn = ReportAnalysisUtil.processDnsReplyInData(topnType, reportId, dataSourceId, queryCond, sessionId);
        dataMap4TopnType.put(10, dnsTopNDnsReplyIn);
        List<DnsGraph> dnsTopNSipSrcIpIn = ReportAnalysisUtil.processSipSrcIpInData(topnType, reportId, dataSourceId, queryCond, sessionId);
        dataMap4TopnType.put(11, dnsTopNSipSrcIpIn);
        List<DnsGraph> dnsTopNSipCallerIn = ReportAnalysisUtil.processSipCallerInData(topnType, reportId, dataSourceId, queryCond, sessionId);
        dataMap4TopnType.put(12, dnsTopNSipCallerIn);
        List<DnsGraph> dnsTopNSipCalleeIn = ReportAnalysisUtil.processSipCalleeInData(topnType, reportId, dataSourceId, queryCond, sessionId);
        dataMap4TopnType.put(13, dnsTopNSipCalleeIn);
        List<DnsGraph> dnsTopNHttpUrlIn = ReportAnalysisUtil.processHttpUrlInData(topnType, reportId, dataSourceId, queryCond, sessionId);
        dataMap4TopnType.put(14, dnsTopNHttpUrlIn);
        List<DnsGraph> dnsTopNHttpHostIn = ReportAnalysisUtil.processHttpHostInData(topnType, reportId, dataSourceId, queryCond, sessionId);
        dataMap4TopnType.put(15, dnsTopNHttpHostIn);
        if (dataMap4TopnType.containsKey(topnType)) {
            return (List)dataMap4TopnType.get(topnType);
        }
        return new ArrayList<DnsGraph>();
    }

    private static List<DnsGraph> processSipCalleeInData(int topnType, String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        List<DnsGraph> dnsTopNFormList = new ArrayList<DnsGraph>();
        if (13 == topnType) {
            Map<Long, List<DnsGraph>> map = SipCalleeInTopNStaticData.getInstance().getDataList();
            if (map.containsKey(sessionId)) {
                dnsTopNFormList = map.get(sessionId);
            } else {
                SipCalleeInTopNDataSet sipCalleeInTopNDataSet = new SipCalleeInTopNDataSet();
                sipCalleeInTopNDataSet.prepareData(reportId, dataSourceId, queryCond, sessionId);
                dnsTopNFormList = SipCalleeInTopNStaticData.getInstance().getDataList().get(sessionId);
            }
            SipCalleeInTopNStaticData.getInstance().removeData(sessionId);
        }
        return dnsTopNFormList;
    }

    private static List<DnsGraph> processSipCallerInData(int topnType, String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        List<DnsGraph> dnsTopNFormList = new ArrayList<DnsGraph>();
        if (12 == topnType) {
            Map<Long, List<DnsGraph>> map = SipCallerInTopNStaticData.getInstance().getDataList();
            if (map.containsKey(sessionId)) {
                dnsTopNFormList = map.get(sessionId);
            } else {
                SipCallerInTopNDataSet sipCallerInTopNDataSet = new SipCallerInTopNDataSet();
                sipCallerInTopNDataSet.prepareData(reportId, dataSourceId, queryCond, sessionId);
                dnsTopNFormList = SipCallerInTopNStaticData.getInstance().getDataList().get(sessionId);
            }
            SipCallerInTopNStaticData.getInstance().removeData(sessionId);
        }
        return dnsTopNFormList;
    }

    private static List<DnsGraph> processSipSrcIpInData(int topnType, String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        List<DnsGraph> dnsTopNFormList = new ArrayList<DnsGraph>();
        if (11 == topnType) {
            Map<Long, List<DnsGraph>> map = SipSrcInTopNStaticData.getInstance().getDataList();
            if (map.containsKey(sessionId)) {
                dnsTopNFormList = map.get(sessionId);
            } else {
                SipSrcInTopNDataSet sipSrcInTopNDataSet = new SipSrcInTopNDataSet();
                sipSrcInTopNDataSet.prepareData(reportId, dataSourceId, queryCond, sessionId);
                dnsTopNFormList = SipSrcInTopNStaticData.getInstance().getDataList().get(sessionId);
            }
            SipSrcInTopNStaticData.getInstance().removeData(sessionId);
        }
        return dnsTopNFormList;
    }

    private static List<DnsGraph> processHttpHostInData(int topnType, String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        List<DnsGraph> dnsTopNFormList = new ArrayList<DnsGraph>();
        if (15 == topnType) {
            Map<Long, List<DnsGraph>> map = HttpHostInTopNStaticData.getInstance().getDataList();
            if (map.containsKey(sessionId)) {
                dnsTopNFormList = map.get(sessionId);
            } else {
                HttpHostInTopNDataSet httpHostInTopNDataSet = new HttpHostInTopNDataSet();
                httpHostInTopNDataSet.prepareData(reportId, dataSourceId, queryCond, sessionId);
                dnsTopNFormList = HttpHostInTopNStaticData.getInstance().getDataList().get(sessionId);
            }
            HttpHostInTopNStaticData.getInstance().removeData(sessionId);
        }
        return dnsTopNFormList;
    }

    private static List<DnsGraph> processHttpUrlInData(int topnType, String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        List<DnsGraph> dnsTopNFormList = new ArrayList<DnsGraph>();
        if (14 == topnType) {
            Map<Long, List<DnsGraph>> map = HttpUrlInTopNStaticData.getInstance().getDataList();
            if (map.containsKey(sessionId)) {
                dnsTopNFormList = map.get(sessionId);
            } else {
                HttpUrlInTopNDataSet httpUrlInTopNDataSet = new HttpUrlInTopNDataSet();
                httpUrlInTopNDataSet.prepareData(reportId, dataSourceId, queryCond, sessionId);
                dnsTopNFormList = HttpUrlInTopNStaticData.getInstance().getDataList().get(sessionId);
            }
            HttpUrlInTopNStaticData.getInstance().removeData(sessionId);
        }
        return dnsTopNFormList;
    }

    private static List<DnsGraph> processHttpsSrcIpOutData(int topnType, String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        List<DnsGraph> dnsTopNFormList = new ArrayList<DnsGraph>();
        if (4 == topnType) {
            Map<Long, List<DnsGraph>> map = HttpsSrcOutTopNStaticData.getInstance().getDataList();
            if (map.containsKey(sessionId)) {
                dnsTopNFormList = map.get(sessionId);
            } else {
                HttpsSrcOutTopNDataSet httpsSrcOutTopNDataSet = new HttpsSrcOutTopNDataSet();
                httpsSrcOutTopNDataSet.prepareData(reportId, dataSourceId, queryCond, sessionId);
                dnsTopNFormList = HttpsSrcOutTopNStaticData.getInstance().getDataList().get(sessionId);
            }
            HttpsSrcOutTopNStaticData.getInstance().removeData(sessionId);
        }
        return dnsTopNFormList;
    }

    private static List<DnsGraph> processHttpsSrcIpInData(int topnType, String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        List<DnsGraph> dnsTopNFormList = new ArrayList<DnsGraph>();
        if (3 == topnType) {
            Map<Long, List<DnsGraph>> map = HttpsSrcInTopNStaticData.getInstance().getDataList();
            if (map.containsKey(sessionId)) {
                dnsTopNFormList = map.get(sessionId);
            } else {
                HttpsSrcInTopNDataSet httpsSrcInTopNDataSet = new HttpsSrcInTopNDataSet();
                httpsSrcInTopNDataSet.prepareData(reportId, dataSourceId, queryCond, sessionId);
                dnsTopNFormList = HttpsSrcInTopNStaticData.getInstance().getDataList().get(sessionId);
            }
            HttpsSrcInTopNStaticData.getInstance().removeData(sessionId);
        }
        return dnsTopNFormList;
    }

    private static List<DnsGraph> processHttpSrcIpOutData(int topnType, String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        List<DnsGraph> dnsTopNFormList = new ArrayList<DnsGraph>();
        if (2 == topnType || 17 == topnType) {
            Map<Long, List<DnsGraph>> map = HttpSrcOutTopNStaticData.getInstance().getDataList();
            if (map.containsKey(sessionId)) {
                dnsTopNFormList = map.get(sessionId);
            } else {
                HttpSrcOutTopNDataSet httpSrcOutTopNDataSet = new HttpSrcOutTopNDataSet();
                httpSrcOutTopNDataSet.prepareData(reportId, dataSourceId, queryCond, sessionId);
                dnsTopNFormList = HttpSrcOutTopNStaticData.getInstance().getDataList().get(sessionId);
            }
            HttpSrcOutTopNStaticData.getInstance().removeData(sessionId);
        }
        return dnsTopNFormList;
    }

    private static List<DnsGraph> processHttpSrcIpInData(int topnType, String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        List<DnsGraph> dnsTopNFormList = new ArrayList<DnsGraph>();
        if (1 == topnType || 16 == topnType) {
            Map<Long, List<DnsGraph>> map = HttpSrcInTopNStaticData.getInstance().getDataList();
            if (map.containsKey(sessionId)) {
                dnsTopNFormList = map.get(sessionId);
            } else {
                HttpSrcInTopNDataSet httpSrcInTopNDataSet = new HttpSrcInTopNDataSet();
                httpSrcInTopNDataSet.prepareData(reportId, dataSourceId, queryCond, sessionId);
                dnsTopNFormList = HttpSrcInTopNStaticData.getInstance().getDataList().get(sessionId);
            }
            HttpSrcInTopNStaticData.getInstance().removeData(sessionId);
        }
        return dnsTopNFormList;
    }

    private static List<DnsGraph> processDnsReplyInData(int topnType, String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        List<DnsGraph> dnsTopNFormList = new ArrayList<DnsGraph>();
        if (10 == topnType) {
            Map<Long, List<DnsGraph>> map = DnsReplyInTopNStaticData.getInstance().getDataList();
            if (map.containsKey(sessionId)) {
                dnsTopNFormList = map.get(sessionId);
            } else {
                DnsReplyInTopNDataSet dnsReplyInTopNDataSet = new DnsReplyInTopNDataSet();
                dnsReplyInTopNDataSet.prepareData(reportId, dataSourceId, queryCond, sessionId);
                dnsTopNFormList = DnsReplyInTopNStaticData.getInstance().getDataList().get(sessionId);
            }
            DnsReplyInTopNStaticData.getInstance().removeData(sessionId);
        }
        return dnsTopNFormList;
    }

    private static List<DnsGraph> processDnsQueryOutData(TopNPara4ReportPrepareObj topNPara4ReportPrepareObj) {
        int topnType = topNPara4ReportPrepareObj.getTopnType();
        String reportId = topNPara4ReportPrepareObj.getReportId();
        String dataSourceId = topNPara4ReportPrepareObj.getDataSourceId();
        Map<?, ?> queryCond = topNPara4ReportPrepareObj.getQueryCond();
        long sessionId = topNPara4ReportPrepareObj.getSessionId();
        boolean isSrcIp = topNPara4ReportPrepareObj.isSrcIp();
        List<DnsGraph> dnsTopNFormList = new ArrayList<DnsGraph>();
        if (7 == topnType || 9 == topnType) {
            if (isSrcIp) {
                Map<Long, List<DnsGraph>> map = DnsRequestSrcIpOutTopNStaticData.getInstance().getDataList();
                if (map.containsKey(sessionId)) {
                    dnsTopNFormList = map.get(sessionId);
                } else {
                    DnsRequestOutTopNDataSet dnsRequestOutTopNDataSet = new DnsRequestOutTopNDataSet();
                    dnsRequestOutTopNDataSet.prepareData(reportId, dataSourceId, queryCond, sessionId);
                    dnsTopNFormList = DnsRequestSrcIpOutTopNStaticData.getInstance().getDataList().get(sessionId);
                }
                DnsRequestSrcIpOutTopNStaticData.getInstance().removeData(sessionId);
            } else {
                Map<Long, List<DnsGraph>> map = DnsRequestOutTopNStaticData.getInstance().getDataList();
                if (map.containsKey(sessionId)) {
                    dnsTopNFormList = map.get(sessionId);
                } else {
                    DnsRequestOutTopNDataSet dnsRequestOutTopNDataSet = new DnsRequestOutTopNDataSet();
                    dnsRequestOutTopNDataSet.prepareData(reportId, dataSourceId, queryCond, sessionId);
                    dnsTopNFormList = DnsRequestOutTopNStaticData.getInstance().getDataList().get(sessionId);
                }
                DnsRequestOutTopNStaticData.getInstance().removeData(sessionId);
            }
        }
        return dnsTopNFormList;
    }

    private static List<DnsGraph> processDnsQueryInData(TopNPara4ReportPrepareObj topNPara4ReportPrepareObj) {
        int topnType = topNPara4ReportPrepareObj.getTopnType();
        String reportId = topNPara4ReportPrepareObj.getReportId();
        String dataSourceId = topNPara4ReportPrepareObj.getDataSourceId();
        Map<?, ?> queryCond = topNPara4ReportPrepareObj.getQueryCond();
        long sessionId = topNPara4ReportPrepareObj.getSessionId();
        boolean isSrcIp = topNPara4ReportPrepareObj.isSrcIp();
        List<DnsGraph> dnsTopNFormList = new ArrayList<DnsGraph>();
        if (6 == topnType || 8 == topnType) {
            if (isSrcIp) {
                Map<Long, List<DnsGraph>> map = DnsRequestSrcIpInTopNStaticData.getInstance().getDataList();
                if (map.containsKey(sessionId)) {
                    dnsTopNFormList = map.get(sessionId);
                } else {
                    DnsRequestInTopNDataSet dnsRequestInTopN = new DnsRequestInTopNDataSet();
                    dnsRequestInTopN.prepareData(reportId, dataSourceId, queryCond, sessionId);
                    dnsTopNFormList = DnsRequestSrcIpInTopNStaticData.getInstance().getDataList().get(sessionId);
                }
                DnsRequestSrcIpInTopNStaticData.getInstance().removeData(sessionId);
            } else {
                Map<Long, List<DnsGraph>> map = DnsRequestInTopNStaticData.getInstance().getDataList();
                if (map.containsKey(sessionId)) {
                    dnsTopNFormList = map.get(sessionId);
                } else {
                    DnsRequestInTopNDataSet dnsRequestInTopN = new DnsRequestInTopNDataSet();
                    dnsRequestInTopN.prepareData(reportId, dataSourceId, queryCond, sessionId);
                    dnsTopNFormList = DnsRequestInTopNStaticData.getInstance().getDataList().get(sessionId);
                }
                DnsRequestInTopNStaticData.getInstance().removeData(sessionId);
            }
        }
        return dnsTopNFormList;
    }

    public static String getUnitFromIntType(int ppsOrKbps) {
        if (ppsOrKbps == 0) {
            return "pps";
        }
        if (ppsOrKbps == 1) {
            return "kbps";
        }
        if (ppsOrKbps == 2) {
            return "qps";
        }
        if (ppsOrKbps == 3) {
            return "";
        }
        if (ppsOrKbps == 4) {
            return "";
        }
        if (ppsOrKbps == 5) {
            return "\u2030";
        }
        return "";
    }

    public static String getCurrentDis(AttackExactLogForm form) {
        String unit = ReportAnalysisUtil.getUnitFromIntType(form.getPpsOrKbps());
        String unit1 = ReportAnalysisUtil.getUnitFromIntType(form.getPpsOrKbps1());
        String currentValue = "";
        String current = CommonUtil.transformNumber((String)String.valueOf(form.getCurrent()), (String)unit);
        String current1 = CommonUtil.transformNumber((String)String.valueOf(form.getCurrent1()), (String)unit1);
        if (0L == form.getCurrent()) {
            current = "-";
        }
        if (0L == form.getCurrent1()) {
            current1 = "-";
        }
        currentValue = "kbps".equals(unit1) ? current1 + "/" + current : current + "/" + current1;
        return currentValue;
    }

    public static String getLimitDis(AttackExactLogForm form) {
        String limitValue;
        String unit = ReportAnalysisUtil.getUnitFromIntType(form.getPpsOrKbps());
        String string = limitValue = form.getLimit() == 0L ? "-" : CommonUtil.transformNumber((String)String.valueOf(form.getLimit()), (String)unit);
        if (form.isIsMultiCurrent()) {
            unit = ReportAnalysisUtil.getUnitFromIntType(form.getPpsOrKbps1());
            limitValue = limitValue + "/" + (form.getLimit1() == 0L ? "-" : CommonUtil.transformNumber((String)String.valueOf(form.getLimit1()), (String)unit));
        }
        return limitValue;
    }

    public static String getLimitDis(AttackTopnForm form) {
        String limitValue;
        String unit = ReportAnalysisUtil.getUnitFromIntType(form.getPpsOrKbps());
        String string = limitValue = form.getLimit() == 0L ? "-" : form.getLimit() + unit;
        if (form.isIsMultiCurrent()) {
            unit = ReportAnalysisUtil.getUnitFromIntType(form.getPpsOrKbps1());
            limitValue = limitValue + "/" + (form.getLimit1() == 0L ? "-" : form.getLimit1() + unit);
        }
        return limitValue;
    }

    public static boolean checkNeedQuery4InteReport(Map<?, ?> queryCond, String reportId) {
        String isInteReport = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
        if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true")) {
            boolean needQuery = false;
            String reportIds = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "reportIds").get(0).getValue());
            if (!AticUtil.isNull((String)reportIds)) {
                String[] reportIdStr = reportIds.split(",");
                for (int i = 0; i < reportIdStr.length; ++i) {
                    if (!reportId.equalsIgnoreCase(reportIdStr[i])) continue;
                    needQuery = true;
                    break;
                }
            }
            return needQuery;
        }
        return true;
    }

    public static void processFlowCompareChapter(String reportId, int chartStart, Map<String, List<String>> map, Locale locale, long sessionId) {
        List<String> hasDataReportIds = AllReportHaveDataCache.getInstance().getDataList(sessionId);
        if (reportId.equalsIgnoreCase("FluxCompareBPS") && hasDataReportIds.contains("FluxCompareBPS")) {
            ArrayList<String> fluxCompareBPS = new ArrayList<String>();
            String fluxCompartStr = AticUtil.getText((String)"report.cleanAndDetect.flowCompare.peakFlow", (Locale)locale);
            fluxCompareBPS.add(chartStart + "." + fluxCompartStr);
            map.put("fluxCompareBPS", fluxCompareBPS);
        }
    }

    public static void processAppFlowDisChapter(String reportId, int chartStart, Map<String, List<String>> map, Locale locale, boolean checkQueryPeakValue) {
        if (reportId.equalsIgnoreCase("AppFlowDis")) {
            ArrayList<String> appFluxDis = new ArrayList<String>();
            String appFluxDisStr = AticUtil.getText((String)"report.cleanAndDetect.appFluxDis.avgFlow", (Locale)locale);
            if (checkQueryPeakValue) {
                appFluxDisStr = AticUtil.getText((String)"report.cleanAndDetect.appFluxDis.peakFlow", (Locale)locale);
            }
            appFluxDis.add(chartStart + "." + appFluxDisStr);
            map.put("appFluxDis", appFluxDis);
        }
    }

    public static void processAttackDisCountChapter(String reportId, int chartStart, Map<String, List<String>> map, Locale locale, int deviceType) {
        if (reportId.equalsIgnoreCase("AttackDisCount")) {
            ArrayList<String> attackDisCount = new ArrayList<String>();
            ArrayList<String> attackDisCountChartName = new ArrayList<String>();
            if (deviceType == 1) {
                attackDisCount.add(chartStart + "." + AticUtil.getText((String)"report.detect.attackDis", (Locale)locale));
                attackDisCountChartName.add(AticUtil.getText((String)"report.detect.attackDisChartName", (Locale)locale));
            } else {
                attackDisCount.add(chartStart + "." + AticUtil.getText((String)"report.clean.attackDis", (Locale)locale));
                attackDisCountChartName.add(AticUtil.getText((String)"report.clean.attackDisChartName", (Locale)locale));
            }
            map.put("attackDisCount", attackDisCount);
            map.put("attackDisCountChartName", attackDisCountChartName);
        }
    }

    public static void processAttackDisPacketChapter(String reportId, int chartStart, Map<String, List<String>> map, Locale locale, int deviceType) {
        if (reportId.equalsIgnoreCase("AttackDisPacket")) {
            ArrayList<String> attackDisPacket = new ArrayList<String>();
            if (deviceType == 0) {
                attackDisPacket.add(chartStart + "." + AticUtil.getText((String)"report.clean.attackDisPacket", (Locale)locale));
            }
            map.put("attackDisPacket", attackDisPacket);
        }
    }

    public static void processAttackTrendChapter(String reportId, int chartStart, Map<String, List<String>> map, Locale locale, int deviceType, long sessionId) {
        List<String> hasDataReportIds = AllReportHaveDataCache.getInstance().getDataList(sessionId);
        if (reportId.equalsIgnoreCase("AttackTrend") && hasDataReportIds.contains("AttackTrend")) {
            ArrayList<String> attackTrend = new ArrayList<String>();
            if (deviceType == 0) {
                attackTrend.add(chartStart + "." + AticUtil.getText((String)"report.clean.attackTrend", (Locale)locale));
            }
            map.put("attackTrend", attackTrend);
        }
    }

    public static void processAttackCountChapter(String reportId, int chartStart, Map<String, List<String>> map, Locale locale, int deviceType) {
        if (reportId.equalsIgnoreCase("AttackCount")) {
            ArrayList<String> attackCountList = new ArrayList<String>();
            ArrayList<String> attackCountChartName = new ArrayList<String>();
            if (deviceType == 1) {
                attackCountList.add(chartStart + "." + AticUtil.getText((String)"report.detect.attackCount", (Locale)locale));
                attackCountChartName.add(AticUtil.getText((String)"report.detect.attackCountChartName", (Locale)locale));
            } else {
                attackCountList.add(chartStart + "." + AticUtil.getText((String)"report.clean.attackCount", (Locale)locale));
                attackCountChartName.add(AticUtil.getText((String)"report.clean.attackCountChartName", (Locale)locale));
            }
            map.put("attackCount", attackCountList);
            map.put("attackCountChartName", attackCountChartName);
        }
    }

    public static void processAttackCountCompareChapter(String reportId, int chartStart, Map<String, List<String>> map, Locale locale, int deviceType) {
        if (reportId.equalsIgnoreCase("AttackCountCompare")) {
            ArrayList<String> attackCountCompare = new ArrayList<String>();
            ArrayList<String> attackCountCompareChartName = new ArrayList<String>();
            if (deviceType == 1) {
                attackCountCompare.add(chartStart + "." + AticUtil.getText((String)"report.detect.attackCountCompare", (Locale)locale));
                attackCountCompareChartName.add(AticUtil.getText((String)"report.detect.attackCountCompareChartName", (Locale)locale));
            } else {
                attackCountCompare.add(chartStart + "." + AticUtil.getText((String)"report.clean.attackCountCompare", (Locale)locale));
                attackCountCompareChartName.add(AticUtil.getText((String)"report.clean.attackCountCompareChartName", (Locale)locale));
            }
            map.put("attackCountCompare", attackCountCompare);
            map.put("attackCountCompareChartName", attackCountCompareChartName);
        }
    }

    public static void processAttackEventTopNChapter(String reportId, int chartStart, Map<String, List<String>> map, Locale locale, int deviceType, long sessionId) {
        List<String> hasDataReportIds = AllReportHaveDataCache.getInstance().getDataList(sessionId);
        if (reportId.equalsIgnoreCase("AttackEventTopN") && hasDataReportIds.contains("AttackEventTopN")) {
            ArrayList<String> attackEventTopN = new ArrayList<String>();
            ArrayList<String> attackEventTopNpps = new ArrayList<String>();
            ArrayList<String> attackEventTopNDuration = new ArrayList<String>();
            if (deviceType == 0) {
                attackEventTopN.add(chartStart + "." + AticUtil.getText((String)"report.clean.attackEventTopN", (Locale)locale));
                attackEventTopNpps.add(AticUtil.getText((String)"report.clean.attackEventTopN.pps", (Locale)locale));
                attackEventTopNDuration.add(AticUtil.getText((String)"report.clean.attackEventTopN.duration", (Locale)locale));
            }
            map.put("attackEventTopN", attackEventTopN);
            map.put("attackEventTopNPps", attackEventTopNpps);
            map.put("attackEventTopNDuration", attackEventTopNDuration);
        }
    }

    public static boolean isContainV1(String deviceId, String zoneId) {
        IAticDeviceService aticDeviceService = ReportBisUtil.getIFirewallService();
        if (null == deviceId) {
            return false;
        }
        if (deviceId.equals(String.valueOf(-2))) {
            return false;
        }
        if (deviceId.equals(String.valueOf(-1))) {
            DataSourceStub dataSourceStub = new DataSourceStub();
            List deviceList = null;
            deviceList = AticUtil.isNull((String)zoneId) || zoneId.equals("0") ? dataSourceStub.getCleanDeviceList() : aticDeviceService.getDeviceByZoneId((long)Integer.parseInt(zoneId));
            return CommonUtil.includesV1R1(deviceList);
        }
        if (deviceId.contains("_")) {
            String[] deviceIdS = deviceId.split("_");
            ArrayList<AticDevice> deviceList = new ArrayList<AticDevice>();
            AticDevice aticDevice = ReportBisUtil.getIFirewallService().getDeviceByMoid(Long.parseLong(deviceIdS[0]));
            if (null != aticDevice) {
                deviceList.add(aticDevice);
            }
            return CommonUtil.includesV1R1(deviceList);
        }
        return false;
    }

    public static void processIpAttackCountTopNChapter(String reportId, int chartStart, Map<String, List<String>> map, Locale locale, int deviceType) {
        if (reportId.equalsIgnoreCase("IpAttackCountTopN")) {
            ArrayList<String> zoneAttackCountTopN = new ArrayList<String>();
            if (deviceType == 1) {
                zoneAttackCountTopN.add(chartStart + "." + AticUtil.getText((String)"report.detect.ipAttackCountTopN", (Locale)locale));
            } else {
                zoneAttackCountTopN.add(chartStart + "." + AticUtil.getText((String)"report.clean.ipAttackCountTopN", (Locale)locale));
            }
            map.put("ipAttackCountTopN", zoneAttackCountTopN);
        }
    }

    public static void processTopNChapter(String reportId, int chartStart, Map<String, List<String>> map, Locale locale) {
        if (reportId.equalsIgnoreCase("DnsRequestTopN")) {
            ArrayList<String> requestDomainTopN = new ArrayList<String>();
            requestDomainTopN.add(chartStart + "." + AticUtil.getText((String)"report.cleanAndDetect.dnsNameRequest", (Locale)locale));
            map.put("requestDomainTopN", requestDomainTopN);
        }
        if (reportId.equalsIgnoreCase("SrcIpRequestTopN")) {
            ArrayList<String> requestSrcIpTopN = new ArrayList<String>();
            requestSrcIpTopN.add(chartStart + "." + AticUtil.getText((String)"report.cleanAndDetect.srcIpRequest", (Locale)locale));
            map.put("requestSrcIpTopN", requestSrcIpTopN);
        }
        if (reportId.equalsIgnoreCase("HttpSrcTopN")) {
            ArrayList<String> httpSrcIpTopN = new ArrayList<String>();
            httpSrcIpTopN.add(chartStart + "." + AticUtil.getText((String)"atic.analysis.report.tab.http.src.topn", (Locale)locale));
            map.put("httpSrcIpTopN", httpSrcIpTopN);
        }
        if (reportId.equalsIgnoreCase("HttpURlTopN")) {
            ArrayList<String> httpUrlTopN = new ArrayList<String>();
            httpUrlTopN.add(chartStart + "." + AticUtil.getText((String)"atic.analysis.report.tab.http.url.topn", (Locale)locale));
            map.put("httpUrlTopN", httpUrlTopN);
        }
        if (reportId.equalsIgnoreCase("SipSrcTopN")) {
            ArrayList<String> sipSrcTopN = new ArrayList<String>();
            sipSrcTopN.add(chartStart + "." + AticUtil.getText((String)"atic.analysis.report.tab.sip.src.topn", (Locale)locale));
            map.put("sipSrcTopN", sipSrcTopN);
        }
        if (reportId.equalsIgnoreCase("SipCallerTopN")) {
            ArrayList<String> sipCallerTopN = new ArrayList<String>();
            sipCallerTopN.add(chartStart + "." + AticUtil.getText((String)"atic.analysis.report.tab.sip.caller.topn", (Locale)locale));
            map.put("sipCallerTopN", sipCallerTopN);
        }
    }

    public static void processAttackIpCountChapter(String reportId, int chartStart, Map<String, List<String>> map, Locale locale, int deviceType) {
        if (reportId.equalsIgnoreCase("AttackIpCount")) {
            ArrayList<String> attackIpCount = new ArrayList<String>();
            if (deviceType == 1) {
                attackIpCount.add(chartStart + "." + AticUtil.getText((String)"report.detect.attackIpCount", (Locale)locale));
            } else {
                attackIpCount.add(chartStart + "." + AticUtil.getText((String)"report.clean.attackIpCount", (Locale)locale));
            }
            map.put("attackIpCount", attackIpCount);
        }
    }

    public static void processZoneAttackCountTopNChapter(String reportId, int chartStart, Map<String, List<String>> map, Locale locale, int deviceType) {
        if (reportId.equalsIgnoreCase("ZoneAttackCountTopN")) {
            ArrayList<String> zoneAttackCountTopN = new ArrayList<String>();
            if (deviceType == 1) {
                zoneAttackCountTopN.add(chartStart + "." + AticUtil.getText((String)"report.detect.zoneAttackCountTopN", (Locale)locale));
            } else {
                zoneAttackCountTopN.add(chartStart + "." + AticUtil.getText((String)"report.clean.zoneAttackCountTopN", (Locale)locale));
            }
            map.put("zoneAttackCountTopN", zoneAttackCountTopN);
        }
    }

    public static String processDeviceType4SysAndZoneReport(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Map<String, List<String>> map) {
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        String deviceName = String.valueOf(jsonValueItem.get(0).getText());
        deviceName = ReportAnalysisUtil.getStrContent4HtmlFile(deviceName, 16);
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        int deviceType = datastatConditionForm.getDevSerType();
        ArrayList<String> deviceTypeList = new ArrayList<String>();
        if (deviceType == 1) {
            deviceTypeList.add("detect");
        } else {
            deviceTypeList.add("clean");
        }
        ArrayList<String> deviceIdList = new ArrayList<String>();
        deviceIdList.add(deviceId);
        map.put("deviceIdList", deviceIdList);
        map.put("isCleanDevice", deviceTypeList);
        return deviceName;
    }

    public static void processCompNameAndLogo4SysAndZoneReport(Map<String, List<String>> map, Locale locale, String reportType, String direction) {
        String companyName = ReportAnalysisUtil.getCompanyName();
        String companyLogo = ReportAnalysisUtil.getCompaneLog();
        String reportTileFormat = "";
        reportTileFormat = reportType.equalsIgnoreCase("sys") ? AticUtil.getText((String)"report.total.sys.summary.sysReport.title", (Locale)locale) : AticUtil.getText((String)"report.total.zone.summary.zoneReport.title", (Locale)locale);
        Object[] reportTileObjs = new Object[]{companyName};
        reportTileFormat = MessageFormat.format(reportTileFormat, reportTileObjs);
        ArrayList<String> reportTile = new ArrayList<String>();
        String reportTitleStr = reportTileFormat;
        if (!AticUtil.isNull((String)direction)) {
            reportTitleStr = reportTitleStr + ReportAnalysisUtil.getInOrOutbound(direction);
        }
        reportTile.add(reportTitleStr);
        map.put("reportName", reportTile);
        String reportDescFormat = AticUtil.getText((String)"report.total.summary.desc", (Locale)locale);
        Object[] reportDescObjs = new Object[]{companyName};
        reportDescFormat = MessageFormat.format(reportDescFormat, reportDescObjs);
        ArrayList<String> reportDesc = new ArrayList<String>();
        reportDesc.add(TAB_SPACE + reportDescFormat);
        map.put("reportDesc", reportDesc);
        ArrayList<String> logUrl = new ArrayList<String>();
        logUrl.add(companyLogo);
        map.put("logImageUrl", logUrl);
    }

    private static String getInOrOutbound(String direction) {
        String returnStr = "(Inbound)";
        if ("2".equals(direction)) {
            returnStr = "(Outbound)";
        }
        return returnStr;
    }

    public static String getAttackTime4SysAndZoneReport(Long sessionId, DataStatConditionForm datastatConditionForm, Locale locale) {
        List<AttackCountTrend> dataListTemp = TransmitAttackCountTrendData.getInstance().getDataList(sessionId);
        TransmitAttackCountTrendData.getInstance().removeData(sessionId);
        HashMap<Long, Object> timeAttackCount = new HashMap<Long, Object>();
        for (AttackCountTrend item : dataListTemp) {
            if (timeAttackCount.containsKey(item.getDateTime())) {
                Object attackCount = (Long)timeAttackCount.get(item.getDateTime());
                attackCount = (Long)attackCount + item.getAttackTypeCount();
                timeAttackCount.put(item.getDateTime(), attackCount);
                continue;
            }
            timeAttackCount.put(item.getDateTime(), item.getAttackTypeCount());
        }
        Long maxAttackCount = 0L;
        Long maxAttackTime = 0L;
        for (Map.Entry entry : timeAttackCount.entrySet()) {
            if ((Long)entry.getValue() < maxAttackCount) continue;
            maxAttackCount = (Long)entry.getValue();
            maxAttackTime = (Long)entry.getKey();
        }
        if (maxAttackCount == 0L) {
            return "";
        }
        Integer timeSpan = ReportAnalysisUtil.getTimeSpanType(datastatConditionForm.getEndTime(), datastatConditionForm.getStartTime());
        Long maxAttackTimeEnd = 0L;
        maxAttackTime = maxAttackTime / 1000L;
        maxAttackTimeEnd = timeSpan.equals(AnalysisConstants.MORE_THAN_SEVEN_DAYS) ? Long.valueOf(maxAttackTime + 86400L) : Long.valueOf(maxAttackTime + 3600L);
        if (maxAttackTimeEnd > datastatConditionForm.getEndTime()) {
            maxAttackTimeEnd = datastatConditionForm.getEndTime();
        }
        String returnStr = AticUtil.convertTimeLong((Long)maxAttackTime) + " " + AticUtil.getText((String)"atic.report.common.to4Report", (Locale)locale) + " " + AticUtil.convertTimeLong((Long)maxAttackTimeEnd);
        returnStr = returnStr + "#" + maxAttackCount;
        return returnStr;
    }

    public static String getIpLocationName(int ipLocationId) {
        ILocationCustomService locationCustomService;
        LocationCustomForm locationCustomForm;
        ILibraryFileService libraryFileService = ReportBisUtil.getLibraryFileService();
        Locale locale = LocaleUtil.INSTANCE.getCurrentUserLocale();
        String language = locale.getLanguage();
        IpLocation ipLocation = (IpLocation)libraryFileService.getIpLocationMap().get(ipLocationId);
        String ipLocationName = "";
        ipLocationName = null != ipLocation ? (language.equalsIgnoreCase("zh") ? ipLocation.getLocationNameZh() : ipLocation.getLocationNameEn()) : (ipLocationId >= 3000 ? (null != (locationCustomForm = (locationCustomService = ReportBisUtil.getLocationCustomService()).findById(Long.valueOf(ipLocationId))) ? locationCustomForm.getLocationName() : AticUtil.getText((String)"atic.bis.location.unknownLoc") + ipLocationId) : AticUtil.getText((String)"atic.bis.location.unknownLoc") + ipLocationId);
        return ipLocationName;
    }

    public static String getIpLocationShortName(int ipLocationId) {
        ILibraryFileService libraryFileService = ReportBisUtil.getLibraryFileService();
        IpLocation ipLocation = (IpLocation)libraryFileService.getIpLocationMap().get(ipLocationId);
        String shortName = "";
        if (null != ipLocation) {
            shortName = ipLocation.getShortName();
        }
        return shortName;
    }

    public static Map<String, String> getAllIpAndDeviceName() {
        List deviceList = ReportBisUtil.getIFirewallService().getAllDevice();
        HashMap<String, String> ipAndDeviceName = new HashMap<String, String>();
        if (null != deviceList && !deviceList.isEmpty()) {
            for (AticDevice device : deviceList) {
                ipAndDeviceName.put(DataEncodeUtil.encode(device.getIpAddress()), DataEncodeUtil.encode(device.getName()));
            }
        }
        return ipAndDeviceName;
    }

    public static boolean validatePageSizeOrEmpty() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String pageSize = request.getParameter("pageSize");
        if (null == pageSize) {
            return true;
        }
        String regex = "^(|10|20|30|50|100)$";
        return pageSize.matches(regex);
    }

    public static List<AticDevice> getAllDetectList4Cluster(IAticDeviceService firewallService, long userId) {
        List detectDeviceList = firewallService.getDetectDevice(userId);
        ArrayList<AticDevice> returnList = new ArrayList<AticDevice>();
        IClusterService clusterService = ReportBisUtil.getClusterService();
        for (AticDevice tempDev : detectDeviceList) {
            if (clusterService.isBelongCluster(Long.valueOf(tempDev.getMoId()))) continue;
            returnList.add(tempDev);
        }
        return returnList;
    }

    public static void processDirectionQueryCondition(Map<?, ?> queryCond) {
        JsonValueObj direction = (JsonValueObj)queryCond.get("direction_combobox");
        ILicenseOutboundService licenseOutboundService = ReportBisUtil.getLicenseOutboundService();
        boolean isSupportOutbound = licenseOutboundService.isSupportOutbound();
        if (null != direction) {
            if (isSupportOutbound) {
                direction.setShowInfo("true");
            } else {
                direction.setShowInfo("false");
            }
        }
    }

    public static void getIpAttackTitleAndColumnName(Map<?, ?> queryCond, Map<String, List<String>> prepareParasMap) {
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        String titleName = "";
        String columnName = "";
        String titleName2 = "";
        String columnName2 = "";
        if (datastatConditionForm.getDevSerType() == 1) {
            titleName = AticUtil.getText((String)"atic.analysis.report.ip.tab.feak.bps");
            columnName = AticUtil.getText((String)"atic.analysis.report.tab.column.feak.bps");
            titleName2 = AticUtil.getText((String)"atic.analysis.report.ip.tab.feak.pps");
            columnName2 = AticUtil.getText((String)"atic.analysis.report.tab.column.feak.pps");
        } else {
            titleName = AticUtil.getText((String)"atic.analysis.report.ip.tab.feak.bps.attack");
            columnName = AticUtil.getText((String)"atic.analysis.report.tab.column.feak.attack.bps");
            titleName2 = AticUtil.getText((String)"atic.analysis.report.ip.tab.feak.pps.attack");
            columnName2 = AticUtil.getText((String)"atic.analysis.report.tab.column.feak.attack.pps");
        }
        ArrayList<String> titleNames = new ArrayList<String>();
        titleNames.add(titleName);
        ArrayList<String> titleNames2 = new ArrayList<String>();
        titleNames2.add(titleName2);
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add(columnName);
        ArrayList<String> columnNames2 = new ArrayList<String>();
        columnNames2.add(columnName2);
        prepareParasMap.put("titleName", titleNames);
        prepareParasMap.put("titleName2", titleNames2);
        prepareParasMap.put("columnName", columnNames);
        prepareParasMap.put("columnName2", columnNames2);
    }

    public static void getZoneAttackTitleAndColumnName(Map<?, ?> queryCond, Map<String, List<String>> prepareParasMap) {
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        String titleName = "";
        String titleName2 = "";
        String columnName = "";
        String columnName2 = "";
        if (datastatConditionForm.getDevSerType() == 1) {
            titleName = AticUtil.getText((String)"atic.analysis.report.zone.tab.feak.bps");
            columnName = AticUtil.getText((String)"atic.analysis.report.tab.column.feak.bps");
            titleName2 = AticUtil.getText((String)"atic.analysis.report.zone.tab.feak.pps");
            columnName2 = AticUtil.getText((String)"atic.analysis.report.tab.column.feak.pps");
        } else {
            titleName = AticUtil.getText((String)"atic.analysis.report.zone.tab.feak.bps.attack");
            columnName = AticUtil.getText((String)"atic.analysis.report.tab.column.feak.attack.bps");
            titleName2 = AticUtil.getText((String)"atic.analysis.report.zone.tab.feak.pps.attack");
            columnName2 = AticUtil.getText((String)"atic.analysis.report.tab.column.feak.attack.pps");
        }
        ArrayList<String> titleNames = new ArrayList<String>();
        titleNames.add(titleName);
        ArrayList<String> titleNames2 = new ArrayList<String>();
        titleNames2.add(titleName2);
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add(columnName);
        ArrayList<String> columnNames2 = new ArrayList<String>();
        columnNames2.add(columnName2);
        prepareParasMap.put("titleName", titleNames);
        prepareParasMap.put("titleName2", titleNames2);
        prepareParasMap.put("columnName", columnNames);
        prepareParasMap.put("columnName2", columnNames2);
    }

    public static List<AvgAndMaxView> processAvgAndMaxData4Table(List<FlowCompareForm> tableData, Long timeSpan, int deviceType, Locale locale) {
        AvgAndMaxView inFlow;
        ArrayList<AvgAndMaxView> resultLists = new ArrayList<AvgAndMaxView>();
        if (null == tableData || tableData.isEmpty()) {
            return resultLists;
        }
        for (FlowCompareForm form : tableData) {
            form.setInFlow(form.getMaxInFlow());
            form.setAttackFlow(form.getMaxAttackFlow());
            form.setOutFlow(form.getMaxOutFlow());
        }
        Long timeNum = ReportAnalysisUtil.getTimeNum(tableData, timeSpan);
        Long totalInFlow = tableData.get(0).getInFlow();
        Long maxInFlow = tableData.get(0).getInFlow();
        Long maxInFlowTime = tableData.get(0).getLogTime();
        Long totalDropFlow = tableData.get(0).getAttackFlow();
        Long maxDropFlow = tableData.get(0).getAttackFlow();
        Long maxDropFlowTime = tableData.get(0).getLogTime();
        Long totalOutFlow = tableData.get(0).getOutFlow();
        Long maxOutFlow = tableData.get(0).getOutFlow();
        Long maxOutFlowTime = tableData.get(0).getLogTime();
        int i = 0;
        for (FlowCompareForm form : tableData) {
            if (i > 0) {
                totalInFlow = totalInFlow + form.getInFlow();
                maxInFlowTime = maxInFlow < form.getInFlow() ? Long.valueOf(form.getLogTime()) : maxInFlowTime;
                maxInFlow = maxInFlow < form.getInFlow() ? form.getInFlow() : maxInFlow;
                totalDropFlow = totalDropFlow + form.getAttackFlow();
                maxDropFlowTime = maxDropFlow < form.getAttackFlow() ? Long.valueOf(form.getLogTime()) : maxDropFlowTime;
                maxDropFlow = maxDropFlow < form.getAttackFlow() ? form.getAttackFlow() : maxDropFlow;
                totalOutFlow = totalOutFlow + form.getOutFlow();
                maxOutFlowTime = maxOutFlow < form.getOutFlow() ? Long.valueOf(form.getLogTime()) : maxOutFlowTime;
                maxOutFlow = maxOutFlow < form.getOutFlow() ? form.getOutFlow() : maxOutFlow;
            }
            ++i;
        }
        if (deviceType == 1) {
            inFlow = new AvgAndMaxView();
            inFlow.setNameColor(ReportAnalysisUtil.getFontColor("77,130,249"));
            inFlow.setName(AticUtil.getText((String)"atic.analysis.common.flux.detect", (Locale)locale));
            inFlow.setAvgValue(totalInFlow / timeNum);
            inFlow.setMaxValue(maxInFlow);
            inFlow.setLogTime(maxInFlowTime);
            resultLists.add(inFlow);
        } else {
            inFlow = new AvgAndMaxView();
            inFlow.setNameColor(ReportAnalysisUtil.getFontColor("77,130,249"));
            inFlow.setName(AticUtil.getText((String)"atic.analysis.common.flux.in", (Locale)locale));
            inFlow.setAvgValue(totalInFlow / timeNum);
            inFlow.setMaxValue(maxInFlow);
            inFlow.setLogTime(maxInFlowTime);
            resultLists.add(inFlow);
            AvgAndMaxView dropFlow = new AvgAndMaxView();
            dropFlow.setNameColor(ReportAnalysisUtil.getFontColor("209,78,57"));
            dropFlow.setName(AticUtil.getText((String)"atic.analysis.common.flux.attack", (Locale)locale));
            dropFlow.setAvgValue(totalDropFlow / timeNum);
            dropFlow.setMaxValue(maxDropFlow);
            dropFlow.setLogTime(maxDropFlowTime);
            AvgAndMaxView outFlow = new AvgAndMaxView();
            outFlow.setNameColor(ReportAnalysisUtil.getFontColor("94,237,79"));
            outFlow.setName(AticUtil.getText((String)"atic.analysis.common.flux.out", (Locale)locale));
            outFlow.setAvgValue(inFlow.getAvgValue() - dropFlow.getAvgValue());
            outFlow.setMaxValue(maxOutFlow);
            outFlow.setLogTime(maxOutFlowTime);
            resultLists.add(outFlow);
        }
        return resultLists;
    }

    private static Long getTimeNum(List<FlowCompareForm> tableData, Long timeSpan) {
        if (null == tableData || tableData.isEmpty()) {
            return 1L;
        }
        Collections.sort(tableData, FlowCompareComparator.getComparatorByFieldName("logTime", "desc"));
        Long endTime = tableData.get(0).getLogTime();
        Long startTime = tableData.get(tableData.size() - 1).getLogTime();
        Long returnTimeNum = 1L;
        returnTimeNum = timeSpan.equals(2L) ? Long.valueOf((endTime - startTime) / 3600000L + 1L) : (timeSpan.equals(3L) ? Long.valueOf((endTime - startTime) / 86400000L + 1L) : Long.valueOf((endTime - startTime) / 300000L + 1L));
        return returnTimeNum;
    }

    public static void processAttackTypeDisChapter(String reportId, int chartStart, Map<String, List<String>> map, int deviceType, Locale locale, long sessionId) {
        List<String> hasDataReportIds = AllReportHaveDataCache.getInstance().getDataList(sessionId);
        if (reportId.equalsIgnoreCase("AttackDisCount") && hasDataReportIds.contains("AttackDisCount")) {
            ArrayList<String> attackDisCount = new ArrayList<String>();
            ArrayList<String> attackDisCountChartName = new ArrayList<String>();
            ArrayList<String> timeDestributionName = new ArrayList<String>();
            ArrayList<String> attackDurationName = new ArrayList<String>();
            ArrayList<String> attackTrafficPeakName = new ArrayList<String>();
            if (deviceType == 1) {
                attackDisCountChartName.add(AticUtil.getText((String)"report.detect.attackDisChartName", (Locale)locale));
                timeDestributionName.add(AticUtil.getText((String)"report.detect.timeDestribution", (Locale)locale));
                attackDurationName.add(AticUtil.getText((String)"report.detect.attackDuration", (Locale)locale));
                attackTrafficPeakName.add(AticUtil.getText((String)"report.detect.attackTrafficPeak", (Locale)locale));
            } else {
                attackDisCountChartName.add(AticUtil.getText((String)"report.clean.attackDisChartName", (Locale)locale));
                timeDestributionName.add(AticUtil.getText((String)"reprot.clean.timeDestribution", (Locale)locale));
                attackDurationName.add(AticUtil.getText((String)"reprot.clean.attackDuration", (Locale)locale));
                attackTrafficPeakName.add(AticUtil.getText((String)"reprot.clean.attackTrafficPeak", (Locale)locale));
            }
            attackDisCount.add(chartStart + "." + AticUtil.getText((String)"report.cleanAndDetect.attackAndAbnormal", (Locale)locale));
            map.put("attackDisCount", attackDisCount);
            map.put("attackDisCountChartName", attackDisCountChartName);
            map.put("timeDestributionName", timeDestributionName);
            map.put("attackDurationName", attackDurationName);
            map.put("attackTrafficPeakName", attackTrafficPeakName);
        }
    }

    public static void processAttackTopNChapter(String reportId, int chartStart, Map<String, List<String>> map, Locale locale, int deviceType, long sessionId) {
        List<String> hasDataReportIds = AllReportHaveDataCache.getInstance().getDataList(sessionId);
        if (reportId.equalsIgnoreCase("AbnormalOrAttackTopN") && hasDataReportIds.contains("AbnormalOrAttackTopN")) {
            ArrayList<String> abnormalOrAttackTopNList = new ArrayList<String>();
            String titleName = "";
            String columnName = "";
            String titleName2 = "";
            String columnName2 = "";
            String zoneTitleName = "";
            String zoneColumnName = "";
            String zoneTitleName2 = "";
            String zoneColumnName2 = "";
            if (deviceType == 1) {
                titleName = AticUtil.getText((String)"atic.analysis.report.ip.tab.feak.bps");
                columnName = AticUtil.getText((String)"atic.analysis.report.tab.column.feak.bps");
                titleName2 = AticUtil.getText((String)"atic.analysis.report.ip.tab.feak.pps");
                columnName2 = AticUtil.getText((String)"atic.analysis.report.tab.column.feak.pps");
                zoneTitleName = AticUtil.getText((String)"atic.analysis.report.zone.tab.feak.bps");
                zoneColumnName = AticUtil.getText((String)"atic.analysis.report.tab.column.feak.bps");
                zoneTitleName2 = AticUtil.getText((String)"atic.analysis.report.zone.tab.feak.pps");
                zoneColumnName2 = AticUtil.getText((String)"atic.analysis.report.tab.column.feak.pps");
            } else {
                titleName = AticUtil.getText((String)"atic.analysis.report.ip.tab.feak.bps.attack");
                columnName = AticUtil.getText((String)"atic.analysis.report.tab.column.feak.attack.bps");
                titleName2 = AticUtil.getText((String)"atic.analysis.report.ip.tab.feak.pps.attack");
                columnName2 = AticUtil.getText((String)"atic.analysis.report.tab.column.feak.attack.pps");
                zoneTitleName = AticUtil.getText((String)"atic.analysis.report.zone.tab.feak.bps.attack");
                zoneColumnName = AticUtil.getText((String)"atic.analysis.report.tab.column.feak.attack.bps");
                zoneTitleName2 = AticUtil.getText((String)"atic.analysis.report.zone.tab.feak.pps.attack");
                zoneColumnName2 = AticUtil.getText((String)"atic.analysis.report.tab.column.feak.attack.pps");
            }
            abnormalOrAttackTopNList.add(chartStart + "." + AticUtil.getText((String)"atic.analysis.report.tab.attackTopn", (Locale)locale));
            map.put("abnormalOrAttackTopN", abnormalOrAttackTopNList);
            ArrayList<String> titleNames = new ArrayList<String>();
            titleNames.add(titleName);
            ArrayList<String> titleNames2 = new ArrayList<String>();
            titleNames2.add(titleName2);
            ArrayList<String> columnNames = new ArrayList<String>();
            columnNames.add(columnName);
            ArrayList<String> columnNames2 = new ArrayList<String>();
            columnNames2.add(columnName2);
            ArrayList<String> zoneTitleNames = new ArrayList<String>();
            zoneTitleNames.add(zoneTitleName);
            ArrayList<String> zoneTitleNames2 = new ArrayList<String>();
            zoneTitleNames2.add(zoneTitleName2);
            ArrayList<String> zoneColumnNames = new ArrayList<String>();
            zoneColumnNames.add(zoneColumnName);
            ArrayList<String> zoneColumnNames2 = new ArrayList<String>();
            zoneColumnNames2.add(zoneColumnName2);
            map.put("titleName", titleNames);
            map.put("titleName2", titleNames2);
            map.put("columnName", columnNames);
            map.put("columnName2", columnNames2);
            map.put("zoneTitleName", zoneTitleNames);
            map.put("zoneTitleName2", zoneTitleNames2);
            map.put("zoneColumnName", zoneColumnNames);
            map.put("zoneColumnName2", zoneColumnNames2);
        }
    }

    public static void processFlowTopNChapter(String reportId, int chartStart, Map<String, List<String>> map, Locale locale, long sessionId) {
        List<String> hasDataReportIds = AllReportHaveDataCache.getInstance().getDataList(sessionId);
        if (reportId.equalsIgnoreCase("FlowTopN") && hasDataReportIds.contains("FlowTopN")) {
            ArrayList<String> fluxCompareBPS = new ArrayList<String>();
            String fluxCompartStr = AticUtil.getText((String)"atic.analysis.report.tab.fluxTopn", (Locale)locale);
            fluxCompareBPS.add(chartStart + "." + fluxCompartStr);
            map.put("flowTopN", fluxCompareBPS);
        }
    }

    public static void processConnCompareChapter(String reportId, int chartStart, Map<String, List<String>> map, Locale locale, long sessionId) {
        List<String> hasDataReportIds = AllReportHaveDataCache.getInstance().getDataList(sessionId);
        if (reportId.equalsIgnoreCase("ConnCompare") && hasDataReportIds.contains("ConnCompare")) {
            ArrayList<String> fluxCompareBPS = new ArrayList<String>();
            String fluxCompartStr = AticUtil.getText((String)"atic.analysis.report.tab.conncompare", (Locale)locale);
            fluxCompareBPS.add(chartStart + "." + fluxCompartStr);
            map.put("connCompare", fluxCompareBPS);
        }
    }

    public static void processIpLocationTopNChapter(String reportId, int chartStart, Map<String, List<String>> map, Locale locale, long sessionId) {
        List<String> hasDataReportIds = AllReportHaveDataCache.getInstance().getDataList(sessionId);
        if (reportId.equalsIgnoreCase("IpLocationTopN") && hasDataReportIds.contains("IpLocationTopN")) {
            ArrayList<String> fluxCompareBPS = new ArrayList<String>();
            String fluxCompartStr = AticUtil.getText((String)"atic.analysis.report.tab.ipLocationTopN", (Locale)locale);
            fluxCompareBPS.add(chartStart + "." + fluxCompartStr);
            map.put("ipLocationTopN", fluxCompareBPS);
        }
    }

    public static void processChapterContent(Map<String, List<String>> map, Map<?, ?> queryCond, long sessionId, Locale locale, int deviceType) {
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "reportIds");
        String reportIds = jsonValueItem.get(0).getText();
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "reportTopns");
        String reportTopns = jsonValueItem.get(0).getText();
        String[] reportIdStr = reportIds.split(",");
        String[] topNValueStr = reportTopns.split(",");
        ArrayList<String> reportShowList = new ArrayList<String>();
        reportShowList.add("true");
        List<String> hasDataReportIds = AllReportHaveDataCache.getInstance().getDataList(sessionId);
        ArrayList<String> orderReportIds = new ArrayList<String>();
        for (int i = 0; i < reportIdStr.length; ++i) {
            if (!hasDataReportIds.contains(reportIdStr[i])) continue;
            orderReportIds.add(reportIdStr[i]);
            map.put("show" + reportIdStr[i], reportShowList);
            if (topNValueStr[i].equals("0")) continue;
            ArrayList reportShowTopNList = new ArrayList();
            reportShowTopNList.add(topNValueStr[i]);
            map.put(reportIdStr[i] + "TOPN", reportShowTopNList);
        }
        int chartStart = 2;
        for (String reportId : orderReportIds) {
            ReportAnalysisUtil.processAttackTypeDisChapter(reportId, chartStart, map, deviceType, locale, sessionId);
            ReportAnalysisUtil.processFlowCompareChapter(reportId, chartStart, map, locale, sessionId);
            ReportAnalysisUtil.processAttackTrendChapter(reportId, chartStart, map, locale, deviceType, sessionId);
            ReportAnalysisUtil.processAttackTopNChapter(reportId, chartStart, map, locale, deviceType, sessionId);
            ReportAnalysisUtil.processAttackEventTopNChapter(reportId, chartStart, map, locale, deviceType, sessionId);
            ReportAnalysisUtil.processFlowTopNChapter(reportId, chartStart, map, locale, sessionId);
            ReportAnalysisUtil.processConnCompareChapter(reportId, chartStart, map, locale, sessionId);
            ReportAnalysisUtil.processIpLocationTopNChapter(reportId, chartStart, map, locale, sessionId);
            ++chartStart;
        }
        AllReportHaveDataCache.getInstance().removeData(sessionId);
        ArrayList<String> summary = new ArrayList<String>();
        summary.add(chartStart + "." + AticUtil.getText((String)"report.clean.summary", (Locale)locale));
        map.put("summary", summary);
    }

    public static String processAttackDataFormat4SixSummary(List<AtackTypeDistribute> attackCountList, int deviceType, long sessionId, Locale locale) {
        if (null != attackCountList && !attackCountList.isEmpty()) {
            StringBuffer totalSecurityText = new StringBuffer(TAB_SPACE);
            totalSecurityText.append('\n');
            totalSecurityText.append(TAB_SPACE);
            totalSecurityText.append(' ');
            totalSecurityText.append("\u25cf ");
            String attackTypeFormat = "";
            attackTypeFormat = deviceType == 1 ? AticUtil.getText((String)"report.total.summary.abnormalInfo", (Locale)locale) : AticUtil.getText((String)"report.total.summary.attackInfo", (Locale)locale);
            String multiVector = AticUtil.getText((String)"atic.attack.vector2", (Locale)locale);
            String trafficPeakTypeName = "";
            List<AtackTypeDistribute> trafficPeakTypeList = TransmitAttackTrafficPeak.getInstance().getDataList(sessionId);
            TransmitAttackTrafficPeak.getInstance().removeData(sessionId);
            if (null != trafficPeakTypeList && !trafficPeakTypeList.isEmpty()) {
                trafficPeakTypeName = trafficPeakTypeList.get(0).getTrafficPeakTypeName();
            }
            String vectorTypeName = "0";
            List<AtackTypeDistribute> vectorTypeList = TransmitAttackVectorData.getInstance().getDataList(sessionId);
            TransmitAttackVectorData.getInstance().removeData(sessionId);
            if (null != vectorTypeList && !vectorTypeList.isEmpty()) {
                for (int num = 0; num < vectorTypeList.size(); ++num) {
                    if (!multiVector.equals(vectorTypeList.get(num).getVectorTypeName())) continue;
                    vectorTypeName = vectorTypeList.get(num).getPercentStr();
                }
            }
            String durationTypeNameStr = "";
            List<AtackTypeDistribute> durationTypeList = TransmitAttackDurationData.getInstance().getDataList(sessionId);
            TransmitAttackDurationData.getInstance().removeData(sessionId);
            if (null != durationTypeList && !durationTypeList.isEmpty()) {
                durationTypeNameStr = durationTypeList.get(0).getDurationTypeNameStr();
            }
            String attackTypeName = attackCountList.get(0).getAttackTypeName();
            Object[] attackTypeObjs = new Object[]{trafficPeakTypeName, vectorTypeName, durationTypeNameStr, attackTypeName};
            attackTypeFormat = MessageFormat.format(attackTypeFormat, attackTypeObjs);
            return totalSecurityText + attackTypeFormat;
        }
        return "";
    }

    public static String conversionFlowUnit(double dropFlow) {
        String flowUnit = "K";
        double totalDropFlow = 0.0;
        if (dropFlow < 1000.0 && dropFlow >= 0.0) {
            BigDecimal b = new BigDecimal(dropFlow);
            totalDropFlow = b.setScale(1, 1).doubleValue();
        } else if (dropFlow < 1000000.0) {
            flowUnit = "M";
            BigDecimal b = new BigDecimal(dropFlow / 1000.0);
            totalDropFlow = b.setScale(1, 1).doubleValue();
        } else if (dropFlow < 1.0E9) {
            flowUnit = "G";
            BigDecimal b = new BigDecimal(dropFlow / 1000000.0);
            totalDropFlow = b.setScale(1, 1).doubleValue();
        } else if (dropFlow < 1.0E12) {
            flowUnit = "T";
            BigDecimal b = new BigDecimal(dropFlow / 1.0E9);
            totalDropFlow = b.setScale(1, 1).doubleValue();
        } else if (dropFlow < 1.0E15) {
            flowUnit = "P";
            BigDecimal b = new BigDecimal(dropFlow / 1.0E12);
            totalDropFlow = b.setScale(1, 1).doubleValue();
        } else if (dropFlow < 1.0E18) {
            flowUnit = "E";
            BigDecimal b = new BigDecimal(dropFlow / 1.0E15);
            totalDropFlow = b.setScale(1, 1).doubleValue();
        } else if (dropFlow < 1.0E21) {
            flowUnit = "Z";
            BigDecimal b = new BigDecimal(dropFlow / 1.0E18);
            totalDropFlow = b.setScale(1, 1).doubleValue();
        } else if (dropFlow < 1.0E24) {
            flowUnit = "Y";
            BigDecimal b = new BigDecimal(dropFlow / 1.0E21);
            totalDropFlow = b.setScale(1, 1).doubleValue();
        } else {
            flowUnit = "B";
            BigDecimal b = new BigDecimal(dropFlow / 1.0E24);
            totalDropFlow = b.setScale(1, 1).doubleValue();
        }
        return totalDropFlow + flowUnit;
    }
}

