/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.util;

import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.form.ZoneListIpForm;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.policy.util.ZoneConstants;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INpFilterService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.springframework.beans.BeanUtils;

public final class ReportAticUtil {
    public static final int ZONE_IP_TYPE_EXCULDE = 1;
    public static final String PACKET_TASK_NAME_REGEX = "^[\\w|\u4e00-\u9fa5|\\!|\\@|\\#|\\$|\\^|\\+|\\-|\\_|\\=|\\}|\\{|\\]|\\[|\\;|\\.]*$";
    public static final String PACKET_FILE_NAME_REGEX = "^[\\w|\u4e00-\u9fa5|\\!|\\@|\\#|\\$|\\^|\\+|\\-|\\_|\\=|\\}|\\{|\\]|\\[|\\;|\\.|\\*|\\:|\\,|\\/| |%]*$";
    private static Map<String, String> resourcMap = new HashMap<String, String>();
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    public static String formatIpAddress(String ip) {
        return ip;
    }

    public static String convertIpFromLong2Str(long address) {
        byte[] values = new byte[]{(byte)(address >>> 24 & 0xFFL), (byte)(address >>> 16 & 0xFFL), (byte)(address >>> 8 & 0xFFL), (byte)(address >>> 0 & 0xFFL)};
        return (values[0] & 0xFF) + "." + (values[1] & 0xFF) + "." + (values[2] & 0xFF) + "." + (values[3] & 0xFF);
    }

    public static long convertIpFromStr2Long(String strIp) {
        try {
            if (ReportAticUtil.isNull(strIp)) {
                return 0L;
            }
            long[] ip = new long[4];
            int position1 = strIp.indexOf(".");
            int position2 = strIp.indexOf(".", position1 + 1);
            int position3 = strIp.indexOf(".", position2 + 1);
            ip[0] = Long.parseLong(strIp.substring(0, position1));
            ip[1] = Long.parseLong(strIp.substring(position1 + 1, position2));
            ip[2] = Long.parseLong(strIp.substring(position2 + 1, position3));
            ip[3] = Long.parseLong(strIp.substring(position3 + 1));
            return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static String appendOperNameFromBatchOper(BatchOperationResult batchOperationResult) {
        StringBuffer names = new StringBuffer();
        for (BatchOperation bo : batchOperationResult.getResult()) {
            names.append(bo.getTargetName()).append(',');
        }
        return names.toString();
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equals(str);
    }

    public static boolean isNullForVpn(String str) {
        return str == null || "".equals(str.trim());
    }

    public static long convertTimeString(String time) {
        if (time == null || time.length() == 0) {
            return 0L;
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = formate.parse(time.trim());
            return date.getTime() / 1000L;
        }
        catch (ParseException ex) {
            return 0L;
        }
    }

    public static String convertTime2DayString(long time) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
        return formate.format(new Date(time * 1000L));
    }

    public static String convertTimeLong(Long time) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(time * 1000L));
    }

    public static String convertTime2FormatString(String time) {
        String formateString = "";
        if (!ReportAticUtil.isNull(time)) {
            Long longTime = Long.parseLong(time);
            SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            formateString = formate.format(new Date(longTime * 1000L));
        }
        return formateString;
    }

    public static ServiceContext getServiceContext() {
        ServiceContext context = ServiceContext.getInstance();
        if (null == context) {
            throw new LegoCheckedException(570506L);
        }
        return context;
    }

    public static String getText(String i18n) {
        return LocaleUtil.INSTANCE.getText(i18n);
    }

    public static String getText(String aTextName, Locale locale) {
        if (null == locale) {
            return ReportAticUtil.getText(aTextName);
        }
        return LocaleUtil.INSTANCE.getText(aTextName, locale);
    }

    public static String getText(String i18n, String[] params) {
        return LocaleUtil.INSTANCE.getText(i18n, params);
    }

    public static String getText(String i18n, Locale locale, String[] params) {
        return LocaleUtil.INSTANCE.getText(i18n, locale, params);
    }

    public static Object copyProperties(Object source, Object target) {
        if (null == source || null == target) {
            return null;
        }
        BeanUtils.copyProperties((Object)source, (Object)target);
        return target;
    }

    public static String getMaskStartIp(String ip, String mask) {
        if (mask.equals("255.255.255.255")) {
            return ip;
        }
        SubnetUtils subnetUtils = new SubnetUtils(ip, mask);
        String startIp = subnetUtils.getInfo().getLowAddress();
        Long startIpLong = ReportAticUtil.convertIpFromStr2Long(startIp);
        String startIpStr = ReportAticUtil.convertIpFromLong2Str(startIpLong - 1L);
        return startIpStr;
    }

    public static String getMaskEndIp(String ip, String mask) {
        if (mask.equals("255.255.255.255")) {
            return ip;
        }
        SubnetUtils subnetUtils = new SubnetUtils(ip, mask);
        String endIp = subnetUtils.getInfo().getHighAddress();
        Long endIpLong = ReportAticUtil.convertIpFromStr2Long(endIp);
        String endIpStr = ReportAticUtil.convertIpFromLong2Str(endIpLong + 1L);
        return endIpStr;
    }

    public static boolean isReSubmit(HttpSession session, StringBuffer submitToken) {
        StringBuffer token = null;
        if (session.getAttribute("submitToken") != null) {
            token = new StringBuffer((String)session.getAttribute("submitToken"));
        }
        if (null != token && token.toString().equals(submitToken.toString())) {
            return true;
        }
        session.setAttribute("submitToken", (Object)submitToken.toString());
        return false;
    }

    public static List<String> splitIpUtil(String ip, String mask, int maskDigit) {
        if (null == ip || null == mask) {
            return null;
        }
        ArrayList<String> iPList = new ArrayList<String>();
        if (mask.equals("255.255.255.255")) {
            iPList.add(ip);
            return iPList;
        }
        String startIp = ReportAticUtil.getMaskStartIp(ip, mask);
        String endIp = ReportAticUtil.getMaskEndIp(ip, mask);
        Long slong = ReportAticUtil.convertIpFromStr2Long(startIp);
        Long elong = ReportAticUtil.convertIpFromStr2Long(endIp);
        ArrayList<String> splitIpList = new ArrayList<String>();
        long flag = (long)Math.pow(2.0, 32 - maskDigit);
        splitIpList.add(startIp);
        boolean isAdd = true;
        while (isAdd) {
            String splitIpString;
            if ((slong = Long.valueOf(slong + flag)) < elong) {
                isAdd = true;
                splitIpString = ReportAticUtil.convertIpFromLong2Str(slong);
                splitIpList.add(splitIpString);
                continue;
            }
            if (slong.equals(elong)) {
                isAdd = false;
                splitIpString = ReportAticUtil.convertIpFromLong2Str(slong);
                splitIpList.add(splitIpString);
                continue;
            }
            isAdd = false;
        }
        return splitIpList;
    }

    public static String getMask(Integer maskBit) {
        StringBuffer mask = new StringBuffer();
        int a = -1;
        a = 0 == maskBit ? 0 : (a <<= 32 - maskBit);
        mask.append((a & 0xFF000000) >>> 24);
        mask.append('.');
        mask.append((a & 0xFF0000) >> 16);
        mask.append('.');
        mask.append((a & 0xFF00) >> 8);
        mask.append('.');
        mask.append(a & 0xFF);
        return mask.toString();
    }

    public static Integer getMaskBit(String mask) {
        Integer maskBit = 0;
        if (null == mask || "".equals(mask)) {
            return maskBit;
        }
        String[] maskSplit = mask.split("\\.");
        String bmask = "";
        for (int i = 0; i < maskSplit.length; ++i) {
            int maskNum = Integer.parseInt(maskSplit[i]);
            bmask = bmask.concat(Integer.toBinaryString(maskNum));
        }
        maskBit = bmask.lastIndexOf("1") + 1;
        return maskBit;
    }

    public static String stringFilter(String str) {
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static Boolean isNum(String str) {
        return str.matches("^[0-9]+$");
    }

    public static Boolean isFileName(String fileName) {
        String fileNameReg = "^[\\u4e00-\\u9fa5a-zA-Z0-9\\@\\.\\_\\-]{1,}$";
        if (fileName.matches(fileNameReg) && !fileNameReg.contains("..")) {
            return true;
        }
        return false;
    }

    public static boolean checkFileName(String downFileName, String downFileType) {
        if (ReportAticUtil.isNull(downFileName)) {
            return false;
        }
        int index = downFileName.lastIndexOf(".");
        if (index > 0) {
            String onlyFileName = downFileName.substring(0, index);
            String fileRealType = downFileName.substring(index + 1, downFileName.length());
            if (ReportAticUtil.isFileName(onlyFileName).booleanValue() && (ReportAticUtil.isNull(downFileType) ? ZoneConstants.getFileTypeList().contains(fileRealType.toLowerCase(Locale.US)) : downFileType.equalsIgnoreCase(fileRealType))) {
                return true;
            }
        }
        return false;
    }

    public static Boolean isPcapFileName(String fileName) {
        if (fileName.matches(PACKET_FILE_NAME_REGEX) && !PACKET_FILE_NAME_REGEX.contains("..")) {
            return true;
        }
        return false;
    }

    public static boolean checkPacpFileName(String downFileName, String downFileType) {
        if (ReportAticUtil.isNull(downFileName)) {
            return false;
        }
        int index = downFileName.lastIndexOf(".");
        if (index > 0) {
            String onlyFileName = downFileName.substring(0, index);
            String fileRealType = downFileName.substring(index + 1, downFileName.length());
            if (ReportAticUtil.isPcapFileName(onlyFileName).booleanValue() && (ReportAticUtil.isNull(downFileType) ? ZoneConstants.getFileTypeList().contains(fileRealType.toLowerCase(Locale.US)) : downFileType.equalsIgnoreCase(fileRealType))) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkFilePath(String exportFolderPath, String downFileFile) {
        try {
            File tempFile = new File(downFileFile);
            File exportFolderFile = new File(exportFolderPath);
            if (tempFile.getCanonicalPath().startsWith(exportFolderFile.getCanonicalPath())) {
                return true;
            }
        }
        catch (IOException e) {
            logger.error((Object)"getCanonicalPath IOException error");
        }
        return false;
    }

    public static void deleteTempFile(String downFileName) {
        Boolean result;
        String downloadFileName = "";
        try {
            downloadFileName = new String(downFileName.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"downloadFile", (Throwable)e);
            return;
        }
        File file = new File(downloadFileName);
        if (file.exists() && file.isFile() && !(result = Boolean.valueOf(file.delete())).booleanValue()) {
            logger.error((Object)"delete file error");
        }
    }

    public static String processAttackTypeNum2Str(String attackType) {
        StringBuffer returnStr = new StringBuffer();
        try {
            if (null == attackType || "".equals(attackType.trim())) {
                return "-";
            }
            String[] ats = attackType.split(",");
            for (int i = 0; i < ats.length; ++i) {
                String attackTypekey = "";
                attackTypekey = Long.parseLong(ats[i]) >= 0L && Long.parseLong(ats[i]) < 10L ? ReportAticUtil.getText("atic.attack.type.0") : (Long.parseLong(ats[i]) >= 2000L && Long.parseLong(ats[i]) < 80000L ? ReportAticUtil.processFilterSubAttackName(Long.parseLong(ats[i])) : (Long.parseLong(ats[i]) >= 80000L ? ReportAticUtil.processNPFilterSubAttackName(Long.parseLong(ats[i])) : ReportAticUtil.getText("atic.attack.type." + Long.parseLong(ats[i]))));
                if (!resourcMap.containsKey(attackTypekey)) {
                    resourcMap.put(attackTypekey, attackTypekey);
                }
                String attackTypeValue = resourcMap.get(attackTypekey);
                if (0 == i) {
                    returnStr.append(attackTypeValue);
                    continue;
                }
                returnStr.append("; " + attackTypeValue);
            }
        }
        catch (NumberFormatException e) {
            returnStr.append(attackType);
        }
        return returnStr.toString();
    }

    public static String processFilterSubAttackName(long attackType) {
        String attackTypeName = "";
        if (2000L == attackType) {
            attackTypeName = ReportAticUtil.getText("atic.attack.type.62");
        } else {
            long filterId = attackType - 2000L;
            IFilterService filterService = (IFilterService)ServiceContext.getInstance().getService("filterService", IFilterService.class);
            FilterForm filterTemp = filterService.queryFilterName(Long.valueOf(filterId));
            attackTypeName = null != filterTemp && !ReportAticUtil.isNull(filterTemp.getFilterName()) ? filterTemp.getFilterName() : ReportAticUtil.getText("atic.analysis.common.unknownFilter") + filterId;
        }
        return attackTypeName;
    }

    public static String processNPFilterSubAttackName(long attackType) {
        String attackTypeName = "";
        if (80000L == attackType) {
            attackTypeName = ReportAticUtil.getText("atic.attack.type.80000");
        } else {
            long filterId = attackType - 80000L;
            INpFilterService npfilterService = (INpFilterService)ServiceContext.getInstance().getService("npFilterService", INpFilterService.class);
            NPFilterForm npfilterTemp = npfilterService.queryNPFilterFormByfilterId(filterId);
            attackTypeName = null != npfilterTemp && !ReportAticUtil.isNull(npfilterTemp.getFilterName()) ? npfilterTemp.getFilterName() : ReportAticUtil.getText("atic.attack.type.80000");
        }
        return attackTypeName;
    }

    public static boolean isValidReportTaskName(String value) {
        String taskNameRegex = "(?!null$)[\u4e00-\u9fa5|a-zA-Z0-9|\\@|\\.|\\_|\\-]*$";
        return value.matches(taskNameRegex) && value.length() <= 32;
    }

    public static List<ZoneIpForm> getZoneIpFormList(List<ZoneListIpForm> zoneListIpFormList) {
        ArrayList<ZoneIpForm> zoneIpFormList = new ArrayList<ZoneIpForm>();
        if (zoneListIpFormList != null && !zoneListIpFormList.isEmpty()) {
            ArrayList<String[]> includeIpv4List = new ArrayList<String[]>();
            ArrayList<String[]> includeIpv6List = new ArrayList<String[]>();
            ArrayList<String[]> excludeIpv4List = new ArrayList<String[]>();
            ArrayList<String[]> excludeIpv6List = new ArrayList<String[]>();
            for (ZoneListIpForm zoneListIpForm : zoneListIpFormList) {
                String startIp = zoneListIpForm.getStartIp();
                String endIp = zoneListIpForm.getEndIp();
                String[] subnetRange = new String[]{startIp, endIp};
                if (zoneListIpForm.getIpType() == 1) {
                    if (IPUtil.isIpv4((String)startIp)) {
                        excludeIpv4List.add(subnetRange);
                        continue;
                    }
                    excludeIpv6List.add(subnetRange);
                    continue;
                }
                if (IPUtil.isIpv4((String)startIp)) {
                    includeIpv4List.add(subnetRange);
                    continue;
                }
                includeIpv6List.add(subnetRange);
            }
            List<String[]> finalIpv4List = ReportAticUtil.getFinalIpList(includeIpv4List, excludeIpv4List);
            List<String[]> finalIpv6List = ReportAticUtil.getFinalIpList(includeIpv6List, excludeIpv6List);
            ArrayList<String[]> finalIpList = new ArrayList<String[]>();
            finalIpList.addAll(finalIpv4List);
            finalIpList.addAll(finalIpv6List);
            for (String[] ip : finalIpList) {
                try {
                    String startIp = ip[0];
                    String endIp = ip[1];
                    String[] tempIpArray = IPUtil.getNetworkSegment((String)startIp, (String)endIp);
                    for (int i = 0; i < tempIpArray.length; ++i) {
                        String ipAndMask = tempIpArray[i];
                        String[] temp = ipAndMask.split("/");
                        String zoneIp = temp[0];
                        String mask = temp[1];
                        ZoneIpForm zoneIpForm = new ZoneIpForm();
                        zoneIpForm.setZoneIp(zoneIp);
                        zoneIpForm.setMask(Integer.valueOf(mask));
                        zoneIpForm.setStartIp(startIp);
                        zoneIpForm.setEndIp(endIp);
                        zoneIpFormList.add(zoneIpForm);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return zoneIpFormList;
    }

    public static List<String[]> getFinalIpList(List<String[]> includeIpList, List<String[]> excludeIpList) {
        int n = excludeIpList.size();
        for (int m = 0; m < n; ++m) {
            ArrayList newIncludeIpList = new ArrayList();
            Iterator<String[]> i = includeIpList.iterator();
            while (i.hasNext()) {
                String[] includeIp = i.next();
                String[] excludeIp = excludeIpList.get(m);
                newIncludeIpList.addAll(IPUtil.getIpRangeExceptOther((String[])includeIp, (String[])excludeIp));
                i.remove();
            }
            includeIpList.addAll(newIncludeIpList);
        }
        includeIpList = ReportAticUtil.cleanUpIpList(includeIpList);
        return includeIpList;
    }

    public static List<String[]> cleanUpIpList(List<String[]> ipList) {
        Collections.sort(ipList, new Comparator<String[]>(){

            @Override
            public int compare(String[] ip1, String[] ip2) {
                return IPUtil.compareTo((String)ip1[0], (String)ip2[0]);
            }
        });
        ArrayList<String[]> returnIpList = new ArrayList<String[]>();
        int k = ipList.size();
        for (int i = 0; i < k; ++i) {
            String[] tempIp;
            String[] ip = ipList.get(i);
            String startIp = ip[0];
            String endIp = ip[1];
            while (i < k - 1 && IPUtil.compareTo((String)endIp, (String)IPUtil.ipPrevious((String)(tempIp = ipList.get(i + 1))[0])) >= 0) {
                endIp = IPUtil.compareTo((String)endIp, (String)tempIp[1]) >= 0 ? endIp : tempIp[1];
                ++i;
            }
            String[] returnIp = new String[]{startIp, endIp};
            returnIpList.add(returnIp);
        }
        return returnIpList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFile(File fileName, String saveFilePath) {
        Boolean isSaveOk = false;
        FileInputStream fileInput = null;
        FileOutputStream fileOutput = null;
        try {
            int bytesRead;
            fileInput = new FileInputStream(fileName);
            fileOutput = new FileOutputStream(saveFilePath);
            byte[] buff = new byte[0x100000];
            while (-1 != (bytesRead = fileInput.read(buff, 0, buff.length))) {
                fileOutput.write(buff, 0, bytesRead);
            }
            isSaveOk = true;
        }
        catch (IOException e) {
            try {
                logger.error((Object)"downloadFile", (Throwable)e);
            }
            catch (Throwable throwable) {
                ReportAticUtil.closeInputStream(fileInput);
                ReportAticUtil.closeOutputStream(fileOutput);
                throw throwable;
            }
            ReportAticUtil.closeInputStream(fileInput);
            ReportAticUtil.closeOutputStream(fileOutput);
        }
        ReportAticUtil.closeInputStream(fileInput);
        ReportAticUtil.closeOutputStream(fileOutput);
        return isSaveOk;
    }

    private static void closeInputStream(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException e) {
                input = null;
            }
            finally {
                input = null;
            }
        }
    }

    private static void closeOutputStream(OutputStream output) {
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException e) {
                output = null;
            }
            finally {
                output = null;
            }
        }
    }

    public static boolean validateSpecialStr(String validateStr) {
        String regex = "^[\\w|\u4e00-\u9fa5|=|\\-|/|_|!|@|#|$|*|^|:|,|.|+|}|{]*$";
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(validateStr).matches();
    }

    public static boolean validatePwd(String password) {
        String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(password).matches();
    }

    public static boolean validateUrl(String url) {
        String regex1 = "^(https://.+)$";
        Pattern pattern = Pattern.compile(regex1);
        if (!pattern.matcher(url).matches()) {
            return false;
        }
        return ReportAticUtil.validateSpecialStr(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkFileType(File file, String fileType) {
        FileInputStream is = null;
        try {
            String hexStr;
            byte[] b = new byte[4];
            is = new FileInputStream(file);
            if (-1 != is.read(b, 0, b.length) && null != (hexStr = ReportAticUtil.bytesToHexString(b))) {
                boolean bl = hexStr.toUpperCase(Locale.getDefault()).contains(fileType.toUpperCase(Locale.getDefault()));
                return bl;
            }
        }
        catch (IOException e) {
            logger.error((Object)"checkFileType error");
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error((Object)"is.close() error");
                }
            }
        }
        return false;
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static boolean checkDateFormat(String dateRegex, String date) {
        String regex = "[0-9:\\ \\-\\/]+";
        if (!date.matches(regex)) {
            return false;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(dateRegex);
            format.setLenient(false);
            format.parse(date.trim());
        }
        catch (ParseException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static boolean validateParameterNames(HttpServletRequest request, String[] whiteList) {
        Set ss = request.getParameterMap().keySet();
        if (null == ss) {
            return true;
        }
        HashSet<String> whiteParaSet = new HashSet<String>();
        whiteParaSet.addAll(Arrays.asList("cfNameHF", "_dc", "_", "struts.token.name", "token", "submitToken", "csrfToken"));
        whiteParaSet.addAll(Arrays.asList(whiteList));
        return whiteParaSet.containsAll(ss);
    }

    public static String getcleanedMessage(String message) {
        if (null == message) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public static boolean validateIpv4(String ip) {
        String ipHeadStr;
        if (ReportAticUtil.isNull(ip)) {
            return false;
        }
        String regex1 = "^((22[0-3]|2[0-1]\\d|1\\d{2}|[1-9]\\d|[1-9])\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[0-9]\\d|[0-9]))?$";
        return ip.matches(regex1) && !StringUtils.equals((CharSequence)(ipHeadStr = ip.split("\\.")[0]), (CharSequence)"127");
    }

    public static void redirectLogin(HttpServletRequest request, HttpServletResponse response) {
        try {
            request.getSession().invalidate();
            response.sendRedirect(request.getContextPath() + "/pages/common/exception.jsp?timeout=true");
        }
        catch (IOException e) {
            logger.error((Object)"sendRedirect fail", (Throwable)e);
        }
    }

    public static String htmlEncode(String text) {
        if (null != text && !text.isEmpty()) {
            text = text.replace("&", "&amp;");
            text = text.replace("<", "&lt;");
            text = text.replace(">", "&gt;");
            text = text.replace("(", "&#40;");
            text = text.replace(")", "&#41;");
        }
        return text;
    }
}

