/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.util;

import com.hs.atic.bis.util.ReportBisConstants;
import com.hs.atic.sdk.bis.service.ILibraryFileService;
import com.hs.atic.sdk.bis.service.ILocationCustomService;
import com.hs.atic.sdk.bis.service.ILocationIpService;
import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IIpDomainService;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.vsm.secservice.sdk.common.service.ICheckUserSecurity;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INpFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.service.IDefendGroupService;
import com.huawei.atic.secne.sdk.service.IAticDeviceNfaService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import org.apache.struts2.ServletActionContext;

public final class ReportBisUtil {
    private static Log haLogger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    private ReportBisUtil() {
    }

    public static IDefendGroupService getDefendGroupService() {
        IDefendGroupService defendGroupService = (IDefendGroupService)AticUtil.getServiceContext().getService("defendGroupService", IDefendGroupService.class);
        if (null == defendGroupService) {
            throw new LegoCheckedException(570506L);
        }
        return defendGroupService;
    }

    public static ILibraryFileService getLibraryFileService() {
        ILibraryFileService libraryFileService = (ILibraryFileService)AticUtil.getServiceContext().getService("libraryFileService", ILibraryFileService.class);
        if (null == libraryFileService) {
            throw new LegoCheckedException(570506L);
        }
        return libraryFileService;
    }

    public static ILocationCustomService getLocationCustomService() {
        ILocationCustomService locationCustomService = (ILocationCustomService)AticUtil.getServiceContext().getService("locationCustomService", ILocationCustomService.class);
        if (null == locationCustomService) {
            throw new LegoCheckedException(570506L);
        }
        return locationCustomService;
    }

    public static ILocationIpService getLocationIpService() {
        ILocationIpService locationIpService = (ILocationIpService)AticUtil.getServiceContext().getService("locationIpService", ILocationIpService.class);
        if (null == locationIpService) {
            throw new LegoCheckedException(570506L);
        }
        return locationIpService;
    }

    public static IZoneService getZoneService() {
        IZoneService zoneService = (IZoneService)AticUtil.getServiceContext().getService("zoneService", IZoneService.class);
        if (zoneService == null) {
            throw new LegoCheckedException(570506L);
        }
        return zoneService;
    }

    public static IAticDeviceService getIFirewallService() {
        IAticDeviceService firewallService = (IAticDeviceService)AticUtil.getServiceContext().getService("aticDeviceService", IAticDeviceService.class);
        if (firewallService == null) {
            throw new LegoCheckedException(570506L);
        }
        return firewallService;
    }

    public static IAticDeviceNfaService getAticDeviceNfaService() {
        IAticDeviceNfaService aticDeviceNfaService = (IAticDeviceNfaService)AticUtil.getServiceContext().getService("aticDeviceNfaService", IAticDeviceNfaService.class);
        if (aticDeviceNfaService == null) {
            throw new LegoCheckedException(570506L);
        }
        return aticDeviceNfaService;
    }

    public static ICollectorService getICollectorService() {
        ICollectorService collectorService = (ICollectorService)AticUtil.getServiceContext().getService("collectorService", ICollectorService.class);
        if (collectorService == null) {
            throw new LegoCheckedException(570506L);
        }
        return collectorService;
    }

    public static ICollectorDeviceService getICollectorDeviceService() {
        ICollectorDeviceService service = (ICollectorDeviceService)AticUtil.getServiceContext().getService("collectorDeviceService", ICollectorDeviceService.class);
        if (service == null) {
            throw new LegoCheckedException(570506L);
        }
        return service;
    }

    public static IZoneMgrNorthSerice getZoneMgrNorthSerice() {
        IZoneMgrNorthSerice zoneMgrNorthSerice = (IZoneMgrNorthSerice)AticUtil.getServiceContext().getService("zoneMgrNorthSerice", IZoneMgrNorthSerice.class);
        if (null == zoneMgrNorthSerice) {
            throw new LegoCheckedException(570506L);
        }
        return zoneMgrNorthSerice;
    }

    public static IUserMgr getIUserMgrService() {
        IUserMgr userMgr = (IUserMgr)AticUtil.getServiceContext().getService("usermgr", IUserMgr.class);
        if (null == userMgr) {
            throw new LegoCheckedException(570506L);
        }
        return userMgr;
    }

    public static String[] generateDivertExportTitles() {
        return new String[]{AticUtil.getText((String)"atic.bis.divert.tactics.device"), AticUtil.getText((String)"atic.bis.divert.choose.zone"), AticUtil.getText((String)"atic.bis.divert.tactics.ip"), AticUtil.getText((String)"atic.bis.divert.tactics.mask"), AticUtil.getText((String)"atic.bis.divert.tactics.vpn"), AticUtil.getText((String)"atic.bis.divert.tactics.log.operate.time"), AticUtil.getText((String)"atic.bis.divert.tactics.log.operate.person"), AticUtil.getText((String)"atic.bis.divert.tactics.log.operate.clientIp"), AticUtil.getText((String)"atic.bis.divert.tactics.log.operate.type"), AticUtil.getText((String)"atic.bis.divert.tactics.log.result"), AticUtil.getText((String)"atic.bis.divert.tactics.divert.mode"), AticUtil.getText((String)"atic.bis.divert.tactics.log.level"), AticUtil.getText((String)"atic.bis.divert.tactics.log.remark")};
    }

    public static String[] generateOutboundDivertExportTitles() {
        return new String[]{AticUtil.getText((String)"atic.bis.divert.outbound.device"), AticUtil.getText((String)"atic.bis.divert.choose.zone"), AticUtil.getText((String)"atic.bis.divert.tactics.ip"), AticUtil.getText((String)"atic.bis.divert.outbound.source.port"), AticUtil.getText((String)"atic.bis.divert.outbound.destination.ip"), AticUtil.getText((String)"atic.bis.divert.outbound.destination.port"), AticUtil.getText((String)"atic.bis.divert.outbound.protocol"), AticUtil.getText((String)"atic.bis.divert.outbound.action"), AticUtil.getText((String)"atic.bis.divert.outbound.threshold"), AticUtil.getText((String)"atic.bis.divert.outbound.nexthop"), AticUtil.getText((String)"atic.bis.divert.tactics.log.operate.time"), AticUtil.getText((String)"atic.bis.divert.tactics.log.operate.person"), AticUtil.getText((String)"atic.bis.divert.tactics.log.operate.clientIp"), AticUtil.getText((String)"atic.bis.divert.tactics.log.operate.type"), AticUtil.getText((String)"atic.bis.divert.tactics.log.result"), AticUtil.getText((String)"atic.bis.divert.tactics.divert.mode"), AticUtil.getText((String)"atic.bis.divert.tactics.log.level"), AticUtil.getText((String)"atic.bis.divert.tactics.log.remark")};
    }

    public static String[] generateDevSyslogExportTitles() {
        return new String[]{AticUtil.getText((String)"atic.system.devsyslog.logTime"), AticUtil.getText((String)"atic.system.devsyslog.devTime"), AticUtil.getText((String)"atic.system.devsyslog.devIp"), AticUtil.getText((String)"atic.system.devsyslog.terminalIp"), AticUtil.getText((String)"atic.system.devsyslog.task"), AticUtil.getText((String)"atic.system.devsyslog.user"), AticUtil.getText((String)"atic.system.devsyslog.vrf"), AticUtil.getText((String)"atic.system.devsyslog.command"), AticUtil.getText((String)"atic.system.devsyslog.detail")};
    }

    public static String[] generateSysLinkExportTitles() {
        return new String[]{AticUtil.getText((String)"atic.system.devsyslog.logTime"), AticUtil.getText((String)"atic.system.devsyslog.devIp"), AticUtil.getText((String)"atic.system.devsyslog.detail")};
    }

    public static int getDestinationPort(int port) {
        return port > 0 ? port : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties openPropertyFile(String relativeFileName) {
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            inputStream = ReportBisUtil.class.getResourceAsStream(relativeFileName);
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (FileNotFoundException e) {
            haLogger.error((Object)"execute BisUtil.openPropertyFile() failed! ");
            Properties properties3 = properties;
            return properties3;
        }
        catch (IOException e) {
            haLogger.error((Object)"execute BisUtil.openPropertyFile() failed! ", (Throwable)e);
            Properties properties4 = properties;
            return properties4;
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    haLogger.error((Object)"execute BisUtil.openPropertyFile() failed! ", (Throwable)e);
                }
            }
        }
    }

    public static List<LangPair> getPcapTypeCombData(boolean hasAll) {
        ArrayList<LangPair> combData = new ArrayList<LangPair>();
        if (hasAll) {
            LangPair all = new LangPair("", AticUtil.getText((String)"atic.bis.packet.task.all"));
            combData.add(all);
        }
        LangPair acl = new LangPair(String.valueOf(1), AticUtil.getText((String)"atic.bis.pcap.task.type.acl"));
        LangPair global = new LangPair(String.valueOf(0), AticUtil.getText((String)"atic.bis.pcap.task.type.global"));
        LangPair attack = new LangPair(String.valueOf(2), AticUtil.getText((String)"atic.bis.pcap.task.type.attack"));
        LangPair abnormal = new LangPair(String.valueOf(3), AticUtil.getText((String)"atic.bis.pcap.task.type.abnormal"));
        combData.add(acl);
        combData.add(global);
        combData.add(attack);
        combData.add(abnormal);
        return combData;
    }

    public static List<LangPair> getPacketTaskStateCombData() {
        ArrayList<LangPair> combData = new ArrayList<LangPair>();
        LangPair data1 = new LangPair("", AticUtil.getText((String)"atic.bis.packet.task.all"));
        LangPair data2 = new LangPair(String.valueOf(1), AticUtil.getText((String)"atic.bis.packet.task.state.start"));
        LangPair data3 = new LangPair(String.valueOf(0), AticUtil.getText((String)"atic.bis.packet.task.state.stop"));
        combData.add(data1);
        combData.add(data2);
        combData.add(data3);
        return combData;
    }

    public static List<LangPair> getPacketFileStatusCombData() {
        ArrayList<LangPair> combData = new ArrayList<LangPair>();
        LangPair ld1 = new LangPair("", AticUtil.getText((String)"atic.bis.packet.file.all"));
        LangPair ld2 = new LangPair(String.valueOf(0), AticUtil.getText((String)"atic.bis.packet.file.status.learned"));
        LangPair ld3 = new LangPair(String.valueOf(1), AticUtil.getText((String)"atic.bis.packet.file.status.writing"));
        combData.add(ld1);
        combData.add(ld2);
        combData.add(ld3);
        return combData;
    }

    public static String getDefendGroupDetectModeCombData() {
        StringBuffer combData = new StringBuffer();
        combData.append("[['").append(1).append("','").append(AticUtil.getText((String)"atic.bis.defend.group.detect.mode.balanced")).append("'],");
        combData.append("['").append(0).append("','").append(AticUtil.getText((String)"atic.bis.defend.group.detect.mode.redundancy")).append("']]");
        return combData.toString();
    }

    public static String getDefendGroupNetModeCombData() {
        StringBuffer combData = new StringBuffer();
        combData.append("[['").append(1).append("','").append(AticUtil.getText((String)"atic.bis.defend.group.netmode.backward")).append("'],");
        combData.append("['").append(2).append("','").append(AticUtil.getText((String)"atic.bis.defend.group.netmode.upward")).append("']]");
        return combData.toString();
    }

    public static List<LangPair> getDivertModeCombData() {
        ArrayList<LangPair> combData = new ArrayList<LangPair>();
        combData.add(new LangPair("", AticUtil.getText((String)"atic.bis.divert.tactics.log.query.all")));
        combData.add(new LangPair(String.valueOf(1), AticUtil.getText((String)"atic.bis.divert.tactics.divert.mode.manually")));
        combData.add(new LangPair(String.valueOf(0), AticUtil.getText((String)"atic.bis.divert.tactics.divert.mode.auto")));
        combData.add(new LangPair(String.valueOf(2), AticUtil.getText((String)"atic.bis.divert.tactics.divert.mode.static")));
        return combData;
    }

    public static List<LangPair> getDivertStatusCombData() {
        ArrayList<LangPair> combData = new ArrayList<LangPair>();
        combData.add(new LangPair("", AticUtil.getText((String)"atic.public.query.all")));
        combData.add(new LangPair(String.valueOf(1), AticUtil.getText((String)"atic.bis.divert.tactics.divert.status.start")));
        combData.add(new LangPair(String.valueOf(0), AticUtil.getText((String)"atic.bis.divert.tactics.divert.status.stop")));
        return combData;
    }

    public static List<LangPair> getDivertLogCombData() {
        ArrayList<LangPair> combData = new ArrayList<LangPair>();
        combData.add(new LangPair("", AticUtil.getText((String)"atic.bis.divert.tactics.log.query.all")));
        combData.add(new LangPair(String.valueOf(1), AticUtil.getText((String)"atic.bis.divert.tactics.log.level.danger")));
        combData.add(new LangPair(String.valueOf(3), AticUtil.getText((String)"atic.bis.divert.tactics.log.level.warning")));
        combData.add(new LangPair(String.valueOf(2), AticUtil.getText((String)"atic.bis.divert.tactics.log.level.general")));
        combData.add(new LangPair(String.valueOf(4), AticUtil.getText((String)"atic.bis.divert.tactics.log.level.info")));
        return combData;
    }

    public static Map<Integer, String> getDiveretLogOperTypeMap() {
        HashMap<Integer, String> data = new HashMap<Integer, String>();
        data.put(ReportBisConstants.DIVERT_LOG_OPER_TYPE_CREATE, AticUtil.getText((String)"atic.bis.divert.tactics.operate.type.create"));
        data.put(ReportBisConstants.DIVERT_LOG_OPER_TYPE_START, AticUtil.getText((String)"atic.bis.divert.tactics.operate.type.start"));
        data.put(ReportBisConstants.DIVERT_LOG_OPER_TYPE_STOP, AticUtil.getText((String)"atic.bis.divert.tactics.operate.type.stop"));
        data.put(ReportBisConstants.DIVERT_LOG_OPER_TYPE_DELETE, AticUtil.getText((String)"atic.bis.divert.tactics.operate.type.delete"));
        data.put(ReportBisConstants.DIVERT_LOG_OPER_TYPE_DELETE_ALL, AticUtil.getText((String)"atic.bis.divert.tactics.operate.type.delete.all"));
        return data;
    }

    public static Map<Integer, String> getDiveretLogActionMap() {
        HashMap<Integer, String> data = new HashMap<Integer, String>();
        data.put(1, AticUtil.getText((String)"atic.bis.divert.outbound.action.block"));
        data.put(2, AticUtil.getText((String)"atic.bis.divert.outbound.action.limit"));
        data.put(3, AticUtil.getText((String)"atic.bis.divert.outbound.action.redirect"));
        return data;
    }

    public static Map<Integer, String> getDiveretLogResultsMap() {
        HashMap<Integer, String> data = new HashMap<Integer, String>();
        data.put(0, AticUtil.getText((String)"atic.bis.divert.tactics.log.result.fail"));
        data.put(1, AticUtil.getText((String)"atic.bis.divert.tactics.log.result.success"));
        return data;
    }

    public static Map<Integer, String> getDivertModeMap() {
        HashMap<Integer, String> data = new HashMap<Integer, String>();
        data.put(1, AticUtil.getText((String)"atic.bis.divert.tactics.divert.mode.manually"));
        data.put(0, AticUtil.getText((String)"atic.bis.divert.tactics.divert.mode.auto"));
        data.put(2, AticUtil.getText((String)"atic.bis.divert.tactics.divert.mode.static"));
        return data;
    }

    public static Map<Integer, String> getDivertStateMap() {
        HashMap<Integer, String> data = new HashMap<Integer, String>();
        data.put(1, AticUtil.getText((String)"atic.bis.divert.tactics.divert.status.start"));
        data.put(0, AticUtil.getText((String)"atic.bis.divert.tactics.divert.status.stop"));
        return data;
    }

    public static Map<Integer, String> getLogLevelMap() {
        HashMap<Integer, String> data = new HashMap<Integer, String>();
        data.put(1, AticUtil.getText((String)"atic.bis.divert.tactics.log.level.danger"));
        data.put(2, AticUtil.getText((String)"atic.bis.divert.tactics.log.level.general"));
        data.put(3, AticUtil.getText((String)"atic.bis.divert.tactics.log.level.warning"));
        data.put(4, AticUtil.getText((String)"atic.bis.divert.tactics.log.level.info"));
        return data;
    }

    public static String getPcapTypeString(int pcapType) {
        String pcapTypeName = "-";
        if (0 == pcapType) {
            pcapTypeName = AticUtil.getText((String)"atic.bis.packet.file.pcaptype.discard");
        } else if (1 == pcapType) {
            pcapTypeName = AticUtil.getText((String)"atic.bis.packet.file.pcaptype.acl");
        } else if (2 == pcapType) {
            pcapTypeName = AticUtil.getText((String)"atic.bis.packet.file.pcaptype.attack");
        } else if (3 == pcapType) {
            pcapTypeName = AticUtil.getText((String)"atic.bis.packet.file.pcaptype.exception");
        }
        return pcapTypeName;
    }

    public static String getProtocolString(int protocol) {
        String protocolString = "";
        if (1 == protocol) {
            protocolString = "TCP";
        } else if (2 == protocol) {
            protocolString = "UDP";
        } else if (3 == protocol) {
            protocolString = "HTTP";
        }
        return protocolString;
    }

    public static String getDsipalyAttackStatus(int attackStatus) {
        String attackStatusString = "-";
        if (0 == attackStatus) {
            attackStatusString = AticUtil.getText((String)"atic.bis.packet.file.event.attack.status.stop");
        } else if (1 == attackStatus) {
            attackStatusString = AticUtil.getText((String)"atic.bis.packet.file.event.attack.status.exception");
        } else if (2 == attackStatus) {
            attackStatusString = AticUtil.getText((String)"atic.bis.packet.file.event.attack.status.attacking");
        }
        return attackStatusString;
    }

    public static boolean createFile(String importPath) {
        File file = new File(importPath);
        if (!file.exists()) {
            boolean ret = file.mkdir();
            return ret;
        }
        return true;
    }

    public static boolean checkIsErrorCode(String deployStatus) {
        String resource;
        String deployErrorCode = deployStatus;
        if (deployStatus.contains(",")) {
            deployErrorCode = deployErrorCode.split(",")[0];
        }
        return AticUtil.isNum((String)deployErrorCode) != false && !(resource = AticUtil.getText((String)("lego.err." + deployErrorCode))).equals("lego.err." + deployErrorCode);
    }

    public static String getDeployStatus4Jsp(String deployStatus, boolean unDeploy) {
        String deployStatusJsp = "";
        if (deployStatus.equals("undeployed")) {
            deployStatusJsp = AticUtil.getText((String)"atic.bis.libraryFile.deployStatus.undeployed");
        } else if (deployStatus.equals("failure")) {
            deployStatusJsp = AticUtil.getText((String)"atic.bis.libraryFile.deployStatus.failure");
        } else if (deployStatus.equals("success")) {
            deployStatusJsp = AticUtil.getText((String)"atic.bis.libraryFile.deployStatus.success");
        } else if (deployStatus.equals("deploying")) {
            deployStatusJsp = AticUtil.getText((String)"atic.bis.libraryFile.deployStatus.deploying");
        } else if (deployStatus.equals("part_suc")) {
            deployStatusJsp = AticUtil.getText((String)"atic.bis.libraryFile.deployStatus.partSuccess");
        } else if (ReportBisUtil.checkIsErrorCode(deployStatus)) {
            if (deployStatus.contains(",")) {
                String deployErrorCode = deployStatus.split(",")[0];
                String errorInfo = deployStatus.substring(deployStatus.indexOf(",") + 1);
                deployStatusJsp = AticUtil.getText((String)("lego.err." + deployErrorCode)) + "(" + errorInfo + ")";
            } else {
                deployStatusJsp = AticUtil.getText((String)("lego.err." + deployStatus));
            }
        } else {
            deployStatusJsp = AticUtil.getText((String)"atic.bis.libraryFile.deployStatus.undeployed");
        }
        return deployStatusJsp;
    }

    public static List<AticDevice> getAllDdosFirewall(HttpSession httpSession) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        List allDdosFirewall = firewallService.getAntiDDoSDevice();
        return allDdosFirewall;
    }

    public static IFilterService getFilterService() {
        ServiceContext serviceContext = ServiceContext.getInstance();
        return (IFilterService)serviceContext.getService("filterService", IFilterService.class);
    }

    public static void checkUserSecurity(List<Long> moIdList) {
        ServiceContext serviceContext = ServiceContext.getInstance();
        ICheckUserSecurity checkUserSecurity = (ICheckUserSecurity)serviceContext.getService("checkUserSecurityService", ICheckUserSecurity.class);
        if (null == checkUserSecurity) {
            throw new LegoCheckedException(570506L);
        }
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        checkUserSecurity.checkUserSecurity(currentUser.getUserID(), Boolean.valueOf("true".equalsIgnoreCase(currentUser.getIsAdmin())), moIdList);
    }

    public static void checkUserSecurity(List<Long> moIdList, User currentUser) {
        ServiceContext serviceContext = ServiceContext.getInstance();
        ICheckUserSecurity checkUserSecurity = (ICheckUserSecurity)serviceContext.getService("checkUserSecurityService", ICheckUserSecurity.class);
        if (null == checkUserSecurity) {
            throw new LegoCheckedException(570506L);
        }
        checkUserSecurity.checkUserSecurity(currentUser.getUserID(), Boolean.valueOf("true".equalsIgnoreCase(currentUser.getIsAdmin())), moIdList);
    }

    public static Long getMoidByZoneid(Long zoneId) {
        Long moid = 0L;
        ServiceContext serviceContext = ServiceContext.getInstance();
        IZoneService zoneService = (IZoneService)serviceContext.getService("zoneService", IZoneService.class);
        ZoneInfoForm zoneInfoForm = zoneService.getById(zoneId);
        if (null != zoneInfoForm) {
            moid = zoneInfoForm.getMoId();
        }
        return moid;
    }

    public static IClusterService getClusterService() {
        ServiceContext serviceContext = ServiceContext.getInstance();
        return (IClusterService)serviceContext.getService("clusterService", IClusterService.class);
    }

    public static ILicenseOutboundService getLicenseOutboundService() {
        ServiceContext serviceContext = ServiceContext.getInstance();
        return (ILicenseOutboundService)serviceContext.getService("licenseOutboundService", ILicenseOutboundService.class);
    }

    public static IIpDomainService getIpDomainService() {
        ServiceContext serviceContext = ServiceContext.getInstance();
        return (IIpDomainService)serviceContext.getInstance().getService("ipDomainService", IIpDomainService.class);
    }

    public static INpFilterService getNpFilterService() {
        ServiceContext serviceContext = ServiceContext.getInstance();
        return (INpFilterService)serviceContext.getService("npFilterService", INpFilterService.class);
    }
}

