/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.report.action;

import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.DataSourceStub;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.report.model.DeviceListForm;
import com.hs.atic.report.model.RadioGroupVO;
import com.hs.atic.report.model.ReportCondModel;
import com.hs.atic.report.model.SelectForm;
import com.hs.atic.report.model.TaskScheduleForm;
import com.hs.atic.report.model.ZoneListForm;
import com.hs.atic.report.util.ReportConditionUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceDeployStatusService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.CommonUtil;
import com.opensymphony.xwork2.ActionContext;
import com.security.ireport.engine.ReportSession;
import com.security.ireport.engine.ReportSessionManager;
import com.security.ireport.engine.output.ExportReport;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.util.IReportMgrUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.ProductFaceUtil;
import com.security.logserver.module.condition.common.BaseAction;
import com.security.logserver.module.condition.util.Pair;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class SystemReportAction
extends BaseAction {
    private static Map<String, String> reportExportStatus = new HashMap<String, String>();
    private static final long serialVersionUID = 7498278516139199774L;
    private static final int DEVICE_NUM = 1;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private String synthesisReportType;
    private String deviceId;
    private String systemDeviceId;
    private String zoneDeviceId;
    private String checkStatusDeviceId;
    private String systemDeviceName;
    private String zoneDeviceName;
    private String defaultDeviceName;
    private String defaultDevice;
    private String defaultDeviceId;
    private String deviceType;
    private Long zoneId;
    private String zoneName;
    private String startTime;
    private String endTime;
    private String formType;
    private String directionSystem;
    private String directionZone;
    private String reportIds;
    private String topNValues;
    private String queryDeviceId;
    private String reportType;
    private String useReportType;
    private List<RadioGroupVO> scheduleTypeList;
    private List<DeviceListForm> initDeviceList;
    private int isSchedule;
    private List<TaskScheduleForm> taskScheduleList;
    private TaskScheduleForm taskScheduleForm;
    private DeviceListForm deviceListForm;
    private String scheduleTime;
    private SelectForm selectMonth;
    private List<SelectForm> selectYearList;
    private SelectForm selectYear;
    private List<RadioGroupVO> reportFileTypeList;
    private int formTypeInteger;
    private File companyLogo;
    private String companyName;
    private String companyLogoPic;
    private String companyLogoName;
    private int schedule;
    private String selectYearValue;
    private String selectMonthValue;
    private String emailTheme;
    private String mainAddressees;
    private String ccAddressee;
    private String content;
    private boolean isSupportOutbound;

    public String showSynthesisReport() {
        ILicenseOutboundService licenseOutboundService = ReportBisUtil.getLicenseOutboundService();
        this.isSupportOutbound = licenseOutboundService.isSupportOutbound();
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        request.getSession().setAttribute("isSupportOutbound", (Object)this.isSupportOutbound);
        return "list";
    }

    public String showSystemReport() {
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        request.setAttribute("isTask", (Object)"0");
        if ("ips".equalsIgnoreCase(AnalysisConstants.getInstance().getReportType())) {
            this.defaultDeviceName = this.getText("ips.analysis.common.netdevice.all");
            request.setAttribute("isIps", (Object)"1");
        } else {
            this.defaultDeviceName = this.getText("ips.analysis.common.netdevice.all");
            request.setAttribute("isIps", (Object)"0");
        }
        this.initTaskScheduleList();
        this.initReportTypeList();
        this.initSelectYearList();
        this.initDeviceList();
        return "list";
    }

    private void initReportTypeList() {
        this.scheduleTypeList = new ArrayList<RadioGroupVO>();
        RadioGroupVO radio1 = new RadioGroupVO();
        radio1.setKey(0);
        radio1.setLabel(this.getText("atic.analysis.common.noShowcompare"));
        RadioGroupVO radio2 = new RadioGroupVO();
        radio2.setKey(1);
        radio2.setLabel(this.getText("atic.analysis.common.showcompare"));
        this.scheduleTypeList.add(radio1);
        this.scheduleTypeList.add(radio2);
        this.isSchedule = 0;
        this.reportFileTypeList = new ArrayList<RadioGroupVO>();
        RadioGroupVO pdf = new RadioGroupVO();
        pdf.setKey(1);
        pdf.setLabel("PDF");
        RadioGroupVO html = new RadioGroupVO();
        html.setKey(2);
        html.setLabel("HTML");
        RadioGroupVO excel = new RadioGroupVO();
        excel.setKey(3);
        excel.setLabel("Excel");
        this.reportFileTypeList.add(pdf);
        this.reportFileTypeList.add(html);
        this.reportFileTypeList.add(excel);
        this.formTypeInteger = 1;
    }

    private void initSelectYearList() {
        int year = Calendar.getInstance().get(1);
        if (null == this.selectYearList) {
            this.selectYearList = new ArrayList<SelectForm>();
            for (int i = 0; i < 5; ++i) {
                SelectForm temp = new SelectForm();
                temp.setSelectName(year - i + "");
                temp.setSelectValue(year - i + "");
                this.selectYearList.add(temp);
            }
        }
        if (null == this.selectYear) {
            this.selectYear = new SelectForm();
            this.selectYear.setSelectName(year + "");
            this.selectYear.setSelectValue(year + "");
        }
        if (null == this.selectMonth) {
            this.selectMonth = new SelectForm();
            this.selectMonth.setSelectName("1");
            this.selectMonth.setSelectValue("1");
        }
    }

    private void initTaskScheduleList() {
        if (null == this.taskScheduleList) {
            this.taskScheduleList = new ArrayList<TaskScheduleForm>();
            TaskScheduleForm scheduleForm1 = new TaskScheduleForm();
            scheduleForm1.setName(this.getText("report.type.schedule.day"));
            scheduleForm1.setSchedule(1);
            this.taskScheduleList.add(scheduleForm1);
            TaskScheduleForm scheduleForm2 = new TaskScheduleForm();
            scheduleForm2.setName(this.getText("report.type.schedule.week"));
            scheduleForm2.setSchedule(2);
            this.taskScheduleList.add(scheduleForm2);
            TaskScheduleForm scheduleForm3 = new TaskScheduleForm();
            scheduleForm3.setName(this.getText("report.type.schedule.month"));
            scheduleForm3.setSchedule(3);
            this.taskScheduleList.add(scheduleForm3);
            TaskScheduleForm scheduleForm4 = new TaskScheduleForm();
            scheduleForm4.setName(this.getText("report.type.schedule.year"));
            scheduleForm4.setSchedule(4);
            this.taskScheduleList.add(scheduleForm4);
        }
        if (null == this.taskScheduleForm) {
            this.taskScheduleForm = new TaskScheduleForm();
            this.taskScheduleForm.setName(this.getText("report.type.schedule.day"));
            this.taskScheduleForm.setSchedule(1);
        }
    }

    public void checkCollectorStatus() {
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, this.checkStatusDeviceId);
        ArrayList<Long> moIDList = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)this.checkStatusDeviceId) && ReportConditionUtil.getLongDeviceId(this.checkStatusDeviceId) > 0L) {
            moIDList.add(ReportConditionUtil.getLongDeviceId(this.checkStatusDeviceId));
        }
        ReportBisUtil.checkUserSecurity(moIDList);
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        List<Object> neList = new ArrayList();
        if (datastatConditionForm.getDeviceId() > 0L) {
            AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
            neList.add(firewall);
        } else {
            neList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, 1L);
        }
        for (AticDevice aticDevice : neList) {
            if (null == aticDevice || null == aticDevice.getIpAddress()) {
                this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
                throw new LegoCheckedException(570502L);
            }
            Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(aticDevice.getMoId()));
            if (null == collectorId || null == collectorService.getCollectorInfo(collectorId.longValue())) {
                this.logger.error((Object)("no collector exist,devId = " + aticDevice.getMoId()));
                continue;
            }
            if (2 != collectorService.getCollectorInfo(collectorId.longValue()).getStatus()) continue;
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + collectorService.getCollectorInfo(collectorId.longValue()).getIpAddress()));
            throw new LegoCheckedException(570504L);
        }
        HttpServletResponse response = (HttpServletResponse)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        response.setContentType("application/xml;charset=UTF-8");
        try {
            response.getWriter().write("success");
        }
        catch (IOException iOException) {
            this.logger.error((Object)"checkCollectorStatus  response.getWriter().write error", (Throwable)iOException);
        }
    }

    public String generalSystemReport4SelectInte() {
        this.logger.info((Object)"Begin SystemReportAction generalSystemReport4SelectInte function");
        String pageName = "";
        ActionContext ctx = ActionContext.getContext();
        HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        String requestSessionId = request.getRequestedSessionId();
        SystemReportAction.setReportExportStatus(requestSessionId, "");
        try {
            this.processReportType();
            String reportFileName = "";
            String reportId4Inte = "";
            if (this.synthesisReportType.equalsIgnoreCase("system")) {
                pageName = "system";
                reportFileName = this.getText("atic.report.task.systemReport");
                reportId4Inte = "systemReport";
            } else {
                pageName = "zone";
                reportFileName = this.getText("atic.report.task.zoneReport");
                reportId4Inte = "zoneReport";
                if (null != this.deviceListForm) {
                    this.zoneDeviceId = this.deviceListForm.getZoneDeviceId();
                    this.zoneDeviceName = this.deviceListForm.getZoneDeviceName();
                }
            }
            ArrayList<Long> moIDList = new ArrayList<Long>();
            if (StringUtils.isNotBlank((CharSequence)this.zoneDeviceId) && ReportConditionUtil.getLongDeviceId(this.zoneDeviceId) > 0L) {
                moIDList.add(ReportConditionUtil.getLongDeviceId(this.zoneDeviceId));
            }
            if (StringUtils.isNotBlank((CharSequence)this.systemDeviceId) && ReportConditionUtil.getLongDeviceId(this.systemDeviceId) > 0L) {
                moIDList.add(ReportConditionUtil.getLongDeviceId(this.systemDeviceId));
            }
            if (null != this.zoneId) {
                moIDList.add(ReportBisUtil.getMoidByZoneid(this.zoneId));
            }
            ReportBisUtil.checkUserSecurity(moIDList);
            ArrayList<ReportSession> reportSessionList = new ArrayList<ReportSession>();
            if (!this.checkSelectAllDevice()) {
                this.processSingleReport(reportSessionList, reportId4Inte, false);
            } else {
                if ("zoneReport".equals(reportId4Inte)) {
                    reportId4Inte = "zoneReportNoSupplement";
                }
                this.processAllDeviceReport(reportSessionList, reportId4Inte);
            }
            HttpServletResponse response = (HttpServletResponse)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
            ExportReport exportReport = new ExportReport(reportSessionList, request, response);
            Boolean exportStatus = null;
            exportStatus = exportReport.export(this.formType, reportFileName);
            if (null != exportStatus) {
                SystemReportAction.setReportExportStatus(requestSessionId, "finished");
                if (!exportStatus.booleanValue()) {
                    SystemReportAction.setReportExportStatus(requestSessionId, "exportError");
                    this.logger.error((Object)"exportReport error!");
                    return pageName;
                }
            }
        }
        catch (LegoCheckedException legoException) {
            SystemReportAction.setReportExportStatus(requestSessionId, "exportError");
            this.logger.error((Object)"generalSystemReport4SelectInte LegoCheckedException", (Throwable)legoException);
            throw legoException;
        }
        catch (RuntimeException e) {
            SystemReportAction.setReportExportStatus(requestSessionId, "exportError");
            this.logger.error((Object)"unknow error!");
            return pageName;
        }
        catch (Exception e) {
            SystemReportAction.setReportExportStatus(requestSessionId, "exportError");
            this.logger.error((Object)"unknow error!");
            return pageName;
        }
        this.logger.info((Object)"end SystemReportAction generalSystemReport4SelectInte function");
        return pageName;
    }

    public boolean validateDate(String date) {
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
    }

    private List<AticDevice> getDevlist() {
        List<Object> devList = new ArrayList();
        ActionContext ctx = ActionContext.getContext();
        Long currentLogUserId = 1L;
        Boolean isAdmin = true;
        if (null != ctx) {
            HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            currentLogUserId = currentUser.getUserID();
            isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
        }
        Long devId = 0L;
        if (this.synthesisReportType.equalsIgnoreCase("system")) {
            devId = Long.parseLong(this.systemDeviceId);
        } else if (this.synthesisReportType.equalsIgnoreCase("zone")) {
            devId = Long.parseLong(this.zoneDeviceId);
        }
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        datastatConditionForm.setDeviceId(devId);
        if (-2L == devId) {
            devList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
            if (!devList.isEmpty()) {
                for (AticDevice aticDevice : devList) {
                    aticDevice.setDdosType(1);
                }
            }
        } else if (-1L == devId) {
            devList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
            if (!devList.isEmpty()) {
                for (AticDevice aticDevice : devList) {
                    aticDevice.setDdosType(0);
                }
            }
        } else if (0L == devId) {
            datastatConditionForm.setDeviceId(-1L);
            List<AticDevice> cleanDevList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
            datastatConditionForm.setDeviceId(-2L);
            List<AticDevice> list = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
            if (!cleanDevList.isEmpty()) {
                for (AticDevice temp : cleanDevList) {
                    temp.setDdosType(0);
                    devList.add(temp);
                }
            }
            if (!list.isEmpty()) {
                for (AticDevice temp : list) {
                    temp.setDdosType(1);
                    devList.add(temp);
                }
            }
        }
        if (this.synthesisReportType.equalsIgnoreCase("zone") && !devList.isEmpty()) {
            ArrayList<AticDevice> zoneDevList = new ArrayList<AticDevice>();
            IZoneDeviceDeployStatusService iZoneDeviceDeployStatusService = (IZoneDeviceDeployStatusService)ServiceContext.getInstance().getService("zoneDeviceDeployStatusService", IZoneDeviceDeployStatusService.class);
            List lstDevId = iZoneDeviceDeployStatusService.getDevByZone4Secutity(this.zoneId, isAdmin, currentLogUserId);
            for (AticDevice aticDevice : devList) {
                Long devIdTemp = aticDevice.getMoId();
                if (!lstDevId.contains(devIdTemp)) continue;
                zoneDevList.add(aticDevice);
            }
            return zoneDevList;
        }
        return devList;
    }

    private void processAllDeviceReport(List<ReportSession> reportSessionList, String reportId4Inte) {
        block10: {
            List<AticDevice> devList;
            block9: {
                devList = this.getDevlist();
                if (!this.synthesisReportType.equalsIgnoreCase("system")) break block9;
                if (devList.isEmpty()) break block10;
                for (AticDevice aticDevice : devList) {
                    if ("Syslog".equals(aticDevice.getDeviceModel())) continue;
                    String deviceIdTemp = String.valueOf(aticDevice.getMoId());
                    String devModel = ReportConditionUtil.getDeviceModelByCombId(deviceIdTemp);
                    int devType = aticDevice.getDdosType();
                    this.systemDeviceId = deviceIdTemp = deviceIdTemp + '_' + devType + '_' + devModel;
                    String name = "";
                    if (0 == devType) {
                        name = this.getText("atic.analysis.common.clean");
                    } else if (1 == devType) {
                        name = this.getText("atic.analysis.common.detect");
                    }
                    this.systemDeviceName = aticDevice.getName() + name;
                    this.processSingleReport(reportSessionList, reportId4Inte, true);
                }
                break block10;
            }
            if (this.synthesisReportType.equalsIgnoreCase("zone") && !devList.isEmpty()) {
                for (AticDevice aticDevice : devList) {
                    if ("Syslog".equals(aticDevice.getDeviceModel())) continue;
                    String deviceIdTemp = String.valueOf(aticDevice.getMoId());
                    String devModel = ReportConditionUtil.getDeviceModelByCombId(deviceIdTemp);
                    int devType = aticDevice.getDdosType();
                    this.zoneDeviceId = deviceIdTemp = deviceIdTemp + '_' + devType + '_' + devModel;
                    String name = "";
                    if (0 == devType) {
                        name = this.getText("atic.analysis.common.clean");
                    } else if (1 == devType) {
                        name = this.getText("atic.analysis.common.detect");
                    }
                    this.zoneDeviceName = aticDevice.getName() + name;
                    this.processSingleReport(reportSessionList, reportId4Inte, true);
                }
            }
        }
    }

    private void processSingleReport(List<ReportSession> reportSessionList, String reportId4Inte, boolean isSelectAllDevice) {
        String deviceTypeStr;
        Locale locale = LocaleUtil.INSTANCE.getCurrentUserLocale();
        ReportCondModel queryCond = new ReportCondModel();
        queryCond.setSelectAllDevice(isSelectAllDevice);
        if (this.synthesisReportType.equalsIgnoreCase("system")) {
            queryCond.setDeviceId(this.systemDeviceId);
            queryCond.setDeviceName(this.systemDeviceName);
            deviceTypeStr = ReportConditionUtil.getDeviceTypeByCombId(this.systemDeviceId);
            queryCond.setDeviceType(deviceTypeStr);
            int directionId = AticUtil.isNull((String)this.directionSystem) || this.directionSystem.equals("Inbound") ? 1 : 2;
            queryCond.setDirectionId(directionId);
        } else {
            queryCond.setDeviceId(this.zoneDeviceId);
            queryCond.setDeviceName(this.zoneDeviceName);
            deviceTypeStr = ReportConditionUtil.getDeviceTypeByCombId(this.zoneDeviceId);
            queryCond.setDeviceType(deviceTypeStr);
            int directionId = AticUtil.isNull((String)this.directionZone) || this.directionZone.equals("Inbound") ? 1 : 2;
            queryCond.setDirectionId(directionId);
        }
        queryCond.setZoneId(this.zoneId);
        queryCond.setZoneName(this.zoneName);
        queryCond.setIsSchedule(this.isSchedule);
        if (this.isSchedule == 0) {
            queryCond.setStartTime(this.startTime);
            queryCond.setEndTime(this.endTime);
        } else {
            String scheduleType = this.processScheduleType(queryCond);
            queryCond.setScheduleType(scheduleType);
        }
        queryCond.setTopNValues(this.topNValues);
        queryCond.setReportIds(this.reportIds);
        Map<String, JsonValueObj> conditionMap = ReportConditionUtil.prepareReportList4SelectInte(queryCond);
        ReportSession reportSession = ReportSessionManager.getInstance().createReportSession(reportId4Inte, null, locale);
        if (null == reportSession) {
            return;
        }
        if (reportSession.prepare(conditionMap, true)) {
            reportSession.prepareJasper();
            reportSessionList.add(reportSession);
        }
    }

    private boolean checkSelectAllDevice() {
        if (this.synthesisReportType.equalsIgnoreCase("system") && ("0".equals(this.systemDeviceId) || "-1".equals(this.systemDeviceId)) || "-2".equals(this.systemDeviceId)) {
            return true;
        }
        return this.synthesisReportType.equalsIgnoreCase("zone") && ("0".equals(this.zoneDeviceId) || "-1".equals(this.zoneDeviceId)) || "-2".equals(this.zoneDeviceId);
    }

    private void processReportType() {
        this.formType = 2 == this.formTypeInteger ? "html" : (3 == this.formTypeInteger ? "excel" : "pdf");
    }

    private String processScheduleType(ReportCondModel queryCond) {
        int scheduleInt = this.schedule;
        if (null != this.taskScheduleForm) {
            scheduleInt = this.taskScheduleForm.getSchedule();
        }
        String scheduleType = "";
        if (1 == scheduleInt) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(AticUtil.convertTimeString((String)(this.scheduleTime + " 00:00:00")) * 1000L);
            queryCond.setStartTime(this.scheduleTime + " 00:00:00");
            queryCond.setEndTime(this.scheduleTime + " 23:59:59");
            scheduleType = "day";
        } else if (2 == scheduleInt) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(AticUtil.convertTimeString((String)(this.scheduleTime + " 00:00:00")) * 1000L);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            int dayWeek = calendar.get(7);
            if (1 == dayWeek) {
                calendar.add(5, -1);
            }
            calendar.setFirstDayOfWeek(2);
            int day = calendar.get(7);
            calendar.add(5, calendar.getFirstDayOfWeek() - day);
            String imptimeBegin = sdf.format(calendar.getTime());
            calendar.add(5, 6);
            String imptimeEnd = sdf.format(calendar.getTime());
            queryCond.setStartTime(imptimeBegin + " 00:00:00");
            queryCond.setEndTime(imptimeEnd + " 23:59:59");
            scheduleType = "week";
        } else if (3 == scheduleInt) {
            String timeStrTemp = "";
            timeStrTemp = null != this.selectYear ? this.selectYear.getSelectValue() + "-" + this.selectMonth.getSelectValue() + "-01 00:00:00" : this.selectYearValue + "-" + this.selectMonthValue + "-01 00:00:00";
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(AticUtil.convertTimeString((String)(timeStrTemp + " 00:00:00")) * 1000L);
            String startStr = "";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            calendar.set(5, 1);
            startStr = sdf.format(calendar.getTime());
            String endStr = "";
            calendar.set(5, 1);
            calendar.add(2, 1);
            calendar.add(5, -1);
            endStr = sdf.format(calendar.getTime());
            queryCond.setStartTime(startStr + " 00:00:00");
            queryCond.setEndTime(endStr + " 23:59:59");
            scheduleType = "month";
        } else if (4 == scheduleInt) {
            String startTimeStr = "";
            String endTimeStr = "";
            if (null != this.selectYear) {
                startTimeStr = this.selectYear.getSelectValue() + "-01-01 00:00:00";
                endTimeStr = this.selectYear.getSelectValue() + "-12-31 23:59:59";
            } else {
                startTimeStr = this.selectYearValue + "-01-01 00:00:00";
                endTimeStr = this.selectYearValue + "-12-31 23:59:59";
            }
            queryCond.setStartTime(startTimeStr);
            queryCond.setEndTime(endTimeStr);
            scheduleType = "year";
        }
        return scheduleType;
    }

    public void ajaxReportExportStatus() {
        ActionContext ctx = ActionContext.getContext();
        HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        String requestSessionId = request.getRequestedSessionId();
        if (!AticUtil.isNull((String)SystemReportAction.getReportExportStatus(requestSessionId))) {
            this.responseResult(SystemReportAction.getReportExportStatus(requestSessionId));
            SystemReportAction.removeReportExportStatus(requestSessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void responseResult(String string) {
        PrintWriter writer = null;
        try {
            ServletActionContext.getResponse().setCharacterEncoding("UTF-8");
            ServletActionContext.getResponse().setHeader("Pragma", "no-cache");
            ServletActionContext.getResponse().setHeader("Cache-Control", "no-store");
            ServletActionContext.getResponse().setDateHeader("Expires", 0L);
            writer = ServletActionContext.getResponse().getWriter();
            writer.write(string);
            writer.flush();
        }
        catch (Exception e) {
            this.logger.error((Object)("write response:" + string), (Throwable)e);
        }
        finally {
            if (null != writer) {
                writer.close();
            }
        }
    }

    private boolean checkSingleDev(String devId) {
        return !"-1".equals(devId) && !"-2".equals(devId) && !"0".equals(devId);
    }

    public String getDeviceList() {
        DataSourceStub dataSourceStub = new DataSourceStub();
        List<Pair<String, String>> listDevice = dataSourceStub.getDeviceListAndNFA();
        ArrayList<DeviceListForm> deviceList = new ArrayList<DeviceListForm>();
        Pair pairClean = new Pair();
        Pair allClean = new Pair();
        Pair alldetect = new Pair();
        pairClean.setKey((Object)String.valueOf(0));
        pairClean.setValue((Object)this.getText("ips.analysis.common.netdevice.all"));
        allClean.setKey((Object)String.valueOf(-1));
        allClean.setValue((Object)this.getText("ips.analysis.common.netdevice.clean.nobracket"));
        alldetect.setKey((Object)String.valueOf(-2));
        alldetect.setValue((Object)this.getText("ips.analysis.common.netdevice.detect.nobracket"));
        listDevice.add(0, (Pair<String, String>)pairClean);
        listDevice.add(1, (Pair<String, String>)allClean);
        listDevice.add(2, (Pair<String, String>)alldetect);
        for (Pair<String, String> device : listDevice) {
            String devId = (String)device.getKey();
            if (this.checkSingleDev(devId)) {
                String devModel = ReportConditionUtil.getDeviceModelByCombId(devId);
                if (devId.contains("_")) {
                    devId = devId + '_' + devModel;
                } else {
                    String devType = ReportConditionUtil.getDeviceTypeByCombId(devId);
                    devId = devId + '_' + devType + '_' + devModel;
                }
            }
            if ("-1".equals(devId)) {
                device.setValue((Object)this.getText("atic.analysis.common.netdevice.clean.nobracket"));
            }
            if ("-2".equals(devId)) {
                device.setValue((Object)this.getText("atic.analysis.common.netdevice.detect.nobracket"));
            }
            if ("0".equals(devId)) {
                device.setValue((Object)this.getText("ips.analysis.common.netdevice.all"));
            }
            DeviceListForm deviceForm = new DeviceListForm();
            if (this.synthesisReportType.equalsIgnoreCase("system")) {
                deviceForm.setSystemDeviceId(devId);
                deviceForm.setSystemDeviceName((String)device.getValue());
            } else {
                deviceForm.setZoneDeviceId(devId);
                deviceForm.setZoneDeviceName((String)device.getValue());
            }
            deviceList.add(deviceForm);
        }
        this.getOperateResult().setData(deviceList);
        return "jsonResult";
    }

    private void initDeviceList() {
        DataSourceStub dataSourceStub = new DataSourceStub();
        List<Pair<String, String>> listDevice = dataSourceStub.getDeviceListAndNFA();
        this.initDeviceList = new ArrayList<DeviceListForm>();
        if (listDevice.size() == 1) {
            String devId = (String)listDevice.get(0).getKey();
            String devModel = ReportConditionUtil.getDeviceModelByCombId(devId);
            if (devId.contains("_")) {
                devId = devId + '_' + devModel;
            } else {
                String devType = ReportConditionUtil.getDeviceTypeByCombId(devId);
                devId = devId + '_' + devType + '_' + devModel;
            }
            DeviceListForm deviceForm = new DeviceListForm();
            deviceForm.setSystemDeviceId(devId);
            deviceForm.setSystemDeviceName((String)listDevice.get(0).getValue());
            this.initDeviceList.add(deviceForm);
            this.defaultDevice = (String)listDevice.get(0).getValue();
            this.defaultDeviceId = devId;
        } else {
            Pair pairClean = new Pair();
            Pair allClean = new Pair();
            Pair alldetect = new Pair();
            pairClean.setKey((Object)String.valueOf(0));
            pairClean.setValue((Object)this.getText("ips.analysis.common.netdevice.all"));
            allClean.setKey((Object)String.valueOf(-1));
            allClean.setValue((Object)this.getText("ips.analysis.common.netdevice.clean.nobracket"));
            alldetect.setKey((Object)String.valueOf(-2));
            alldetect.setValue((Object)this.getText("ips.analysis.common.netdevice.detect.nobracket"));
            listDevice.add(0, (Pair<String, String>)pairClean);
            listDevice.add(1, (Pair<String, String>)allClean);
            listDevice.add(2, (Pair<String, String>)alldetect);
            for (Pair<String, String> device : listDevice) {
                String devId = (String)device.getKey();
                if (this.checkSingleDev(devId)) {
                    String devModel = ReportConditionUtil.getDeviceModelByCombId(devId);
                    if (devId.contains("_")) {
                        devId = devId + '_' + devModel;
                    } else {
                        String devType = ReportConditionUtil.getDeviceTypeByCombId(devId);
                        devId = devId + '_' + devType + '_' + devModel;
                    }
                }
                if ("-1".equals(devId)) {
                    device.setValue((Object)this.getText("atic.analysis.common.netdevice.clean.nobracket"));
                }
                if ("-2".equals(devId)) {
                    device.setValue((Object)this.getText("atic.analysis.common.netdevice.detect.nobracket"));
                }
                if ("0".equals(devId)) {
                    device.setValue((Object)this.getText("ips.analysis.common.netdevice.all"));
                }
                DeviceListForm deviceForm = new DeviceListForm();
                deviceForm.setSystemDeviceId(devId);
                deviceForm.setSystemDeviceName((String)device.getValue());
                this.initDeviceList.add(deviceForm);
            }
            this.defaultDevice = this.getText("ips.analysis.common.netdevice.all");
            this.defaultDeviceId = "0";
        }
    }

    public void getDeviceListByZoneId() {
        ActionContext ctx = ActionContext.getContext();
        HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        User currentUser = (User)request.getSession().getAttribute("currentUser");
        Boolean isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        ArrayList<AticDevice> fwList = new ArrayList<AticDevice>();
        if (null != this.zoneId) {
            IZoneDeviceDeployStatusService zoneDeviceDeployStatusService = (IZoneDeviceDeployStatusService)ServiceContext.getInstance().getService("zoneDeviceDeployStatusService", IZoneDeviceDeployStatusService.class);
            List lstDevId = zoneDeviceDeployStatusService.getDevByZone4Secutity(this.zoneId, isAdmin, Long.valueOf(currentUser.getUserID()));
            for (Long devId : lstDevId) {
                AticDevice firewall = firewallService.getDeviceByMoid(devId.longValue());
                if (null == firewall) continue;
                fwList.add(firewall);
            }
        }
        StringBuffer lds = new StringBuffer();
        lds.append('[');
        if (fwList.isEmpty()) {
            lds.deleteCharAt(lds.length() - 1);
            lds.append(']');
        } else {
            StringBuffer lds4DevList = new StringBuffer();
            boolean hasCleanDev = false;
            boolean hasDetectDev = false;
            for (int i = 0; i < fwList.size(); ++i) {
                AticDevice firewall = (AticDevice)fwList.get(i);
                String fireName = firewall.getName();
                String moId = String.valueOf(firewall.getMoId());
                int deviceTypeStr = ReportAnalysisUtil.getDeviceDdos(firewall);
                if (0 == deviceTypeStr) {
                    fireName = fireName + this.getText("atic.analysis.common.clean");
                    moId = moId + "_0";
                    hasCleanDev = true;
                } else if (1 == deviceTypeStr) {
                    fireName = fireName + this.getText("atic.analysis.common.detect");
                    moId = moId + "_1";
                    hasDetectDev = true;
                } else if (2 == deviceTypeStr) {
                    String fireNameClean = fireName + this.getText("atic.analysis.common.clean");
                    String moIdClean = moId + "_" + 0;
                    lds4DevList.append("['").append(moIdClean).append("','").append(fireNameClean).append("'],");
                    fireName = fireName + this.getText("atic.analysis.common.detect");
                    moId = moId + "_1";
                    hasCleanDev = true;
                    hasDetectDev = true;
                }
                lds4DevList.append("['").append(moId).append("','").append(fireName).append("'],");
            }
            lds4DevList.deleteCharAt(lds4DevList.length() - 1);
            lds4DevList.append(']');
            this.processIdsJsonStr(lds, hasCleanDev, hasDetectDev, fwList.size());
            lds.append(lds4DevList);
        }
        this.responseResult(lds.toString());
    }

    private void processIdsJsonStr(StringBuffer lds, boolean hasCleanDev, boolean hasDetectDev, int size) {
        if (hasCleanDev && hasDetectDev) {
            lds.append("['0','" + this.getText("ips.analysis.common.netdevice.all") + "'],");
            lds.append("['-1','" + this.getText("atic.analysis.common.netdevice.clean.nobracket") + "'],");
            lds.append("['-2','" + this.getText("atic.analysis.common.netdevice.detect.nobracket") + "'],");
        } else if (size > 1) {
            if (hasCleanDev && !hasDetectDev) {
                lds.append("['-1','" + this.getText("atic.analysis.common.netdevice.clean.nobracket") + "'],");
            } else if (!hasCleanDev && hasDetectDev) {
                lds.append("['-2','" + this.getText("atic.analysis.common.netdevice.detect.nobracket") + "'],");
            }
        }
    }

    public String getZoneList() {
        ArrayList<ZoneListForm> listZone = new ArrayList<ZoneListForm>();
        List lstZone = null;
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        User currentUser = (User)request.getSession().getAttribute("currentUser");
        Boolean isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
        if (this.deviceId.contains("_")) {
            String[] dev = this.deviceId.split("_");
            this.deviceId = dev[0];
        }
        if (null == (lstZone = Long.parseLong(this.deviceId) == -1L ? ReportBisUtil.getZoneService().getDeployZoneInfoByDeviceType(Long.valueOf(currentUser.getUserID()), isAdmin, 0) : (Long.parseLong(this.deviceId) == -2L ? ReportBisUtil.getZoneService().getDeployZoneInfoByDeviceType(Long.valueOf(currentUser.getUserID()), isAdmin, 1) : ReportBisUtil.getZoneService().getDeployZoneInfoByDeviceId(Long.valueOf(currentUser.getUserID()), isAdmin, Long.valueOf(Long.parseLong(this.deviceId))))) || lstZone.isEmpty()) {
            this.getOperateResult().setData(listZone);
            return "jsonResult";
        }
        for (ZoneInfoForm zoneForm : lstZone) {
            ZoneListForm tempForm = new ZoneListForm();
            tempForm.setZoneId(zoneForm.getZoneId().toString());
            tempForm.setZoneName(zoneForm.getZoneDesc());
            listZone.add(tempForm);
        }
        this.getOperateResult().setData(listZone);
        return "jsonResult";
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
        this.setUseReportType(reportType);
        if ("ips".equalsIgnoreCase(reportType)) {
            if (!"ips".equalsIgnoreCase(AnalysisConstants.getInstance().getReportType())) {
                AnalysisConstants.getInstance().setReportType("ips");
            }
        } else if (!"atic".equalsIgnoreCase(AnalysisConstants.getInstance().getReportType())) {
            AnalysisConstants.getInstance().setReportType("atic");
        }
    }

    public String showReportConfig() {
        ServiceContext context = ServiceContext.getInstance();
        IDataStatService dataStatService = (IDataStatService)context.getService("dataStatService", IDataStatService.class);
        Map<String, String> parameter = dataStatService.getReportConfig();
        this.companyName = parameter.get("companyName");
        this.companyLogoPic = !AticUtil.isNull((String)parameter.get("companyLogo")) ? "/iReport/iReportBiz/jasperTemplete/" + parameter.get("companyLogo") : "noPic";
        return "list";
    }

    private void processOpeLog(Boolean sucess, String operation, String detail, String errorInfo) {
        ISysOptLog sysOptLogMgr = ReportAnalysisUtil.getSysOptLog();
        SysOptLog sysOptLogLego = new SysOptLog();
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        sysOptLogLego.setModule("lego.dic.module.AticAnalysis");
        sysOptLogLego.setOperation(operation);
        sysOptLogLego.setTarget("".equals(this.companyName) ? "--" : this.companyName);
        if (sucess.booleanValue()) {
            sysOptLogLego.setResult(1);
            sysOptLogLego.setDetail(detail);
            String[] para = new String[]{this.companyName};
            sysOptLogLego.setDetailPara(para);
        } else {
            sysOptLogLego.setResult(0);
            sysOptLogLego.setDetail(errorInfo);
        }
        String terminalIp = "127.0.0.1";
        if (null != request) {
            terminalIp = request.getRemoteAddr();
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            sysOptLogLego.setOperator(currentUser.getUserName());
        }
        sysOptLogLego.setTerminalIp(terminalIp);
        sysOptLogMgr.writeOptLog(sysOptLogLego);
    }

    private void checkCompanyLogo() {
        int logoPicHeight;
        int logoPicSize = (int)(this.companyLogo.length() / 1024L + 1L);
        if (logoPicSize > 2048) {
            this.processOpeLog(false, "atic.report.task.ReportConfig", "", this.getText("lego.err.571918"));
            throw new LegoCheckedException(571918L);
        }
        if (!AticUtil.checkFileType((File)this.companyLogo, (String)"FFD8FF")) {
            this.processOpeLog(false, "atic.report.task.ReportConfig", "", this.getText("lego.err.571920"));
            throw new LegoCheckedException(571920L);
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.companyLogo);
        }
        catch (IOException e) {
            this.logger.error((Object)"ImageIO.read error");
        }
        if (null == image) {
            this.processOpeLog(false, "atic.report.task.ReportConfig", "", this.getText("lego.err.571920"));
            throw new LegoCheckedException(571920L);
        }
        int logoPicWidth = image.getWidth();
        if (logoPicWidth > (logoPicHeight = image.getHeight()) && logoPicWidth > 5 * logoPicHeight) {
            this.processOpeLog(false, "atic.report.task.ReportConfig", "", this.getText("lego.err.571919"));
            throw new LegoCheckedException(571919L);
        }
        if (logoPicHeight > logoPicWidth && logoPicHeight > 5 * logoPicWidth) {
            this.processOpeLog(false, "atic.report.task.ReportConfig", "", this.getText("lego.err.571919"));
            throw new LegoCheckedException(571919L);
        }
    }

    public void reportConfig() {
        this.logger.info((Object)"enter reportConfig ");
        ActionContext ctx = ActionContext.getContext();
        HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        response.setContentType("text/html");
        String importPath = request.getSession().getServletContext().getRealPath("") + File.separator + "iReport" + File.separator + "iReportBiz" + File.separator + "jasperTemplete";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("companyName", this.companyName.trim());
        String fileNameTmp = "logo_atic_carrier.jpg";
        if (null != this.companyLogo) {
            String filePath;
            try {
                this.checkCompanyLogo();
            }
            catch (LegoCheckedException e) {
                this.processOpeLog(false, "atic.report.task.ReportConfig", "atic.report.task.ReportLogoConfigDetail", this.getText("lego.err." + e.getErrorCode()));
                throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error((Object)"reportConfig ImageIO.read", (Throwable)e);
                this.processOpeLog(false, "atic.report.task.ReportConfig", "atic.report.task.ReportLogoConfigDetail", this.getText("lego.err.570507"));
                throw new LegoCheckedException(570507L, (Throwable)e);
            }
            if (!this.createFile(importPath)) {
                return;
            }
            File oldFile = new File(importPath + File.separator + "logo_atic_carrier.JPG");
            if (oldFile.exists() && !oldFile.delete()) {
                this.logger.error((Object)"delete() failed");
            }
            if (!AticUtil.saveFile((File)this.companyLogo, (String)(filePath = importPath + File.separator + fileNameTmp))) {
                return;
            }
            parameter.put("companyLogo", fileNameTmp);
        } else if (!AticUtil.isNull((String)this.companyLogoPic) && !"noPic".equalsIgnoreCase(this.companyLogoPic)) {
            parameter.put("companyLogo", fileNameTmp);
        }
        ReportAnalysisUtil.getDataStatService().saveReportConfig(parameter);
        if (null != this.companyLogo) {
            this.processOpeLog(true, "atic.report.task.ReportConfig", "atic.report.task.ReportLogoConfigDetail", "");
        } else {
            this.processOpeLog(true, "atic.report.task.ReportConfig", "atic.report.task.ReportConfigDetail", "");
        }
    }

    public boolean processPara() {
        int iLast;
        String companeNameTemp = this.companyName.trim();
        if (AticUtil.isNull((String)companeNameTemp) || companeNameTemp.length() > 64) {
            return false;
        }
        String nameRegex = "^(?!(?i)null$)[\\w|\u4e00-\u9fa5|\\-|!|@|#|$|\\^|\\.|\\+|\\}|\\{]*$";
        if (!companeNameTemp.matches(nameRegex)) {
            return false;
        }
        String compameLogoName = this.companyLogoName.trim();
        String logoType = compameLogoName.substring((iLast = compameLogoName.lastIndexOf(".")) + 1, compameLogoName.length());
        if (!"JPG".equalsIgnoreCase(logoType)) {
            this.processOpeLog(false, "atic.report.task.ReportConfig", "", this.getText("lego.err.571920"));
            return false;
        }
        return true;
    }

    public void deleteReportConfig() {
        this.logger.info((Object)"enter deleteReportConfig ");
        ReportAnalysisUtil.getDataStatService().deleteReportConfig();
        if (!AticUtil.isNull((String)this.companyLogoPic) && !"noPic".equalsIgnoreCase(this.companyLogoPic)) {
            this.processOpeLog(true, "atic.report.task.DeleteReportConfig", "atic.report.task.DeleteReportLogoConfigDetail", "");
        } else {
            this.processOpeLog(true, "atic.report.task.DeleteReportConfig", "atic.report.task.DeleteReportConfigDetail", "");
        }
    }

    private boolean createFile(String downloadPath) {
        File file = new File(downloadPath);
        if (!file.exists()) {
            return file.mkdir();
        }
        return true;
    }

    public String sendEmail4ReportFileInit() {
        String reportFileName = "";
        reportFileName = this.reportType.equalsIgnoreCase("system") ? this.getText("atic.report.task.systemReport") : this.getText("atic.report.task.zoneReport");
        this.emailTheme = this.getChangeFileName(reportFileName);
        return "list";
    }

    public void sendEmail4ReportFile() {
        this.logger.info((Object)"Begin SystemReportAction sendEmail4ReportFile function");
        ActionContext ctx = ActionContext.getContext();
        HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        try {
            this.processReportType();
            String reportFileName = "";
            String reportId4Inte = "";
            if (this.synthesisReportType.equalsIgnoreCase("system")) {
                reportFileName = this.getText("atic.report.task.systemReport");
                reportId4Inte = "systemReport";
            } else {
                reportFileName = this.getText("atic.report.task.zoneReport");
                reportId4Inte = "zoneReport";
            }
            ArrayList<ReportSession> reportSessionList = new ArrayList<ReportSession>();
            if (!this.checkSelectAllDevice()) {
                this.processSingleReport(reportSessionList, reportId4Inte, false);
            } else {
                if ("zoneReport".equals(reportId4Inte)) {
                    reportId4Inte = "zoneReportNoSupplement";
                }
                this.processAllDeviceReport(reportSessionList, reportId4Inte);
            }
            ArrayList<Long> moIDList = new ArrayList<Long>();
            if (StringUtils.isNotBlank((CharSequence)this.zoneDeviceId) && ReportConditionUtil.getLongDeviceId(this.zoneDeviceId) > 0L) {
                moIDList.add(ReportConditionUtil.getLongDeviceId(this.zoneDeviceId));
            }
            if (StringUtils.isNotBlank((CharSequence)this.systemDeviceId) && ReportConditionUtil.getLongDeviceId(this.systemDeviceId) > 0L) {
                moIDList.add(ReportConditionUtil.getLongDeviceId(this.systemDeviceId));
            }
            if (null != this.zoneId) {
                moIDList.add(ReportBisUtil.getMoidByZoneid(this.zoneId));
            }
            ReportBisUtil.checkUserSecurity(moIDList);
            ExportReport exportReport = new ExportReport(reportSessionList, request, response);
            String returnStr = this.processSendEmail(exportReport, reportFileName, request);
            this.logger.info((Object)("reportFile sendEmail resultInfo:" + SystemReportAction.getcleanedMessage(returnStr)));
            response.getWriter().write(returnStr);
        }
        catch (LegoCheckedException legoException) {
            this.writeSysLog("sendEmail4ReportFile LegoCheckedException", new String[]{this.mainAddressees});
            this.logger.error((Object)"sendEmail4ReportFile LegoCheckedException", (Throwable)legoException);
            try {
                response.getWriter().write(this.getText("lego.err." + legoException.getErrorCode()));
            }
            catch (IOException e1) {
                this.logger.error((Object)"sendEmail4ReportFile LegoCheckedException", (Throwable)e1);
            }
        }
        catch (Exception e) {
            this.writeSysLog("export and send Email failed!", new String[]{this.mainAddressees});
            this.logger.error((Object)("export and send Email failed!" + SystemReportAction.getcleanedMessage(e.toString())));
            try {
                response.getWriter().write(this.getText("lego.err.570507"));
            }
            catch (IOException e1) {
                this.logger.error((Object)"IOException", (Throwable)e1);
            }
        }
        this.logger.info((Object)"end SystemReportAction sendEmail4ReportFile function");
    }

    public boolean validateStartTime() {
        return AticUtil.isNullForVpn((String)this.startTime) || AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.startTime);
    }

    public boolean validateEndTime() {
        if (!AticUtil.isNullForVpn((String)this.endTime) && !AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.endTime)) {
            return false;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date startDate = format.parse(this.startTime.trim());
            Date endDate = format.parse(this.endTime.trim());
            if (startDate.getTime() > endDate.getTime()) {
                return false;
            }
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    private void writeSysLog(String returnStr, String[] emailAddress) {
        this.logger.info((Object)("In the writeSysLog. The returnStr is " + SystemReportAction.getcleanedMessage(returnStr)));
        ISysOptLog sysOptLogMgr = ReportAnalysisUtil.getSysOptLog();
        SysOptLog sysOptLogLego = new SysOptLog();
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        String terminalIp = "127.0.0.1";
        String operator = "";
        if (null != request) {
            terminalIp = request.getRemoteAddr();
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            operator = currentUser.getUserName();
        }
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.normal.getValue());
        sysOptLogLego.setModule("lego.dic.module.AticAnalysis");
        sysOptLogLego.setOperation("report.commom.sysLog");
        sysOptLogLego.setOperator(operator);
        sysOptLogLego.setTerminalIp(terminalIp);
        StringBuffer target = new StringBuffer();
        for (String s : emailAddress) {
            target.append(s + ";");
        }
        sysOptLogLego.setTarget(target.toString());
        if ("success".equals(returnStr)) {
            sysOptLogLego.setDetail("report.commom.sysLog.success");
            sysOptLogLego.setDetailPara(emailAddress);
            sysOptLogLego.setResult(1);
        } else {
            sysOptLogLego.setDetail("report.commom.sysLog.failure");
            sysOptLogLego.setDetailPara(emailAddress);
            sysOptLogLego.setResult(0);
        }
        sysOptLogMgr.writeOptLog(sysOptLogLego);
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private String processSendEmail(ExportReport exportReport, String reportFileName, HttpServletRequest request) {
        String[] totalAddressees = null;
        totalAddressees = !AticUtil.isNull((String)this.ccAddressee) ? new String[]{this.mainAddressees, this.ccAddressee} : new String[]{this.mainAddressees};
        String exportTypes = this.formType;
        if (!AticUtil.isNull((String)exportTypes)) {
            String[] exportTypeArray = exportTypes.split(",");
            String fileName = this.getChangeFileName(reportFileName);
            String randomPath = IReportUtil.getIReportTempImagePath() + File.separator + Math.random() + File.separator;
            String realPath = randomPath + File.separator + fileName + File.separator;
            File realPathFile = new File(realPath);
            if (!realPathFile.exists() && !realPathFile.mkdirs()) {
                this.logger.error((Object)"mkdirs() failed");
            }
            String result = null;
            int num = exportTypeArray.length;
            for (int index = 0; index < num; ++index) {
                result = exportReport.timeExport(exportTypeArray[index], realPath, fileName + this.getSuffixName(exportTypeArray[index]));
                if (null == result) continue;
                this.logger.error((Object)("export failed , the failed message is:" + SystemReportAction.getcleanedMessage(result)));
                this.writeSysLog(result, totalAddressees);
                return result;
            }
            IReportMgrUtil.exportToZipFile((String)randomPath, (String)fileName);
            String sendReturnMessage = ProductFaceUtil.getInstance().notifySendEmail(totalAddressees, this.emailTheme, this.content, randomPath + File.separator + fileName + ".zip");
            if (AticUtil.isNull((String)sendReturnMessage) || sendReturnMessage.equalsIgnoreCase("success")) {
                this.writeSysLog("success", totalAddressees);
                return "success";
            }
            this.writeSysLog(sendReturnMessage, totalAddressees);
            return sendReturnMessage;
        }
        String returnStr = "no reportType select";
        this.writeSysLog(returnStr, totalAddressees);
        return returnStr;
    }

    private String getChangeFileName(String reportFileName) {
        String fileName = reportFileName;
        String tmpTime = new SimpleDateFormat("yyyyMMdd_HH_mm_ss").format(new Date());
        fileName = fileName + "(" + tmpTime + ")";
        fileName = fileName.replaceAll("[/\\:\\-~`*?\"<>|]", "_");
        fileName = IReportMgrUtil.replaceAllBlank((String)fileName);
        return fileName;
    }

    private String getSuffixName(String fileType) {
        String suffixName = "";
        suffixName = "pdf".equalsIgnoreCase(fileType) ? ".pdf" : ("excel".equalsIgnoreCase(fileType) ? ".xls" : ("html".equalsIgnoreCase(fileType) ? ".zip" : ("csv".equalsIgnoreCase(fileType) ? ".csv" : ("rtf".equalsIgnoreCase(fileType) ? ".rtf" : ""))));
        return suffixName;
    }

    public boolean validateZoneId() {
        if (null == this.zoneId) {
            return true;
        }
        try {
            if (this.zoneId < 0L) {
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean validateZoneDeviceId() {
        if (!AticUtil.isNullForVpn((String)this.zoneDeviceId)) {
            return this.zoneDeviceId.matches("^[-0-9_]+$");
        }
        return true;
    }

    public boolean validateDeviceListFormZoneDeviceId() {
        String formZoneDeviceId;
        if (null != this.deviceListForm && !AticUtil.isNullForVpn((String)(formZoneDeviceId = this.deviceListForm.getZoneDeviceId()))) {
            return formZoneDeviceId.matches("^[-0-9_]+$");
        }
        return true;
    }

    public boolean validateCheckStatusDeviceId() {
        if (!AticUtil.isNullForVpn((String)this.checkStatusDeviceId)) {
            if (this.checkStatusDeviceId.contains("_")) {
                this.checkStatusDeviceId = this.checkStatusDeviceId.split("_")[0];
            }
            try {
                if (Long.parseLong(this.checkStatusDeviceId) < -200L) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public boolean validateDeviceName() {
        if (CommonUtil.isNull((String)this.zoneDeviceName)) {
            return true;
        }
        String name = this.zoneDeviceName.trim();
        if (name.length() > 32) {
            return false;
        }
        String nameRegex = "^[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$";
        return name.matches(nameRegex);
    }

    public boolean validateDeviceListFormDeviceName() {
        if (null != this.deviceListForm) {
            String formZoneDeviceName = this.deviceListForm.getZoneDeviceName();
            if (CommonUtil.isNull((String)formZoneDeviceName)) {
                return true;
            }
            String name = formZoneDeviceName.trim();
            if (name.contains("-")) {
                name = name.substring(0, name.indexOf("-"));
            }
            if (name.length() > 32) {
                return false;
            }
            String nameRegex = "^[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$";
            if (!formZoneDeviceName.matches(nameRegex)) {
                return false;
            }
        }
        return true;
    }

    public boolean validateReportIds() {
        if (AticUtil.isNull((String)this.synthesisReportType)) {
            return false;
        }
        if ("system".equals(this.synthesisReportType)) {
            return this.validateSystemReportIds();
        }
        if ("zone".equals(this.synthesisReportType)) {
            return this.validateZoneReportIds();
        }
        return false;
    }

    public boolean validateSystemReportIds() {
        String[] allReports = new String[]{"AttackDisCount", "FluxCompareBPS", "AttackTrend", "AbnormalOrAttackTopN", "AttackEventTopN", "FlowTopN", "ConnCompare", "IpLocationTopN"};
        ArrayList<String> allReportsList = new ArrayList<String>(Arrays.asList(allReports));
        if (AticUtil.isNull((String)this.reportIds)) {
            return false;
        }
        String[] testReports = this.reportIds.substring(0, this.reportIds.length() - 1).split(",");
        if (testReports.length == 0) {
            return false;
        }
        return allReportsList.containsAll(new ArrayList<String>(Arrays.asList(testReports)));
    }

    public boolean validateZoneReportIds() {
        String[] allReports = new String[]{"AttackDisCount", "FluxCompareBPS", "AttackTrend", "AbnormalOrAttackTopN", "AttackEventTopN", "FlowTopN", "ConnCompare", "IpLocationTopN"};
        ArrayList<String> allReportsList = new ArrayList<String>(Arrays.asList(allReports));
        if (AticUtil.isNull((String)this.reportIds)) {
            return false;
        }
        String[] testReports = this.reportIds.substring(0, this.reportIds.length() - 1).split(",");
        if (testReports.length == 0) {
            return false;
        }
        return allReportsList.containsAll(new ArrayList<String>(Arrays.asList(testReports)));
    }

    public boolean validateTopNValues() {
        String[] reportValue0 = new String[]{"AttackDisCount", "FluxCompareBPS", "AttackTrend", "ConnCompare"};
        String[] reportValue50 = new String[]{"AbnormalOrAttackTopN", "AttackEventTopN", "FlowTopN", "IpLocationTopN"};
        if (AticUtil.isNull((String)this.reportIds)) {
            return false;
        }
        String[] testReportNames = this.reportIds.substring(0, this.reportIds.length() - 1).split(",");
        if (testReportNames.length == 0) {
            return false;
        }
        if (AticUtil.isNull((String)this.topNValues)) {
            return false;
        }
        String[] testTopNValuess = this.topNValues.substring(0, this.topNValues.length() - 1).split(",");
        if (testTopNValuess.length == 0) {
            return false;
        }
        if (testReportNames.length != testTopNValuess.length) {
            return false;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < testReportNames.length; ++i) {
            try {
                map.put(testReportNames[i], Integer.valueOf(testTopNValuess[i]));
                continue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        for (String keyStr : reportValue0) {
            if (null == map.get(keyStr) || (Integer)map.get(keyStr) == 0) continue;
            return false;
        }
        for (String keyStr : reportValue50) {
            Integer testValue = (Integer)map.get(keyStr);
            if (null == testValue || testValue >= 1 && testValue <= 50) continue;
            return false;
        }
        return true;
    }

    public boolean validateParams() {
        String isScheduleRegex = "^(0|1)?$";
        if (!String.valueOf(this.isSchedule).matches(isScheduleRegex)) {
            return false;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat dateFormats = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setLenient(false);
        dateFormats.setLenient(false);
        try {
            dateFormat.parse(this.startTime);
            dateFormat.parse(this.endTime);
            dateFormats.parse(this.scheduleTime);
        }
        catch (ParseException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
        String isReportType = "^(system|zone)?$";
        if (!this.synthesisReportType.matches(isReportType)) {
            return false;
        }
        if (!AticUtil.validateSpecialStr((String)this.topNValues)) {
            return false;
        }
        if (!AticUtil.validateSpecialStr((String)this.reportIds)) {
            return false;
        }
        return AticUtil.validateSpecialStr((String)this.selectYear.getSelectValue());
    }

    public boolean validateEmailThem() {
        String regex = "^(?!(?i)null$)[\\u4e00-\\u9fa5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\u2018|\\\u2019|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\ |\\w|\\!|\\:|\\;|\\?|\\.|\\,|\\(|\\)]*$";
        if (null == this.emailTheme || "".equals(this.emailTheme.trim())) {
            return true;
        }
        return this.emailTheme.matches(regex);
    }

    public boolean validateMainAddressees() {
        String[] each;
        for (String tempeach : each = this.mainAddressees.split(";")) {
            if (tempeach.matches("^\\w+([-\\.]\\w+)*@\\w+([-\\.]\\w+)*\\.\\w+([-\\.]\\w+)*$")) continue;
            return false;
        }
        return true;
    }

    public boolean validateccAddressee() {
        String[] each;
        if (AticUtil.isNullForVpn((String)this.ccAddressee)) {
            return true;
        }
        for (String tempeach : each = this.ccAddressee.split(";")) {
            if (tempeach.matches("^\\w+([-\\.]\\w+)*@\\w+([-\\.]\\w+)*\\.\\w+([-\\.]\\w+)*$")) continue;
            return false;
        }
        return true;
    }

    public boolean checkScheduleTime() {
        SimpleDateFormat dateFormats = new SimpleDateFormat("yyyy-MM-dd");
        dateFormats.setLenient(false);
        try {
            dateFormats.parse(this.scheduleTime);
        }
        catch (ParseException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean checkDeviceId() {
        try {
            if (!AticUtil.validateSpecialStr((String)this.deviceId)) {
                return false;
            }
            if (this.deviceId.contains("_")) {
                String[] dev = this.deviceId.split("_");
                this.deviceId = dev[0];
            }
            if (Long.parseLong(this.deviceId) < -2L) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean checkLogoPic() {
        String fileNameReg = "^[\\u4e00-\\u9fa5a-zA-Z0-9\\/\\_\\-]{1,5000}\\.(?i)jpg$";
        return "noPic".equals(this.companyLogoPic) || this.companyLogoPic.matches(fileNameReg);
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getFormType() {
        return this.formType;
    }

    public void setFormType(String formType) {
        this.formType = formType;
    }

    public String getTopNValues() {
        return this.topNValues;
    }

    public void setTopNValues(String topNValues) {
        this.topNValues = topNValues;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public String getReportIds() {
        return this.reportIds;
    }

    public void setReportIds(String reportIds) {
        this.reportIds = reportIds;
    }

    public String getSynthesisReportType() {
        return this.synthesisReportType;
    }

    public void setSynthesisReportType(String synthesisReportType) {
        this.synthesisReportType = synthesisReportType;
    }

    public String getSystemDeviceName() {
        return this.systemDeviceName;
    }

    public void setSystemDeviceName(String systemDeviceName) {
        this.systemDeviceName = systemDeviceName;
    }

    public String getZoneDeviceName() {
        return this.zoneDeviceName;
    }

    public void setZoneDeviceName(String zoneDeviceName) {
        this.zoneDeviceName = zoneDeviceName;
    }

    public void setSystemDeviceId(String systemDeviceId) {
        this.systemDeviceId = systemDeviceId;
    }

    public void setZoneDeviceId(String zoneDeviceId) {
        this.zoneDeviceId = zoneDeviceId;
    }

    public String getDefaultDeviceName() {
        return this.defaultDeviceName;
    }

    public void setDefaultDeviceName(String defaultDeviceName) {
        this.defaultDeviceName = defaultDeviceName;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getCheckStatusDeviceId() {
        return this.checkStatusDeviceId;
    }

    public void setCheckStatusDeviceId(String checkStatusDeviceId) {
        this.checkStatusDeviceId = checkStatusDeviceId;
    }

    public String getSystemDeviceId() {
        return this.systemDeviceId;
    }

    public String getZoneDeviceId() {
        return this.zoneDeviceId;
    }

    public String getQueryDeviceId() {
        return this.queryDeviceId;
    }

    public void setQueryDeviceId(String queryDeviceId) {
        this.queryDeviceId = queryDeviceId;
    }

    public String getReportType() {
        return this.reportType;
    }

    public String getUseReportType() {
        return this.useReportType;
    }

    public void setUseReportType(String useReportType) {
        this.useReportType = useReportType;
    }

    public List<RadioGroupVO> getScheduleTypeList() {
        return this.scheduleTypeList;
    }

    public void setScheduleTypeList(List<RadioGroupVO> scheduleTypeList) {
        this.scheduleTypeList = scheduleTypeList;
    }

    public List<TaskScheduleForm> getTaskScheduleList() {
        return this.taskScheduleList;
    }

    public void setTaskScheduleList(List<TaskScheduleForm> taskScheduleList) {
        this.taskScheduleList = taskScheduleList;
    }

    public TaskScheduleForm getTaskScheduleForm() {
        return this.taskScheduleForm;
    }

    public void setTaskScheduleForm(TaskScheduleForm taskScheduleForm) {
        this.taskScheduleForm = taskScheduleForm;
    }

    public int getIsSchedule() {
        return this.isSchedule;
    }

    public void setIsSchedule(int isSchedule) {
        this.isSchedule = isSchedule;
    }

    public String getScheduleTime() {
        return this.scheduleTime;
    }

    public void setScheduleTime(String scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    public SelectForm getSelectMonth() {
        return this.selectMonth;
    }

    public void setSelectMonth(SelectForm selectMonth) {
        this.selectMonth = selectMonth;
    }

    public List<SelectForm> getSelectYearList() {
        return this.selectYearList;
    }

    public void setSelectYearList(List<SelectForm> selectYearList) {
        this.selectYearList = selectYearList;
    }

    public SelectForm getSelectYear() {
        return this.selectYear;
    }

    public void setSelectYear(SelectForm selectYear) {
        this.selectYear = selectYear;
    }

    public List<RadioGroupVO> getReportFileTypeList() {
        return this.reportFileTypeList;
    }

    public void setReportFileTypeList(List<RadioGroupVO> reportFileTypeList) {
        this.reportFileTypeList = reportFileTypeList;
    }

    public int getFormTypeInteger() {
        return this.formTypeInteger;
    }

    public void setFormTypeInteger(int formTypeInteger) {
        this.formTypeInteger = formTypeInteger;
    }

    public File getCompanyLogo() {
        return this.companyLogo;
    }

    public void setCompanyLogo(File companyLogo) {
        this.companyLogo = companyLogo;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getCompanyLogoPic() {
        return this.companyLogoPic;
    }

    public void setCompanyLogoPic(String companyLogoPic) {
        this.companyLogoPic = companyLogoPic;
    }

    public static String getReportExportStatus(String httpSessionId) {
        return reportExportStatus.get(httpSessionId);
    }

    public static String removeReportExportStatus(String httpSessionId) {
        return reportExportStatus.remove(httpSessionId);
    }

    public static void setReportExportStatus(String httpSessionId, String reportExportStatusStr) {
        reportExportStatus.put(httpSessionId, reportExportStatusStr);
    }

    public int getSchedule() {
        return this.schedule;
    }

    public void setSchedule(int schedule) {
        this.schedule = schedule;
    }

    public String getSelectYearValue() {
        return this.selectYearValue;
    }

    public void setSelectYearValue(String selectYearValue) {
        this.selectYearValue = selectYearValue;
    }

    public String getSelectMonthValue() {
        return this.selectMonthValue;
    }

    public void setSelectMonthValue(String selectMonthValue) {
        this.selectMonthValue = selectMonthValue;
    }

    public String getEmailTheme() {
        return this.emailTheme;
    }

    public void setEmailTheme(String emailTheme) {
        this.emailTheme = emailTheme;
    }

    public DeviceListForm getDeviceListForm() {
        return this.deviceListForm;
    }

    public void setDeviceListForm(DeviceListForm deviceListForm) {
        this.deviceListForm = deviceListForm;
    }

    public String getMainAddressees() {
        return this.mainAddressees;
    }

    public void setMainAddressees(String mainAddressees) {
        this.mainAddressees = mainAddressees;
    }

    public String getCcAddressee() {
        return this.ccAddressee;
    }

    public void setCcAddressee(String ccAddressee) {
        this.ccAddressee = ccAddressee;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getCompanyLogoName() {
        return this.companyLogoName;
    }

    public void setCompanyLogoName(String companyLogoName) {
        this.companyLogoName = companyLogoName;
    }

    public boolean validateBatchEmailTheme() {
        if (null == this.emailTheme) {
            return false;
        }
        try {
            String ms = "[/\\:\\-~`*?\"<>|]";
            if (this.emailTheme.matches(ms)) {
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean validateBatchScheduleTime() {
        if (null == this.scheduleTime) {
            return false;
        }
        try {
            if (!this.scheduleTime.matches("\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{2}:\\d{2}:\\d{2}")) {
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean validateBatchCompanyLogo() {
        if (null == this.companyLogo) {
            return false;
        }
        try {
            if (!AticUtil.checkFileType((File)this.companyLogo, (String)"FFD8FF")) {
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean validateBatchSystemDeviceId() {
        if (AticUtil.isNullForVpn((String)this.systemDeviceId)) {
            return true;
        }
        return this.systemDeviceId.matches("^[-0-9_]+$");
    }

    public String getDirectionSystem() {
        return this.directionSystem;
    }

    public void setDirectionSystem(String directionSystem) {
        this.directionSystem = directionSystem;
    }

    public String getDirectionZone() {
        return this.directionZone;
    }

    public void setDirectionZone(String directionZone) {
        this.directionZone = directionZone;
    }

    public List<DeviceListForm> getInitDeviceList() {
        return this.initDeviceList;
    }

    public void setInitDeviceList(List<DeviceListForm> initDeviceList) {
        this.initDeviceList = initDeviceList;
    }

    public String getDefaultDevice() {
        return this.defaultDevice;
    }

    public void setDefaultDevice(String defaultDevice) {
        this.defaultDevice = defaultDevice;
    }

    public String getDefaultDeviceId() {
        return this.defaultDeviceId;
    }

    public void setDefaultDeviceId(String defaultDeviceId) {
        this.defaultDeviceId = defaultDeviceId;
    }
}

