/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.report.util;

import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.report.util.SystemUtil;
import com.hs.atic.sdk.system.form.LogHoldTimeForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.security.ireport.model.vo.PageInfo;
import com.security.ireport.model.vo.ParamPage;
import com.security.ireport.model.vo.TimeTask;
import com.security.ireport.service.ResultReportService;
import com.security.ireport.service.TimeTaskService;
import com.security.ireport.service.impl.ResultReportServiceImpl;
import com.security.ireport.service.impl.TimeTaskServiceImpl;
import com.security.ireport.util.IReportMgrUtil;
import com.security.ireport.util.IReportUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ReportFileHoldManager {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private transient ResultReportService resultReportService = new ResultReportServiceImpl();
    private transient TimeTaskService timeTaskService = new TimeTaskServiceImpl();

    public void deleteReportFileData() {
        this.logger.info((Object)"start deleteReportFileData");
        LogHoldTimeForm logHoldTimeForm = SystemUtil.getLogHoldTime();
        if (null == logHoldTimeForm) {
            this.logger.error((Object)"logHoldTimeForm is null");
            this.processOpeLog(0, false, 1, "", "report.mail.subject", true);
            this.processOpeLog(0, false, 2, "", "report.mail.subject", true);
            this.processOpeLog(0, false, 3, "", "report.mail.subject", true);
            this.processOpeLog(0, false, 4, "", "report.mail.subject", true);
            return;
        }
        Long currentTime = System.currentTimeMillis() / 1000L;
        try {
            Integer dayReportTime = logHoldTimeForm.getDayReportTime();
            Long dayReportKeepTime = SystemUtil.getDataKeepTime(1, dayReportTime);
            int dayReportNum = this.resultReportService.deleteReportFile(0L, currentTime - dayReportKeepTime, 1);
            String dayTime = AticUtil.convertTimeLong((Long)(currentTime - dayReportKeepTime));
            this.logger.info((Object)("delete dayReportNum :" + dayReportNum + " the finish time before " + dayTime));
            this.processOpeLog(dayReportNum, true, 1, dayTime, "report.mail.subject", true);
        }
        catch (Exception e) {
            this.logger.error((Object)"deleteReportFileData dayReport error", (Throwable)e);
            this.processOpeLog(0, false, 1, "", "report.mail.subject", true);
        }
        try {
            Integer weekReportTime = logHoldTimeForm.getWeekReportTime();
            Long weekReportKeepTime = SystemUtil.getDataKeepTime(2, weekReportTime);
            int weekReportNum = this.resultReportService.deleteReportFile(0L, currentTime - weekReportKeepTime, 2);
            String weekTime = AticUtil.convertTimeLong((Long)(currentTime - weekReportKeepTime));
            this.logger.info((Object)("delete weekReportNum :" + weekReportNum + " the finish time before " + weekTime));
            this.processOpeLog(weekReportNum, true, 2, weekTime, "report.mail.subject", true);
        }
        catch (Exception e) {
            this.logger.error((Object)"deleteReportFileData monthReport error", (Throwable)e);
            this.processOpeLog(0, false, 2, "", "report.mail.subject", true);
        }
        try {
            Integer monthReportTime = logHoldTimeForm.getMonthReportTime();
            Long monthReportKeepTime = SystemUtil.getDataKeepTime(3, monthReportTime);
            int monthReportNum = this.resultReportService.deleteReportFile(0L, currentTime - monthReportKeepTime, 3);
            String monthTime = AticUtil.convertTimeLong((Long)(currentTime - monthReportKeepTime));
            this.logger.info((Object)("delete monthReportNum :" + monthReportNum + " the finish time before " + monthTime));
            this.processOpeLog(monthReportNum, true, 3, monthTime, "report.mail.subject", true);
        }
        catch (Exception e) {
            this.logger.error((Object)"deleteReportFileData monthReport error", (Throwable)e);
            this.processOpeLog(0, false, 3, "", "report.mail.subject", true);
        }
        try {
            Integer yearReportTime = logHoldTimeForm.getYearReportTime();
            Long yearReportKeepTime = SystemUtil.getDataKeepTime(3, yearReportTime);
            int yearReportNum = this.resultReportService.deleteReportFile(0L, currentTime - yearReportKeepTime, 4);
            String yearTime = AticUtil.convertTimeLong((Long)(currentTime - yearReportKeepTime));
            this.logger.info((Object)("delete yearReportNum :" + yearReportNum + " the finish time before " + yearTime));
            this.processOpeLog(yearReportNum, true, 4, yearTime, "report.mail.subject", true);
        }
        catch (Exception e) {
            this.logger.error((Object)"deleteReportFileData yearReport error", (Throwable)e);
            this.processOpeLog(0, false, 4, "", "report.mail.subject", true);
        }
    }

    private void processOpeLog(int num, Boolean sucess, int schedule, String time, String target, boolean targetLocal) {
        String scheduleStr = "";
        switch (schedule) {
            case 1: {
                scheduleStr = "report.operation.sysLog.timeDel.dayReport";
                break;
            }
            case 2: {
                scheduleStr = "report.operation.sysLog.timeDel.weekReport";
                break;
            }
            case 3: {
                scheduleStr = "report.operation.sysLog.timeDel.monthReport";
                break;
            }
            default: {
                scheduleStr = "report.operation.sysLog.timeDel.yearReport";
            }
        }
        ISysOptLog sysOptLogMgr = ReportAnalysisUtil.getSysOptLog();
        SysOptLog sysOptLogLego = new SysOptLog();
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        sysOptLogLego.setModule("lego.dic.module.AticAnalysis");
        sysOptLogLego.setOperation("report.operation.sysLog.timeDel.oper");
        sysOptLogLego.setOperator("system");
        sysOptLogLego.setTarget(target);
        sysOptLogLego.setTargetLocal(Boolean.valueOf(targetLocal));
        if (sucess.booleanValue()) {
            sysOptLogLego.setResult(1);
            sysOptLogLego.setDetail("report.operation.sysLog.timeDel.success");
            String[] para = new String[]{time, scheduleStr, String.valueOf(num)};
            sysOptLogLego.setDetailPara(para);
        } else {
            sysOptLogLego.setResult(0);
            sysOptLogLego.setDetail("report.operation.sysLog.timeDel.failure");
        }
        String terminalIp = "127.0.0.1";
        sysOptLogLego.setTerminalIp(terminalIp);
        sysOptLogMgr.writeOptLog(sysOptLogLego);
    }

    public void deleteNoUsedReportTaskAndFile() {
        this.logger.info((Object)"start deleteNoUsedReportTaskAndFile");
        ArrayList<String> allUsrName = new ArrayList<String>();
        IUserMgr userMgr = ReportAnalysisUtil.getUserMgr();
        List usrList = userMgr.getAllUser();
        for (User user : usrList) {
            allUsrName.add(user.getUserName());
        }
        ArrayList<Integer> needDelTaskList = new ArrayList<Integer>();
        TimeTask timeTask = new TimeTask();
        timeTask.setUserName("admin");
        timeTask.setAuthId("VSM_ATIC");
        PageInfo pageInfo = this.timeTaskService.queryTask(new ParamPage(0, Integer.MAX_VALUE), timeTask);
        List taskList = pageInfo.getResults();
        for (TimeTask timeTaskItem : taskList) {
            String usrName = timeTaskItem.getUserName();
            if (allUsrName.contains(usrName)) continue;
            needDelTaskList.add(timeTaskItem.getTaskId());
        }
        if (!needDelTaskList.isEmpty()) {
            List deleteFileNameList = this.timeTaskService.getLogPathInfo(needDelTaskList);
            this.timeTaskService.delTimeTask(needDelTaskList);
            this.resultReportService.updateResultReportByTaskId(needDelTaskList);
            this.logger.info((Object)("end deleteNoUsedReportTaskAndFile,sise: " + needDelTaskList.size()));
            IReportUtil.deleteFile((String)IReportMgrUtil.getExportPath(), (List)deleteFileNameList);
            this.logger.info((Object)("deleteFileNameList:" + deleteFileNameList));
            ISysOptLog sysOptLogMgr = ReportAnalysisUtil.getSysOptLog();
            SysOptLog sysOptLogLego = new SysOptLog();
            sysOptLogLego.setDate(new Date());
            sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
            sysOptLogLego.setModule("lego.dic.module.AticAnalysis");
            sysOptLogLego.setOperation("module.del.time.task");
            sysOptLogLego.setOperator("system");
            sysOptLogLego.setTarget("report.mail.subject");
            sysOptLogLego.setTargetLocal(Boolean.valueOf(true));
            sysOptLogLego.setResult(1);
            sysOptLogLego.setDetail("report.operation.timeDel.noUsed.success");
            String[] para = new String[]{String.valueOf(needDelTaskList.size())};
            sysOptLogLego.setDetailPara(para);
            String terminalIp = "127.0.0.1";
            sysOptLogLego.setTerminalIp(terminalIp);
            sysOptLogMgr.writeOptLog(sysOptLogLego);
        }
    }
}

