/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.restful;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.action.QueryReportRestful;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

@Path(value="/ireport")
@Produces(value={"application/json"})
public class RestIreportServiceImpl {
    protected final transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    private <T> T fromJSON(String json, TypeReference<T> type) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (JsonParseException e) {
            this.logger.error((Object)e);
        }
        catch (JsonMappingException e) {
            this.logger.error((Object)e);
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        return null;
    }

    @POST
    @Path(value="/export")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String queryReport(String json) {
        try {
            this.logger.info((Object)"queryReport restful start");
            this.logger.info((Object)("json" + json));
            Map<String, String> obj = this.fromJSON(json, new MyTypeReference());
            this.logger.info((Object)("obj" + obj));
            String localeStr = obj.get("localeStr");
            Locale locale = Locale.ENGLISH;
            if (null != localeStr && localeStr.contains("zh")) {
                locale = Locale.CHINA;
            }
            QueryReportRestful queryReportRestful = new QueryReportRestful();
            queryReportRestful.setLocale(locale);
            queryReportRestful.setHttpSessionId(obj.get("httpSessionId"));
            queryReportRestful.setReportId(obj.get("reportId"));
            queryReportRestful.setConditionStr(obj.get("condition"));
            queryReportRestful.setType(obj.get("formType"));
            queryReportRestful.setCurUserName(obj.get("userName"));
            queryReportRestful.setUserId(Long.parseLong(obj.get("userId")));
            queryReportRestful.setPath(obj.get("path"));
            queryReportRestful.setUnitText(obj.get("unitText"));
            queryReportRestful.importTurnBackTaskPage();
            queryReportRestful.queryReport();
            queryReportRestful.exportReport();
        }
        catch (LegoCheckedException e) {
            return e.getErrorCode() + "";
        }
        catch (Exception e) {
            return "error";
        }
        return "success";
    }

    private static class MyTypeReference
    extends TypeReference<Map<String, String>> {
    }
}

