/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi;

import com.hs.atic.rmi.AnalyzeSuccessRateService;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.DataStatService;
import com.hs.atic.rmi.FlowCompareService;
import com.hs.atic.rmi.NormalAndExceptService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.util.HashMap;
import java.util.Map;

public class ReportCollectorRMIProxy
implements Serializable {
    private static final long serialVersionUID = -7353997750449280835L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private Map<String, Registry> map = new HashMap<String, Registry>();

    public DataStatService getDataStatService(String collectorIpStr) {
        DataStatService dataSta = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                dataSta = (DataStatService)registry.lookup("dataStatService");
            }
            catch (Exception e) {
                this.logger.error((Object)"Get DataStatService interface object failed !", (Throwable)e);
                dataSta = null;
            }
        }
        if (dataSta != null) {
            this.logger.info((Object)("Get dataSta success:" + this.getcleanedMessage(dataSta.toString())));
        }
        return dataSta;
    }

    public FlowCompareService getFlowCompareService(String collectorIpStr) {
        FlowCompareService flowCompareService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                flowCompareService = (FlowCompareService)registry.lookup("flowCompareService");
            }
            catch (Exception e) {
                this.logger.error((Object)"Get FlowCompareService interface object failed !", (Throwable)e);
                flowCompareService = null;
            }
        }
        if (flowCompareService != null) {
            this.logger.info((Object)("Get FlowCompareService success:" + flowCompareService));
        }
        return flowCompareService;
    }

    public AnalyzeSuccessRateService getAnalyzeSuccessRateService(String collectorIpStr) {
        AnalyzeSuccessRateService analyzeSuccessRateService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                analyzeSuccessRateService = (AnalyzeSuccessRateService)registry.lookup("analyzeSuccessRateService");
            }
            catch (Exception e) {
                this.logger.error((Object)"Get AnalyzeSuccessRateService interface object failed !", (Throwable)e);
                analyzeSuccessRateService = null;
            }
        }
        if (analyzeSuccessRateService != null) {
            this.logger.info((Object)("Get AnalyzeSuccessRateService success:" + analyzeSuccessRateService));
        }
        return analyzeSuccessRateService;
    }

    public NormalAndExceptService getNormalAndExceptionService(String collectorIpStr) {
        NormalAndExceptService normalAndExceptionService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                normalAndExceptionService = (NormalAndExceptService)registry.lookup("normalAndExceptionService");
            }
            catch (Exception e) {
                this.logger.error((Object)"Get NormalAndExceptionService interface object failed !", (Throwable)e);
                normalAndExceptionService = null;
            }
        }
        if (normalAndExceptionService != null) {
            this.logger.info((Object)("Get NormalAndExceptionService success:" + normalAndExceptionService));
        }
        return normalAndExceptionService;
    }

    private Registry getCollectorRegistry(String collectorIpStr) {
        this.logger.info((Object)("collectorIpStr:" + collectorIpStr));
        if (null != this.map.get(collectorIpStr)) {
            return this.map.get(collectorIpStr);
        }
        Registry registry = null;
        try {
            ClientSocketFactory csf = new ClientSocketFactory(true);
            registry = LocateRegistry.getRegistry(collectorIpStr, 11099, (RMIClientSocketFactory)csf);
            this.map.put(collectorIpStr, registry);
        }
        catch (IllegalArgumentException e) {
            this.logger.error((Object)("collectorIpStr:" + collectorIpStr + " have exist in the map"), (Throwable)e);
            return registry;
        }
        catch (Exception e) {
            this.logger.error((Object)"Regist failed !", (Throwable)e);
            registry = null;
        }
        return registry;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }
}

