/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.sdk.zone.form.IpDomainForm;
import com.hs.atic.sdk.zone.service.IIpDomainService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.ddos.policy.action.ZoneManageAction;
import com.hs.vsm.secservice.ddos.policy.util.CSVReader;
import com.hs.vsm.secservice.ddos.policy.util.ZoneUtil;
import com.huawei.atic.util.AticInstallUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ImportAndExportIpDomainAction
extends BaseAction {
    private static final long serialVersionUID = 2212426294223304418L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private String importFilePath;
    private Long progressId;
    private List<BatchOperation> frontOperationList = new ArrayList<BatchOperation>();
    private List<LangPair> selectExportContentList;
    private List<LangPair> selectExportContentByDeviceList;
    private String selectExportContents;
    private String dimension;
    private String exportTag;
    private Long progressBarId;
    private String idStr;
    private String exportFileName;
    private String exportContentStr;

    public void exportIpDomain() {
        if (null != this.idStr) {
            String[] idStrCs;
            String idStrC = this.idStr.substring(0, this.idStr.length() - 1);
            for (String id : idStrCs = idStrC.split(",")) {
                if (AticUtil.isNum((String)id).booleanValue()) continue;
                throw new LegoCheckedException(570505L);
            }
        }
        try {
            String exportFilePath = this.initExportFile("ipdomain");
            List<IpDomainForm> ipDomainForms = this.getExportIpDomain();
            this.writeIpDomainToExportFile(ipDomainForms, exportFilePath);
            String[] args = null;
            int version = AticInstallUtil.getInstance().getAticInstallOS();
            args = 1 == version ? exportFilePath.split("/") : exportFilePath.split("\\\\");
            this.responseResult(args[args.length - 1]);
        }
        catch (Exception e) {
            logger.error((Object)"export IpDomain error : ", (Throwable)e);
            throw new LegoCheckedException(570697L, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIpDomainToExportFile(List<IpDomainForm> ipDomainForms, String exportFilePath) throws IOException {
        byte[] uft8bom = new byte[]{-17, -69, -65};
        CSVReader reader = new CSVReader(exportFilePath, "UTF-8");
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter fw = null;
        try {
            fos = new FileOutputStream(exportFilePath);
            fos.write(uft8bom);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            fw = new BufferedWriter(osw);
            List ipDomains = reader.getList();
            for (String line : ipDomains) {
                fw.write(line + System.getProperty("line.separator", "/n"));
            }
            if (null != ipDomainForms && !ipDomainForms.isEmpty()) {
                int j = ipDomainForms.size();
                for (int i = 0; i < j; ++i) {
                    IpDomainForm ipDomainForm = ipDomainForms.get(i);
                    fw.write(ipDomainForm.getDestIp() + "," + ipDomainForm.getDomain() + System.getProperty("line.separator", "/n"));
                }
            }
        }
        finally {
            if (null != fw) {
                fw.close();
            }
            if (null != osw) {
                osw.close();
            }
            if (null != fos) {
                fos.close();
            }
            reader.csvClose();
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<IpDomainForm> getExportIpDomain() {
        IIpDomainService service = ReportBisUtil.getIpDomainService();
        String path = this.getExportFilePath("ipdomain");
        String[] fileName = path.split("\\\\");
        List<IpDomainForm> ipDomainForms = null;
        if (null != this.idStr) {
            if (!"".equals(this.idStr)) {
                this.idStr = this.idStr.substring(0, this.idStr.length() - 1);
                ipDomainForms = service.getByIds(this.idStr);
            }
            this.getOperateLog().info("atic.ipdomain.title.export.select", "lego.dic.module.AticBis", fileName[fileName.length - 1], false, "atic.ip.domain.title.emport.success", null);
            logger.info((Object)("export IpDomain to memory, the export-IpDomain : " + this.getcleanedMessage(this.idStr)));
        } else {
            ipDomainForms = service.queryByPage(this.createIpDomainQueryAllMap(), 0, Integer.MAX_VALUE).getData();
            this.getOperateLog().info("atic.ipdomain.title.export.all", "lego.dic.module.AticBis", fileName[fileName.length - 1], false, "atic.ip.domain.title.emport.success", null);
            logger.info((Object)"export IpDomain to memory, the export-IpDomain : all");
        }
        return ipDomainForms;
    }

    private String initExportFile(String source) throws IOException {
        String exportFilePath = this.getExportFilePath(source);
        String templateFilePath = "";
        if ("zoneInfo".equals(source)) {
            templateFilePath = this.getSession().getServletContext().getRealPath("") + File.separator + "template" + File.separator + LocaleUtil.INSTANCE.getText("atic.user.file.template.name");
            ZoneUtil.copyFile((String)templateFilePath, (String)exportFilePath);
        } else {
            templateFilePath = this.getSession().getServletContext().getRealPath("") + File.separator + "template" + File.separator + LocaleUtil.INSTANCE.getText("atic.ipdomain.file.template.name");
            ZoneUtil.copyCsvFile((String)templateFilePath, (String)exportFilePath);
        }
        return exportFilePath;
    }

    private String getExportFilePath(String source) {
        String exportFolderPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
        boolean isCreateExportFolderSuccess = ZoneUtil.isCreateFolderSuccess((String)exportFolderPath);
        if (!isCreateExportFolderSuccess) {
            throw new LegoCheckedException(0L);
        }
        Long dateTime = System.currentTimeMillis();
        String exportFolderName = "";
        exportFolderName = source.contains("zoneInfo") ? "zoneInfo_" + dateTime + ".xls" : "ipDescription_" + dateTime + ".csv";
        return exportFolderPath + File.separator + exportFolderName;
    }

    private Map<String, String> createIpDomainQueryAllMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("destIp", null);
        queryMap.put("domain", null);
        queryMap.put("sortName", null);
        queryMap.put("sortType", null);
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (null != currentUser) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        return queryMap;
    }

    public String getImportFilePath() {
        return this.importFilePath;
    }

    public void setImportFilePath(String importFilePath) {
        this.importFilePath = importFilePath;
    }

    public Long getProgressId() {
        return this.progressId;
    }

    public void setProgressId(Long progressId) {
        this.progressId = progressId;
    }

    public List<BatchOperation> getFrontOperationList() {
        return this.frontOperationList;
    }

    public void setFrontOperationList(List<BatchOperation> frontOperationList) {
        this.frontOperationList = frontOperationList;
    }

    public List<LangPair> getSelectExportContentList() {
        return this.selectExportContentList;
    }

    public void setSelectExportContentList(List<LangPair> selectExportContentList) {
        this.selectExportContentList = selectExportContentList;
    }

    public String getSelectExportContents() {
        return this.selectExportContents;
    }

    public void setSelectExportContents(String selectExportContents) {
        this.selectExportContents = selectExportContents;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public List<LangPair> getSelectExportContentByDeviceList() {
        return this.selectExportContentByDeviceList;
    }

    public void setSelectExportContentByDeviceList(List<LangPair> selectExportContentByDeviceList) {
        this.selectExportContentByDeviceList = selectExportContentByDeviceList;
    }

    public String getExportTag() {
        return this.exportTag;
    }

    public void setExportTag(String exportTag) {
        this.exportTag = exportTag;
    }

    public Long getProgressBarId() {
        return this.progressBarId;
    }

    public void setProgressBarId(Long progressBarId) {
        this.progressBarId = progressBarId;
    }

    public String getIdStr() {
        return this.idStr;
    }

    public void setIdStr(String idStr) {
        this.idStr = idStr;
    }

    public String getExportFileName() {
        return this.exportFileName;
    }

    public void setExportFileName(String exportFileName) {
        this.exportFileName = exportFileName;
    }

    public String getExportContentStr() {
        return this.exportContentStr;
    }

    public void setExportContentStr(String exportContentStr) {
        this.exportContentStr = exportContentStr;
    }

    public boolean validateIdstr(String parameterName) {
        HttpServletRequest request = this.fetchRequest();
        String zoneIdsTemp = request.getParameter(parameterName);
        if (null == zoneIdsTemp) {
            return true;
        }
        return new ZoneManageAction().validateZoneIds(parameterName);
    }

    public boolean validateExportContentStr() {
        if (this.exportContentStr == null || "".equals(this.exportContentStr.trim()) || "null".equals(this.exportContentStr)) {
            return false;
        }
        String regex = "^[0-9A-Za-z,]{0,}$";
        return this.exportContentStr.matches(regex);
    }

    public boolean validateIdStr() {
        if (null == this.idStr) {
            return true;
        }
        String[] ids = this.idStr.split(",");
        for (int i = 0; i < ids.length; ++i) {
            try {
                long id = Long.parseLong(ids[i]);
                if (id >= 0L) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public boolean validateBatchBatchIdStr() {
        try {
            String idStrC;
            if (null != this.idStr && !AticUtil.isNum((String)(idStrC = this.idStr.substring(0, this.idStr.length() - 1))).booleanValue()) {
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean validateExportTag() {
        if (null == this.exportTag) {
            return true;
        }
        return "export".equals(this.exportTag) || "exportAll".equals(this.exportTag);
    }
}

