/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.sdk.zone.form.IpDomainForm;
import com.hs.atic.sdk.zone.service.IIpDomainService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogResultLevel;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.policy.util.CSVReader;
import com.hs.vsm.secservice.ddos.policy.util.PolicyUtil;
import com.hs.vsm.secservice.sdk.common.util.Locker;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.ServletActionContext;

public class IpDomainAction
extends BaseAction {
    public static final String SORT_NAME = "sortName";
    public static final String SORT_TYPE = "sortType";
    public static final int IP_MAX_LIST_NUM = 10000;
    public static final int IP_MAX_NUM = 1001;
    private static final long serialVersionUID = 4755021228497156861L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<IpDomainForm> ipDomainFormList;
    private IpDomainForm ipDomainForm;
    private IpDomainForm addIpDomainForm;
    private String sortType;
    private String sortField;
    private Long id;
    private Long[] ids;
    private String[] destIps;
    private String queryIp;
    private String queryDomain;
    private IIpDomainService ipDomainService;
    private String fileName;
    private String ipDomainFileName;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String listIpDomain() {
        this.ipDomainService = ReportBisUtil.getIpDomainService();
        Paging page = this.ipDomainService.queryByPage(this.createQueryMap(), this.getStart(), this.getPageSize());
        this.ipDomainFormList = page.getData();
        for (IpDomainForm form : this.ipDomainFormList) {
            form.setDestIp(IPUtil4Atic.compressIP((String)form.getDestIp()));
        }
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.setTotal(page.getCount());
        return "list";
    }

    public int getPageSize() {
        if (this.isEmpty(this.ipDomainForm)) {
            return this.pageSize;
        }
        if (null == this.fetchRequest().getParameter("pageSize")) {
            if (this.getSession().getAttribute("pageSize") == null) {
                return this.pageSize;
            }
            return (Integer)this.getSession().getAttribute("pageSize");
        }
        return this.pageSize;
    }

    private boolean isEmpty(IpDomainForm ipDomainForms) {
        if (null == ipDomainForms) {
            return true;
        }
        return ipDomainForms.getDestIp() == null && ipDomainForms.getDomain() == null && ipDomainForms.getId() == null;
    }

    public String showImportIpDomain() {
        this.logger.info((Object)"prepare to import ip domain info.");
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importIpDomain() {
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        boolean addLocker = false;
        try {
            if (Locker.getInstance().isImportIpDomainFlag()) {
                this.responseResult("571994");
                this.writeSysLog(this.ipDomainFileName, "atic.ipdomain.title.import", "atic.ip.domain.title.import.failed", null);
                return;
            }
            addLocker = true;
            Locker.getInstance().setImportIpDomainFlag(true);
            String ipDomainFileNameTemp = this.ipDomainFileName.trim();
            int iLast = ipDomainFileNameTemp.lastIndexOf(".");
            String logoType = ipDomainFileNameTemp.substring(iLast + 1, ipDomainFileNameTemp.length());
            if (!"csv".equalsIgnoreCase(logoType)) {
                this.writeSysLog(this.ipDomainFileName, "atic.ipdomain.title.import", "atic.user.import.fileType.tip.csv", null);
                this.responseResult(this.getText("atic.user.import.fileType.tip.csv"));
                return;
            }
            File csvFile = new File(this.fileName);
            if (csvFile.exists() && csvFile.length() > 0x100000L) {
                this.writeSysLog(this.ipDomainFileName, "atic.ipdomain.title.import", "atic.ip.domain.title.import.fileTooBig", null);
                this.responseResult(this.getText("atic.ip.domain.title.import.fileTooBig"));
                return;
            }
            this.ipDomainService = ReportBisUtil.getIpDomainService();
            Paging page = this.ipDomainService.queryByPage(this.createQueryMap(), this.getStart(), this.getPageSize());
            int ipListNum = page.getCount();
            CSVReader reader = new CSVReader(this.fileName);
            List ipDomains = reader.getList();
            if (null != ipDomains && !ipDomains.isEmpty()) {
                if (ipDomains.size() > 1001) {
                    this.logger.error((Object)("ipDomains.size() exceed 1000, ipDomains.size()=" + ipDomains.size()));
                    this.writeSysLog(this.ipDomainFileName, "atic.ipdomain.title.import", "atic.ip.domain.title.import.failed", null);
                    this.responseResult("571993");
                    return;
                }
                if (10001 < ipListNum + ipDomains.size()) {
                    this.logger.error((Object)("ip_list_num exceed 10000, ip_list_num=" + ipListNum + ipDomains.size()));
                    this.writeSysLog(this.ipDomainFileName, "atic.ipdomain.title.import", "atic.ip.domain.title.import.failed", null);
                    this.responseResult("571995");
                    return;
                }
                int i = 0;
                this.getOperateLog().info("atic.ipdomain.title.import", "lego.dic.module.AticBis");
                for (String line : ipDomains) {
                    if (i == 0) {
                        ++i;
                        continue;
                    }
                    BatchOperation bo = new BatchOperation();
                    if (line == null || "".equals(line)) continue;
                    bo.setOptDetail(line);
                    batchOpList.add(bo);
                }
            }
            reader.csvClose();
            this.ipDomainService = ReportBisUtil.getIpDomainService();
            this.batchOperationResult = this.ipDomainService.saveIpDomains(batchOpList);
            this.bathResult(this.batchOperationResult);
            Locker.getInstance().setImportIpDomainFlag(false);
        }
        catch (Exception e) {
            this.writeSysLog(this.ipDomainFileName, "atic.ipdomain.title.import", "atic.ip.domain.title.import.failed", null);
            Locker.getInstance().setImportIpDomainFlag(false);
            this.logger.error((Object)("get csv list error:" + e));
            this.responseResult(e.toString());
            return;
        }
        finally {
            if (addLocker) {
                Locker.getInstance().setImportIpDomainFlag(false);
            }
        }
    }

    private void writeSysLog(String target, String operation, String detail, String[] detailPara) {
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        SysOptLog oOptLog = new SysOptLog();
        oOptLog.setDate(new Date());
        oOptLog.setTarget(target);
        oOptLog.setLevel(SysoplogLevel.normal.getValue());
        oOptLog.setModule("lego.dic.module.AticBis");
        oOptLog.setOperation(operation);
        oOptLog.setDetail(detail);
        oOptLog.setDetailPara(detailPara);
        oOptLog.setResult(SysoplogResultLevel.failed.getValue());
        oOptLog.setOperator(currentUser.getUserName());
        oOptLog.setTerminalIp(currentUser.getIpAdr());
        ISysOptLog sysOpLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        if (null != sysOpLog) {
            sysOpLog.writeOptLog(oOptLog);
        }
    }

    private Map<String, String> createQueryMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (null != this.ipDomainForm) {
            if (null != this.ipDomainForm.getDestIp()) {
                queryMap.put("destIp", this.ipDomainForm.getDestIp());
            }
            if (null != this.ipDomainForm.getDomain()) {
                queryMap.put("domain", this.ipDomainForm.getDomain());
            }
        } else {
            this.ipDomainForm = new IpDomainForm();
            if (this.queryIp != null && !"".equals(this.queryIp)) {
                queryMap.put("destIp", this.queryIp);
                this.ipDomainForm.setDestIp(this.queryIp);
            }
            if (this.queryDomain != null && !"".equals(this.queryDomain)) {
                queryMap.put("domain", this.queryDomain);
                this.ipDomainForm.setDomain(this.queryDomain);
            }
        }
        queryMap.put(SORT_NAME, this.sortField);
        queryMap.put(SORT_TYPE, this.sortType);
        return queryMap;
    }

    public String addIpDomain() {
        return "add";
    }

    public boolean validateDestIp() {
        String[] ipSplit;
        String domainTemp = this.addIpDomainForm.getDomain().trim();
        if (PolicyUtil.isNull((String)domainTemp) || PolicyUtil.isNull((String)this.addIpDomainForm.getDestIp())) {
            return false;
        }
        if (null != this.addIpDomainForm.getDestIp() && null != (ipSplit = this.addIpDomainForm.getDestIp().split("\\."))[0] && "127".equals(ipSplit[0])) {
            return false;
        }
        if (!IPUtil.isIpv4((String)this.addIpDomainForm.getDestIp()) && !IPUtil.isIpv6((String)this.addIpDomainForm.getDestIp())) {
            return false;
        }
        if (domainTemp.equalsIgnoreCase("null")) {
            return false;
        }
        String locationNameRegex = "^(?!\\s*null$)(?![\\s\\S]*[\\s]+null$)(?!\\s*null\\s{1}[\\s\\S]*$)(?![\\s\\S]*[\\s]+null[\\s]+[\\s\\S]*$)[\u4e00-\u9fa5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\u2018|\\\u2019|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\ |\\w|\\!|\\:|\\;|\\?|\\.|\\,]*$";
        return domainTemp.length() <= 255 && domainTemp.matches(locationNameRegex);
    }

    public boolean validateIpdomain() {
        if (null == this.ipDomainForm) {
            return true;
        }
        String domainTemp = this.ipDomainForm.getDomain().trim();
        if (!AticUtil.isNullForVpn((String)this.ipDomainForm.getDestIp())) {
            String[] ipSplit = this.ipDomainForm.getDestIp().split("\\.");
            if (null != ipSplit[0] && "127".equals(ipSplit[0])) {
                return false;
            }
            if (!IPUtil.isIpv4((String)this.ipDomainForm.getDestIp()) && !IPUtil.isIpv6((String)this.ipDomainForm.getDestIp())) {
                return false;
            }
        }
        String locationNameRegex = "^(?!\\s*null$)(?![\\s\\S]*[\\s]+null$)(?!\\s*null\\s{1}[\\s\\S]*$)(?![\\s\\S]*[\\s]+null[\\s]+[\\s\\S]*$)[\u4e00-\u9fa5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\u2018|\\\u2019|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\ |\\w|\\!|\\:|\\;|\\?|\\.|\\,|\\-]*$";
        if (!AticUtil.isNullForVpn((String)domainTemp)) {
            if (domainTemp.equalsIgnoreCase("null")) {
                return false;
            }
            if (domainTemp.length() > 255 || !domainTemp.matches(locationNameRegex)) {
                return false;
            }
        }
        return true;
    }

    public boolean validateEditDestIp() {
        String[] ipSplit;
        String domainTemp = this.ipDomainForm.getDomain().trim();
        if (PolicyUtil.isNull((String)domainTemp) || PolicyUtil.isNull((String)this.ipDomainForm.getDestIp())) {
            return false;
        }
        if (null != this.ipDomainForm.getDestIp() && null != (ipSplit = this.ipDomainForm.getDestIp().split("\\."))[0] && "127".equals(ipSplit[0])) {
            return false;
        }
        if (!IPUtil.isIpv4((String)this.ipDomainForm.getDestIp()) && !IPUtil.isIpv6((String)this.ipDomainForm.getDestIp())) {
            return false;
        }
        if (domainTemp.equalsIgnoreCase("null")) {
            return false;
        }
        String locationNameRegex = "^(?!\\s*null$)(?![\\s\\S]*[\\s]+null$)(?!\\s*null\\s{1}[\\s\\S]*$)(?![\\s\\S]*[\\s]+null[\\s]+[\\s\\S]*$)[\u4e00-\u9fa5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\u2018|\\\u2019|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\ |\\w|\\!|\\:|\\;|\\?|\\.|\\,|\\-]*$";
        return domainTemp.length() <= 255 && domainTemp.matches(locationNameRegex);
    }

    public boolean validateDestIpS() {
        if (null != this.ids) {
            for (int i = 0; i < this.ids.length; ++i) {
                if (this.ids[i] >= 0L) continue;
                return false;
            }
        }
        if (null == this.destIps) {
            return false;
        }
        for (String dIp : this.destIps) {
            String[] ipSplit;
            if (PolicyUtil.isNull((String)dIp)) {
                return false;
            }
            if (null != dIp && null != (ipSplit = dIp.split("\\."))[0] && "127".equals(ipSplit[0])) {
                return false;
            }
            if (!IPUtil.isIpv4((String)dIp) && !IPUtil.isIpv6((String)dIp)) {
                return false;
            }
            String locationNameRegex = "^(?!\\s*(?i)null$)(?![\\s\\S]*[\\s]+(?i)null$)(?!\\s*(?i)null\\s{1}[\\s\\S]*$)(?![\\s\\S]*[\\s]+(?i)null[\\s]+[\\s\\S]*$)[\u4e00-\u9fa5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\u2018|\\\u2019|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\ |\\w|\\!|\\:|\\;|\\?|\\.|\\,|\\-]*$";
            if (dIp.length() <= 255 && dIp.matches(locationNameRegex)) continue;
            return false;
        }
        return true;
    }

    public void deployIpDomain() {
        this.ipDomainService = ReportBisUtil.getIpDomainService();
        List<IpDomainForm> forms = this.ipDomainService.findExistIp(this.addIpDomainForm.getDestIp());
        if (null != forms && !forms.isEmpty()) {
            this.responseResult(this.getText("atic.zone.ip.domain.ip.exist"));
            return;
        }
        String[] detailPara = new String[]{this.addIpDomainForm.getDestIp(), this.addIpDomainForm.getDomain()};
        Paging page = this.ipDomainService.queryByPage(this.createQueryMap(), this.getStart(), this.getPageSize());
        int ipListNum = page.getCount();
        if (ipListNum >= 10000) {
            this.logger.error((Object)("ip_list_num exceed 10000, ip_list_num=" + ipListNum));
            this.writeSysLog(this.addIpDomainForm.getDestIp(), "atic.zone.ip.domain.button.add", "atic.zone.ip.domain.oplog.add.description.failed", detailPara);
            this.responseResult("571995");
            return;
        }
        this.ipDomainService.saveIpDomain(this.addIpDomainForm);
        this.getOperateLog().normal("atic.zone.ip.domain.button.add", "lego.dic.module.AticBis", this.addIpDomainForm.getDestIp(), false, "atic.zone.ip.domain.oplog.add.description", detailPara);
        this.logger.info((Object)("add IPDomain : " + this.getcleanedMessage(this.addIpDomainForm.getDestIp()) + "," + this.getcleanedMessage(this.addIpDomainForm.getDomain()) + " successfully"));
        this.responseResult("success");
    }

    public void deleteIpDomain() {
        if (null == this.ids || null == this.destIps) {
            this.logger.error((Object)"id or destIps is null");
            throw new LegoCheckedException(570505L);
        }
        this.checkParames();
        this.getOperateLog().info("atic.zone.ip.domain.del", "lego.dic.module.AticBis");
        this.ipDomainService = ReportBisUtil.getIpDomainService();
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        for (int i = 0; i < this.ids.length; ++i) {
            BatchOperation bo = new BatchOperation();
            bo.setTargetId(this.ids[i].longValue());
            bo.setTargetName(this.destIps[i]);
            batchOpList.add(bo);
        }
        this.batchOperationResult = this.ipDomainService.batchDelIpDomain(batchOpList);
        StringBuffer names = new StringBuffer();
        for (BatchOperation bo : this.batchOperationResult.getResult()) {
            names.append(bo.getTargetName()).append(',');
        }
        this.logger.info((Object)("delete notify rule : " + this.getcleanedMessage(names.toString())));
        this.bathResult(this.batchOperationResult);
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public String showEditIpDomain() {
        this.ipDomainService = ReportBisUtil.getIpDomainService();
        this.ipDomainForm = this.ipDomainService.findById(this.id);
        if (null == this.ipDomainForm) {
            throw new LegoCheckedException(571006L);
        }
        return "edit";
    }

    public void editIpDomain() {
        this.ipDomainService = ReportBisUtil.getIpDomainService();
        List<IpDomainForm> forms = this.ipDomainService.findEditExistIp(this.ipDomainForm.getDestIp(), this.ipDomainForm.getId());
        if (null != forms && !forms.isEmpty()) {
            this.responseResult(this.getText("atic.zone.ip.domain.ip.exist"));
            return;
        }
        this.ipDomainService.editIpDomain(this.ipDomainForm);
        String[] detailPara = new String[]{this.ipDomainForm.getDestIp(), this.ipDomainForm.getDomain()};
        this.getOperateLog().normal("atic.zone.ip.domain.button.edit", "lego.dic.module.AticBis", this.ipDomainForm.getDestIp(), false, "atic.zone.ip.domain.oplog.edit.description", detailPara);
        this.logger.info((Object)("edit ipDomain : " + this.getcleanedMessage(this.ipDomainForm.getDestIp()) + "," + this.getcleanedMessage(this.ipDomainForm.getDomain()) + " successfully"));
        this.responseResult("success");
    }

    public void checkParames() {
        int i;
        for (i = 0; i < this.ids.length; ++i) {
            if (this.ids[i] >= 0L) continue;
            throw new LegoCheckedException(570505L);
        }
        for (i = 0; i < this.destIps.length; ++i) {
            if (IPUtil.isIpv4((String)this.destIps[i]) || IPUtil.isIpv6((String)this.destIps[i])) continue;
            throw new LegoCheckedException(570505L);
        }
    }

    public List<IpDomainForm> getIpDomainFormList() {
        return this.ipDomainFormList;
    }

    public void setIpDomainFormList(List<IpDomainForm> ipDomainFormList) {
        this.ipDomainFormList = ipDomainFormList;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public IpDomainForm getIpDomainForm() {
        return this.ipDomainForm;
    }

    public void setIpDomainForm(IpDomainForm ipDomainForm) {
        this.ipDomainForm = ipDomainForm;
    }

    public IpDomainForm getAddIpDomainForm() {
        return this.addIpDomainForm;
    }

    public void setAddIpDomainForm(IpDomainForm addIpDomainForm) {
        this.addIpDomainForm = addIpDomainForm;
    }

    public Long[] getIds() {
        if (null != this.ids) {
            return (Long[])this.ids.clone();
        }
        return new Long[0];
    }

    public void setIds(Long[] ids) {
        this.ids = null != ids ? (Long[])ids.clone() : null;
    }

    public String[] getDestIps() {
        if (null != this.destIps) {
            return (String[])this.destIps.clone();
        }
        return new String[0];
    }

    public void setDestIps(String[] destIps) {
        this.destIps = null != destIps ? (String[])destIps.clone() : null;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getQueryIp() {
        return this.queryIp;
    }

    public void setQueryIp(String queryIp) {
        this.queryIp = queryIp;
    }

    public String getQueryDomain() {
        return this.queryDomain;
    }

    public void setQueryDomain(String queryDomain) {
        this.queryDomain = queryDomain;
    }

    public String getIpDomainFileName() {
        return this.ipDomainFileName;
    }

    public void setIpDomainFileName(String ipDomainFileName) {
        this.ipDomainFileName = ipDomainFileName;
    }

    public boolean validateBatchBatchQueryIp() {
        if (null == this.queryIp || this.queryIp.trim().length() == 0) {
            return true;
        }
        try {
            if (this.queryIp.length() > 39 || !IPUtil.isIpv6((String)this.queryIp)) {
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean validateBatchBatchQueryDomain() {
        if (null == this.queryDomain || this.queryDomain.trim().length() == 0) {
            return true;
        }
        try {
            if (this.queryDomain.length() > 256) {
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean validateBatchBatchIpDomainFileName() {
        if (null == this.ipDomainFileName) {
            return false;
        }
        try {
            int iLast = this.ipDomainFileName.lastIndexOf(".");
            String logoType = this.ipDomainFileName.substring(iLast + 1, this.ipDomainFileName.length());
            if (!"csv".equalsIgnoreCase(logoType)) {
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }
}

