/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.guard;

import com.hs.atic.collector.guard.LogManager;
import com.hs.atic.collector.guard.MemoryDetector;
import com.hs.lego.core.sdk.base.dataprotect.util.AticDataProtector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Guard
implements Runnable {
    private static final String PROPERTY_FILENAME = "conf" + File.separator + "guard.conf";
    private static final String NEXT_LINE = System.getProperty("line.separator");
    private static Logger logger = LogManager.getInstance().getGuardLog();
    private List<String> commands = new ArrayList<String>();
    private double memoryRatio;
    private String ip;
    private int port;
    private int connectLimit;
    private int outOfMemoryLimit;
    private int sleepTime;
    private MemoryDetector detector;
    private int connectFailCount;
    private int outOfMemoryFailCount;

    public Guard() throws IOException {
        this.initFromProperties();
        this.detector = new MemoryDetector(this.ip, this.port, this.memoryRatio);
    }

    public static void main(String[] args) throws IOException {
        Guard guard = new Guard();
        Thread thread = new Thread(guard);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFromProperties() throws IOException {
        FileInputStream inputStream = null;
        Properties properties = new Properties();
        try {
            inputStream = new FileInputStream(PROPERTY_FILENAME);
            properties.load(inputStream);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("FileNotFoundException:" + e));
        }
        catch (RuntimeException e) {
            logger.error((Object)("RuntimeException:" + e));
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
        }
        this.memoryRatio = Double.parseDouble(properties.getProperty("MemoryRatio"));
        this.connectLimit = Integer.parseInt(properties.getProperty("ConnectLimit"));
        this.outOfMemoryLimit = Integer.parseInt(properties.getProperty("OutOfMemoryLimit"));
        this.sleepTime = Integer.parseInt(properties.getProperty("SleepTime"));
        this.ip = System.getProperty("java.rmi.server.hostname");
        this.port = Integer.parseInt(properties.getProperty("Port"));
        String commandString = properties.getProperty("Commands");
        for (String command : commandString.split(";")) {
            this.commands.add(command);
        }
        Properties certInfoPro = this.loadCollectorCertInfoProperties();
        System.setProperty("javax.net.ssl.keyStore", System.getProperty("user.dir") + "\\cert\\collector_keystore");
        StringBuffer keystorePwd = AticDataProtector.sdpDecryptInitData(certInfoPro.getProperty("keystore.collector.password"));
        if (null != keystorePwd) {
            System.setProperty("javax.net.ssl.keyStorePassword", keystorePwd.toString());
        } else {
            logger.error((Object)"decrypt init data error: keystore.collector.password");
        }
        System.setProperty("javax.net.ssl.trustStore", System.getProperty("user.dir") + "\\cert\\collector_truststore");
        StringBuffer truststorePwd = AticDataProtector.sdpDecryptInitData(certInfoPro.getProperty("truststore.collector.password"));
        if (null != truststorePwd) {
            System.setProperty("javax.net.ssl.trustStorePassword", truststorePwd.toString());
        } else {
            logger.error((Object)"decrypt init data error: truststore.collector.password");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadCollectorCertInfoProperties() {
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            String path = System.getProperty("user.dir") + "/cert/collectorCertInfo.properties";
            inputStream = new FileInputStream(path);
            properties.load(inputStream);
        }
        catch (IOException e) {
            logger.error((Object)"load collector cert info error", (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error((Object)"load collector cert info error", (Throwable)e);
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)"close inputStream error", (Throwable)e);
                }
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugProcessInSystem() {
        BufferedReader reader = null;
        try {
            String line;
            Process process = Runtime.getRuntime().exec("tasklist");
            reader = new BufferedReader(new InputStreamReader(process.getInputStream(), System.getProperty("file.encoding")));
            StringBuffer buffer = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append(NEXT_LINE);
            }
            logger.info((Object)("debugProcessInSystem :" + buffer.toString()));
        }
        catch (IOException e) {
            logger.error((Object)"IOException error ", (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error((Object)"debugProcessInSystem error ", (Throwable)e);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error((Object)"debugProcessInSystem IOException error ", (Throwable)e);
                }
            }
        }
    }

    private void detect() {
        try {
            if (this.detector.isConnected()) {
                if (this.detector.isOutOfMemory()) {
                    ++this.outOfMemoryFailCount;
                    logger.warn((Object)("collector is out of memory. fail count is: " + this.outOfMemoryFailCount));
                    if (this.outOfMemoryFailCount == this.outOfMemoryLimit / 2) {
                        logger.warn((Object)("outOfMemoryFailCount to " + this.outOfMemoryLimit / 2));
                    }
                } else {
                    this.outOfMemoryFailCount = 0;
                    logger.warn((Object)"reset outOfMemoryFailCount to 0");
                }
                this.connectFailCount = 0;
            } else {
                ++this.connectFailCount;
                logger.error((Object)("connectFailCount is: " + this.connectFailCount));
            }
        }
        catch (Exception e) {
            logger.error((Object)"connect fail: ", (Throwable)e);
            ++this.connectFailCount;
            logger.error((Object)("connectFailCount is: " + this.connectFailCount));
        }
    }

    public int getFailedLimit() {
        return this.connectLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart() {
        this.debugProcessInSystem();
        this.connectFailCount = 0;
        this.outOfMemoryFailCount = 0;
        for (String command : this.commands) {
            BufferedReader reader = null;
            try {
                String line;
                logger.info((Object)("now run command:" + command));
                Process p = Runtime.getRuntime().exec(command);
                reader = new BufferedReader(new InputStreamReader(p.getInputStream(), System.getProperty("file.encoding")));
                while ((line = reader.readLine()) != null) {
                    logger.debug((Object)line);
                }
                logger.info((Object)"command execute over.");
            }
            catch (IOException e) {
                logger.error((Object)"IOException ", (Throwable)e);
            }
            catch (RuntimeException e) {
                logger.error((Object)"RuntimeException ", (Throwable)e);
            }
            finally {
                if (null == reader) continue;
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error((Object)("IOException:" + e));
                }
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            this.detect();
            if (this.shouldRestart()) {
                logger.info((Object)"begin to restatr collector.");
                this.restart();
            }
            try {
                Thread.sleep(this.sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                logger.error((Object)"run InterruptedException error ", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void setFailedLimit(int failedLimit) {
        this.connectLimit = failedLimit;
    }

    private boolean shouldRestart() {
        if (this.connectFailCount > this.connectLimit || this.outOfMemoryFailCount > this.outOfMemoryLimit) {
            logger.info((Object)("ConnectFailCount: " + this.connectFailCount));
            logger.info((Object)("OutOfMemoryCount: " + this.outOfMemoryFailCount));
            return true;
        }
        return false;
    }

    public static void stop(String[] args) {
        logger.info((Object)"Collector guard service shutdown.");
        Guard.systemExit();
    }

    private static void systemExit() {
        System.exit(0);
    }
}

