/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.guard;

import com.hs.atic.collector.guard.LogManager;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.GuardCollectorStatus;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.apache.log4j.Logger;

public class MemoryDetector {
    private Logger logger = LogManager.getInstance().getGuardLog();
    private String ip;
    private int port;
    private double ratio;

    public MemoryDetector(String ip, int port, double ratio) {
        this.ip = ip;
        this.port = port;
        this.ratio = ratio;
        this.logger.info((Object)("init MemoryDetector. ip: " + ip + " port: " + port + " ratio: " + ratio));
    }

    public boolean isOutOfMemory() {
        boolean isOutOfMemory = false;
        try {
            GuardCollectorStatus guardCollectorStatus = this.getGuardCollectorStatus();
            if (null == guardCollectorStatus) {
                this.logger.error((Object)"can not connect collector error ");
                return true;
            }
            String userdStr = guardCollectorStatus.getUsedJVMMemory();
            String maxStr = guardCollectorStatus.getMaxJVMMemory();
            Long used = Long.parseLong(userdStr.substring(0, userdStr.length() - 1));
            Long max = Long.parseLong(maxStr.substring(0, maxStr.length() - 1));
            this.logger.info((Object)("memory used: " + userdStr + ", memory max: " + maxStr));
            if ((double)used.longValue() / (double)max.longValue() > this.ratio) {
                isOutOfMemory = true;
                this.logger.info((Object)("now ratio is : " + (double)used.longValue() / (double)max.longValue()));
                this.logger.info((Object)("init ratio is : " + this.ratio));
            }
        }
        catch (Exception e) {
            isOutOfMemory = true;
            this.logger.error((Object)"isOutOfMemory unknow error : ", (Throwable)e);
        }
        return isOutOfMemory;
    }

    public boolean isConnected() {
        boolean isConnected = true;
        GuardCollectorStatus guardCollectorStatus = this.getGuardCollectorStatus();
        if (null == guardCollectorStatus) {
            this.logger.error((Object)"can not connect collector error ");
            return false;
        }
        return isConnected;
    }

    private GuardCollectorStatus getGuardCollectorStatus() {
        GuardCollectorStatus guardCollectorStatus = null;
        Registry registry = this.getCollectorRegistry(this.ip);
        if (null != registry) {
            try {
                guardCollectorStatus = (GuardCollectorStatus)registry.lookup("guardCollectorStatus");
            }
            catch (Exception e) {
                this.logger.error((Object)"Get GuardCollectorStatus interface object failed !", (Throwable)e);
                guardCollectorStatus = null;
            }
        }
        if (guardCollectorStatus != null) {
            this.logger.info((Object)("Get GuardCollectorStatus success, ip: " + this.ip + ", port:" + this.port));
        }
        return guardCollectorStatus;
    }

    private Registry getCollectorRegistry(String collectorIpStr) {
        Registry registry = null;
        try {
            ClientSocketFactory csf = new ClientSocketFactory(true);
            registry = LocateRegistry.getRegistry(collectorIpStr, this.port, csf);
        }
        catch (Exception e) {
            this.logger.error((Object)("collectorIpStr:" + collectorIpStr + ", Regist failed !"), (Throwable)e);
            registry = null;
        }
        return registry;
    }
}

