/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.base.dataprotect;

import com.hs.atic.collector.guard.LogManager;
import com.hs.lego.core.sdk.base.dataprotect.KmcFiles;
import com.hs.lego.core.sdk.base.dataprotect.KmcManager;
import com.hs.lego.core.sdk.base.dataprotect.util.StringConverter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.log4j.Logger;

public class DataProtector {
    public static final String CHARSETNAME = "UTF-8";
    private static final Logger LOGGER = LogManager.getInstance().getGuardLog();
    private static final long SUCCESS = 0L;
    private static final int MIN_CIPHER_BUFF_LEN = 144;
    private static Object lock = new Object();
    private KmcManager kmc = null;

    public DataProtector(String libFolderPath, KmcFiles kmcFileNames) {
        KmcManager.loadKmcLib(libFolderPath);
        this.kmc = new KmcManager(kmcFileNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sdpEncrypt(long domainId, StringBuffer pucPlainText) {
        if (null == pucPlainText) {
            pucPlainText = new StringBuffer();
        }
        String pucCipherText = null;
        try {
            byte[] pucPlainBytes = pucPlainText.toString().getBytes(CHARSETNAME);
            long pulCipherLen = 0L;
            Object object = lock;
            synchronized (object) {
                this.kmc.doBeforeUse();
                pulCipherLen = this.kmc.sdpGetCipherDataLen(pucPlainBytes.length);
            }
            if (pulCipherLen <= 0L) {
                LOGGER.error((Object)"KMC sdpGetCipherDataLen error");
                return null;
            }
            byte[] pucCipherBytes = new byte[(int)pulCipherLen];
            Object object2 = lock;
            synchronized (object2) {
                this.kmc.doBeforeUse();
                pulCipherLen = this.kmc.sdpEncrypt(domainId, pucPlainBytes, pucPlainBytes.length, pucCipherBytes, pulCipherLen);
            }
            if (pulCipherLen <= 0L) {
                LOGGER.error((Object)"KMC sdpEncrypt error ");
                return null;
            }
            ByteBuffer buffer = ByteBuffer.wrap(pucCipherBytes);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            byte[] result = new byte[(int)pulCipherLen];
            buffer.get(result, 0, result.length);
            pucCipherText = StringConverter.getInstanse().parseByte2HexStr(result);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"sdpEncrypt UnsupportedEncodingException", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)"sdpEncrypt Exception", (Throwable)e);
        }
        return pucCipherText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer sdpDecrypt(long domainId, String pucCipherText) {
        StringBuffer pucPlain = null;
        if (null == pucCipherText || pucCipherText.isEmpty()) {
            LOGGER.error((Object)"KMC sdpDecrypt input error,pucCipherText is null or empty");
            return null;
        }
        try {
            byte[] pucCipherBytes = StringConverter.getInstanse().parseHexStr2Byte(pucCipherText);
            Integer pulPTLen = Math.max(pucCipherBytes.length * 2, 144);
            byte[] pucPlainByte = new byte[pulPTLen.intValue()];
            long errorCode = 0L;
            Object object = lock;
            synchronized (object) {
                this.kmc.doBeforeUse();
                errorCode = this.kmc.sdpDecrypt(domainId, pucCipherBytes, pucCipherBytes.length, pucPlainByte, pulPTLen);
            }
            if (0L != errorCode) {
                LOGGER.error((Object)("KMC sdpDecrypt error,errorCode=" + errorCode));
                return null;
            }
            ByteBuffer buffer = ByteBuffer.wrap(pucPlainByte);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            byte[] result = new byte[pulPTLen.intValue()];
            buffer.get(result, 0, result.length);
            pucPlain = new StringBuffer(new String(result, CHARSETNAME));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"sdpDecrypt UnsupportedEncodingException", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)"sdpDecrypt Exception", (Throwable)e);
        }
        return pucPlain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sdpProtectPwd(StringBuffer pucPlainText) {
        if (null == pucPlainText) {
            pucPlainText = new StringBuffer();
        }
        String pucCipherText = null;
        try {
            byte[] pucPlainBytes = pucPlainText.toString().getBytes(CHARSETNAME);
            long pulCipherLen = 0L;
            Object object = lock;
            synchronized (object) {
                this.kmc.doBeforeUse();
                pulCipherLen = this.kmc.sdpGetPwdCipherLen(pucPlainBytes.length);
            }
            if (pulCipherLen <= 0L) {
                LOGGER.error((Object)"KMC sdpGetPwdCipherLen error ");
                return null;
            }
            byte[] pulCipherBytes = new byte[(int)pulCipherLen];
            long errorCode = 0L;
            Object object2 = lock;
            synchronized (object2) {
                this.kmc.doBeforeUse();
                errorCode = this.kmc.sdpProtectPwd(pucPlainBytes, pucPlainBytes.length, pulCipherBytes, pulCipherLen);
            }
            if (0L != errorCode) {
                LOGGER.error((Object)("KMC sdpProtectPwd error ,errorCode=" + errorCode));
                return null;
            }
            pucCipherText = StringConverter.getInstanse().parseByte2HexStr(pulCipherBytes);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"sdpProtectPwd UnsupportedEncodingException", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)"sdpProtectPwd Exception", (Throwable)e);
        }
        return pucCipherText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sdpVerifyPwd(String pucPlainText, String pucCipherText) {
        boolean result = false;
        if (null == pucPlainText) {
            pucPlainText = "";
        }
        if (null == pucCipherText || pucCipherText.isEmpty()) {
            LOGGER.error((Object)"KMC sdpVerifyPwd input error,pucCipherText is null or empty");
            return false;
        }
        try {
            byte[] pucPlainByte = pucPlainText.getBytes(CHARSETNAME);
            byte[] pucCipherBytes = StringConverter.getInstanse().parseHexStr2Byte(pucCipherText);
            long errorCode = 0L;
            Object object = lock;
            synchronized (object) {
                this.kmc.doBeforeUse();
                errorCode = this.kmc.sdpVerifyPwd(pucPlainByte, pucPlainByte.length, pucCipherBytes, pucCipherBytes.length);
            }
            if (0L == errorCode) {
                result = true;
            } else {
                LOGGER.error((Object)("KMC sdpVerifyPwd error ,errorCode=" + errorCode));
                result = false;
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"sdpVerifyPwd UnsupportedEncodingException", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)"sdpVerifyPwd Exception", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sdpHmac(StringBuffer pucPlainText) {
        if (null == pucPlainText) {
            pucPlainText = new StringBuffer();
        }
        String pucCipherText = null;
        try {
            byte[] pucPlainByte = pucPlainText.toString().getBytes(CHARSETNAME);
            byte[] pucCipherBytes = null;
            Object object = lock;
            synchronized (object) {
                pucCipherBytes = this.kmc.sdpHmac(pucPlainByte);
            }
            pucCipherText = StringConverter.getInstanse().parseByte2HexStr(pucCipherBytes);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"sdpDecrypt UnsupportedEncodingException", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOGGER.error((Object)"sdpDecrypt Exception", (Throwable)e);
            return null;
        }
        return pucCipherText;
    }
}

