/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.base.dataprotect;

import com.hs.atic.collector.guard.LogManager;
import com.hs.lego.core.sdk.base.dataprotect.KmcFiles;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;

public class KmcManager {
    private static final Logger LOGGER = LogManager.getInstance().getGuardLog();
    private static KmcFiles currKmcFiles = null;
    private KmcFiles kmcFileNames = null;

    public KmcManager(KmcFiles kmcFileNames) {
        this.kmcFileNames = kmcFileNames;
    }

    public static void loadKmcLib(String libFolderPath) {
        try {
            LOGGER.info((Object)"begin load library ...,path");
            LOGGER.info((Object)"currect java system java.library.path is ---->");
            String osName = System.getProperty("os.name");
            if (osName.equals("SunOS") || osName.equals("AIX") || osName.equals("Linux")) {
                LOGGER.info((Object)"load library libsecurec.so");
                System.load(libFolderPath + "/libsecurec.so");
                LOGGER.info((Object)"load library libcrypto.so.1.0.0");
                System.load(libFolderPath + "/libcrypto.so.1.0.0");
                LOGGER.info((Object)"load library libssl.so");
                System.load(libFolderPath + "/libssl.so");
                LOGGER.info((Object)"load library libKMC.so");
                System.load(libFolderPath + "/libKMC.so");
                LOGGER.info((Object)"load library libSDP.so");
                System.load(libFolderPath + "/libSDP.so");
                LOGGER.info((Object)"load library end");
            } else {
                LOGGER.info((Object)"load library libeay32.dll");
                System.load(libFolderPath + "/libeay32.dll");
                LOGGER.info((Object)"load library libSDP4j.dll");
                System.load(libFolderPath + "/libSDP4j.dll");
                LOGGER.info((Object)"load library end");
            }
        }
        catch (UnsatisfiedLinkError ule) {
            LOGGER.error((Object)("UnsatisfiedLinkError,Can not find the shared library for kmc:" + ule));
            Runtime.getRuntime().exit(0);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception when loading kmc:" + e));
            Runtime.getRuntime().exit(0);
        }
    }

    public void doBeforeUse() {
        if (this.kmcFileNames != null && !this.kmcFileNames.equals(currKmcFiles)) {
            this.reload();
        }
    }

    private void init() {
        long errorCode = this.wsecInitialize(this.kmcFileNames.getKeyStoreFile(), this.kmcFileNames.getKeyStoreBakFile(), this.kmcFileNames.getKmcCfgFile(), this.kmcFileNames.getKmcCfgBakFile(), this.kmcFileNames.getLogConfigFile());
        if (errorCode > 0L) {
            LOGGER.error((Object)("wsecInitialize errorCode=" + errorCode));
        }
        currKmcFiles = this.kmcFileNames;
    }

    private void reload() {
        if (null != currKmcFiles) {
            this.wsecFinalize();
        }
        this.init();
    }

    public native long wsecInitialize(String var1, String var2, String var3, String var4, String var5);

    public native long wsecFinalize();

    public native long sdpGetCipherDataLen(long var1);

    public native long sdpEncrypt(long var1, byte[] var3, long var4, byte[] var6, long var7);

    public native long sdpDecrypt(long var1, byte[] var3, long var4, byte[] var6, Integer var7);

    public native long sdpGetPwdCipherLen(long var1);

    public native long sdpProtectPwd(byte[] var1, long var2, byte[] var4, long var5);

    public native long sdpVerifyPwd(byte[] var1, long var2, byte[] var4, long var5);

    public byte[] sdpHmac(byte[] pucPlainText) {
        MessageDigest md = null;
        String encName = "SHA-256";
        try {
            md = MessageDigest.getInstance(encName);
            md.update(pucPlainText);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)"sdpHmac NoSuchAlgorithmException", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)"sdpHmac Exception", (Throwable)e);
        }
        return new byte[0];
    }
}

