/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz;

import com.hs.atic.collector.biz.Buffer;
import com.hs.atic.collector.biz.Consumer;
import com.hs.atic.collector.biz.SortBuffer;
import com.hs.atic.collector.biz.event.nfa.NfaEventConsumer;
import com.hs.atic.collector.biz.event.nfa.NfaPacketParser;
import com.hs.atic.collector.biz.event.process.Alarm70secFlowHandler;
import com.hs.atic.collector.biz.event.process.AllCpu5minSumHandler;
import com.hs.atic.collector.biz.event.process.AllCpuCycleSumHandler;
import com.hs.atic.collector.biz.event.process.AllCpuMinSumHandler;
import com.hs.atic.collector.biz.event.process.AttackTypeEventHandler;
import com.hs.atic.collector.biz.event.process.BaselineFlowSumHandler;
import com.hs.atic.collector.biz.event.process.BaselineRepositoryHandlerThread;
import com.hs.atic.collector.biz.event.process.BizAttackLifeHandler;
import com.hs.atic.collector.biz.event.process.BizEventConsumer;
import com.hs.atic.collector.biz.event.process.DashboardEventHandler;
import com.hs.atic.collector.biz.event.process.DnsDefendConsumer;
import com.hs.atic.collector.biz.event.process.DnsDefendEventHandler;
import com.hs.atic.collector.biz.event.process.DnsDefendEventHourHandler;
import com.hs.atic.collector.biz.event.process.DnsEventConsumer;
import com.hs.atic.collector.biz.event.process.DnsEventHandler;
import com.hs.atic.collector.biz.event.process.EventPacketParser;
import com.hs.atic.collector.biz.event.process.ExceptionAndBlackIpSortConsumer;
import com.hs.atic.collector.biz.event.process.ExceptionEventConsumer;
import com.hs.atic.collector.biz.event.process.ExceptionEventHandler;
import com.hs.atic.collector.biz.event.process.ExceptionEventRepositoryThread;
import com.hs.atic.collector.biz.event.process.ExceptionEventSumRepositoryThread;
import com.hs.atic.collector.biz.event.process.ExceptionLifeHandler;
import com.hs.atic.collector.biz.event.process.FlowEventConsumer;
import com.hs.atic.collector.biz.event.process.FlowEventHandler;
import com.hs.atic.collector.biz.event.process.GeneratePacketsKey;
import com.hs.atic.collector.biz.event.process.HourAverAllFlowHandler;
import com.hs.atic.collector.biz.event.process.HourAverageBizIpFlowHandler;
import com.hs.atic.collector.biz.event.process.HourAverageBizZoneFlowHandler;
import com.hs.atic.collector.biz.event.process.HourDnsEventHandler;
import com.hs.atic.collector.biz.event.process.HourDnsTypeEventIpHandler;
import com.hs.atic.collector.biz.event.process.HourDnsTypeEventZoneHandler;
import com.hs.atic.collector.biz.event.process.HourMaxAllFlowHandler;
import com.hs.atic.collector.biz.event.process.HourMaxBizIpFlowHandler;
import com.hs.atic.collector.biz.event.process.HourMaxBizZoneFlowHandler;
import com.hs.atic.collector.biz.event.process.IpAttackLifeHandler;
import com.hs.atic.collector.biz.event.process.IpAttackTypeHandler;
import com.hs.atic.collector.biz.event.process.IpAttackTypeOriginalHandler;
import com.hs.atic.collector.biz.event.process.IpAverageEventHandler;
import com.hs.atic.collector.biz.event.process.IpLocation5minSumHandler;
import com.hs.atic.collector.biz.event.process.IpStateHandler;
import com.hs.atic.collector.biz.event.process.NotifyZoneHandler;
import com.hs.atic.collector.biz.event.process.PacketsDispatchConsumer;
import com.hs.atic.collector.biz.event.process.ParseConsumer;
import com.hs.atic.collector.biz.event.process.SecondFLowHandler;
import com.hs.atic.collector.biz.event.process.SecondFlowConsumer;
import com.hs.atic.collector.biz.event.process.ServiceLearningEvnetHanlder;
import com.hs.atic.collector.biz.event.process.ServiceLearningRepositoryThread;
import com.hs.atic.collector.biz.event.process.SumAllFlowHandler;
import com.hs.atic.collector.biz.event.process.SumIpFlowHandler;
import com.hs.atic.collector.biz.event.process.SumMinFlowHandler;
import com.hs.atic.collector.biz.event.process.SumZoneFlowHandler;
import com.hs.atic.collector.biz.event.process.SysLogHandler;
import com.hs.atic.collector.biz.event.process.TimeDatagramPacket;
import com.hs.atic.collector.biz.event.process.ZoneAttackLifeHandler;
import com.hs.atic.collector.biz.event.process.ZoneAttackTypeHandler;
import com.hs.atic.collector.biz.event.process.ZoneAttackTypeOriginalHandler;
import com.hs.atic.collector.biz.event.process.ZoneBlackListEventHandler;
import com.hs.atic.collector.biz.event.process.ZoneBlacklistHistoryRepositoryThread;
import com.hs.atic.collector.biz.event.process.ZoneFlowEventHandler;
import com.hs.atic.collector.biz.event.protal.ProtalAttackMinSumHandler;
import com.hs.atic.collector.biz.event.protal.ProtalSumHourFlowHandler;
import com.hs.atic.collector.biz.event.protal.ProtalSumMinFlowHandler;
import com.hs.atic.collector.biz.pcap.PcapBuilder;
import com.hs.atic.collector.biz.pcap.PcapConsumer;
import com.hs.atic.collector.biz.pcap.PcapPacketParser;
import com.hs.atic.collector.entity.event.BizEvent;
import com.hs.atic.collector.entity.event.DnsDefendEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.entity.event.SecondFlowEvent;
import com.hs.atic.collector.entity.event.ZoneBlackListEvent;
import com.hs.atic.collector.manager.agent.resource.MBeanResourceFactory;
import com.hs.atic.collector.manager.control.MemoryControl;
import com.hs.atic.collector.util.CrashThreadHandler;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;

public final class DefaultConsumerFactory {
    private static final Logger LOGGER = LogManager.getInstance().getSystemLog();
    private static final int DEFAULT_FLOW_PERIOD = 300000;
    private static final int DEFAULT_CYCLE_FLOW_PERIOD = 60000;
    private static final int DEFAULT_THREAD_CYCLE_PACKET_NUM = 100;
    private static final int DEFAULT_DNS_PERIOD = 300000;
    private static final int MAX_FLOW_SIZE = 10000;
    private static DefaultConsumerFactory instance = new DefaultConsumerFactory();
    private static PacketsDispatchConsumer eventConsumer;
    private static PacketsDispatchConsumer nfaEventConsumer;

    private DefaultConsumerFactory() {
        DefaultConsumerFactory.createEventConsumer();
    }

    public static DefaultConsumerFactory getInstance() {
        return instance;
    }

    public PacketsDispatchConsumer getEventConsumer() {
        return eventConsumer;
    }

    public PacketsDispatchConsumer getNfaEventConsumer() {
        return nfaEventConsumer;
    }

    private static void createEventConsumer() {
        Buffer<OriginalExceptionEvent> exceptionBuffer = new Buffer<OriginalExceptionEvent>();
        Buffer<Event> flowBuffer = new Buffer<Event>();
        Buffer<ZoneBlackListEvent> blackBuffer = new Buffer<ZoneBlackListEvent>();
        Buffer<BizEvent> bizBuffer = new Buffer<BizEvent>();
        Buffer<Event> dnsBuffer = new Buffer<Event>();
        Buffer<DnsDefendEvent> dnsDefendBuffer = new Buffer<DnsDefendEvent>();
        Buffer<SecondFlowEvent> secondFlowBuffer = new Buffer<SecondFlowEvent>();
        ConcurrentLinkedQueue<TimeDatagramPacket> packetQueue = new ConcurrentLinkedQueue<TimeDatagramPacket>();
        ConcurrentLinkedQueue<TimeDatagramPacket> nfaPacketQueue = new ConcurrentLinkedQueue<TimeDatagramPacket>();
        Consumer flowConsumer = DefaultConsumerFactory.getConsumer("C30FlowEvent");
        Consumer exConsumer = DefaultConsumerFactory.getConsumer("ExceptionEvent");
        Consumer blackEventConsumer = DefaultConsumerFactory.getConsumer("ZoneBlackEvent");
        Consumer bizEventConsumer = DefaultConsumerFactory.getConsumer("BizEvent");
        Consumer dnsEventConsumer = DefaultConsumerFactory.getConsumer("DnsEvent");
        Consumer dnsDefendEventConsumer = DefaultConsumerFactory.getConsumer("dnsdefend");
        Consumer secondFlowCounsumer = DefaultConsumerFactory.getConsumer("SecondFlowEvent");
        flowConsumer.setBuffer(flowBuffer);
        exConsumer.setBuffer(exceptionBuffer);
        blackEventConsumer.setBuffer(blackBuffer);
        MBeanResourceFactory.BLACKLIST_FLOW.setBlackBuffer(blackBuffer);
        bizEventConsumer.setBuffer(bizBuffer);
        dnsEventConsumer.setBuffer(dnsBuffer);
        dnsDefendEventConsumer.setBuffer(dnsDefendBuffer);
        secondFlowCounsumer.setBuffer(secondFlowBuffer);
        flowConsumer.start();
        exConsumer.start();
        blackEventConsumer.start();
        bizEventConsumer.start();
        dnsEventConsumer.start();
        dnsDefendEventConsumer.start();
        secondFlowCounsumer.start();
        ExceptionAndBlackIpSortConsumer exceptionAndBlackIpSortConsumer = new ExceptionAndBlackIpSortConsumer();
        exceptionAndBlackIpSortConsumer.setExceptionsBuff(exceptionBuffer);
        exceptionAndBlackIpSortConsumer.setBlackIpBuffer(blackBuffer);
        ArrayList<SortBuffer<ZoneBlackListEvent>> blackIpBufferSortList = new ArrayList<SortBuffer<ZoneBlackListEvent>>();
        ArrayList<SortBuffer<OriginalExceptionEvent>> exceptionBufferSortList = new ArrayList<SortBuffer<OriginalExceptionEvent>>();
        exceptionAndBlackIpSortConsumer.setBlackIpBufferList(blackIpBufferSortList);
        exceptionAndBlackIpSortConsumer.setExceptionBufferList(exceptionBufferSortList);
        exceptionAndBlackIpSortConsumer.setName("exceptionAndBlackIpSort consumer");
        exceptionAndBlackIpSortConsumer.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
        exceptionAndBlackIpSortConsumer.start();
        LOGGER.info((Object)"ExceptionAndBlackIpSortConsumer start");
        int cycleNum = DefaultConsumerFactory.getThreadCyclePacketNum();
        int canUsedCpuSize = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors() / 2;
        canUsedCpuSize = canUsedCpuSize > 2 ? canUsedCpuSize : 2;
        MBeanResourceFactory.UNRESOLVED_BINARY_PACKET.setFlowQueue(packetQueue);
        GeneratePacketsKey generatePacketsKey = new GeneratePacketsKey();
        GeneratePacketsKey generateBlacksKey = new GeneratePacketsKey();
        ArrayList<EventPacketParser> parsers = new ArrayList<EventPacketParser>();
        for (int i = 0; i < canUsedCpuSize; ++i) {
            EventPacketParser packetParser = new EventPacketParser();
            parsers.add(packetParser);
            ParseConsumer parseConsumer = new ParseConsumer(packetParser);
            if (cycleNum > 0) {
                parseConsumer.setCycleNum(cycleNum);
            }
            parseConsumer.setPacketQueue(packetQueue);
            parseConsumer.setGeneratePacketsKey(generatePacketsKey);
            parseConsumer.setGenerateBlacksKey(generateBlacksKey);
            parseConsumer.setFlowBuff(flowBuffer);
            parseConsumer.setBizEventBuffer(bizBuffer);
            parseConsumer.setDnsEventBuffer(dnsBuffer);
            parseConsumer.setDnsDefendEventBuffer(dnsDefendBuffer);
            parseConsumer.setExceptionBufferSortList(exceptionBufferSortList);
            parseConsumer.setBlackIpBufferSortList(blackIpBufferSortList);
            parseConsumer.setSecondFlowBuffer(secondFlowBuffer);
            parseConsumer.setName("parse consumer " + i);
            parseConsumer.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
            parseConsumer.start();
            NfaPacketParser nfaPacketParser = new NfaPacketParser();
            NfaEventConsumer nfaParseConsumer = new NfaEventConsumer(nfaPacketParser);
            nfaParseConsumer.setPacketQueue(nfaPacketQueue);
            nfaParseConsumer.setGeneratePacketsKey(generatePacketsKey);
            nfaParseConsumer.setFlowBuff(flowBuffer);
            nfaParseConsumer.setExceptionBufferSortList(exceptionBufferSortList);
            nfaParseConsumer.setName("nfa parse consumer " + i);
            nfaParseConsumer.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
            nfaParseConsumer.start();
        }
        MemoryControl.getInstance().setParser(parsers);
        eventConsumer = new PacketsDispatchConsumer();
        eventConsumer.setPacketQueue(packetQueue);
        nfaEventConsumer = new PacketsDispatchConsumer();
        nfaEventConsumer.setPacketQueue(nfaPacketQueue);
    }

    public static PcapConsumer createPcapConsumer() {
        PcapBuilder builder = PcapBuilder.getInstance();
        PcapPacketParser packetParser = new PcapPacketParser();
        PcapConsumer consumer = new PcapConsumer(packetParser, builder);
        return consumer;
    }

    private static Consumer getConsumer(String type) {
        if (type.equalsIgnoreCase("ExceptionEvent")) {
            ExceptionEventRepositoryThread exceptionEventRepositoryThread = new ExceptionEventRepositoryThread();
            ExceptionEventSumRepositoryThread ipAttackEventRepositoryThead = DefaultConsumerFactory.getAbnormalPersistentHandlerThread(1);
            ExceptionEventSumRepositoryThread bizAttackEventRepositoryThead = DefaultConsumerFactory.getAbnormalPersistentHandlerThread(2);
            ExceptionEventSumRepositoryThread zoneAttackEventRepositoryThead = DefaultConsumerFactory.getAbnormalPersistentHandlerThread(3);
            NotifyZoneHandler notifyZoneHandler = NotifyZoneHandler.getInstance();
            ExceptionEventHandler builder = new ExceptionEventHandler();
            AttackTypeEventHandler attackTypeEventHandler = new AttackTypeEventHandler();
            int peroid = DefaultConsumerFactory.getFlowPeroid();
            IpAttackTypeOriginalHandler ipAttackTypeOriginalHandler = new IpAttackTypeOriginalHandler(peroid);
            ZoneAttackTypeOriginalHandler zoneAttackTypeOriginalHandler = new ZoneAttackTypeOriginalHandler();
            IpAttackTypeHandler ipAttackTypeHandler = new IpAttackTypeHandler();
            ZoneAttackTypeHandler zoneAttackTypeHandler = new ZoneAttackTypeHandler();
            MBeanResourceFactory.ABNORMAL_FLOW.setAttackTypeEventCache(ipAttackTypeHandler.getAttackTypeEventCache());
            MBeanResourceFactory.ABNORMAL_FLOW.setIpEventMaps(ipAttackTypeOriginalHandler.getIpEventMaps());
            ExceptionLifeHandler cleanDeviceExceptionHandler = new ExceptionLifeHandler(true);
            ExceptionLifeHandler detectDeviceExceptionHandler = new ExceptionLifeHandler(false);
            MBeanResourceFactory.ABNORMAL_FLOW.setDetectExceptionRecords(detectDeviceExceptionHandler.getExceptionRecords());
            MBeanResourceFactory.ABNORMAL_FLOW.setCleanExceptionRecords(cleanDeviceExceptionHandler.getExceptionRecords());
            IpAttackLifeHandler ipExceptionLifeHandler = new IpAttackLifeHandler();
            IpAttackLifeHandler ipAttackLifeHandler = new IpAttackLifeHandler();
            MBeanResourceFactory.ABNORMAL_FLOW.setDetectIpAttackRecords(ipExceptionLifeHandler.getIpAttackRecords());
            MBeanResourceFactory.ABNORMAL_FLOW.setCleanIpAttackRecords(ipAttackLifeHandler.getIpAttackRecords());
            IpStateHandler ipStateHandler = new IpStateHandler();
            BizAttackLifeHandler bizAttackLifeHandler = new BizAttackLifeHandler();
            BizAttackLifeHandler bizExceptionLifeHandler = new BizAttackLifeHandler();
            ZoneAttackLifeHandler zoneExceptionLifeHandler = new ZoneAttackLifeHandler();
            ZoneAttackLifeHandler zoneAttackLifeHandler = new ZoneAttackLifeHandler();
            builder.addFollowHandle(detectDeviceExceptionHandler);
            builder.addFollowHandle(cleanDeviceExceptionHandler);
            builder.addFollowHandle(attackTypeEventHandler);
            attackTypeEventHandler.addFollowHandle(ipAttackTypeOriginalHandler);
            ProtalAttackMinSumHandler protalAttackminSumHandler = new ProtalAttackMinSumHandler();
            attackTypeEventHandler.addFollowHandle(protalAttackminSumHandler);
            ipAttackTypeOriginalHandler.addFollowHandle(ipAttackTypeHandler);
            ipAttackTypeOriginalHandler.addFollowHandle(zoneAttackTypeOriginalHandler);
            zoneAttackTypeOriginalHandler.addFollowHandle(zoneAttackTypeHandler);
            detectDeviceExceptionHandler.addFollowHandle(exceptionEventRepositoryThread);
            detectDeviceExceptionHandler.addFollowHandle(ipExceptionLifeHandler);
            ipExceptionLifeHandler.addFollowHandle(ipAttackEventRepositoryThead);
            ipExceptionLifeHandler.addFollowHandle(ipStateHandler);
            ipExceptionLifeHandler.addFollowHandle(bizExceptionLifeHandler);
            ipExceptionLifeHandler.addFollowHandle(zoneExceptionLifeHandler);
            bizExceptionLifeHandler.addFollowHandle(bizAttackEventRepositoryThead);
            zoneExceptionLifeHandler.addFollowHandle(zoneAttackEventRepositoryThead);
            zoneExceptionLifeHandler.addFollowHandle(notifyZoneHandler);
            cleanDeviceExceptionHandler.addFollowHandle(exceptionEventRepositoryThread);
            cleanDeviceExceptionHandler.addFollowHandle(ipAttackLifeHandler);
            ipAttackLifeHandler.addFollowHandle(ipAttackEventRepositoryThead);
            ipAttackLifeHandler.addFollowHandle(ipStateHandler);
            ipAttackLifeHandler.addFollowHandle(bizAttackLifeHandler);
            ipAttackLifeHandler.addFollowHandle(zoneAttackLifeHandler);
            bizAttackLifeHandler.addFollowHandle(bizAttackEventRepositoryThead);
            zoneAttackLifeHandler.addFollowHandle(zoneAttackEventRepositoryThead);
            zoneAttackLifeHandler.addFollowHandle(notifyZoneHandler);
            Thread persistent = new Thread((Runnable)exceptionEventRepositoryThread, "exception db persistent thread");
            persistent.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
            persistent.start();
            Thread ipPersistent = new Thread((Runnable)ipAttackEventRepositoryThead, "ipattack db persistent thread");
            ipPersistent.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
            ipPersistent.start();
            Thread bizPersistent = new Thread((Runnable)bizAttackEventRepositoryThead, "bizattack db persistent thread");
            bizPersistent.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
            bizPersistent.start();
            Thread zonePersistent = new Thread((Runnable)zoneAttackEventRepositoryThead, "zoneattack db persistent thread");
            zonePersistent.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
            zonePersistent.start();
            ExceptionEventConsumer consumer = new ExceptionEventConsumer(builder);
            consumer.setName("attack consumer");
            consumer.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
            return consumer;
        }
        if (type.equalsIgnoreCase("C30FlowEvent")) {
            try {
                int peroid = DefaultConsumerFactory.getFlowPeroid();
                int cyclePeriod = DefaultConsumerFactory.getCycleFlowPeroid();
                int reportCycle = DefaultConsumerFactory.getReportCyclePeroid();
                FlowEventHandler flowEventHandler = new FlowEventHandler();
                AllCpuMinSumHandler allCpuMinSumHandler = new AllCpuMinSumHandler();
                AllCpu5minSumHandler allCpu5minSumHandler = new AllCpu5minSumHandler(peroid);
                SumMinFlowHandler sumMinFlowHandler = new SumMinFlowHandler();
                AllCpuCycleSumHandler allCpuCycleSumHandler = new AllCpuCycleSumHandler(cyclePeriod);
                LOGGER.info((Object)"Get C30 flow consumer: allCpuMinSumHandler new");
                IpAverageEventHandler ipAverageEventHandler = new IpAverageEventHandler();
                ZoneFlowEventHandler zoneFlowEventHandler = new ZoneFlowEventHandler();
                SumZoneFlowHandler sumZoneFlowHandler = new SumZoneFlowHandler();
                SumIpFlowHandler sumIpFlowHandler = new SumIpFlowHandler();
                HourAverageBizIpFlowHandler hourAveBizIpFlowHandler = new HourAverageBizIpFlowHandler();
                HourMaxBizIpFlowHandler hourMaxBizIpFlowHandler = new HourMaxBizIpFlowHandler();
                HourAverageBizZoneFlowHandler hourAveBizZoneFlowHandler = new HourAverageBizZoneFlowHandler();
                HourMaxBizZoneFlowHandler hourMaxBizZoneFlowHandler = new HourMaxBizZoneFlowHandler();
                HourDnsTypeEventIpHandler hourDnsTypeIpHandler = new HourDnsTypeEventIpHandler();
                HourDnsTypeEventZoneHandler hourDnsTypeZoneHandler = new HourDnsTypeEventZoneHandler();
                SumAllFlowHandler sumAllFlowHandler = new SumAllFlowHandler();
                HourAverAllFlowHandler hourAverAllFlowHandler = new HourAverAllFlowHandler();
                HourMaxAllFlowHandler hourMaxAllFlowHandler = new HourMaxAllFlowHandler();
                IpLocation5minSumHandler ipLocation5minSumHandler = new IpLocation5minSumHandler();
                HourAverAllFlowHandler totalIpLocationAver = new HourAverAllFlowHandler();
                SysLogHandler sysLogHandler = SysLogHandler.getInstance();
                BaselineRepositoryHandlerThread baselineRepositoryHandlerThread = new BaselineRepositoryHandlerThread();
                Thread baseline = new Thread(baselineRepositoryHandlerThread, "NfaBaselinePersistenHandlerThread");
                baseline.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
                baseline.start();
                BaselineFlowSumHandler baselineFlowSumHandler = BaselineFlowSumHandler.getInstance();
                LOGGER.info((Object)"Get C30 flow consumer: flowEventHandler addfollowhandle allCpuMinSumHandler");
                flowEventHandler.addFollowHandle(allCpuMinSumHandler);
                allCpuMinSumHandler.addFollowHandle(allCpu5minSumHandler);
                allCpuMinSumHandler.addFollowHandle(sysLogHandler);
                allCpuMinSumHandler.addFollowHandle(DashboardEventHandler.getInstance());
                allCpuMinSumHandler.addFollowHandle(Alarm70secFlowHandler.getInstance());
                if (reportCycle < cyclePeriod) {
                    allCpuCycleSumHandler.addFollowHandle(sumMinFlowHandler);
                    LOGGER.info((Object)"Get C30 flow consumer:  allCpuMinSumHandler addfollowhandle ok");
                    ProtalSumMinFlowHandler protalSumMinHandler = new ProtalSumMinFlowHandler();
                    sumMinFlowHandler.addFollowHandle(protalSumMinHandler);
                    LOGGER.info((Object)"Get C30 flow consumer:  protalSumMinHandler new");
                }
                allCpuMinSumHandler.addFollowHandle(baselineFlowSumHandler);
                allCpu5minSumHandler.addFollowHandle(zoneFlowEventHandler);
                allCpu5minSumHandler.addFollowHandle(ipAverageEventHandler);
                allCpu5minSumHandler.addFollowHandle(sumAllFlowHandler);
                allCpu5minSumHandler.addFollowHandle(ipLocation5minSumHandler);
                ipLocation5minSumHandler.addFollowHandle(totalIpLocationAver);
                baselineFlowSumHandler.addFollowHandle(baselineRepositoryHandlerThread);
                ipAverageEventHandler.addFollowHandle(sumIpFlowHandler);
                ipAverageEventHandler.addFollowHandle(hourAveBizIpFlowHandler);
                ipAverageEventHandler.addFollowHandle(hourMaxBizIpFlowHandler);
                ipAverageEventHandler.addFollowHandle(hourDnsTypeIpHandler);
                sumAllFlowHandler.addFollowHandle(hourAverAllFlowHandler);
                sumAllFlowHandler.addFollowHandle(hourMaxAllFlowHandler);
                zoneFlowEventHandler.addFollowHandle(sumZoneFlowHandler);
                zoneFlowEventHandler.addFollowHandle(hourDnsTypeZoneHandler);
                zoneFlowEventHandler.addFollowHandle(hourAveBizZoneFlowHandler);
                zoneFlowEventHandler.addFollowHandle(hourMaxBizZoneFlowHandler);
                ProtalSumHourFlowHandler protalSumIpHourHandler = new ProtalSumHourFlowHandler();
                sumIpFlowHandler.addFollowHandle(protalSumIpHourHandler);
                ProtalSumHourFlowHandler protalSumZoneHourHandler = new ProtalSumHourFlowHandler();
                sumZoneFlowHandler.addFollowHandle(protalSumZoneHourHandler);
                LOGGER.info((Object)"Get C30 flow consumer:  protalSumZoneHourHandler ok");
                FlowEventConsumer consumer = new FlowEventConsumer(flowEventHandler);
                consumer.setName("C30 flow consumer");
                consumer.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
                LOGGER.info((Object)"Get C30 flow consumer success");
                return consumer;
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)"Get C30 flow consumer error,", (Throwable)e);
                FlowEventHandler flowEventHandler = new FlowEventHandler();
                FlowEventConsumer consumer = new FlowEventConsumer(flowEventHandler);
                consumer.setName("C30 flow consumer error");
                consumer.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
                return consumer;
            }
        }
        if (type.equalsIgnoreCase("BizEvent")) {
            ServiceLearningEvnetHanlder serviceLearningEvnetHanlder = ServiceLearningEvnetHanlder.getInstance();
            ServiceLearningRepositoryThread serviceLearningRepositoryThread = new ServiceLearningRepositoryThread();
            Thread serviceLearningThread = new Thread((Runnable)serviceLearningRepositoryThread, "ServiceLearningPersistentThread");
            serviceLearningThread.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
            serviceLearningThread.start();
            serviceLearningEvnetHanlder.addFollowHandle(serviceLearningRepositoryThread);
            BizEventConsumer<BizEvent> bizEventConsumer = new BizEventConsumer<BizEvent>(serviceLearningEvnetHanlder);
            bizEventConsumer.setName("biz event consumer");
            bizEventConsumer.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
            return bizEventConsumer;
        }
        if (type.equalsIgnoreCase("DnsEvent")) {
            int peroid = DefaultConsumerFactory.getDnsPeroid();
            DnsEventHandler dnsEventHandler = new DnsEventHandler(peroid);
            HourDnsEventHandler dnsHourHandler = new HourDnsEventHandler();
            dnsEventHandler.addFollowHandle(dnsHourHandler);
            DnsEventConsumer<Event> consumer = new DnsEventConsumer<Event>(dnsEventHandler);
            consumer.setName("dns event consumer");
            consumer.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
            return consumer;
        }
        if (type.equalsIgnoreCase("ZoneBlackEvent")) {
            ZoneBlacklistHistoryRepositoryThread historyRepositoryThread = new ZoneBlacklistHistoryRepositoryThread();
            historyRepositoryThread.setName("ZoneBlacklistHistoryRepositoryThread");
            historyRepositoryThread.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
            historyRepositoryThread.start();
            ZoneBlackListEventHandler zoneBlackListEventHandler = ZoneBlackListEventHandler.getInstance();
            zoneBlackListEventHandler.setHistoryRepositoryThread(historyRepositoryThread);
            MBeanResourceFactory.BLACKLIST_FLOW.setDyBlackListCache(zoneBlackListEventHandler.getCache());
            FlowEventConsumer<ZoneBlackListEvent> consumer = new FlowEventConsumer<ZoneBlackListEvent>(zoneBlackListEventHandler);
            consumer.setName("black event consumer");
            consumer.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
            return consumer;
        }
        if (type.equalsIgnoreCase("dnsdefend")) {
            int peroid = DefaultConsumerFactory.getFlowPeroid();
            DnsDefendEventHandler handler = new DnsDefendEventHandler(peroid);
            DnsDefendEventHourHandler hourHandler = new DnsDefendEventHourHandler();
            handler.addFollowHandle(hourHandler);
            DnsDefendConsumer<DnsDefendEvent> comsumer = new DnsDefendConsumer<DnsDefendEvent>(handler);
            MBeanResourceFactory.DNS_DEFEND_FLOW.setCacheList5min(handler.getCacheList());
            MBeanResourceFactory.DNS_DEFEND_FLOW.setCacheList1hour(hourHandler.getEventList());
            comsumer.setName("dnsdefend");
            comsumer.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
            return comsumer;
        }
        if ("SecondFlowEvent".equalsIgnoreCase(type)) {
            SecondFLowHandler secondFlowHandler = SecondFLowHandler.getInstance();
            SecondFlowConsumer<SecondFlowEvent> consumer = new SecondFlowConsumer<SecondFlowEvent>(secondFlowHandler);
            consumer.setName("SecondFlowConsumer");
            consumer.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
            return consumer;
        }
        return null;
    }

    private static int getThreadCyclePacketNum() {
        int period = 100;
        try {
            period = Integer.parseInt(EventUtil.getEventConfigProperty("threadCyclePacketNum"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"read config error content error,key is FlowThreadPeriod", (Throwable)e);
        }
        return period;
    }

    private static int getCycleFlowPeroid() {
        int period = 60000;
        return period;
    }

    private static int getReportCyclePeroid() {
        int intervalTime = 0;
        try {
            intervalTime = Integer.parseInt(EventUtil.getEventConfigProperty("deviceLogReportCycle"));
        }
        catch (Exception e) {
            intervalTime = 64;
            LOGGER.error((Object)"read config error content error,key is FlowThreadPeriod", (Throwable)e);
        }
        return (intervalTime *= 1000) * 1000;
    }

    private static int getFlowPeroid() {
        int period = 300000;
        try {
            period = Integer.parseInt(EventUtil.getEventConfigProperty("FlowThreadPeriod"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"read config error content error,key is FlowThreadPeriod", (Throwable)e);
        }
        return period;
    }

    private static int getDnsPeroid() {
        int period = 300000;
        try {
            period = Integer.parseInt(EventUtil.getEventConfigProperty("DnsThreadPeriod"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"read config error content error,key is DnsThreadPeriod", (Throwable)e);
        }
        return period;
    }

    private static ExceptionEventSumRepositoryThread getAbnormalPersistentHandlerThread(int eventType) {
        switch (eventType) {
            case 1: {
                return new ExceptionEventSumRepositoryThread("com.hs.atic.collector.entity.event.IpAttackEvent");
            }
            case 2: {
                return new ExceptionEventSumRepositoryThread("com.hs.atic.collector.entity.event.BizAttackEvent");
            }
            case 3: {
                return new ExceptionEventSumRepositoryThread("com.hs.atic.collector.entity.event.ZoneAttackEvent");
            }
        }
        return new ExceptionEventSumRepositoryThread("com.hs.atic.collector.entity.event.IpAttackEvent");
    }
}

